/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.openlineage;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.OpenLineageLogStoreConnectorBase;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.ffdc.OpenLineageIntegrationConnectorAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.ffdc.OpenLineageIntegrationConnectorErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRunEvent;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class APIBasedOpenLineageLogStoreConnector
extends OpenLineageLogStoreConnectorBase {
    private RestTemplate restTemplate = null;
    private HttpHeaders header = null;

    @Override
    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        try {
            this.restTemplate = new RestTemplate();
            List converters = this.restTemplate.getMessageConverters();
            converters.removeIf(httpMessageConverter -> httpMessageConverter instanceof StringHttpMessageConverter);
            converters.add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
            this.header = new HttpHeaders();
            this.header.setContentType(MediaType.APPLICATION_JSON);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(OpenLineageIntegrationConnectorErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "start", error.getMessage()), this.getClass().getName(), "start", (Throwable)error);
        }
    }

    @Override
    protected void newDestinationIdentified(String destinationAddress) {
    }

    @Override
    public void storeEvent(OpenLineageRunEvent openLineageEvent, String rawEvent, String logStoreURL) throws InvalidParameterException {
        String methodName = "storeEvent";
        if (rawEvent != null) {
            try {
                HttpEntity request = new HttpEntity((Object)rawEvent, (MultiValueMap)this.header);
                this.restTemplate.exchange(logStoreURL, HttpMethod.POST, request, Void.class, new Object[0]);
            }
            catch (Exception error) {
                this.auditLog.logMessage("storeEvent", OpenLineageIntegrationConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "storeEvent", error.getMessage()), logStoreURL);
            }
        } else {
            super.logNoRawEvent(openLineageEvent);
        }
    }
}

