/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.openlineage;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.OpenLineageLogStore;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.ffdc.OpenLineageIntegrationConnectorAuditCode;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.ffdc.OpenLineageIntegrationConnectorErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorConnector;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorContext;
import org.odpi.openmetadata.integrationservices.lineage.connector.OpenLineageEventListener;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRunEvent;

public abstract class OpenLineageLogStoreConnectorBase
extends LineageIntegratorConnector
implements OpenLineageLogStore,
OpenLineageEventListener {
    private static final ObjectWriter OBJECT_WRITER = new ObjectMapper().writer();
    protected String distributorName = "<Unknown>";
    protected LineageIntegratorContext myContext = null;
    protected final List<String> destinationAddresses = new ArrayList<String>();

    @Override
    public abstract void storeEvent(OpenLineageRunEvent var1, String var2, String var3) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException;

    protected abstract void newDestinationIdentified(String var1) throws ConnectorCheckedException;

    private String getJSONOpenLineageEvent(OpenLineageRunEvent openLineageEvent) throws InvalidParameterException {
        String methodName = "getJSONOpenLineageEvent";
        String parameterName = "openLineageEvent";
        if (openLineageEvent != null) {
            try {
                return OBJECT_WRITER.writeValueAsString((Object)openLineageEvent);
            }
            catch (Exception error) {
                throw new InvalidParameterException(OpenLineageIntegrationConnectorErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "getJSONOpenLineageEvent", error.getMessage()), this.getClass().getName(), "getJSONOpenLineageEvent", (Throwable)error, "openLineageEvent");
            }
        }
        return null;
    }

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        if (connectionProperties != null) {
            ConnectorTypeProperties connectorType;
            if (connectionProperties.getDisplayName() != null) {
                this.distributorName = connectionProperties.getDisplayName();
            } else if (connectionProperties.getConnectorType() != null && (connectorType = connectionProperties.getConnectorType()).getDisplayName() != null) {
                this.distributorName = connectorType.getDisplayName();
            }
        }
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        EndpointProperties endpoint = this.connectionProperties.getEndpoint();
        if (endpoint != null && endpoint.getAddress() != null) {
            this.destinationAddresses.add(endpoint.getAddress());
            this.newDestinationIdentified(endpoint.getAddress());
        }
        this.myContext = super.getContext();
        if (this.myContext != null) {
            this.myContext.registerListener((OpenLineageEventListener)this);
        }
    }

    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        try {
            int startFrom = 0;
            List catalogTargets = this.myContext.getCatalogTargets(startFrom, this.myContext.getMaxPageSize());
            while (catalogTargets != null) {
                for (CatalogTarget catalogTarget : catalogTargets) {
                    String networkAddress;
                    OpenMetadataElement endpoint;
                    RelatedMetadataElement endpointElement;
                    RelatedMetadataElement connectionElement;
                    if (catalogTarget == null) continue;
                    String endpointGUID = null;
                    if (this.propertyHelper.isTypeOf((ElementControlHeader)catalogTarget.getCatalogTargetElement(), OpenMetadataType.ENDPOINT.typeName)) {
                        endpointGUID = catalogTarget.getCatalogTargetElement().getGUID();
                    } else if (this.propertyHelper.isTypeOf((ElementControlHeader)catalogTarget.getCatalogTargetElement(), OpenMetadataType.CONNECTION.typeName)) {
                        RelatedMetadataElement endpointElement2 = this.myContext.getIntegrationGovernanceContext().getOpenMetadataAccess().getRelatedMetadataElement(catalogTarget.getCatalogTargetElement().getGUID(), 2, OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeName, new Date());
                        if (endpointElement2 != null) {
                            endpointGUID = endpointElement2.getElement().getElementGUID();
                        }
                    } else if (this.propertyHelper.isTypeOf((ElementControlHeader)catalogTarget.getCatalogTargetElement(), OpenMetadataType.ASSET.typeName) && (connectionElement = this.myContext.getIntegrationGovernanceContext().getOpenMetadataAccess().getRelatedMetadataElement(catalogTarget.getCatalogTargetElement().getGUID(), 2, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeName, new Date())) != null && (endpointElement = this.myContext.getIntegrationGovernanceContext().getOpenMetadataAccess().getRelatedMetadataElement(connectionElement.getElement().getElementGUID(), 2, OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeName, new Date())) != null) {
                        endpointGUID = endpointElement.getElement().getElementGUID();
                    }
                    if (endpointGUID == null || (endpoint = this.myContext.getIntegrationGovernanceContext().getOpenMetadataAccess().getMetadataElementByGUID(endpointGUID)) == null || (networkAddress = this.propertyHelper.getStringProperty(this.connectorName, OpenMetadataProperty.NETWORK_ADDRESS.name, endpoint.getElementProperties(), "refresh")) == null || this.destinationAddresses.contains(networkAddress)) continue;
                    this.destinationAddresses.add(networkAddress);
                    this.newDestinationIdentified(networkAddress);
                }
                catalogTargets = this.myContext.getCatalogTargets(startFrom += this.myContext.getMaxPageSize(), this.myContext.getMaxPageSize());
            }
        }
        catch (Exception error) {
            this.auditLog.logException("refresh", OpenLineageIntegrationConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "refresh", error.getMessage()), (Throwable)error);
        }
    }

    public void processOpenLineageRunEvent(OpenLineageRunEvent event, String rawEvent) {
        String methodName = "processOpenLineageRunEvent";
        String jsonEvent = rawEvent;
        try {
            if (jsonEvent == null) {
                jsonEvent = this.getJSONOpenLineageEvent(event);
            }
            for (String destinationAddress : this.destinationAddresses) {
                this.storeEvent(event, rawEvent, destinationAddress);
            }
        }
        catch (Exception error) {
            this.auditLog.logException("processOpenLineageRunEvent", OpenLineageIntegrationConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "processOpenLineageRunEvent", error.getMessage()), jsonEvent, (Throwable)error);
        }
    }

    protected void logNoRawEvent(OpenLineageRunEvent openLineageEvent) throws InvalidParameterException {
        String methodName = "logNoRawEvent";
        String parameterName = "rawEvent";
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        if (openLineageEvent != null) {
            additionalProperties.put("rawEvent", openLineageEvent.toString());
        }
        throw new InvalidParameterException(OpenLineageIntegrationConnectorErrorCode.NO_RAW_EVENT.getMessageDefinition(this.connectorName, "logNoRawEvent"), this.getClass().getName(), "logNoRawEvent", "rawEvent", additionalProperties);
    }
}

