/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.openlineage;

import java.net.URI;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.accessservices.assetmanager.api.AssetManagerEventListener;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerEventType;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerOutTopicEvent;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.ffdc.OpenLineageIntegrationConnectorAuditCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.EngineActionElement;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorConnector;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageInputDataSet;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageJob;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageNominalTimeRunFacet;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageOutputDataSet;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageParentRunFacet;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageParentRunFacetJob;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageParentRunFacetRun;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRun;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRunEvent;
import org.odpi.openmetadata.integrationservices.lineage.properties.OpenLineageRunFacets;

public class GovernanceActionOpenLineageIntegrationConnector
extends LineageIntegratorConnector
implements AssetManagerEventListener {
    private static final URI producer = URI.create("https://egeria-project.org/");
    private static final String defaultNameSpace = "GovernanceActions";
    private final ZoneId zoneId = ZoneId.systemDefault();
    private String namespace = "GovernanceActions";

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.namespace = super.getStringConfigurationProperty("namespace", this.connectionProperties.getConfigurationProperties());
        if (this.namespace == null || this.namespace.isBlank()) {
            this.namespace = defaultNameSpace;
        }
        try {
            super.getContext().registerListener((AssetManagerEventListener)this);
        }
        catch (Exception error) {
            this.auditLog.logException("start", OpenLineageIntegrationConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "start", error.getMessage()), (Throwable)error);
        }
    }

    public void refresh() {
    }

    public void processEvent(AssetManagerOutTopicEvent event) {
        block4: {
            String methodName = "processEvent";
            ElementHeader elementHeader = event.getElementHeader();
            if ((event.getEventType() == AssetManagerEventType.NEW_ELEMENT_CREATED || event.getEventType() == AssetManagerEventType.REFRESH_ELEMENT_EVENT || event.getEventType() == AssetManagerEventType.ELEMENT_UPDATED) && this.propertyHelper.isTypeOf((ElementControlHeader)elementHeader, OpenMetadataType.ENGINE_ACTION.typeName)) {
                try {
                    String previousActionStatus = this.getActionStatus(event.getPreviousElementProperties());
                    String currentActionStatus = this.getActionStatus(event.getElementProperties());
                    if (!previousActionStatus.equals(currentActionStatus) && (EngineActionStatus.IN_PROGRESS.getName().equals(currentActionStatus) || EngineActionStatus.ACTIONED.getName().equals(currentActionStatus) || EngineActionStatus.FAILED.getName().equals(currentActionStatus) || EngineActionStatus.INVALID.getName().equals(currentActionStatus))) {
                        EngineActionElement engineAction = super.getContext().getEngineAction(elementHeader.getGUID());
                        this.publishOpenLineageEvent(currentActionStatus, event.getEventTime(), engineAction);
                    }
                }
                catch (Exception error) {
                    if (this.auditLog == null) break block4;
                    String stringEvent = event.toString();
                    this.auditLog.logException("processEvent", OpenLineageIntegrationConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "processEvent", error.getMessage()), stringEvent, (Throwable)error);
                }
            }
        }
    }

    private String getActionStatus(Map<String, Object> elementProperties) {
        if (elementProperties != null && elementProperties.get(OpenMetadataProperty.ACTION_STATUS.name) != null) {
            return elementProperties.get(OpenMetadataProperty.ACTION_STATUS.name).toString();
        }
        return "<null>";
    }

    private void publishOpenLineageEvent(String engineActionStatus, Date eventTime, EngineActionElement engineAction) throws ConnectorCheckedException {
        OpenLineageInputDataSet inputDataSet;
        OpenLineageRunEvent event = new OpenLineageRunEvent();
        event.setProducer(producer);
        event.setEventTime(this.getTimeStamp(eventTime));
        if (EngineActionStatus.IN_PROGRESS.getName().equals(engineActionStatus)) {
            event.setEventType("START");
        } else if (EngineActionStatus.ACTIONED.getName().equals(engineActionStatus)) {
            event.setEventType("COMPLETE");
        } else if (EngineActionStatus.FAILED.getName().equals(engineActionStatus)) {
            event.setEventType("FAIL");
        } else if (EngineActionStatus.INVALID.getName().equals(engineActionStatus)) {
            event.setEventType("ABORT");
        }
        OpenLineageJob job = new OpenLineageJob();
        if (engineAction.getProcessStepName() != null) {
            job.setName(engineAction.getProcessStepName());
        } else {
            job.setName(engineAction.getGovernanceEngineName() + ":" + engineAction.getRequestType());
        }
        job.setNamespace(this.namespace);
        event.setJob(job);
        OpenLineageRun run = new OpenLineageRun();
        run.setRunId(UUID.fromString(engineAction.getElementHeader().getGUID()));
        String anchorGUID = this.propertyHelper.getAnchorGUID(engineAction.getElementHeader());
        OpenLineageRunFacets runFacets = new OpenLineageRunFacets();
        if (anchorGUID != null) {
            OpenLineageParentRunFacet parentRunFacet = new OpenLineageParentRunFacet();
            OpenLineageParentRunFacetJob parentRunFacetJob = new OpenLineageParentRunFacetJob();
            OpenLineageParentRunFacetRun parentRunFacetRun = new OpenLineageParentRunFacetRun();
            parentRunFacet.set_producer(producer);
            parentRunFacetJob.setName(engineAction.getProcessName());
            parentRunFacetJob.setNamespace(this.namespace);
            parentRunFacet.setJob(parentRunFacetJob);
            parentRunFacetRun.setRunId(UUID.fromString(anchorGUID));
            parentRunFacet.setRun(parentRunFacetRun);
            runFacets.setParent(parentRunFacet);
        }
        OpenLineageNominalTimeRunFacet nominalTimeRunFacet = new OpenLineageNominalTimeRunFacet();
        nominalTimeRunFacet.set_producer(producer);
        if (engineAction.getStartTime() == null) {
            nominalTimeRunFacet.setNominalStartTime(this.getTimeStamp(engineAction.getRequestedTime()));
        } else {
            nominalTimeRunFacet.setNominalStartTime(this.getTimeStamp(engineAction.getStartTime()));
        }
        if (engineAction.getCompletionTime() != null) {
            nominalTimeRunFacet.setNominalEndTime(this.getTimeStamp(engineAction.getCompletionTime()));
        }
        runFacets.setNominalTime(nominalTimeRunFacet);
        run.setFacets(runFacets);
        event.setRun(run);
        ArrayList<OpenLineageInputDataSet> inputDataSets = new ArrayList<OpenLineageInputDataSet>();
        if (engineAction.getActionTargetElements() != null) {
            for (ActionTargetElement actionTarget : engineAction.getActionTargetElements()) {
                if (actionTarget == null) continue;
                inputDataSet = new OpenLineageInputDataSet();
                inputDataSet.setName(actionTarget.getActionTargetName());
                inputDataSet.setNamespace(this.namespace);
                inputDataSets.add(inputDataSet);
            }
        }
        if (engineAction.getReceivedGuards() != null) {
            for (String guard : engineAction.getReceivedGuards()) {
                if (guard == null) continue;
                inputDataSet = new OpenLineageInputDataSet();
                inputDataSet.setName(guard);
                inputDataSet.setNamespace(this.namespace);
                inputDataSets.add(inputDataSet);
            }
        }
        if (engineAction.getRequestParameters() != null) {
            for (String requestParameter : engineAction.getRequestParameters().values()) {
                if (requestParameter == null) continue;
                inputDataSet = new OpenLineageInputDataSet();
                inputDataSet.setName(requestParameter);
                inputDataSet.setNamespace(this.namespace);
                inputDataSets.add(inputDataSet);
            }
        }
        event.setInputs(inputDataSets);
        if (engineAction.getCompletionTime() != null) {
            ArrayList<OpenLineageOutputDataSet> outputDataSets = new ArrayList<OpenLineageOutputDataSet>();
            if (engineAction.getCompletionGuards() != null) {
                for (String guard : engineAction.getCompletionGuards()) {
                    if (guard == null) continue;
                    OpenLineageOutputDataSet outputDataSet = new OpenLineageOutputDataSet();
                    outputDataSet.setName(guard);
                    outputDataSet.setNamespace(this.namespace);
                    outputDataSets.add(outputDataSet);
                }
            }
            event.setOutputs(outputDataSets);
        }
        super.getContext().publishOpenLineageRunEvent(event);
    }

    private String getTimeStamp(Date date) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(date.toInstant(), this.zoneId);
        String zonedDateString = zonedDateTime.toString();
        String[] dataTokens = zonedDateString.split("\\[");
        return dataTokens[0];
    }
}

