/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.openlineage;

import org.odpi.openmetadata.adapters.connectors.integration.openlineage.ffdc.OpenLineageIntegrationConnectorAuditCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.integration.connectors.CatalogTargetProcessorBase;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;

public class OpenLineageEventReceiverCatalogTargetProcessor
extends CatalogTargetProcessorBase {
    public OpenLineageEventReceiverCatalogTargetProcessor(CatalogTarget template, Connector connectorToTarget, String connectorName, AuditLog auditLog, OpenMetadataTopicListener listener) {
        super(template, connectorToTarget, connectorName, auditLog);
        Connector connector = super.getCatalogTargetConnector();
        if (connector instanceof OpenMetadataTopicConnector) {
            OpenMetadataTopicConnector topicConnector = (OpenMetadataTopicConnector)connector;
            this.registerTopicConnector(topicConnector, listener);
        }
    }

    private void registerTopicConnector(OpenMetadataTopicConnector topicConnector, OpenMetadataTopicListener listener) {
        EndpointProperties endpoint;
        String methodName = "registerTopicConnector";
        topicConnector.registerListener(listener);
        ConnectionProperties connectionProperties = topicConnector.getConnection();
        if (connectionProperties != null && (endpoint = connectionProperties.getEndpoint()) != null) {
            this.auditLog.logMessage("registerTopicConnector", OpenLineageIntegrationConnectorAuditCode.KAFKA_RECEIVER_CONFIGURATION.getMessageDefinition(this.connectorName, endpoint.getAddress(), connectionProperties.getConnectionName()));
        }
    }

    public void refresh() {
    }
}

