/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.integration.openlineage;

import org.odpi.openmetadata.adapters.connectors.integration.openlineage.OpenLineageEventReceiverCatalogTargetProcessor;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.ffdc.OpenLineageIntegrationConnectorAuditCode;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.integration.connectors.CatalogTargetIntegrator;
import org.odpi.openmetadata.frameworks.integration.properties.RequestedCatalogTarget;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorConnector;
import org.odpi.openmetadata.integrationservices.lineage.connector.LineageIntegratorContext;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListener;

public class OpenLineageEventReceiverIntegrationConnector
extends LineageIntegratorConnector
implements OpenMetadataTopicListener,
CatalogTargetIntegrator {
    public void processEvent(String event) {
        String methodName = "processEvent";
        try {
            LineageIntegratorContext myContext = super.getContext();
            if (myContext != null) {
                myContext.publishOpenLineageRunEvent(event);
            }
        }
        catch (Exception error) {
            this.auditLog.logMessage("processEvent", OpenLineageIntegrationConnectorAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "processEvent", error.getMessage()));
        }
    }

    public void refresh() throws ConnectorCheckedException {
        super.refreshCatalogTargets((CatalogTargetIntegrator)this);
    }

    public void integrateCatalogTarget(RequestedCatalogTarget requestedCatalogTarget) throws ConnectorCheckedException {
    }

    public RequestedCatalogTarget getNewRequestedCatalogTargetSkeleton(CatalogTarget retrievedCatalogTarget, Connector connectorToTarget) {
        if (this.propertyHelper.isTypeOf((ElementControlHeader)retrievedCatalogTarget.getCatalogTargetElement(), OpenMetadataType.KAFKA_TOPIC.typeName)) {
            return new OpenLineageEventReceiverCatalogTargetProcessor(retrievedCatalogTarget, connectorToTarget, this.connectorName, this.auditLog, this);
        }
        return new RequestedCatalogTarget(retrievedCatalogTarget, connectorToTarget);
    }
}

