/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.organization.connector;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.communityprofile.api.CommunityProfileEventListener;
import org.odpi.openmetadata.accessservices.communityprofile.client.CommunityProfileEventClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.OrganizationManagement;
import org.odpi.openmetadata.accessservices.communityprofile.client.SecurityGroupManagement;
import org.odpi.openmetadata.accessservices.communityprofile.client.UserIdentityManagement;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.client.ActionControlInterface;
import org.odpi.openmetadata.frameworks.governanceaction.client.GovernanceConfiguration;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.integration.client.OpenIntegrationClient;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.Appointee;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.PersonRoleElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SecurityGroupElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.UserIdentityElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ActorProfileProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.AppointmentProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ContactMethodProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ContributionRecord;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.PersonRoleProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.ProfileIdentityProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.UserIdentityProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.security.SecurityGroupProperties;

public class OrganizationIntegratorContext
extends IntegrationContext {
    private final OrganizationManagement organizationClient;
    private final SecurityGroupManagement securityGroupClient;
    private final UserIdentityManagement userIdentityClient;
    private final CommunityProfileEventClient eventClient;
    private final AuditLog auditLog;

    public OrganizationIntegratorContext(String connectorId, String connectorName, String connectorUserId, String serverName, OpenIntegrationClient openIntegrationClient, GovernanceConfiguration governanceConfiguration, OpenMetadataClient openMetadataStoreClient, ActionControlInterface actionControlInterface, OrganizationManagement organizationManagement, SecurityGroupManagement securityGroupManagement, UserIdentityManagement userIdentityManagement, CommunityProfileEventClient eventClient, boolean generateIntegrationReport, PermittedSynchronization permittedSynchronization, String integrationConnectorGUID, String externalSourceGUID, String externalSourceName, int maxPageSize, AuditLog auditLog) {
        super(connectorId, connectorName, connectorUserId, serverName, openIntegrationClient, governanceConfiguration, openMetadataStoreClient, actionControlInterface, generateIntegrationReport, permittedSynchronization, externalSourceGUID, externalSourceName, integrationConnectorGUID, auditLog, maxPageSize);
        this.organizationClient = organizationManagement;
        this.securityGroupClient = securityGroupManagement;
        this.userIdentityClient = userIdentityManagement;
        this.eventClient = eventClient;
        this.auditLog = auditLog;
    }

    public String getExternalSourceName() {
        return this.externalSourceName;
    }

    public void registerListener(CommunityProfileEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        this.eventClient.registerListener(this.userId, listener);
    }

    public String createActorProfile(ActorProfileProperties properties, ContributionRecord contributionRecord) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.organizationClient.createActorProfile(this.userId, this.externalSourceGUID, this.externalSourceName, properties, contributionRecord);
    }

    public void updateActorProfile(String actorProfileGUID, boolean isMergeUpdate, ActorProfileProperties properties, ContributionRecord contributionRecord) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.organizationClient.updateActorProfile(this.userId, this.externalSourceGUID, this.externalSourceName, actorProfileGUID, isMergeUpdate, properties, contributionRecord);
    }

    public void deleteActorProfile(String actorProfileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.organizationClient.deleteActorProfile(this.userId, this.externalSourceGUID, this.externalSourceName, actorProfileGUID);
    }

    public String addContactMethod(String actorProfileGUID, ContactMethodProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.organizationClient.addContactMethod(this.userId, this.externalSourceGUID, this.externalSourceName, actorProfileGUID, properties);
    }

    public void deleteContactMethod(String contactMethodGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.organizationClient.deleteContactMethod(this.userId, this.externalSourceGUID, this.externalSourceName, contactMethodGUID);
    }

    public void linkTeamsInHierarchy(String superTeamProfileGUID, String subTeamProfileGUID, boolean delegationEscalationAuthority, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.organizationClient.linkTeamsInHierarchy(this.userId, this.externalSourceGUID, this.externalSourceName, superTeamProfileGUID, subTeamProfileGUID, delegationEscalationAuthority, effectiveFrom, effectiveTo);
    }

    public void unlinkTeamsInHierarchy(String superTeamProfileGUID, String subTeamProfileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.organizationClient.unlinkTeamsInHierarchy(this.userId, this.externalSourceGUID, this.externalSourceName, superTeamProfileGUID, subTeamProfileGUID);
    }

    public ActorProfileElement getActorProfileByGUID(String actorProfileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.organizationClient.getActorProfileByGUID(this.userId, actorProfileGUID);
    }

    public ActorProfileElement getActorProfileByUserId(String actorProfileUserId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.organizationClient.getActorProfileByUserId(this.userId, actorProfileUserId);
    }

    public List<ActorProfileElement> getActorProfilesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.organizationClient.getActorProfilesByName(this.userId, name, startFrom, pageSize);
    }

    public List<ActorProfileElement> getActorProfilesByLocation(String locationGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.organizationClient.getActorProfilesByLocation(this.userId, locationGUID, startFrom, pageSize);
    }

    public List<ActorProfileElement> getActorProfiles(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.organizationClient.getActorProfiles(this.userId, startFrom, pageSize);
    }

    public List<ActorProfileElement> findActorProfiles(String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.organizationClient.findActorProfiles(this.userId, searchString, startFrom, pageSize);
    }

    public String createPersonRole(PersonRoleProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.organizationClient.createPersonRole(this.userId, this.externalSourceGUID, this.externalSourceName, properties);
    }

    public void updatePersonRole(String personRoleGUID, boolean isMergeUpdate, PersonRoleProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.organizationClient.updatePersonRole(this.userId, this.externalSourceGUID, this.externalSourceName, personRoleGUID, isMergeUpdate, properties);
    }

    public void deletePersonRole(String personRoleGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.organizationClient.deletePersonRole(this.userId, this.externalSourceGUID, this.externalSourceName, personRoleGUID);
    }

    public void linkPersonRoleToProfile(String personRoleGUID, String personProfileGUID, AppointmentProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.organizationClient.linkPersonRoleToProfile(this.userId, this.externalSourceGUID, this.externalSourceName, personRoleGUID, personProfileGUID, properties);
    }

    public List<Appointee> getAppointees(String personRoleGUID, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.organizationClient.getAppointees(this.userId, personRoleGUID, effectiveTime, startFrom, pageSize);
    }

    public void updateAppointment(String appointmentGUID, boolean isMergeUpdate, AppointmentProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.organizationClient.updateAppointment(this.userId, this.externalSourceGUID, this.externalSourceName, appointmentGUID, isMergeUpdate, properties);
    }

    public void unlinkPersonRoleFromProfile(String appointmentGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.organizationClient.unlinkPersonRoleFromProfile(this.userId, this.externalSourceGUID, this.externalSourceName, appointmentGUID);
    }

    public void linkTeamPlayer(String teamRoleGUID, String teamProfileGUID, String position, boolean leadershipPosition) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.organizationClient.linkTeamPlayer(this.userId, this.externalSourceGUID, this.externalSourceName, teamRoleGUID, teamProfileGUID, position, leadershipPosition);
    }

    public void unlinkTeamPlayer(String teamRoleGUID, String teamProfileGUID, boolean leadershipPosition) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.organizationClient.unlinkTeamPlayer(this.userId, this.externalSourceGUID, this.externalSourceName, teamRoleGUID, teamProfileGUID, leadershipPosition);
    }

    public PersonRoleElement getPersonRoleByGUID(String personRoleGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.organizationClient.getPersonRoleByGUID(this.userId, personRoleGUID);
    }

    public List<PersonRoleElement> getPersonRolesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.organizationClient.getPersonRolesByName(this.userId, name, startFrom, pageSize);
    }

    public List<PersonRoleElement> getLeadershipRolesForTeam(String teamGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.organizationClient.getLeadershipRolesForTeam(this.userId, teamGUID, startFrom, pageSize);
    }

    public List<PersonRoleElement> getMembershipRolesForTeam(String teamGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.organizationClient.getMembershipRolesForTeam(this.userId, teamGUID, startFrom, pageSize);
    }

    public List<PersonRoleElement> findPersonRoles(String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.organizationClient.findPersonRoles(this.userId, searchString, startFrom, pageSize);
    }

    public String createSecurityGroup(SecurityGroupProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.securityGroupClient.createSecurityGroup(this.userId, properties);
    }

    public void updateSecurityGroup(String securityGroupGUID, boolean isMergeUpdate, SecurityGroupProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.securityGroupClient.updateSecurityGroup(this.userId, securityGroupGUID, isMergeUpdate, properties);
    }

    public void deleteSecurityGroup(String securityGroupGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.securityGroupClient.deleteSecurityGroup(this.userId, securityGroupGUID);
    }

    public List<SecurityGroupElement> getSecurityGroupsForDistinguishedName(String distinguishedName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.securityGroupClient.getSecurityGroupsForDistinguishedName(this.userId, distinguishedName, startFrom, pageSize);
    }

    public List<ElementStub> getElementsGovernedBySecurityGroup(String securityGroupGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.securityGroupClient.getElementsGovernedBySecurityGroup(this.userId, securityGroupGUID, startFrom, pageSize);
    }

    public List<SecurityGroupElement> findSecurityGroups(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.securityGroupClient.findSecurityGroups(this.userId, searchString, startFrom, pageSize);
    }

    public String createUserIdentity(UserIdentityProperties newIdentity) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.userIdentityClient.createUserIdentity(this.userId, this.externalSourceGUID, this.externalSourceName, newIdentity);
    }

    public String createUserIdentityForProfile(String profileGUID, UserIdentityProperties newIdentity) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.userIdentityClient.createUserIdentityForProfile(this.userId, this.externalSourceGUID, this.externalSourceName, profileGUID, newIdentity);
    }

    public void updateUserIdentity(String userIdentityGUID, boolean isMergeUpdate, UserIdentityProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.userIdentityClient.updateUserIdentity(this.userId, this.externalSourceGUID, this.externalSourceName, userIdentityGUID, isMergeUpdate, properties);
    }

    public void deleteUserIdentity(String userIdentityGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.userIdentityClient.deleteUserIdentity(this.userId, this.externalSourceGUID, this.externalSourceName, userIdentityGUID);
    }

    public void addIdentityToProfile(String userIdentityGUID, String profileGUID, ProfileIdentityProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.userIdentityClient.addIdentityToProfile(this.userId, this.externalSourceGUID, this.externalSourceName, userIdentityGUID, profileGUID, properties);
    }

    public void updateProfileIdentity(String userIdentityGUID, String profileGUID, boolean isMergeUpdate, ProfileIdentityProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.userIdentityClient.updateProfileIdentity(this.userId, this.externalSourceGUID, this.externalSourceName, userIdentityGUID, profileGUID, isMergeUpdate, properties);
    }

    public void removeIdentityFromProfile(String userIdentityGUID, String profileGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.userIdentityClient.removeIdentityFromProfile(this.userId, this.externalSourceGUID, this.externalSourceName, userIdentityGUID, profileGUID);
    }

    public List<UserIdentityElement> findUserIdentities(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.userIdentityClient.findUserIdentities(this.userId, searchString, startFrom, pageSize);
    }

    public List<UserIdentityElement> getUserIdentitiesByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.userIdentityClient.getUserIdentitiesByName(this.userId, name, startFrom, pageSize);
    }

    public UserIdentityElement getUserIdentityByGUID(String userIdentityGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.userIdentityClient.getUserIdentityByGUID(this.userId, userIdentityGUID);
    }
}

