/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.organization.contextmanager;

import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.client.CommunityProfileEventClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.MetadataSourceClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.OrganizationManagement;
import org.odpi.openmetadata.accessservices.communityprofile.client.SecurityGroupManagement;
import org.odpi.openmetadata.accessservices.communityprofile.client.UserIdentityManagement;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.accessservices.communityprofile.properties.MetadataSourceProperties;
import org.odpi.openmetadata.adminservices.configuration.properties.PermittedSynchronization;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.connectors.IntegrationConnector;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.integrationservices.organization.connector.OrganizationIntegratorConnector;
import org.odpi.openmetadata.integrationservices.organization.connector.OrganizationIntegratorContext;
import org.odpi.openmetadata.integrationservices.organization.ffdc.OrganizationIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.organization.ffdc.OrganizationIntegratorErrorCode;

public class OrganizationIntegratorContextManager
extends IntegrationContextManager {
    private MetadataSourceClient metadataSourceClient = null;
    private OrganizationManagement organizationManagement = null;
    private SecurityGroupManagement securityGroupManagement = null;
    private UserIdentityManagement userIdentityManagement = null;

    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, Map<String, Object> serviceOptions, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, serviceOptions, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", OrganizationIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients() throws InvalidParameterException {
        CommunityProfileRESTClient restClient = this.localServerPassword == null ? new CommunityProfileRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.auditLog) : new CommunityProfileRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.auditLog);
        this.metadataSourceClient = new MetadataSourceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize);
        this.organizationManagement = new OrganizationManagement(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize);
        this.securityGroupManagement = new SecurityGroupManagement(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize);
        this.userIdentityManagement = new UserIdentityManagement(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize);
    }

    private String setUpMetadataSource(String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataSourceQualifiedNameParameterName = "metadataSourceQualifiedName";
        String methodName = "setUpMetadataSource";
        InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
        invalidParameterHandler.validateName(metadataSourceQualifiedName, "metadataSourceQualifiedName", "setUpMetadataSource");
        String metadataSourceGUID = this.metadataSourceClient.getMetadataSourceGUID(this.localServerUserId, metadataSourceQualifiedName);
        if (metadataSourceGUID == null) {
            MetadataSourceProperties properties = new MetadataSourceProperties();
            properties.setQualifiedName(metadataSourceQualifiedName);
            metadataSourceGUID = this.metadataSourceClient.createMetadataSource(this.localServerUserId, properties);
        }
        return metadataSourceGUID;
    }

    public void setContext(String connectorId, String connectorName, String metadataSourceQualifiedName, IntegrationConnector integrationConnector, PermittedSynchronization permittedSynchronization) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (this.serviceOptions != null) {
            serviceOptionsString = this.serviceOptions.toString();
        }
        if (!(integrationConnector instanceof OrganizationIntegratorConnector)) {
            String parameterName = "integrationConnector";
            throw new InvalidParameterException(OrganizationIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.ORGANIZATION_INTEGRATOR_OMIS.getIntegrationServiceFullName(), OrganizationIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
        }
        this.auditLog.logMessage("setContext", OrganizationIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
        OrganizationIntegratorConnector serviceSpecificConnector = (OrganizationIntegratorConnector)integrationConnector;
        String metadataSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName);
        CommunityProfileEventClient eventClient = new CommunityProfileEventClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, connectorId);
        serviceSpecificConnector.setContext(new OrganizationIntegratorContext(this.organizationManagement, this.securityGroupManagement, this.userIdentityManagement, eventClient, this.localServerUserId, metadataSourceGUID, metadataSourceQualifiedName, connectorName, this.auditLog));
    }
}

