/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.organization.contextmanager;

import java.util.Map;
import org.odpi.openmetadata.accessservices.communityprofile.client.CommunityProfileEventClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.GovernanceConfigurationClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.MetadataSourceClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.OpenGovernanceClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.OpenIntegrationServiceClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.communityprofile.client.OrganizationManagement;
import org.odpi.openmetadata.accessservices.communityprofile.client.SecurityGroupManagement;
import org.odpi.openmetadata.accessservices.communityprofile.client.UserIdentityManagement;
import org.odpi.openmetadata.accessservices.communityprofile.client.rest.CommunityProfileRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnector;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.integrationservices.organization.connector.OrganizationIntegratorConnector;
import org.odpi.openmetadata.integrationservices.organization.connector.OrganizationIntegratorContext;
import org.odpi.openmetadata.integrationservices.organization.ffdc.OrganizationIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.organization.ffdc.OrganizationIntegratorErrorCode;

public class OrganizationIntegratorContextManager
extends IntegrationContextManager {
    private MetadataSourceClient metadataSourceClient = null;
    private OrganizationManagement organizationManagement = null;
    private SecurityGroupManagement securityGroupManagement = null;
    private UserIdentityManagement userIdentityManagement = null;

    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, Map<String, Object> serviceOptions, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, serviceOptions, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", OrganizationIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients(int maxPageSize) throws InvalidParameterException {
        this.openIntegrationClient = new OpenIntegrationServiceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        this.actionControlInterface = new OpenGovernanceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        this.governanceConfiguration = new GovernanceConfigurationClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, maxPageSize);
        CommunityProfileRESTClient restClient = this.localServerPassword == null ? new CommunityProfileRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.auditLog) : new CommunityProfileRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.auditLog);
        this.metadataSourceClient = new MetadataSourceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize);
        this.organizationManagement = new OrganizationManagement(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize);
        this.securityGroupManagement = new SecurityGroupManagement(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize);
        this.userIdentityManagement = new UserIdentityManagement(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, maxPageSize);
    }

    public IntegrationContext setContext(String connectorId, String connectorName, String connectorUserId, IntegrationConnector integrationConnector, String integrationConnectorGUID, PermittedSynchronization permittedSynchronization, boolean generateIntegrationReport, String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (this.serviceOptions != null) {
            serviceOptionsString = this.serviceOptions.toString();
        }
        if (integrationConnector instanceof OrganizationIntegratorConnector) {
            OrganizationIntegratorConnector serviceSpecificConnector = (OrganizationIntegratorConnector)integrationConnector;
            this.auditLog.logMessage("setContext", OrganizationIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
            String externalSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName, null, null, null);
            String externalSourceName = metadataSourceQualifiedName;
            if (externalSourceGUID == null) {
                externalSourceName = null;
            }
            CommunityProfileEventClient eventClient = new CommunityProfileEventClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, connectorId);
            OrganizationIntegratorContext integratorContext = new OrganizationIntegratorContext(connectorId, connectorName, connectorUserId, this.partnerOMASServerName, this.openIntegrationClient, this.governanceConfiguration, this.openMetadataStoreClient, this.actionControlInterface, this.organizationManagement, this.securityGroupManagement, this.userIdentityManagement, eventClient, generateIntegrationReport, permittedSynchronization, integrationConnectorGUID, externalSourceGUID, externalSourceName, this.maxPageSize, this.auditLog);
            serviceSpecificConnector.setContext(integratorContext);
            integrationConnector.setConnectorName(connectorName);
            return integratorContext;
        }
        String parameterName = "integrationConnector";
        throw new InvalidParameterException(OrganizationIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.ORGANIZATION_INTEGRATOR_OMIS.getIntegrationServiceFullName(), OrganizationIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
    }
}

