/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.organization.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorReportResponse;
import org.odpi.openmetadata.integrationservices.organization.rest.OrganizationIntegratorRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/integration-services/organization-integrator/users/{userId}"})
@Tag(name="Integration Daemon: Organization Integrator OMIS", description="Supports the detection and creation of metadata for file systems and file servers.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omis/organization-integrator/overview/"))
public class OrganizationIntegratorResource {
    private final OrganizationIntegratorRESTServices restAPI = new OrganizationIntegratorRESTServices();

    @GetMapping(path={"/validate-connector/{connectorProviderClassName}"})
    @Operation(summary="validateConnector", description="Validate the connector and return its connector type.  The integration service does not need to be running in the integration daemon in order for this call to be successful.  The integration service only needs to be registered with the integration daemon.", externalDocs=@ExternalDocumentation(description="Integration Connectors", url="https://egeria-project.org/concepts/integration-connector"))
    public ConnectorReportResponse validateConnector(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectorProviderClassName) {
        return this.restAPI.validateConnector(serverName, userId, connectorProviderClassName);
    }
}

