/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.openmetadata.serverchassis.springboot;

import org.springframework.context.ApplicationEvent;

import java.io.Serial;

/**
 *   Application event used for the case of startup list fails
 */
public class StartupFailEvent extends ApplicationEvent
{

    @Serial
    private static final long serialVersionUID = 1L;

    private final Object source;
    private final String message;


    /**
     * Constructor
     *
     * @param source source
     * @param message message
     */
    public StartupFailEvent(Object source, String message)
    {
        super(source);
        this.source = source;
        this.message = message;
    }


    /**
     * Return the source.
     *
     * @return object
     */
    @Override
    public Object getSource()
    {
        return source;
    }


    /**
     * Return the message.
     *
     * @return string
     */
    public String getMessage()
    {
        return message;
    }
}
