/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.platformchassis.springboot;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adminservices.server.OMAGServerAdminStoreServices;
import org.odpi.openmetadata.http.HttpHelper;
import org.odpi.openmetadata.platformchassis.springboot.StartupFailEvent;
import org.odpi.openmetadata.serveroperations.rest.SuccessMessageResponse;
import org.odpi.openmetadata.serveroperations.server.OMAGServerOperationalServices;
import org.odpi.openmetadata.tokenmanager.http.HTTPRequestHeadersFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@SpringBootApplication(scanBasePackages={"${scan.packages:org.odpi.openmetadata.*}"})
@OpenAPIDefinition(info=@Info(title="Egeria's Open Metadata and Governance (OMAG) Server Platform", version="5.0", description="The OMAG Server Platform provides a runtime process and platform for Open Metadata and Governance (OMAG) Services.\n\nThe OMAG services are configured and activated in OMAG Servers using the Administration Services.\nThe configuration operations of the admin services create configuration documents, one for each OMAG Server.  Inside a configuration document is the definition of which OMAG services to activate in the server. These include the repository services (any type of server), the access services (for metadata access points and metadata servers), governance services (for governance servers) and view services (for view servers).  Once a configuration document is defined, the OMAG Server can be started and stopped multiple times by the admin services server instance operations.  \n\nThe OMAG Server Platform also supports platform services to query details of the servers running on the platform.\n\nThe OMAG Server Platform can host multiple OMAG servers at any one time. Each OMAG server is isolated within the server platform and so the OMAG server platform can be used to support multi-tenant operation for a cloud service, or host a variety of different OMAG Servers needed at a particular location.\n\nNOTE: many REST APIs are not guaranteed to be backward-compatible from release to release since they have supported Java clients.  REST APIs may be used for development, testing, evaluation.  Click on the documentation for each module to discover more ...", license=@License(name="Apache-2.0 License", url="https://www.apache.org/licenses/LICENSE-2.0"), contact=@Contact(url="https://egeria-project.org", name="Egeria Project", email="egeria-technical-discuss@lists.lfaidata.foundation")), externalDocs=@ExternalDocumentation(description="OMAG Server Platform documentation", url="https://egeria-project.org/concepts/omag-server-platform/"))
public class OMAGServerPlatform {
    @Value(value="${strict.ssl:true}")
    Boolean strictSSL;
    @Value(value="${startup.user:system}")
    String sysUser;
    @Value(value="${startup.server.list:}")
    String startupServers;
    @Value(value="${authn.header.name.list:}")
    List<String> headerNames;
    @Value(value="${platform.configstore.provider:}")
    String configStoreProvider;
    @Value(value="${platform.configstore.endpoint:}")
    String configStoreEndpoint;
    @Value(value="${platform.default.config.document:}")
    String defaultConfigDocument;
    @Value(value="${platform.placeholder.variables:}")
    String placeholderVariables;
    @Value(value="${platform.security.provider:}")
    String platformSecurityProvider;
    @Value(value="${platform.security.name:}")
    String platformSecurityName;
    @Autowired
    private Environment env;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    private boolean triggeredRuntimeHalt = false;
    private String startupMessage = "";
    private final OMAGServerOperationalServices operationalServices = new OMAGServerOperationalServices();
    private final OMAGServerAdminStoreServices configStoreServices = new OMAGServerAdminStoreServices();
    private static final Logger log = LoggerFactory.getLogger(OMAGServerPlatform.class);

    public static void main(String[] args) {
        SpringApplication.run(OMAGServerPlatform.class, (String[])args);
    }

    @Bean
    public InitializingBean getInitialize() {
        return () -> {
            log.info("Working directory is: " + System.getProperty("user.dir"));
            if (!this.strictSSL.booleanValue()) {
                log.warn("Option strict.ssl is set to false! Invalid certificates will be accepted for connection!");
                HttpHelper.noStrictSSL();
            }
            if (System.getProperty("javax.net.ssl.trustStore") == null) {
                log.warn("Java trust store 'javax.net.ssl.trustStore' is null - this is needed by Tomcat - using 'server.ssl.trust-store'");
                if (this.env.getProperty("server.ssl.trust-store") != null) {
                    System.setProperty("javax.net.ssl.trustStore", this.env.getProperty("server.ssl.trust-store"));
                }
                if (this.env.getProperty("server.ssl.trust-store-password") != null) {
                    System.setProperty("javax.net.ssl.trustStorePassword", this.env.getProperty("server.ssl.trust-store-password"));
                }
            }
        };
    }

    List<String> getAutoStartList() {
        if (!this.startupServers.trim().isEmpty()) {
            String[] splits = this.startupServers.split(",");
            ArrayList<String> serverList = new ArrayList<String>();
            for (String serverName : splits) {
                if (serverName == null || serverName.trim().isEmpty()) continue;
                serverList.add(serverName.trim());
            }
            if (!serverList.isEmpty()) {
                return serverList;
            }
        }
        return null;
    }

    private void autoStartConfig() {
        SuccessMessageResponse response;
        List servers = this.getAutoStartList();
        if (servers != null) {
            log.info("Startup detected for servers: {}", (Object)this.startupServers);
        }
        if ((response = this.operationalServices.activateServerListWithStoredConfig(this.sysUser.trim(), servers)).getRelatedHTTPCode() == 200) {
            this.startupMessage = response.getSuccessMessage();
        } else {
            this.startupMessage = "Server startup failed with error: " + response.getExceptionErrorMessage();
            StartupFailEvent customSpringEvent = new StartupFailEvent((Object)this, this.startupMessage);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)customSpringEvent);
            this.triggeredRuntimeHalt = true;
        }
    }

    private void temporaryDeactivateServers() {
        List servers = this.getAutoStartList();
        if (servers != null) {
            log.info("Temporarily deactivating any auto-started servers '{}'", (Object)servers);
            System.out.println(new Date() + " OMAG Server Platform shutdown requested. Shutting down auto-started servers (if running): " + servers);
            this.operationalServices.deactivateTemporarilyServerList(this.sysUser, servers);
        }
    }

    @Bean
    public FilterRegistrationBean<HTTPRequestHeadersFilter> getRequestHeadersFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new HTTPRequestHeadersFilter(this.headerNames));
        registrationBean.addUrlPatterns(new String[]{"/servers/*"});
        registrationBean.setOrder(1);
        return registrationBean;
    }
}

