/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.platformservices.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.platformservices.properties.OMAGServerInstanceHistory;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ServerStatus {
    private String serverName = null;
    private String serverType = null;
    private boolean isActive = true;
    private Date serverStartTime = null;
    private Date serverEndTime = null;
    private List<OMAGServerInstanceHistory> serverHistory = null;

    public ServerStatus() {
    }

    public ServerStatus(ServerStatus template) {
        if (template != null) {
            this.serverName = template.getServerName();
            this.serverType = template.getServerType();
            this.isActive = template.isActive;
            this.serverStartTime = template.getServerStartTime();
            this.serverEndTime = template.getServerEndTime();
            this.serverHistory = template.getServerHistory();
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public Date getServerStartTime() {
        return this.serverStartTime;
    }

    public void setServerStartTime(Date serverStartTime) {
        this.serverStartTime = serverStartTime;
    }

    public Date getServerEndTime() {
        return this.serverEndTime;
    }

    public void setServerEndTime(Date serverEndTime) {
        this.serverEndTime = serverEndTime;
    }

    public List<OMAGServerInstanceHistory> getServerHistory() {
        if (this.serverHistory == null) {
            return null;
        }
        if (this.serverHistory.isEmpty()) {
            return null;
        }
        return new ArrayList<OMAGServerInstanceHistory>(this.serverHistory);
    }

    public void setServerHistory(List<OMAGServerInstanceHistory> serverHistory) {
        this.serverHistory = serverHistory;
    }

    public String toString() {
        return "ServerStatus{serverName='" + this.serverName + "', serverType='" + this.serverType + "', isActive=" + this.isActive + ", serverStartTime=" + this.serverStartTime + ", serverEndTime=" + this.serverEndTime + ", serverHistory=" + this.serverHistory + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ServerStatus that = (ServerStatus)objectToCompare;
        return this.getIsActive() == that.getIsActive() && Objects.equals(this.getServerName(), that.getServerName()) && Objects.equals(this.getServerType(), that.getServerType()) && Objects.equals(this.getServerStartTime(), that.getServerStartTime()) && Objects.equals(this.getServerEndTime(), that.getServerEndTime()) && Objects.equals(this.getServerHistory(), that.getServerHistory());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getServerName(), this.getServerType(), this.getIsActive(), this.getServerStartTime(), this.getServerEndTime(), this.getServerHistory());
    }
}

