/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.platformservices.client;

import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.platformservices.client.PlatformServicesRESTClient;
import org.odpi.openmetadata.platformservices.properties.ServerStatus;
import org.odpi.openmetadata.platformservices.rest.ServerListResponse;
import org.odpi.openmetadata.platformservices.rest.ServerServicesListResponse;
import org.odpi.openmetadata.platformservices.rest.ServerStatusResponse;

public class PlatformServicesClient {
    private final PlatformServicesRESTClient restClient;
    private final String platformRootURL;
    protected AuditLog auditLog;
    private final String retrieveURLTemplatePrefix = "/open-metadata/platform-services/users/{1}/server-platform";
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();

    public PlatformServicesClient(String platformName, String platformRootURL, AuditLog auditLog) throws InvalidParameterException {
        this.platformRootURL = platformRootURL;
        this.restClient = new PlatformServicesRESTClient(platformName, platformRootURL, auditLog);
    }

    public PlatformServicesClient(String platformName, String platformRootURL) throws InvalidParameterException {
        this.platformRootURL = platformRootURL;
        this.restClient = new PlatformServicesRESTClient(platformName, platformRootURL);
    }

    public PlatformServicesClient(String platformName, String platformRootURL, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        this.platformRootURL = platformRootURL;
        this.restClient = new PlatformServicesRESTClient(platformName, platformRootURL, userId, password, auditLog);
    }

    public PlatformServicesClient(String platformName, String platformRootURL, String userId, String password) throws InvalidParameterException {
        this.platformRootURL = platformRootURL;
        this.restClient = new PlatformServicesRESTClient(platformName, platformRootURL, userId, password);
    }

    public String getPlatformOrigin(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPlatformOrigin";
        this.invalidParameterHandler.validateUserId(userId, "getPlatformOrigin");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/origin";
        String restResult = this.restClient.callStringGetRESTCall("getPlatformOrigin", urlTemplate, userId);
        return restResult;
    }

    public ConnectorType getConnectorType(String userId, String connectorProviderClassName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectorType";
        String connectorProviderParameterName = "connectorProviderClassName";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorType");
        this.invalidParameterHandler.validateName(connectorProviderClassName, "connectorProviderClassName", "getConnectorType");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/connector-types/{1}" + connectorProviderClassName;
        ConnectorTypeResponse restResult = this.restClient.callConnectorTypeGetRESTCall("getConnectorType", urlTemplate, userId, connectorProviderClassName);
        return restResult.getConnectorType();
    }

    public ServerStatus getServerStatus(String userId, String serverName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getServerStatus";
        this.invalidParameterHandler.validateUserId(userId, "getServerStatus");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers/" + serverName + "/status";
        ServerStatusResponse restResult = this.restClient.callServerStatusGetRESTCall("getServerStatus", urlTemplate, userId);
        ServerStatus serverStatus = new ServerStatus();
        serverStatus.setServerName(restResult.getServerName());
        serverStatus.setIsActive(restResult.isActive());
        serverStatus.setServerStartTime(restResult.getServerStartTime());
        serverStatus.setServerEndTime(restResult.getServerEndTime());
        serverStatus.setServerHistory(restResult.getServerHistory());
        return serverStatus;
    }

    public List<String> getActiveServices(String userId, String serverName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActiveServices";
        this.invalidParameterHandler.validateUserId(userId, "getActiveServices");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers/" + serverName + "/services";
        ServerServicesListResponse restResult = this.restClient.callServiceListGetRESTCall("getActiveServices", urlTemplate, userId);
        return restResult.getServerServicesList();
    }

    public List<String> getActiveServers(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActiveServers";
        this.invalidParameterHandler.validateUserId(userId, "getActiveServers");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers/active";
        ServerListResponse restResult = this.restClient.callServerListGetRESTCall("getActiveServers", urlTemplate, userId);
        return restResult.getServerList();
    }

    public List<String> getKnownServers(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getKnownServers";
        this.invalidParameterHandler.validateUserId(userId, "getKnownServers");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/servers";
        ServerListResponse restResult = this.restClient.callServerListGetRESTCall("getKnownServers", urlTemplate, userId);
        return restResult.getServerList();
    }

    public List<RegisteredOMAGService> getAccessServices(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAccessServices";
        this.invalidParameterHandler.validateUserId(userId, "getAccessServices");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/registered-services/access-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getAccessServices", urlTemplate, userId);
        return restResult.getServices();
    }

    public List<RegisteredOMAGService> getEngineServices(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getEngineServices";
        this.invalidParameterHandler.validateUserId(userId, "getEngineServices");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/registered-services/engine-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getEngineServices", urlTemplate, userId);
        return restResult.getServices();
    }

    public List<RegisteredOMAGService> getViewServices(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getViewServices";
        this.invalidParameterHandler.validateUserId(userId, "getViewServices");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/registered-services/view-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getViewServices", urlTemplate, userId);
        return restResult.getServices();
    }

    public List<RegisteredOMAGService> getGovernanceServices(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGovernanceServices";
        this.invalidParameterHandler.validateUserId(userId, "getGovernanceServices");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/registered-services/governance-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getGovernanceServices", urlTemplate, userId);
        return restResult.getServices();
    }

    public List<RegisteredOMAGService> getIntegrationServices(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationServices";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationServices");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/registered-services/integration-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getIntegrationServices", urlTemplate, userId);
        return restResult.getServices();
    }

    public List<RegisteredOMAGService> getCommonServices(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCommonServices";
        this.invalidParameterHandler.validateUserId(userId, "getCommonServices");
        String urlTemplate = this.platformRootURL + "/open-metadata/platform-services/users/{1}/server-platform/registered-services/common-services";
        RegisteredOMAGServicesResponse restResult = this.restClient.callRegisteredOMAGServicesGetRESTCall("getCommonServices", urlTemplate, userId);
        return restResult.getServices();
    }
}

