/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.platformservices.server;

import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerPlatformInstanceMap;
import org.odpi.openmetadata.platformservices.rest.ServerListResponse;
import org.odpi.openmetadata.platformservices.rest.ServerServicesListResponse;
import org.odpi.openmetadata.platformservices.rest.ServerStatusResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMAGServerPlatformActiveServices {
    private static final Logger log = LoggerFactory.getLogger(OMAGServerPlatformActiveServices.class);
    private OMAGServerPlatformInstanceMap serverInstanceMap = new OMAGServerPlatformInstanceMap();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();

    public RegisteredOMAGServicesResponse getRegisteredAccessServices(String userId) {
        String methodName = "getRegisteredAccessServices";
        log.debug("Calling method: getRegisteredAccessServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredAccessServices(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredAccessServices");
        }
        log.debug("Returning from method: getRegisteredAccessServices with response: " + response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getRegisteredEngineServices(String userId) {
        String methodName = "getRegisteredEngineServices";
        log.debug("Calling method: getRegisteredEngineServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredEngineServices(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredEngineServices");
        }
        log.debug("Returning from method: getRegisteredEngineServices with response: " + response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getRegisteredIntegrationServices(String userId) {
        String methodName = "getRegisteredIntegrationServices";
        log.debug("Calling method: getRegisteredIntegrationServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredIntegrationServices(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredIntegrationServices");
        }
        log.debug("Returning from method: getRegisteredIntegrationServices with response: " + response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getRegisteredViewServices(String userId) {
        String methodName = "getRegisteredViewServices";
        log.debug("Calling method: getRegisteredViewServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredViewServices(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredViewServices");
        }
        log.debug("Returning from method: getRegisteredViewServices with response: " + response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getRegisteredGovernanceServices(String userId) {
        String methodName = "getRegisteredGovernanceServices";
        log.debug("Calling method: getRegisteredGovernanceServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredGovernanceServices(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredGovernanceServices");
        }
        log.debug("Returning from method: getRegisteredGovernanceServices with response: " + response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getRegisteredCommonServices(String userId) {
        String methodName = "getRegisteredCommonServices";
        log.debug("Calling method: getRegisteredCommonServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredCommonServices(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredCommonServices");
        }
        log.debug("Returning from method: getRegisteredCommonServices with response: " + response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getAllRegisteredServices(String userId) {
        String methodName = "getAllRegisteredServices";
        log.debug("Calling method: getAllRegisteredServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getAllRegisteredServices(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getAllRegisteredServices");
        }
        log.debug("Returning from method: getAllRegisteredServices with response: " + response.toString());
        return response;
    }

    public BooleanResponse isServerKnown(String userId, String serverName) {
        String methodName = "isServerKnown";
        log.debug("Calling method: isServerKnown");
        BooleanResponse response = new BooleanResponse();
        try {
            response.setFlag(this.serverInstanceMap.isServerKnown(userId, serverName));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "isServerKnown");
        }
        log.debug("Returning from method: isServerKnown with response: " + response.toString());
        return response;
    }

    public ServerListResponse getKnownServerList(String userId) {
        String methodName = "getKnownServerList";
        log.debug("Calling method: getKnownServerList");
        ServerListResponse response = new ServerListResponse();
        try {
            response.setServerList(this.serverInstanceMap.getKnownServerList(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getKnownServerList");
        }
        log.debug("Returning from method: getKnownServerList with response: " + response.toString());
        return response;
    }

    public ServerListResponse getActiveServerList(String userId) {
        String methodName = "getActiveServerList";
        log.debug("Calling method: getActiveServerList");
        ServerListResponse response = new ServerListResponse();
        try {
            response.setServerList(this.serverInstanceMap.getActiveServerList(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getActiveServerList");
        }
        log.debug("Returning from method: getActiveServerList with response: " + response.toString());
        return response;
    }

    public ServerStatusResponse getServerStatus(String userId, String serverName) {
        String methodName = "getServerStatus";
        log.debug("Calling method: getServerStatus");
        ServerStatusResponse response = new ServerStatusResponse();
        try {
            response.setServerName(serverName);
            response.setServerType(this.serverInstanceMap.getServerType(userId, serverName, "getServerStatus"));
            response.setActive(this.serverInstanceMap.isServerActive(userId, serverName));
            response.setServerStartTime(this.serverInstanceMap.getServerStartTime(userId, serverName));
            response.setServerEndTime(this.serverInstanceMap.getServerEndTime(userId, serverName));
            response.setServerHistory(this.serverInstanceMap.getServerHistory(userId, serverName));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getServerStatus");
        }
        log.debug("Returning from method: getServerStatus with response: " + response.toString());
        return response;
    }

    public ServerServicesListResponse getActiveServiceListForServer(String userId, String serverName) {
        String methodName = "getActiveServerList";
        log.debug("Calling method: getActiveServerList");
        ServerServicesListResponse response = new ServerServicesListResponse();
        try {
            response.setServerName(serverName);
            response.setServerServicesList(this.serverInstanceMap.getActiveServiceListForServer(userId, serverName));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getActiveServerList", null);
        }
        log.debug("Returning from method: getActiveServerList with response: " + response.toString());
        return response;
    }
}

