/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.platformservices.server;

import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerPlatformInstanceMap;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.platformservices.rest.ServerListResponse;
import org.odpi.openmetadata.platformservices.rest.ServerServicesListResponse;
import org.odpi.openmetadata.platformservices.rest.ServerStatusResponse;
import org.slf4j.LoggerFactory;

public class OMAGServerPlatformActiveServices {
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerPlatformActiveServices.class), CommonServicesDescription.PLATFORM_SERVICES.getServiceName());
    private final OMAGServerPlatformInstanceMap serverInstanceMap = new OMAGServerPlatformInstanceMap();
    private final RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private final String serverName = "<null>";

    public RegisteredOMAGServicesResponse getRegisteredAccessServices(String userId) {
        String methodName = "getRegisteredAccessServices";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getRegisteredAccessServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredAccessServices(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredAccessServices");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getRegisteredEngineServices(String userId) {
        String methodName = "getRegisteredEngineServices";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getRegisteredEngineServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredEngineServices(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredEngineServices");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getRegisteredIntegrationServices(String userId) {
        String methodName = "getRegisteredIntegrationServices";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getRegisteredIntegrationServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredIntegrationServices(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredIntegrationServices");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getRegisteredViewServices(String userId) {
        String methodName = "getRegisteredViewServices";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getRegisteredViewServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredViewServices(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredViewServices");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getRegisteredGovernanceServices(String userId) {
        String methodName = "getRegisteredGovernanceServices";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getRegisteredGovernanceServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredGovernanceServices(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredGovernanceServices");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getRegisteredCommonServices(String userId) {
        String methodName = "getRegisteredCommonServices";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getRegisteredCommonServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredCommonServices(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredCommonServices");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getAllRegisteredServices(String userId) {
        String methodName = "getAllRegisteredServices";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getAllRegisteredServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getAllRegisteredServices(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getAllRegisteredServices");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectorTypeResponse getConnectorType(String userId, String connectorProviderClassName) {
        String methodName = "getConnectorType";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getConnectorType");
        ConnectorTypeResponse response = new ConnectorTypeResponse();
        try {
            OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform((String)userId);
            Class<?> connectorProviderClass = Class.forName(connectorProviderClassName);
            Object potentialConnectorProvider = connectorProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ConnectorProvider connectorProvider = (ConnectorProvider)potentialConnectorProvider;
            ConnectorType connectorType = connectorProvider.getConnectorType();
            if (connectorType == null) {
                connectorType = new ConnectorType();
                connectorType.setConnectorProviderClassName(connectorProviderClassName);
            }
            response.setConnectorType(connectorType);
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectorType");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public BooleanResponse isServerKnown(String userId, String serverName) {
        String methodName = "isServerKnown";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "isServerKnown");
        BooleanResponse response = new BooleanResponse();
        try {
            response.setFlag(this.serverInstanceMap.isServerKnown(userId, serverName));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "isServerKnown");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerListResponse getKnownServerList(String userId) {
        String methodName = "getKnownServerList";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getKnownServerList");
        ServerListResponse response = new ServerListResponse();
        try {
            response.setServerList(this.serverInstanceMap.getKnownServerList(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getKnownServerList");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerListResponse getActiveServerList(String userId) {
        String methodName = "getActiveServerList";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getActiveServerList");
        ServerListResponse response = new ServerListResponse();
        try {
            response.setServerList(this.serverInstanceMap.getActiveServerList(userId));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getActiveServerList");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerStatusResponse getServerStatus(String userId, String serverName) {
        String methodName = "getServerStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getServerStatus");
        ServerStatusResponse response = new ServerStatusResponse();
        try {
            response.setServerName(serverName);
            response.setServerType(this.serverInstanceMap.getServerType(userId, serverName, "getServerStatus"));
            response.setActive(this.serverInstanceMap.isServerActive(userId, serverName));
            response.setServerStartTime(this.serverInstanceMap.getServerStartTime(userId, serverName));
            response.setServerEndTime(this.serverInstanceMap.getServerEndTime(userId, serverName));
            response.setServerHistory(this.serverInstanceMap.getServerHistory(userId, serverName));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getServerStatus");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerServicesListResponse getActiveServiceListForServer(String userId, String serverName) {
        String methodName = "getActiveServerList";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveServerList");
        ServerServicesListResponse response = new ServerServicesListResponse();
        try {
            response.setServerName(serverName);
            response.setServerServicesList(this.serverInstanceMap.getActiveServiceListForServer(userId, serverName));
        }
        catch (Exception error) {
            this.exceptionHandler.captureExceptions((FFDCResponse)response, error, "getActiveServerList", null);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

