/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.platformservices.server;

import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.adminservices.rest.PlatformSecurityRequestBody;
import org.odpi.openmetadata.adminservices.server.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.server.OMAGServerExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataPlatformSecurityVerifier;
import org.slf4j.LoggerFactory;

public class OMAGServerPlatformSecurityServices {
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerPlatformSecurityServices.class), CommonServicesDescription.PLATFORM_SERVICES.getServiceName());
    private final OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();
    private final OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();

    public synchronized VoidResponse setPlatformSecurityConnection(String userId, PlatformSecurityRequestBody requestBody) {
        String methodName = "setPlatformSecurityConnection";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "setPlatformSecurityConnection");
        VoidResponse response = new VoidResponse();
        try {
            if (requestBody == null) {
                this.exceptionHandler.handleNoRequestBody(userId, "setPlatformSecurityConnection", "<null>");
            } else {
                this.errorHandler.validatePlatformConnection(requestBody.getPlatformSecurityConnection(), "setPlatformSecurityConnection");
                OpenMetadataPlatformSecurityVerifier.setPlatformSecurityConnection((String)userId, (String)requestBody.getUrlRoot(), (Connection)requestBody.getPlatformSecurityConnection());
            }
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("setPlatformSecurityConnection", (FFDCResponseBase)response, (Throwable)error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized ConnectionResponse getPlatformSecurityConnection(String userId) {
        String methodName = "getPlatformSecurityConnection";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "getPlatformSecurityConnection");
        ConnectionResponse response = new ConnectionResponse();
        try {
            response.setConnection(OpenMetadataPlatformSecurityVerifier.getPlatformSecurityConnection((String)userId));
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("getPlatformSecurityConnection", (FFDCResponseBase)response, (Throwable)error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public synchronized VoidResponse clearPlatformSecurityConnection(String userId) {
        String methodName = "clearPlatformSecurityConnection";
        RESTCallToken token = restCallLogger.logRESTCall(null, userId, "clearPlatformSecurityConnection");
        VoidResponse response = new VoidResponse();
        try {
            OpenMetadataPlatformSecurityVerifier.clearPlatformSecurityConnection((String)userId);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("clearPlatformSecurityConnection", (FFDCResponseBase)response, (Throwable)error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

