/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.platformservices.server;

import java.util.Date;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectorTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerPlatformInstanceMap;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.platformservices.rest.ServerListResponse;
import org.odpi.openmetadata.serveroperations.properties.ServerStatus;
import org.odpi.openmetadata.serveroperations.rest.ServerServicesListResponse;
import org.odpi.openmetadata.serveroperations.rest.ServerStatusResponse;
import org.slf4j.LoggerFactory;

public class OMAGServerPlatformActiveServices {
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerPlatformActiveServices.class), CommonServicesDescription.PLATFORM_SERVICES.getServiceName());
    private final OMAGServerPlatformInstanceMap serverInstanceMap = new OMAGServerPlatformInstanceMap();
    private final RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private final String serverName = "<null>";
    private final Date platformStartTime = new Date();

    public Date getPlatformStartTime(String userId) {
        String methodName = "getPlatformStartTime";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getPlatformStartTime");
        restCallLogger.logRESTCallReturn(token, this.platformStartTime.toString());
        return this.platformStartTime;
    }

    public RegisteredOMAGServicesResponse getRegisteredAccessServices(String userId) {
        String methodName = "getRegisteredAccessServices";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getRegisteredAccessServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredAccessServices(userId));
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRegisteredAccessServices", null);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getRegisteredEngineServices(String userId) {
        String methodName = "getRegisteredEngineServices";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getRegisteredEngineServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredEngineServices(userId));
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRegisteredEngineServices", null);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getRegisteredIntegrationServices(String userId) {
        String methodName = "getRegisteredIntegrationServices";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getRegisteredIntegrationServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredIntegrationServices(userId));
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRegisteredIntegrationServices", null);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getRegisteredViewServices(String userId) {
        String methodName = "getRegisteredViewServices";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getRegisteredViewServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredViewServices(userId));
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRegisteredViewServices", null);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getRegisteredGovernanceServices(String userId) {
        String methodName = "getRegisteredGovernanceServices";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getRegisteredGovernanceServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredGovernanceServices(userId));
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRegisteredGovernanceServices", null);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getRegisteredCommonServices(String userId) {
        String methodName = "getRegisteredCommonServices";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getRegisteredCommonServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getRegisteredCommonServices(userId));
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getRegisteredCommonServices", null);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredOMAGServicesResponse getAllRegisteredServices(String userId) {
        String methodName = "getAllRegisteredServices";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getAllRegisteredServices");
        RegisteredOMAGServicesResponse response = new RegisteredOMAGServicesResponse();
        try {
            response.setServices(this.serverInstanceMap.getAllRegisteredServices(userId));
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getAllRegisteredServices", null);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public OCFConnectorTypeResponse getConnectorType(String userId, String connectorProviderClassName) {
        String methodName = "getConnectorType";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getConnectorType");
        OCFConnectorTypeResponse response = new OCFConnectorTypeResponse();
        try {
            OMAGServerPlatformInstanceMap.validateUserAsInvestigatorForPlatform((String)userId);
            Class<?> connectorProviderClass = Class.forName(connectorProviderClassName);
            Object potentialConnectorProvider = connectorProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ConnectorProvider connectorProvider = (ConnectorProvider)potentialConnectorProvider;
            ConnectorType connectorType = connectorProvider.getConnectorType();
            if (connectorType == null) {
                connectorType = new ConnectorType();
                connectorType.setConnectorProviderClassName(connectorProviderClassName);
            }
            response.setConnectorType(connectorType);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getConnectorType", null);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public BooleanResponse isServerKnown(String userId, String serverName) {
        String methodName = "isServerKnown";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "isServerKnown");
        BooleanResponse response = new BooleanResponse();
        try {
            response.setFlag(this.serverInstanceMap.isServerKnown(userId, serverName));
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "isServerKnown", null);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerListResponse getKnownServerList(String userId) {
        String methodName = "getKnownServerList";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getKnownServerList");
        ServerListResponse response = new ServerListResponse();
        try {
            response.setServerList(this.serverInstanceMap.getKnownServerList(userId));
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getKnownServerList", null);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerListResponse getActiveServerList(String userId) {
        String methodName = "getActiveServerList";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "getActiveServerList");
        ServerListResponse response = new ServerListResponse();
        try {
            response.setServerList(this.serverInstanceMap.getActiveServerList(userId));
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getActiveServerList", null);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerStatusResponse getServerStatus(String userId, String serverName) {
        String methodName = "getServerStatus";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getServerStatus");
        ServerStatusResponse response = new ServerStatusResponse();
        try {
            response.setServerName(serverName);
            ServerStatus serverStatus = this.serverInstanceMap.getServerStatus(userId, serverName, "getServerStatus");
            response.setServerType(serverStatus.getServerType());
            response.setActive(serverStatus.getIsActive());
            response.setServerStartTime(serverStatus.getServerStartTime());
            response.setServerEndTime(serverStatus.getServerEndTime());
            response.setServerHistory(serverStatus.getServerHistory());
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getServerStatus", null);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerServicesListResponse getActiveServicesForServer(String userId, String serverName) {
        String methodName = "getActiveServerList";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActiveServerList");
        ServerServicesListResponse response = new ServerServicesListResponse();
        try {
            response.setServerName(serverName);
            response.setServerServicesList(this.serverInstanceMap.getActiveServicesForServer(userId, serverName));
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getActiveServerList", null);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse shutdownPlatform(String userId) {
        String methodName = "shutdownPlatform";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "shutdownPlatform");
        VoidResponse response = new VoidResponse();
        try {
            OMAGServerPlatformInstanceMap.validateUserAsOperatorForPlatform((String)userId);
            System.exit(0);
        }
        catch (Throwable error) {
            this.exceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "shutdownPlatform", null);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

