/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.platformservices.server;

import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.server.OMAGServerErrorHandler;
import org.odpi.openmetadata.adminservices.server.OMAGServerExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.multitenant.OMAGServerPlatformInstanceMap;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.serveroperations.server.OMAGServerOperationalInstanceHandler;
import org.odpi.openmetadata.serveroperations.server.OMAGServerOperationalServices;
import org.slf4j.LoggerFactory;

public class OMAGServerPlatformOperationalServices {
    private final OMAGServerOperationalInstanceHandler serverOperationalInstanceHandler = new OMAGServerOperationalInstanceHandler(CommonServicesDescription.SERVER_OPERATIONS.getServiceName());
    private final OMAGServerOperationalServices serverOperationalServices = new OMAGServerOperationalServices();
    private final OMAGServerPlatformInstanceMap platformInstanceMap = new OMAGServerPlatformInstanceMap();
    private final OMAGServerErrorHandler errorHandler = new OMAGServerErrorHandler();
    private final OMAGServerExceptionHandler exceptionHandler = new OMAGServerExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OMAGServerPlatformOperationalServices.class), CommonServicesDescription.PLATFORM_SERVICES.getServiceName());

    public VoidResponse shutdownAllServers(String userId) {
        String methodName = "shutdownAllServer";
        String serverName = "<null>";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "shutdownAllServer");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateUserId(userId, "<null>", "shutdownAllServer");
            List activeServers = this.platformInstanceMap.getActiveServerList(userId);
            if (activeServers != null) {
                for (String activeServerName : activeServers) {
                    this.serverOperationalServices.deactivateRunningServiceInstances(userId, activeServerName, "shutdownAllServer", this.serverOperationalInstanceHandler.getServerServiceInstance(userId, activeServerName, "shutdownAllServer"), false);
                }
            }
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("<null>", "shutdownAllServer", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse shutdownAndUnregisterAllServers(String userId) {
        String methodName = "shutdownAndUnregisterAllServers";
        String serverName = "<null>";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "shutdownAndUnregisterAllServers");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateUserId(userId, "<null>", "shutdownAndUnregisterAllServers");
            List activeServers = this.platformInstanceMap.getActiveServerList(userId);
            if (activeServers != null) {
                for (String activeServerName : activeServers) {
                    this.serverOperationalServices.deactivateRunningServiceInstances(userId, activeServerName, "shutdownAndUnregisterAllServers", this.serverOperationalInstanceHandler.getServerServiceInstance(userId, activeServerName, "shutdownAndUnregisterAllServers"), true);
                }
            }
        }
        catch (InvalidParameterException error) {
            this.exceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.exceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("<null>", "shutdownAndUnregisterAllServers", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse shutdownPlatform(String userId) {
        String methodName = "shutdownPlatform";
        String serverName = "<null>";
        RESTCallToken token = restCallLogger.logRESTCall("<null>", userId, "shutdownPlatform");
        VoidResponse response = new VoidResponse();
        try {
            this.errorHandler.validateUserId(userId, "<null>", "shutdownPlatform");
            Runtime.getRuntime().exit(1);
        }
        catch (OMAGNotAuthorizedException error) {
            this.exceptionHandler.captureNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Exception error) {
            this.exceptionHandler.capturePlatformRuntimeException("<null>", "shutdownPlatform", (FFDCResponseBase)response, error);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

