/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.platformservices.server.spring;

import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServicesResponse;
import org.odpi.openmetadata.platformservices.rest.ServerListResponse;
import org.odpi.openmetadata.platformservices.rest.ServerServicesListResponse;
import org.odpi.openmetadata.platformservices.rest.ServerStatusResponse;
import org.odpi.openmetadata.platformservices.server.OMAGServerPlatformActiveServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/platform-services/users/{userId}/server-platform"})
public class OMAGServerPlatformActiveResource {
    OMAGServerPlatformActiveServices platformAPI = new OMAGServerPlatformActiveServices();

    @RequestMapping(method={RequestMethod.GET}, path={"/registered-services/access-services"})
    public RegisteredOMAGServicesResponse getRegisteredAccessServices(@PathVariable String userId) {
        return this.platformAPI.getRegisteredAccessServices(userId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/registered-services/governance-services"})
    public RegisteredOMAGServicesResponse getRegisteredGovernanceServices(@PathVariable String userId) {
        return this.platformAPI.getRegisteredGovernanceServices(userId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/registered-services/common-services"})
    public RegisteredOMAGServicesResponse getRegisteredCommonServices(@PathVariable String userId) {
        return this.platformAPI.getRegisteredCommonServices(userId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/registered-services"})
    public RegisteredOMAGServicesResponse getAllRegisteredServices(@PathVariable String userId) {
        return this.platformAPI.getAllRegisteredServices(userId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/servers/{serverName}/is-known"})
    public BooleanResponse isServerKnown(@PathVariable String userId, @PathVariable String serverName) {
        return this.platformAPI.isServerKnown(userId, serverName);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/servers"})
    public ServerListResponse getKnownServerList(@PathVariable String userId) {
        return this.platformAPI.getKnownServerList(userId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/servers/active"})
    public ServerListResponse getActiveServerList(@PathVariable String userId) {
        return this.platformAPI.getActiveServerList(userId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/servers/{serverName}/status"})
    public ServerStatusResponse getServerStatus(@PathVariable String userId, @PathVariable String serverName) {
        return this.platformAPI.getServerStatus(userId, serverName);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/servers/{serverName}/services"})
    public ServerServicesListResponse getActiveServiceListForServer(@PathVariable String userId, @PathVariable String serverName) {
        return this.platformAPI.getActiveServiceListForServer(userId, serverName);
    }
}

