/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.platformservices.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.platformservices.server.OMAGServerPlatformOriginServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/platform-services/users/{userId}"})
@Tag(name="Platform Services", description="The platform services provides the APIs for querying the Open Metadata and Governance (OMAG) Server Platform and discovering information about the OMAG Servers that it is hosting.", externalDocs=@ExternalDocumentation(description="Platform Services", url="https://odpi.github.io/egeria-docs/services/platform-services"))
public class ServerPlatformOriginResource {
    OMAGServerPlatformOriginServices originAPI = new OMAGServerPlatformOriginServices();

    @Deprecated
    @GetMapping(path={"/server-platform-origin"})
    public String getOldServerOrigin(@PathVariable String userId) {
        return this.originAPI.getServerPlatformOrigin(userId);
    }

    @GetMapping(path={"/server-platform/origin"})
    @Operation(summary="Get origin description of this OMAG Server Platform", description="Retrieve a string that details the provider and version of this platform", responses={@ApiResponse(responseCode="200", description="server platform origin description", content={@Content(mediaType="text/plain")})})
    public String getServerOrigin(@Parameter(description="calling user") @PathVariable String userId) {
        return this.originAPI.getServerPlatformOrigin(userId);
    }
}

