/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.platformservices.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.rest.ConnectionResponse;
import org.odpi.openmetadata.adminservices.rest.PlatformSecurityRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.platformservices.server.OMAGServerPlatformSecurityServices;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/admin-services/users/{userId}/platform/security"})
@Tag(name="Platform Services", description="The platform services provides the APIs for querying the Open Metadata and Governance (OMAG) Server Platform. It is able to start an stop OMAG Servers and discovering information about the OMAG Servers that the OMAG Server Platform is hosting.  It is also able to dynamically change the platform metadata security connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/platform-services/overview"))
@Deprecated
public class OldPlatformSecurityResource {
    private final OMAGServerPlatformSecurityServices adminSecurityAPI = new OMAGServerPlatformSecurityServices();

    @PostMapping(path={"/connection"})
    public VoidResponse setPlatformSecurityConnection(@PathVariable String userId, @RequestBody PlatformSecurityRequestBody requestBody) {
        return this.adminSecurityAPI.setPlatformSecurityConnection(userId, requestBody);
    }

    @GetMapping(path={"/connection"})
    public ConnectionResponse getPlatformSecurityConnection(@PathVariable String userId) {
        return this.adminSecurityAPI.getPlatformSecurityConnection(userId);
    }

    @DeleteMapping(path={"/connection"})
    public VoidResponse clearPlatformSecurityConnection(@PathVariable String userId) {
        return this.adminSecurityAPI.clearPlatformSecurityConnection(userId);
    }
}

