/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.platformservices.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.platformservices.server.OMAGServerPlatformOperationalServices;
import org.odpi.openmetadata.serveroperations.rest.OMAGServerStatusResponse;
import org.odpi.openmetadata.serveroperations.rest.SuccessMessageResponse;
import org.odpi.openmetadata.serveroperations.server.OMAGServerOperationalServices;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/platform-services/users/{userId}/server-platform"})
@Tag(name="Platform Services", description="The platform services provides the APIs for querying the Open Metadata and Governance (OMAG) Server Platform. It is able to start an stop OMAG Servers and discovering information about the OMAG Servers that the OMAG Server Platform is hosting.  It is also able to dynamically change the platform metadata security connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/platform-services/overview"))
public class OMAGServerOperationResource {
    private final OMAGServerOperationalServices serverOperationalServices = new OMAGServerOperationalServices();
    private final OMAGServerPlatformOperationalServices platformOperationalServices = new OMAGServerPlatformOperationalServices();

    @PostMapping(path={"/servers/{serverName}/instance"})
    @Operation(summary="activateWithStoredConfig", description="Activate the named OMAG server using the appropriate configuration document found in the configuration store.", externalDocs=@ExternalDocumentation(description="Configuration Documents", url="https://egeria-project.org/concepts/configuration-document"))
    public SuccessMessageResponse activateWithStoredConfig(@PathVariable String userId, @PathVariable String serverName) {
        return this.serverOperationalServices.activateWithStoredConfig(userId, serverName);
    }

    @PostMapping(path={"/servers/{serverName}/instance/configuration"})
    @Operation(summary="activateWithSuppliedConfig", description="Activate the named OMAG server using the supplied configuration document. This configuration document is added to the configuration store, over-writing any previous configuration for this server.", externalDocs=@ExternalDocumentation(description="Configuration Documents", url="https://egeria-project.org/concepts/configuration-document"))
    public SuccessMessageResponse activateWithSuppliedConfig(@PathVariable String userId, @PathVariable String serverName, @RequestBody OMAGServerConfig configuration) {
        return this.serverOperationalServices.activateWithSuppliedConfig(userId, serverName, configuration);
    }

    @DeleteMapping(path={"/servers/{serverName}/instance"})
    @Operation(summary="shutdownServer", description="Temporarily shutdown the named OMAG server.  This server can be restarted as a later time.")
    public VoidResponse shutdownServer(@PathVariable String userId, @PathVariable String serverName) {
        return this.serverOperationalServices.shutdownServer(userId, serverName);
    }

    @DeleteMapping(path={"/servers/instance"})
    @Operation(summary="shutdownAllServers", description="Shutdown all active servers.  They can be restarted as a later time.")
    public VoidResponse shutdownAllServers(@PathVariable String userId) {
        return this.platformOperationalServices.shutdownAllServers(userId);
    }

    @DeleteMapping(path={"/servers/{serverName}"})
    @Operation(summary="shutdownAndUnregisterServer", description="Shutdown the named OMAG server.  The server will also be removed from any open metadata repository cohorts it has registered with.")
    public VoidResponse shutdownAndUnregisterServer(@PathVariable String userId, @PathVariable String serverName) {
        return this.serverOperationalServices.shutdownAndUnregisterServer(userId, serverName);
    }

    @DeleteMapping(path={"/servers"})
    @Operation(summary="shutdownAndUnregisterAllServers", description="Shutdown all OMAG Servers that are active on the platform.  The servers will also be removed from any open metadata repository cohorts they are registered with.")
    public VoidResponse shutdownAndUnregisterAllServers(@PathVariable String userId) {
        return this.platformOperationalServices.shutdownAndUnregisterAllServers(userId);
    }

    @DeleteMapping(path={"/instance"})
    @Operation(summary="shutdownPlatform", description="Shutdown this OMAG Server Platform.")
    public VoidResponse shutdownPlatform(@PathVariable String userId) {
        return this.platformOperationalServices.shutdownPlatform(userId);
    }

    @GetMapping(path={"/servers/{serverName}/instance/configuration"})
    @Operation(summary="getActiveConfiguration", description="Retrieve the configuration document used to start a running instance of a server. The stored configuration document may have changed since the server was started.  This operation makes it possible to verify the configuration values actually being used in the running server. An InvalidParameterException is returned if the server is not running.", externalDocs=@ExternalDocumentation(description="Configuration Documents", url="https://egeria-project.org/concepts/configuration-document"))
    public OMAGServerConfigResponse getActiveConfiguration(@PathVariable String userId, @PathVariable String serverName) {
        return this.serverOperationalServices.getActiveConfiguration(userId, serverName);
    }

    @GetMapping(path={"/servers/{serverName}/instance/status"})
    @Operation(summary="getActiveServerStatus", description="Retrieve the status for a running instance of a server. The stored configuration document may have changed since the server was started.  This operation makes it possible to verify that all the services. An InvalidParameterException is returned if the server is not running.", externalDocs=@ExternalDocumentation(description="OMAG Server", url="https://egeria-project.org/concepts/omag-server"))
    public OMAGServerStatusResponse getActiveServerStatus(@PathVariable String userId, @PathVariable String serverName) {
        return this.serverOperationalServices.getActiveServerStatus(userId, serverName);
    }

    @PostMapping(path={"/servers/{serverName}/instance/open-metadata-archives/file"})
    @Operation(summary="addOpenMetadataArchiveFile", description="An open metadata archive contains metadata types and instances.  This operation loads an open metadata archive that is readable through the connector identified by the connection.  It can be used with OMAG servers that are of type Cohort Member.", externalDocs=@ExternalDocumentation(description="Open Metadata Archives", url="https://egeria-project.org/concepts/open-metadata-archives/"))
    public VoidResponse addOpenMetadataArchiveFile(@PathVariable String userId, @PathVariable String serverName, @RequestBody String fileName) {
        return this.serverOperationalServices.addOpenMetadataArchiveFile(userId, serverName, fileName);
    }

    @PostMapping(path={"/servers/{serverName}/instance/open-metadata-archives/connection"})
    @Operation(summary="addOpenMetadataArchive", description="An open metadata archive contains metadata types and instances.  This operation loads an open metadata archive that is readable through the connector identified by the connection.  It can be used with OMAG servers that are of type Cohort Member.", externalDocs=@ExternalDocumentation(description="Open Metadata Archives", url="https://egeria-project.org/concepts/open-metadata-archives/"))
    public VoidResponse addOpenMetadataArchive(@PathVariable String userId, @PathVariable String serverName, @RequestBody Connection connection) {
        return this.serverOperationalServices.addOpenMetadataArchive(userId, serverName, connection);
    }
}

