/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.database;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnector;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.mappers.BaseMapper;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.properties.JDBCDataValue;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.database.QueryBuilder;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.ffdc.PostgresErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers.ClassificationMapper;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers.ControlMapper;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers.EntityMapper;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers.RelationshipMapper;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.schema.RepositoryColumn;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.schema.RepositoryTable;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class DatabaseStore {
    private final JDBCResourceConnector jdbcResourceConnector;
    private final String repositoryName;
    private final OMRSRepositoryHelper repositoryHelper;
    private final BaseMapper baseMapper;

    public DatabaseStore(JDBCResourceConnector jdbcResourceConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper) {
        this.jdbcResourceConnector = jdbcResourceConnector;
        this.repositoryName = repositoryName;
        this.repositoryHelper = repositoryHelper;
        this.baseMapper = new BaseMapper(repositoryName);
    }

    public ControlMapper getControlTable() throws RepositoryErrorException {
        String methodName = "getControlTable";
        try {
            List controlTable = this.jdbcResourceConnector.getRows(RepositoryTable.CONTROL.getTableName(), RepositoryTable.CONTROL.getColumnNameTypeMap());
            if (controlTable == null) {
                return null;
            }
            return new ControlMapper(this.repositoryName, controlTable);
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "getControlTable", sqlException.getMessage()), this.getClass().getName(), "getControlTable", (Throwable)sqlException);
        }
    }

    public void saveControlTable(ControlMapper controlMapper) throws RepositoryErrorException {
        String methodName = "saveControlTable";
        try {
            this.jdbcResourceConnector.insertRowIntoTable(RepositoryTable.CONTROL.getTableName(), controlMapper.getControlTableRow());
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "saveControlTable", sqlException.getMessage()), this.getClass().getName(), "saveControlTable", (Throwable)sqlException);
        }
    }

    public EntityMapper getEntityForUpdate(String guid) throws RepositoryErrorException {
        return this.getEntityFromStore(guid, null);
    }

    public RelationshipMapper getRelationshipForUpdate(String guid) throws RepositoryErrorException {
        return this.getRelationshipFromStore(guid, null);
    }

    public ClassificationMapper getClassificationForUpdate(String entityGUID, String classificationName) throws RepositoryErrorException {
        String methodName = "getClassificationForUpdate";
        try {
            Map classificationRow = this.jdbcResourceConnector.getMatchingRow(RepositoryTable.CLASSIFICATION.getTableName(), RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + entityGUID + "' and " + RepositoryColumn.CLASSIFICATION_NAME.getColumnName() + " = '" + classificationName + "'" + this.getAsOfTimeClause(null), RepositoryTable.CLASSIFICATION.getColumnNameTypeMap());
            if (classificationRow != null) {
                BaseMapper baseMapper = new BaseMapper(this.repositoryName);
                long version = baseMapper.getLongPropertyFromColumn(RepositoryColumn.VERSION.getColumnName(), classificationRow, true);
                String whereClause = RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + entityGUID + "' and " + RepositoryColumn.CLASSIFICATION_NAME.getColumnName() + " = '" + classificationName + "' and " + RepositoryColumn.VERSION.getColumnName() + " = " + version;
                List classificationProperties = this.jdbcResourceConnector.getMatchingRows(RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getTableName(), whereClause, RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getColumnNameTypeMap());
                return new ClassificationMapper(classificationRow, classificationProperties, this.repositoryHelper, this.repositoryName);
            }
            return null;
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "getClassificationForUpdate", sqlException.getMessage()), this.getClass().getName(), "getClassificationForUpdate", (Throwable)sqlException);
        }
    }

    public List<ClassificationMapper> getHomeClassifications(String guid, String localMetadataCollectionId, Date asOfTime) throws RepositoryErrorException {
        String methodName = "getHomeClassifications";
        try {
            String whereClause = RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + guid + "' and " + RepositoryColumn.METADATA_COLLECTION_GUID.getColumnName() + " = '" + localMetadataCollectionId + "' " + this.getAsOfTimeClause(asOfTime) + ";";
            List classifications = this.jdbcResourceConnector.getMatchingRows(RepositoryTable.CLASSIFICATION.getTableName(), whereClause, RepositoryTable.CLASSIFICATION.getColumnNameTypeMap());
            ArrayList<ClassificationMapper> classificationMappers = null;
            if (classifications != null) {
                classificationMappers = new ArrayList<ClassificationMapper>();
                for (Map classificationRow : classifications) {
                    if (classificationRow == null) continue;
                    String classificationName = this.baseMapper.getStringPropertyFromColumn(RepositoryColumn.CLASSIFICATION_NAME.getColumnName(), classificationRow, true);
                    long version = this.baseMapper.getLongPropertyFromColumn(RepositoryColumn.VERSION.getColumnName(), classificationRow, true);
                    String classificationWhereClause = RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + guid + "' and " + RepositoryColumn.VERSION.getColumnName() + " = " + version + " and " + RepositoryColumn.CLASSIFICATION_NAME.getColumnName() + " = '" + classificationName + "';";
                    List classificationProperties = this.jdbcResourceConnector.getMatchingRows(RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getTableName(), classificationWhereClause, RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getColumnNameTypeMap());
                    ClassificationMapper classificationMapper = new ClassificationMapper(classificationRow, classificationProperties, this.repositoryHelper, this.repositoryName);
                    classificationMappers.add(classificationMapper);
                }
            }
            return classificationMappers;
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "getHomeClassifications", sqlException.getMessage()), this.getClass().getName(), "getHomeClassifications", (Throwable)sqlException);
        }
    }

    public EntityMapper getEntityFromStore(String guid, Date asOfTime) throws RepositoryErrorException {
        String methodName = "getEntityFromStore";
        try {
            Map entityRow = this.jdbcResourceConnector.getMatchingRow(RepositoryTable.ENTITY.getTableName(), RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + guid + "'" + this.getAsOfTimeClause(asOfTime), RepositoryTable.ENTITY.getColumnNameTypeMap());
            return this.getCompleteEntityFromStore(guid, entityRow, asOfTime);
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "getEntityFromStore", sqlException.getMessage()), this.getClass().getName(), "getEntityFromStore", (Throwable)sqlException);
        }
    }

    public RelationshipMapper getRelationshipFromStore(String guid, Date asOfTime) throws RepositoryErrorException {
        String methodName = "getRelationshipFromStore";
        try {
            Map relationshipRow = this.jdbcResourceConnector.getMatchingRow(RepositoryTable.RELATIONSHIP.getTableName(), RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + guid + "'" + this.getAsOfTimeClause(asOfTime), RepositoryTable.RELATIONSHIP.getColumnNameTypeMap());
            return this.getCompleteRelationshipFromStore(guid, relationshipRow, asOfTime);
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "getRelationshipFromStore", sqlException.getMessage()), this.getClass().getName(), "getRelationshipFromStore", (Throwable)sqlException);
        }
    }

    public List<EntityMapper> retrieveEntitiesByProperties(QueryBuilder entityQueryBuilder, QueryBuilder classificationQueryBuilder, Date asOfTime) throws RepositoryErrorException {
        String methodName = "retrieveEntitiesByProperties";
        String sqlEntityQuery = "select distinct * from " + RepositoryTable.ENTITY.getTableName() + " where " + entityQueryBuilder.getAsOfTimeWhereClause();
        try {
            List entityRows;
            if (classificationQueryBuilder == null) {
                entityRows = this.jdbcResourceConnector.getMatchingRows(sqlEntityQuery + entityQueryBuilder.getSequenceAndPaging(RepositoryTable.ENTITY.getTableName()), RepositoryTable.ENTITY.getColumnNameTypeMap());
            } else {
                String sqlClassificationQuery = classificationQueryBuilder.getPropertyJoinQuery(RepositoryTable.CLASSIFICATION.getTableName(), RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getTableName(), RepositoryColumn.INSTANCE_GUID.getColumnName(RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getTableName())) + " where " + classificationQueryBuilder.getAsOfTimeWhereClause();
                entityRows = this.jdbcResourceConnector.getMatchingRows(sqlEntityQuery + " and " + RepositoryColumn.INSTANCE_GUID.getColumnName(RepositoryTable.ENTITY.getTableName()) + " in (" + sqlClassificationQuery + ")" + entityQueryBuilder.getSequenceAndPaging(RepositoryTable.ENTITY.getTableName()), RepositoryTable.ENTITY.getColumnNameTypeMap());
            }
            if (entityRows != null) {
                Map<String, EntityMapper> entityMappers = this.getCompleteEntitiesFromStore(entityRows, asOfTime);
                return new ArrayList<EntityMapper>(entityMappers.values());
            }
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "retrieveEntitiesByProperties", sqlException.getMessage()), this.getClass().getName(), "retrieveEntitiesByProperties", (Throwable)sqlException);
        }
        return null;
    }

    public List<RelationshipMapper> retrieveRelationships(QueryBuilder queryBuilder, Date asOfTime) throws RepositoryErrorException {
        String methodName = "retrieveRelationships";
        String sqQuery = "select distinct * from " + RepositoryTable.RELATIONSHIP.getTableName() + " where " + queryBuilder.getAsOfTimeWhereClause();
        try {
            List relationshipRows = this.jdbcResourceConnector.getMatchingRows(sqQuery + queryBuilder.getSequenceAndPaging(RepositoryTable.RELATIONSHIP.getTableName()), RepositoryTable.RELATIONSHIP.getColumnNameTypeMap());
            if (relationshipRows != null) {
                return this.getCompleteRelationshipsFromStore(relationshipRows, asOfTime);
            }
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "retrieveRelationships", sqlException.getMessage()), this.getClass().getName(), "retrieveRelationships", (Throwable)sqlException);
        }
        return null;
    }

    public List<RelationshipMapper> retrieveRelationshipsByProperties(QueryBuilder queryBuilder, Date asOfTime) throws RepositoryErrorException {
        String methodName = "retrieveRelationshipsByProperties";
        String sqlQuery = "select distinct * from " + RepositoryTable.RELATIONSHIP.getTableName() + " where " + queryBuilder.getAsOfTimeWhereClause() + queryBuilder.getSequenceAndPaging(RepositoryTable.RELATIONSHIP.getTableName());
        try {
            List relationshipRows = this.jdbcResourceConnector.getMatchingRows(sqlQuery, RepositoryTable.RELATIONSHIP.getColumnNameTypeMap());
            if (relationshipRows != null) {
                return this.getCompleteRelationshipsFromStore(relationshipRows, asOfTime);
            }
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "retrieveRelationshipsByProperties", sqlException.getMessage()), this.getClass().getName(), "retrieveRelationshipsByProperties", (Throwable)sqlException);
        }
        return null;
    }

    public EntityMapper getCompleteEntityFromStore(String guid, Map<String, JDBCDataValue> entityRow, Date asOfTime) throws RepositoryErrorException {
        String methodName = "getCompleteEntityFromStore";
        try {
            Object versionObject;
            if (entityRow != null && (versionObject = entityRow.get(RepositoryColumn.VERSION.getColumnName()).getDataValue()) != null) {
                String whereClause = RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + guid + "' and " + RepositoryColumn.VERSION.getColumnName() + " = " + versionObject;
                List entityProperties = this.jdbcResourceConnector.getMatchingRows(RepositoryTable.ENTITY_ATTRIBUTE_VALUE.getTableName(), whereClause, RepositoryTable.ENTITY_ATTRIBUTE_VALUE.getColumnNameTypeMap());
                Map<String, List<ClassificationMapper>> classificationMappersForEntityGUIDs = this.getClassificationMappersForEntityGUIDs(RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + guid + "'" + this.getAsOfTimeClause(asOfTime));
                return new EntityMapper(entityRow, entityProperties, classificationMappersForEntityGUIDs.get(guid), this.repositoryHelper, this.repositoryName);
            }
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "getCompleteEntityFromStore", sqlException.getMessage()), this.getClass().getName(), "getCompleteEntityFromStore", (Throwable)sqlException);
        }
        return null;
    }

    public RelationshipMapper getCompleteRelationshipFromStore(String guid, Map<String, JDBCDataValue> relationshipRow, Date asOfTime) throws RepositoryErrorException {
        String methodName = "getCompleteRelationshipFromStore";
        try {
            if (relationshipRow != null) {
                long version = this.baseMapper.getLongPropertyFromColumn(RepositoryColumn.VERSION.getColumnName(), relationshipRow, true);
                String end1GUID = this.baseMapper.getStringPropertyFromColumn(RepositoryColumn.END_1_GUID.getColumnName(), relationshipRow, true);
                String end2GUID = this.baseMapper.getStringPropertyFromColumn(RepositoryColumn.END_2_GUID.getColumnName(), relationshipRow, true);
                String whereClause = RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + guid + "' and " + RepositoryColumn.VERSION.getColumnName() + " = " + version;
                List relationshipProperties = this.jdbcResourceConnector.getMatchingRows(RepositoryTable.RELATIONSHIP_ATTRIBUTE_VALUE.getTableName(), whereClause, RepositoryTable.RELATIONSHIP_ATTRIBUTE_VALUE.getColumnNameTypeMap());
                EntityMapper end1Mapper = this.getEntityFromStore(end1GUID, asOfTime);
                EntityMapper end2Mapper = this.getEntityFromStore(end2GUID, asOfTime);
                return new RelationshipMapper(relationshipRow, relationshipProperties, end1Mapper, end2Mapper, this.repositoryHelper, this.repositoryName);
            }
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "getCompleteRelationshipFromStore", sqlException.getMessage()), this.getClass().getName(), "getCompleteRelationshipFromStore", (Throwable)sqlException);
        }
        return null;
    }

    private Map<String, EntityMapper> getCompleteEntitiesFromGUIDs(List<String> entityGUIDs, Date asOfTime) throws RepositoryErrorException {
        String methodName = "getCompleteEntitiesFromGUIDs";
        HashMap<String, EntityMapper> entities = new HashMap<String, EntityMapper>();
        if (entityGUIDs != null && !entityGUIDs.isEmpty()) {
            try {
                QueryBuilder queryBuilder = new QueryBuilder(RepositoryTable.ENTITY.getTableName(), RepositoryTable.ENTITY_ATTRIBUTE_VALUE.getTableName(), this.repositoryHelper, this.repositoryName);
                queryBuilder.setGUIDList(entityGUIDs);
                queryBuilder.setAsOfTime(asOfTime);
                List entityRows = this.jdbcResourceConnector.getMatchingRows(RepositoryTable.ENTITY.getTableName(), queryBuilder.getAsOfTimeWhereClause() + queryBuilder.getSequenceAndPaging(RepositoryTable.ENTITY.getTableName()), RepositoryTable.ENTITY.getColumnNameTypeMap());
                return this.getCompleteEntitiesFromStore(entityRows, asOfTime);
            }
            catch (PropertyServerException sqlException) {
                throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "getCompleteEntitiesFromGUIDs", sqlException.getMessage()), this.getClass().getName(), "getCompleteEntitiesFromGUIDs", (Throwable)sqlException);
            }
        }
        return entities;
    }

    private Map<String, EntityMapper> getCompleteEntitiesFromStore(List<Map<String, JDBCDataValue>> entityRows, Date asOfTime) throws RepositoryErrorException {
        if (entityRows != null && !entityRows.isEmpty()) {
            Map<String, DatabaseResultRows> databaseResultRowsMap = this.getAttributesDatabaseResults(entityRows, RepositoryTable.ENTITY, RepositoryTable.ENTITY_ATTRIBUTE_VALUE);
            QueryBuilder queryBuilder = new QueryBuilder(RepositoryTable.CLASSIFICATION.getTableName(), RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getTableName(), this.repositoryHelper, this.repositoryName);
            queryBuilder.setGUIDList(new ArrayList<String>(databaseResultRowsMap.keySet()));
            queryBuilder.setAsOfTime(asOfTime);
            Map<String, List<ClassificationMapper>> classificationMappersForEntityGUIDs = this.getClassificationMappersForEntityGUIDs(queryBuilder.getAsOfTimeWhereClause() + queryBuilder.getSequenceAndPaging(RepositoryTable.CLASSIFICATION.getTableName()));
            if (!databaseResultRowsMap.isEmpty()) {
                HashMap<String, EntityMapper> entityMappers = new HashMap<String, EntityMapper>();
                for (String instanceGUID : databaseResultRowsMap.keySet()) {
                    DatabaseResultRows databaseResultRows = databaseResultRowsMap.get(instanceGUID);
                    entityMappers.put(instanceGUID, new EntityMapper(databaseResultRows.principleTableRow, databaseResultRows.propertyTableRows, classificationMappersForEntityGUIDs.get(instanceGUID), this.repositoryHelper, this.repositoryName));
                }
                return entityMappers;
            }
        }
        return null;
    }

    private List<RelationshipMapper> getCompleteRelationshipsFromStore(List<Map<String, JDBCDataValue>> relationshipRows, Date asOfTime) throws RepositoryErrorException {
        Map<String, DatabaseResultRows> mapperResultRowsMap;
        if (relationshipRows != null && !relationshipRows.isEmpty() && !(mapperResultRowsMap = this.getAttributesDatabaseResults(relationshipRows, RepositoryTable.RELATIONSHIP, RepositoryTable.RELATIONSHIP_ATTRIBUTE_VALUE)).isEmpty()) {
            ArrayList<String> entityGUIDs = new ArrayList<String>();
            for (Map<String, JDBCDataValue> relationshipRow : relationshipRows) {
                String entityGUID = this.baseMapper.getStringPropertyFromColumn(RepositoryColumn.END_1_GUID.getColumnName(), relationshipRow, true);
                if (!entityGUIDs.contains(entityGUID)) {
                    entityGUIDs.add(entityGUID);
                }
                if (entityGUIDs.contains(entityGUID = this.baseMapper.getStringPropertyFromColumn(RepositoryColumn.END_2_GUID.getColumnName(), relationshipRow, true))) continue;
                entityGUIDs.add(entityGUID);
            }
            Map<String, EntityMapper> entityEnds = this.getCompleteEntitiesFromGUIDs(entityGUIDs, asOfTime);
            ArrayList<RelationshipMapper> relationshipMappers = new ArrayList<RelationshipMapper>();
            for (DatabaseResultRows databaseResultRows : mapperResultRowsMap.values()) {
                String end1GUID = this.baseMapper.getStringPropertyFromColumn(RepositoryColumn.END_1_GUID.getColumnName(), databaseResultRows.principleTableRow, true);
                String end2GUID = this.baseMapper.getStringPropertyFromColumn(RepositoryColumn.END_2_GUID.getColumnName(), databaseResultRows.principleTableRow, true);
                EntityMapper end1Mapper = entityEnds.get(end1GUID);
                EntityMapper end2Mapper = entityEnds.get(end2GUID);
                relationshipMappers.add(new RelationshipMapper(databaseResultRows.principleTableRow, databaseResultRows.propertyTableRows, end1Mapper, end2Mapper, this.repositoryHelper, this.repositoryName));
            }
            return relationshipMappers;
        }
        return null;
    }

    private Map<String, DatabaseResultRows> getAttributesDatabaseResults(List<Map<String, JDBCDataValue>> instanceRows, RepositoryTable principleTable, RepositoryTable attributesTable) throws RepositoryErrorException {
        String methodName = "getAttributesDatabaseResults";
        try {
            HashMap<String, DatabaseResultRows> databaseResultRowsMap = new HashMap<String, DatabaseResultRows>();
            QueryBuilder queryBuilder = new QueryBuilder(principleTable.getTableName(), attributesTable.getTableName(), this.repositoryHelper, this.repositoryName);
            ArrayList<String> instanceGUIDs = new ArrayList<String>();
            StringBuilder instanceWhereClause = new StringBuilder();
            boolean firstInstance = true;
            for (Map<String, JDBCDataValue> instanceRow : instanceRows) {
                String instanceGUID = this.baseMapper.getStringPropertyFromColumn(RepositoryColumn.INSTANCE_GUID.getColumnName(), instanceRow, true);
                if (instanceGUIDs.contains(instanceGUID)) continue;
                instanceGUIDs.add(instanceGUID);
                long version = this.baseMapper.getLongPropertyFromColumn(RepositoryColumn.VERSION.getColumnName(), instanceRow, true);
                if (firstInstance) {
                    firstInstance = false;
                } else {
                    instanceWhereClause.append(" or ");
                }
                instanceWhereClause.append(queryBuilder.getPrimaryKeysClause(instanceGUID, version, null));
                DatabaseResultRows databaseResultRows = new DatabaseResultRows();
                databaseResultRows.principleTableRow = instanceRow;
                databaseResultRowsMap.put(instanceGUID, databaseResultRows);
            }
            List attributeRows = this.jdbcResourceConnector.getMatchingRows(attributesTable.getTableName(), instanceWhereClause.toString(), attributesTable.getColumnNameTypeMap());
            if (attributeRows != null) {
                for (Map attributeRow : attributeRows) {
                    String instanceGUID = this.baseMapper.getStringPropertyFromColumn(RepositoryColumn.INSTANCE_GUID.getColumnName(), attributeRow, true);
                    DatabaseResultRows databaseResultRows = (DatabaseResultRows)databaseResultRowsMap.get(instanceGUID);
                    if (databaseResultRows.propertyTableRows == null) {
                        databaseResultRows.propertyTableRows = new ArrayList<Map<String, JDBCDataValue>>();
                    }
                    databaseResultRows.propertyTableRows.add(attributeRow);
                }
            }
            return databaseResultRowsMap;
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "getAttributesDatabaseResults", sqlException.getMessage()), this.getClass().getName(), "getAttributesDatabaseResults", (Throwable)sqlException);
        }
    }

    private Map<String, List<ClassificationMapper>> getClassificationMappersForEntityGUIDs(String whereClause) throws RepositoryErrorException {
        String methodName = "getClassificationMappersForEntityGUIDs";
        HashMap<String, List<ClassificationMapper>> classificationMappersForEntity = new HashMap<String, List<ClassificationMapper>>();
        try {
            List classifications = this.jdbcResourceConnector.getMatchingRows(RepositoryTable.CLASSIFICATION.getTableName(), whereClause, RepositoryTable.CLASSIFICATION.getColumnNameTypeMap());
            if (classifications != null) {
                HashMap<String, DatabaseResultRows> mapperResultRowsMap = new HashMap<String, DatabaseResultRows>();
                QueryBuilder queryBuilder = new QueryBuilder(RepositoryTable.CLASSIFICATION.getTableName(), RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getTableName(), this.repositoryHelper, this.repositoryName);
                StringBuilder classificationWhereClause = new StringBuilder();
                boolean firstClassification = true;
                for (Map classificationRow : classifications) {
                    DatabaseResultRows classificationMapperRow;
                    String instanceGUID = this.baseMapper.getStringPropertyFromColumn(RepositoryColumn.INSTANCE_GUID.getColumnName(), classificationRow, true);
                    String classificationName = this.baseMapper.getStringPropertyFromColumn(RepositoryColumn.CLASSIFICATION_NAME.getColumnName(), classificationRow, true);
                    long version = this.baseMapper.getLongPropertyFromColumn(RepositoryColumn.VERSION.getColumnName(), classificationRow, true);
                    if (firstClassification) {
                        firstClassification = false;
                    } else {
                        classificationWhereClause.append(" or ");
                    }
                    classificationWhereClause.append(queryBuilder.getPrimaryKeysClause(instanceGUID, version, classificationName));
                    DatabaseResultRows databaseResultRows = (DatabaseResultRows)mapperResultRowsMap.get(instanceGUID);
                    if (databaseResultRows == null) {
                        databaseResultRows = new DatabaseResultRows();
                    }
                    if (databaseResultRows.propertyTableRows == null) {
                        databaseResultRows.propertyTableRows = new ArrayList<Map<String, JDBCDataValue>>();
                    }
                    if (databaseResultRows.classifications == null) {
                        databaseResultRows.classifications = new HashMap<String, DatabaseResultRows>();
                    }
                    if ((classificationMapperRow = databaseResultRows.classifications.get(classificationName)) == null) {
                        classificationMapperRow = new DatabaseResultRows();
                    }
                    classificationMapperRow.principleTableRow = classificationRow;
                    databaseResultRows.classifications.put(classificationName, classificationMapperRow);
                    mapperResultRowsMap.put(instanceGUID, databaseResultRows);
                }
                List classificationAttributes = this.jdbcResourceConnector.getMatchingRows(RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getTableName(), classificationWhereClause.toString(), RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getColumnNameTypeMap());
                if (classificationAttributes != null) {
                    for (Map classificationAttributeRow : classificationAttributes) {
                        String instanceGUID = this.baseMapper.getStringPropertyFromColumn(RepositoryColumn.INSTANCE_GUID.getColumnName(), classificationAttributeRow, true);
                        String classificationName = this.baseMapper.getStringPropertyFromColumn(RepositoryColumn.CLASSIFICATION_NAME.getColumnName(), classificationAttributeRow, true);
                        DatabaseResultRows databaseResultRows = (DatabaseResultRows)mapperResultRowsMap.get(instanceGUID);
                        DatabaseResultRows classificationAttributesMapperResults = databaseResultRows.classifications.get(classificationName);
                        if (classificationAttributesMapperResults.propertyTableRows == null) {
                            classificationAttributesMapperResults.propertyTableRows = new ArrayList<Map<String, JDBCDataValue>>();
                        }
                        classificationAttributesMapperResults.propertyTableRows.add(classificationAttributeRow);
                    }
                }
                if (!mapperResultRowsMap.isEmpty()) {
                    for (String instanceGUID : mapperResultRowsMap.keySet()) {
                        DatabaseResultRows databaseResultRows = (DatabaseResultRows)mapperResultRowsMap.get(instanceGUID);
                        if (databaseResultRows == null || databaseResultRows.classifications == null) continue;
                        ArrayList<ClassificationMapper> classificationMappers = new ArrayList<ClassificationMapper>();
                        for (String classificationName : databaseResultRows.classifications.keySet()) {
                            DatabaseResultRows classificationMapperResults = databaseResultRows.classifications.get(classificationName);
                            ClassificationMapper classificationMapper = new ClassificationMapper(classificationMapperResults.principleTableRow, classificationMapperResults.propertyTableRows, this.repositoryHelper, this.repositoryName);
                            classificationMappers.add(classificationMapper);
                        }
                        if (classificationMappers.isEmpty()) continue;
                        classificationMappersForEntity.put(instanceGUID, classificationMappers);
                    }
                }
            }
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "getClassificationMappersForEntityGUIDs", sqlException.getMessage()), this.getClass().getName(), "getClassificationMappersForEntityGUIDs", (Throwable)sqlException);
        }
        return classificationMappersForEntity;
    }

    public List<EntityMapper> getEntityHistoryFromStore(String guid, Date fromTime, Date toTime, boolean oldestFirst) throws RepositoryErrorException {
        String methodName = "getEntityHistoryFromStore";
        ArrayList<EntityMapper> entityMappers = new ArrayList<EntityMapper>();
        try {
            List entityRows = this.jdbcResourceConnector.getMatchingRows(RepositoryTable.ENTITY.getTableName(), RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + guid + "'" + this.getDateRangeClause(fromTime, toTime, oldestFirst), RepositoryTable.ENTITY.getColumnNameTypeMap());
            if (entityRows != null) {
                for (Map entityRow : entityRows) {
                    Date versionEndTime = this.baseMapper.getDatePropertyFromColumn(RepositoryColumn.VERSION_END_TIME.getColumnName(), entityRow, false);
                    entityMappers.add(this.getCompleteEntityFromStore(guid, entityRow, versionEndTime));
                }
            }
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "getEntityHistoryFromStore", sqlException.getMessage()), this.getClass().getName(), "getEntityHistoryFromStore", (Throwable)sqlException);
        }
        if (!entityMappers.isEmpty()) {
            return entityMappers;
        }
        return null;
    }

    public List<RelationshipMapper> getRelationshipHistoryFromStore(String guid, Date fromTime, Date toTime, boolean oldestFirst) throws RepositoryErrorException {
        String methodName = "getRelationshipHistoryFromStore";
        ArrayList<RelationshipMapper> relationshipMappers = new ArrayList<RelationshipMapper>();
        try {
            List relationshipRows = this.jdbcResourceConnector.getMatchingRows(RepositoryTable.RELATIONSHIP.getTableName(), RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + guid + "'" + this.getDateRangeClause(fromTime, toTime, oldestFirst), RepositoryTable.RELATIONSHIP.getColumnNameTypeMap());
            if (relationshipRows != null) {
                for (Map relationshipRow : relationshipRows) {
                    Date asOfTime = this.baseMapper.getDatePropertyFromColumn(RepositoryColumn.VERSION_START_TIME.getColumnName(), relationshipRow, true);
                    relationshipMappers.add(this.getCompleteRelationshipFromStore(guid, relationshipRow, asOfTime));
                }
            }
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "getRelationshipHistoryFromStore", sqlException.getMessage()), this.getClass().getName(), "getRelationshipHistoryFromStore", (Throwable)sqlException);
        }
        if (!relationshipMappers.isEmpty()) {
            return relationshipMappers;
        }
        return null;
    }

    private String getAsOfTimeClause(Date asOfTime) {
        if (asOfTime == null) {
            return " and " + RepositoryColumn.VERSION_END_TIME.getColumnName() + " is null";
        }
        return " and (" + RepositoryColumn.VERSION_START_TIME.getColumnName() + " <= '" + asOfTime + "' and (" + RepositoryColumn.VERSION_END_TIME.getColumnName() + " is null or " + RepositoryColumn.VERSION_END_TIME.getColumnName() + " > '" + asOfTime + "'))";
    }

    private String getDateRangeClause(Date fromTime, Date toTime, boolean oldestFirst) {
        if (fromTime == null && toTime == null) {
            return this.getOrderByDateClause(oldestFirst);
        }
        if (fromTime == null) {
            return " and (" + RepositoryColumn.VERSION_START_TIME.getColumnName() + " < '" + toTime + "')" + this.getOrderByDateClause(oldestFirst);
        }
        if (toTime == null) {
            return " and (" + RepositoryColumn.VERSION_END_TIME.getColumnName() + " is null or " + RepositoryColumn.VERSION_END_TIME.getColumnName() + " > '" + fromTime + "')" + this.getOrderByDateClause(oldestFirst);
        }
        return " and (" + RepositoryColumn.VERSION_START_TIME.getColumnName() + " < '" + toTime + "' and (" + RepositoryColumn.VERSION_END_TIME.getColumnName() + " is null or " + RepositoryColumn.VERSION_END_TIME.getColumnName() + " > '" + fromTime + "'))" + this.getOrderByDateClause(oldestFirst);
    }

    private String getOrderByDateClause(boolean oldestFirst) {
        if (oldestFirst) {
            return " order by " + RepositoryColumn.VERSION_START_TIME.getColumnName() + " asc";
        }
        return " order by " + RepositoryColumn.VERSION_START_TIME.getColumnName() + " desc";
    }

    public void addEntityToStore(EntityMapper entityMapper) throws RepositoryErrorException {
        String methodName = "addEntityToStore";
        try {
            this.jdbcResourceConnector.insertRowIntoTable(RepositoryTable.ENTITY.getTableName(), entityMapper.getEntityTableRow());
            this.jdbcResourceConnector.insertRowsIntoTable(RepositoryTable.ENTITY_ATTRIBUTE_VALUE.getTableName(), entityMapper.getEntityPropertiesTableRows());
            List<ClassificationMapper> classificationMappers = entityMapper.getClassificationMappers();
            if (classificationMappers != null) {
                for (ClassificationMapper classificationMapper : classificationMappers) {
                    ClassificationMapper storedClassification = this.getClassificationForUpdate(classificationMapper.getEntityGUID(), classificationMapper.getClassification().getName());
                    if (storedClassification == null) {
                        this.saveClassification(classificationMapper);
                        continue;
                    }
                    if (classificationMapper.getClassification().getVersion() <= storedClassification.getClassification().getVersion()) continue;
                    this.updatePreviousClassificationVersionEndTime(storedClassification, this.getVersionEndDate(classificationMapper.getClassification().getUpdateTime()));
                    this.saveClassification(classificationMapper);
                }
            }
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "addEntityToStore", sqlException.getMessage()), this.getClass().getName(), "addEntityToStore", (Throwable)sqlException);
        }
    }

    public Date getVersionEndDate(Date updateTime) throws RepositoryErrorException {
        String methodName = "getVersionEndDate";
        if (updateTime != null) {
            long versionEndDate = updateTime.getTime() - 1L;
            return new Date(versionEndDate);
        }
        throw new RepositoryErrorException(PostgresErrorCode.MISSING_MAPPING_VALUE.getMessageDefinition("updateTime", "getVersionEndDate", this.getClass().getName()), this.getClass().getName(), "getVersionEndDate");
    }

    public void addEntityProxyToStore(EntityMapper entityMapper) throws RepositoryErrorException {
        String methodName = "addEntityProxyToStore";
        try {
            EntityMapper existingEntity = this.getEntityForUpdate(entityMapper.getEntityProxy().getGUID());
            if (existingEntity == null) {
                this.jdbcResourceConnector.insertRowIntoTable(RepositoryTable.ENTITY.getTableName(), entityMapper.getEntityTableRow());
                this.jdbcResourceConnector.insertRowsIntoTable(RepositoryTable.ENTITY_ATTRIBUTE_VALUE.getTableName(), entityMapper.getUniquePropertiesTableRows());
                this.saveClassifications(entityMapper.getClassificationMappers());
            }
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "addEntityProxyToStore", sqlException.getMessage()), this.getClass().getName(), "addEntityProxyToStore", (Throwable)sqlException);
        }
    }

    private void saveClassifications(List<ClassificationMapper> classificationMappers) throws RepositoryErrorException {
        if (classificationMappers != null) {
            for (ClassificationMapper classificationMapper : classificationMappers) {
                this.saveClassification(classificationMapper);
            }
        }
    }

    public void saveClassification(ClassificationMapper classificationMapper) throws RepositoryErrorException {
        String methodName = "saveClassification";
        if (classificationMapper != null) {
            try {
                this.jdbcResourceConnector.insertRowIntoTable(RepositoryTable.CLASSIFICATION.getTableName(), classificationMapper.getClassificationTableRow());
                this.jdbcResourceConnector.insertRowsIntoTable(RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getTableName(), classificationMapper.getClassificationPropertiesTableRows());
            }
            catch (PropertyServerException sqlException) {
                throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "saveClassification", sqlException.getMessage()), this.getClass().getName(), "saveClassification", (Throwable)sqlException);
            }
        }
    }

    public void addRelationshipToStore(RelationshipMapper relationshipMapper) throws RepositoryErrorException {
        String methodName = "addRelationshipToStore";
        try {
            this.addEntityProxyToStore(relationshipMapper.getEnd1Mapper());
            this.addEntityProxyToStore(relationshipMapper.getEnd2Mapper());
            this.jdbcResourceConnector.insertRowIntoTable(RepositoryTable.RELATIONSHIP.getTableName(), relationshipMapper.getRelationshipTableRow());
            this.jdbcResourceConnector.insertRowsIntoTable(RepositoryTable.RELATIONSHIP_ATTRIBUTE_VALUE.getTableName(), relationshipMapper.getRelationshipPropertiesTableRows());
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "addRelationshipToStore", sqlException.getMessage()), this.getClass().getName(), "addRelationshipToStore", (Throwable)sqlException);
        }
    }

    public void updatePreviousEntityVersionEndTime(EntityMapper entityMapper, Date versionEndTime) throws RepositoryErrorException {
        String methodName = "updatePreviousEntityVersionEndTime";
        try {
            this.jdbcResourceConnector.issueSQLCommand("update " + RepositoryTable.ENTITY.getTableName() + " set " + RepositoryColumn.VERSION_END_TIME.getColumnName() + " = '" + versionEndTime + "' where " + RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + entityMapper.getEntityDetail().getGUID() + "' and " + RepositoryColumn.VERSION.getColumnName() + " = " + entityMapper.getEntityDetail().getVersion() + ";");
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "updatePreviousEntityVersionEndTime", sqlException.getMessage()), this.getClass().getName(), "updatePreviousEntityVersionEndTime", (Throwable)sqlException);
        }
    }

    public void updatePreviousClassificationVersionEndTime(ClassificationMapper classificationMapper, Date versionEndTime) throws RepositoryErrorException {
        String methodName = "updatePreviousClassificationVersionEndTime";
        try {
            this.jdbcResourceConnector.issueSQLCommand("update " + RepositoryTable.CLASSIFICATION.getTableName() + " set " + RepositoryColumn.VERSION_END_TIME.getColumnName() + " = '" + versionEndTime + "' where " + RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + classificationMapper.getEntityGUID() + "' and " + RepositoryColumn.CLASSIFICATION_NAME.getColumnName() + " = '" + classificationMapper.getClassification().getName() + "' and " + RepositoryColumn.VERSION.getColumnName() + " = " + classificationMapper.getClassification().getVersion() + ";");
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "updatePreviousClassificationVersionEndTime", sqlException.getMessage()), this.getClass().getName(), "updatePreviousClassificationVersionEndTime", (Throwable)sqlException);
        }
    }

    public void updatePreviousRelationshipVersionEndTime(RelationshipMapper relationshipMapper, Date versionEndTime) throws RepositoryErrorException {
        String methodName = "updatePreviousRelationshipVersionEndTime";
        try {
            this.jdbcResourceConnector.issueSQLCommand("update " + RepositoryTable.RELATIONSHIP.getTableName() + " set " + RepositoryColumn.VERSION_END_TIME.getColumnName() + " = '" + versionEndTime + "' where " + RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + relationshipMapper.getRelationship().getGUID() + "' and " + RepositoryColumn.VERSION.getColumnName() + " = " + relationshipMapper.getRelationship().getVersion() + ";");
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "updatePreviousRelationshipVersionEndTime", sqlException.getMessage()), this.getClass().getName(), "updatePreviousRelationshipVersionEndTime", (Throwable)sqlException);
        }
    }

    public void purgeClassification(String entityGUID, String classificationName) throws RepositoryErrorException {
        String methodName = "purgeClassification";
        try {
            this.jdbcResourceConnector.issueSQLCommand("delete from " + RepositoryTable.CLASSIFICATION.getTableName() + " where " + RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + entityGUID + "' and " + RepositoryColumn.CLASSIFICATION_NAME.getColumnName() + " = '" + classificationName + "';");
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "purgeClassification", sqlException.getMessage()), this.getClass().getName(), "purgeClassification", (Throwable)sqlException);
        }
    }

    public void purgeEntity(String guid) throws RepositoryErrorException {
        String methodName = "purgeEntity";
        try {
            List relationshipRows = this.jdbcResourceConnector.getMatchingRows(RepositoryTable.RELATIONSHIP.getTableName(), "(" + RepositoryColumn.END_1_GUID.getColumnName() + " = '" + guid + "' or " + RepositoryColumn.END_2_GUID.getColumnName() + " = '" + guid + "')", RepositoryTable.RELATIONSHIP.getColumnNameTypeMap());
            if (relationshipRows != null) {
                for (Map relationshipRow : relationshipRows) {
                    String relationshipGUID = this.baseMapper.getStringPropertyFromColumn(RepositoryColumn.INSTANCE_GUID.getColumnName(), relationshipRow, true);
                    this.purgeRelationship(relationshipGUID);
                }
            }
            this.jdbcResourceConnector.issueSQLCommand("delete from " + RepositoryTable.ENTITY.getTableName() + " where " + RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + guid + "';");
            this.jdbcResourceConnector.issueSQLCommand("delete from " + RepositoryTable.ENTITY_ATTRIBUTE_VALUE.getTableName() + " where " + RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + guid + "';");
            this.jdbcResourceConnector.issueSQLCommand("delete from " + RepositoryTable.CLASSIFICATION.getTableName() + " where " + RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + guid + "';");
            this.jdbcResourceConnector.issueSQLCommand("delete from " + RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getTableName() + " where " + RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + guid + "';");
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "purgeEntity", sqlException.getMessage()), this.getClass().getName(), "purgeEntity", (Throwable)sqlException);
        }
    }

    public void purgeRelationship(String guid) throws RepositoryErrorException {
        String methodName = "purgeRelationship";
        try {
            this.jdbcResourceConnector.issueSQLCommand("delete from " + RepositoryTable.RELATIONSHIP.getTableName() + " where " + RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + guid + "';");
            this.jdbcResourceConnector.issueSQLCommand("delete from " + RepositoryTable.RELATIONSHIP_ATTRIBUTE_VALUE.getTableName() + " where " + RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + guid + "';");
        }
        catch (PropertyServerException sqlException) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)sqlException)).getClass().getName(), "purgeRelationship", sqlException.getMessage()), this.getClass().getName(), "purgeRelationship", (Throwable)sqlException);
        }
    }

    static class DatabaseResultRows {
        Map<String, JDBCDataValue> principleTableRow = null;
        List<Map<String, JDBCDataValue>> propertyTableRows = null;
        Map<String, DatabaseResultRows> classifications = null;

        DatabaseResultRows() {
        }
    }
}

