/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.properties.JDBCDataValue;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.ffdc.PostgresErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers.RepositoryMapper;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.schema.RepositoryColumn;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class ClassificationMapper
extends RepositoryMapper {
    private String entityGUID = null;
    private Classification classification = null;
    private Map<String, JDBCDataValue> classificationTableRow = null;
    private List<Map<String, JDBCDataValue>> classificationPropertiesTableRows = null;

    public ClassificationMapper(String entityGUID, Classification classification, OMRSRepositoryHelper repositoryHelper, String repositoryName) {
        super(repositoryHelper, repositoryName);
        this.entityGUID = entityGUID;
        this.classification = classification;
    }

    public ClassificationMapper(Map<String, JDBCDataValue> classificationTableRow, List<Map<String, JDBCDataValue>> classificationPropertiesTableRows, OMRSRepositoryHelper repositoryHelper, String repositoryName) {
        super(repositoryHelper, repositoryName);
        this.classificationTableRow = classificationTableRow;
        this.classificationPropertiesTableRows = classificationPropertiesTableRows;
    }

    public Classification getClassification() throws RepositoryErrorException {
        String methodName = "getClassification";
        if (this.classification == null) {
            if (this.classificationTableRow != null) {
                Classification newClassification = new Classification();
                super.fillInstanceAuditHeader((InstanceAuditHeader)newClassification, this.classificationTableRow);
                newClassification.setName(super.getStringPropertyFromColumn(RepositoryColumn.CLASSIFICATION_NAME.getColumnName(), this.classificationTableRow, true));
                newClassification.setProperties(super.getInstanceProperties(this.classificationTableRow, this.classificationPropertiesTableRows));
                this.classification = newClassification;
            } else {
                throw new RepositoryErrorException(PostgresErrorCode.MISSING_MAPPING_VALUE.getMessageDefinition("classificationTableRow", "getClassification", ((Object)((Object)this)).getClass().getName()), ((Object)((Object)this)).getClass().getName(), "getClassification");
            }
        }
        return this.classification;
    }

    public String getEntityGUID() throws RepositoryErrorException {
        String methodName = "getEntityGUID";
        if (this.entityGUID == null) {
            if (this.classificationTableRow != null) {
                this.entityGUID = super.getStringPropertyFromColumn(RepositoryColumn.INSTANCE_GUID.getColumnName(), this.classificationTableRow, true);
            } else {
                throw new RepositoryErrorException(PostgresErrorCode.MISSING_MAPPING_VALUE.getMessageDefinition("classificationTableRow", "getEntityGUID", ((Object)((Object)this)).getClass().getName()), ((Object)((Object)this)).getClass().getName(), "getEntityGUID");
            }
        }
        return this.entityGUID;
    }

    public Map<String, JDBCDataValue> getClassificationTableRow() throws RepositoryErrorException {
        String methodName = "getClassificationTableRow";
        if (this.classificationTableRow == null) {
            HashMap<String, JDBCDataValue> newClassificationTableRow = new HashMap<String, JDBCDataValue>();
            if (this.classification != null && this.entityGUID != null) {
                if (this.classification.getProperties() != null) {
                    super.extractValuesFromInstanceAuditHeader(newClassificationTableRow, this.entityGUID, this.classification.getName(), this.classification.getProperties().getEffectiveFromTime(), this.classification.getProperties().getEffectiveToTime(), null, (InstanceAuditHeader)this.classification);
                } else {
                    super.extractValuesFromInstanceAuditHeader(newClassificationTableRow, this.entityGUID, this.classification.getName(), null, null, null, (InstanceAuditHeader)this.classification);
                }
            } else {
                throw new RepositoryErrorException(PostgresErrorCode.MISSING_MAPPING_VALUE.getMessageDefinition("classification and/or entityGUID", "getClassificationTableRow", ((Object)((Object)this)).getClass().getName()), ((Object)((Object)this)).getClass().getName(), "getClassificationTableRow");
            }
            if (!newClassificationTableRow.isEmpty()) {
                this.classificationTableRow = newClassificationTableRow;
            }
        }
        return this.classificationTableRow;
    }

    public List<Map<String, JDBCDataValue>> getClassificationPropertiesTableRows() throws RepositoryErrorException {
        String methodName = "getClassificationPropertiesTableRows";
        if (this.classificationPropertiesTableRows == null) {
            if (this.classification != null) {
                this.classificationPropertiesTableRows = this.extractValuesFromInstanceProperties(this.entityGUID, this.classification.getName(), this.classification.getVersion(), this.classification.getType().getTypeDefName(), this.classification.getProperties(), null, null);
            } else {
                throw new RepositoryErrorException(PostgresErrorCode.MISSING_MAPPING_VALUE.getMessageDefinition("classification", "getClassificationPropertiesTableRows", ((Object)((Object)this)).getClass().getName()), ((Object)((Object)this)).getClass().getName(), "getClassificationPropertiesTableRows");
            }
        }
        return this.classificationPropertiesTableRows;
    }
}

