/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.mappers.BaseMapper;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.properties.JDBCDataValue;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.schema.RepositoryColumn;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class ControlMapper
extends BaseMapper {
    private String serverName = null;
    private String localMetadataCollectionGUID = null;
    private String schemaVersion = null;

    public ControlMapper(String repositoryName, String serverName, String localMetadataCollectionGUID, String schemaVersion) {
        super(repositoryName);
        this.serverName = serverName;
        this.localMetadataCollectionGUID = localMetadataCollectionGUID;
        this.schemaVersion = schemaVersion;
    }

    public ControlMapper(String repositoryName, List<Map<String, JDBCDataValue>> controlTable) throws RepositoryErrorException {
        super(repositoryName);
        if (controlTable != null && !controlTable.isEmpty()) {
            this.serverName = super.getStringPropertyFromColumn(RepositoryColumn.SERVER_NAME.getColumnName(), controlTable.get(0), true);
            this.localMetadataCollectionGUID = super.getStringPropertyFromColumn(RepositoryColumn.LOCAL_METADATA_COLLECTION_GUID.getColumnName(), controlTable.get(0), true);
            this.schemaVersion = super.getStringPropertyFromColumn(RepositoryColumn.SCHEMA_VERSION.getColumnName(), controlTable.get(0), true);
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getLocalMetadataCollectionGUID() {
        return this.localMetadataCollectionGUID;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public Map<String, JDBCDataValue> getControlTableRow() throws RepositoryErrorException {
        HashMap<String, JDBCDataValue> newControlTableRow = new HashMap<String, JDBCDataValue>();
        super.setUpStringValueInRow(newControlTableRow, this.serverName, RepositoryColumn.SERVER_NAME.getColumnName(), true);
        super.setUpStringValueInRow(newControlTableRow, this.localMetadataCollectionGUID, RepositoryColumn.LOCAL_METADATA_COLLECTION_GUID.getColumnName(), true);
        super.setUpStringValueInRow(newControlTableRow, this.schemaVersion, RepositoryColumn.SCHEMA_VERSION.getColumnName(), true);
        return newControlTableRow;
    }
}

