/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.mappers.BaseMapper;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.properties.ColumnType;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.properties.JDBCDataValue;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.ffdc.PostgresErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.schema.RepositoryColumn;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.StructPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class RepositoryMapper
extends BaseMapper {
    final OMRSRepositoryHelper repositoryHelper;
    final String repositoryName;

    public RepositoryMapper(OMRSRepositoryHelper repositoryHelper, String repositoryName) {
        super(repositoryName);
        this.repositoryHelper = repositoryHelper;
        this.repositoryName = repositoryName;
    }

    private InstanceProvenanceType getInstanceProvenanceType(Map<String, JDBCDataValue> instanceTableRow) throws RepositoryErrorException {
        String methodName = "getInstanceProvenanceType";
        String instanceProvenanceTypeName = super.getStringPropertyFromColumn(RepositoryColumn.INSTANCE_PROVENANCE_TYPE.getColumnName(), instanceTableRow, true);
        for (InstanceProvenanceType instanceProvenanceType : InstanceProvenanceType.values()) {
            if (!instanceProvenanceType.getName().equals(instanceProvenanceTypeName)) continue;
            return instanceProvenanceType;
        }
        throw new RepositoryErrorException(PostgresErrorCode.INVALID_REPOSITORY_VALUE.getMessageDefinition(this.repositoryName, RepositoryColumn.INSTANCE_PROVENANCE_TYPE.getColumnName(), "getInstanceProvenanceType", ((Object)((Object)this)).getClass().getName(), instanceTableRow.toString()), ((Object)((Object)this)).getClass().getName(), "getInstanceProvenanceType");
    }

    private InstanceStatus getInstanceStatus(String columnName, Map<String, JDBCDataValue> instanceTableRow, boolean isRequired) throws RepositoryErrorException {
        String methodName = "getInstanceStatus";
        String instanceStatusName = super.getStringPropertyFromColumn(columnName, instanceTableRow, isRequired);
        for (InstanceStatus instanceStatus : InstanceStatus.values()) {
            if (!instanceStatus.getName().equals(instanceStatusName)) continue;
            return instanceStatus;
        }
        if (isRequired) {
            throw new RepositoryErrorException(PostgresErrorCode.INVALID_REPOSITORY_VALUE.getMessageDefinition(this.repositoryName, columnName, "getInstanceStatus", ((Object)((Object)this)).getClass().getName(), instanceTableRow.toString()), ((Object)((Object)this)).getClass().getName(), "getInstanceStatus");
        }
        return null;
    }

    protected void fillInstanceAuditHeader(InstanceAuditHeader instanceAuditHeader, Map<String, JDBCDataValue> instanceTableRow) throws RepositoryErrorException {
        String methodName = "fillInstanceAuditHeader";
        String typeName = super.getStringPropertyFromColumn(RepositoryColumn.TYPE_NAME.getColumnName(), instanceTableRow, true);
        String[] typeNameParts = typeName.split(":");
        TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.repositoryName, typeNameParts[1]);
        if (typeDef != null) {
            try {
                instanceAuditHeader.setType(this.repositoryHelper.getNewInstanceType(this.repositoryName, (TypeDefSummary)typeDef));
            }
            catch (TypeErrorException typeErrorException) {
                throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)typeErrorException)).getClass().getName(), "fillInstanceAuditHeader", typeErrorException.getMessage()), ((Object)((Object)this)).getClass().getName(), "fillInstanceAuditHeader", (Throwable)typeErrorException);
            }
            instanceAuditHeader.setInstanceProvenanceType(this.getInstanceProvenanceType(instanceTableRow));
            instanceAuditHeader.setMetadataCollectionId(super.getStringPropertyFromColumn(RepositoryColumn.METADATA_COLLECTION_GUID.getColumnName(), instanceTableRow, true));
            instanceAuditHeader.setMetadataCollectionName(super.getStringPropertyFromColumn(RepositoryColumn.METADATA_COLLECTION_NAME.getColumnName(), instanceTableRow, false));
            instanceAuditHeader.setReplicatedBy(super.getStringPropertyFromColumn(RepositoryColumn.REPLICATED_BY.getColumnName(), instanceTableRow, false));
            instanceAuditHeader.setInstanceLicense(super.getStringPropertyFromColumn(RepositoryColumn.INSTANCE_LICENCE.getColumnName(), instanceTableRow, false));
            instanceAuditHeader.setCreatedBy(super.getStringPropertyFromColumn(RepositoryColumn.CREATED_BY.getColumnName(), instanceTableRow, true));
            instanceAuditHeader.setUpdatedBy(super.getStringPropertyFromColumn(RepositoryColumn.UPDATED_BY.getColumnName(), instanceTableRow, false));
            instanceAuditHeader.setMaintainedBy(super.getStringArrayPropertyFromColumn(RepositoryColumn.MAINTAINED_BY.getColumnName(), instanceTableRow, false));
            instanceAuditHeader.setCreateTime(super.getDatePropertyFromColumn(RepositoryColumn.CREATE_TIME.getColumnName(), instanceTableRow, true));
            if (instanceAuditHeader.getUpdatedBy() != null) {
                instanceAuditHeader.setUpdateTime(super.getDatePropertyFromColumn(RepositoryColumn.UPDATE_TIME.getColumnName(), instanceTableRow, false));
            }
        } else {
            throw new RepositoryErrorException(PostgresErrorCode.INVALID_REPOSITORY_VALUE.getMessageDefinition(this.repositoryName, RepositoryColumn.TYPE_NAME.getColumnName(), "fillInstanceAuditHeader", ((Object)((Object)this)).getClass().getName(), instanceTableRow.toString()), ((Object)((Object)this)).getClass().getName(), "fillInstanceAuditHeader");
        }
        instanceAuditHeader.setVersion(super.getLongPropertyFromColumn(RepositoryColumn.VERSION.getColumnName(), instanceTableRow, true));
        instanceAuditHeader.setStatus(this.getInstanceStatus(RepositoryColumn.CURRENT_STATUS.getColumnName(), instanceTableRow, true));
        instanceAuditHeader.setStatusOnDelete(this.getInstanceStatus(RepositoryColumn.STATUS_ON_DELETE.getColumnName(), instanceTableRow, false));
        instanceAuditHeader.setMappingProperties(super.getSerializableMapPropertyFromColumn(RepositoryColumn.MAPPING_PROPERTIES.getColumnName(), instanceTableRow, false));
    }

    protected void fillInstanceHeader(InstanceHeader instanceHeader, Map<String, JDBCDataValue> instanceTableRow) throws RepositoryErrorException {
        this.fillInstanceAuditHeader((InstanceAuditHeader)instanceHeader, instanceTableRow);
        instanceHeader.setGUID(super.getStringPropertyFromColumn(RepositoryColumn.INSTANCE_GUID.getColumnName(), instanceTableRow, true));
        instanceHeader.setInstanceURL(super.getStringPropertyFromColumn(RepositoryColumn.INSTANCE_URL.getColumnName(), instanceTableRow, false));
        instanceHeader.setReIdentifiedFromGUID(super.getStringPropertyFromColumn(RepositoryColumn.REIDENTIFIED_FROM_GUID.getColumnName(), instanceTableRow, false));
    }

    private InstanceProperties getInstanceProperties(Map<String, JDBCDataValue> instanceTableRow, List<Map<String, JDBCDataValue>> instancePropertiesTableRows, boolean uniqueOnly) throws RepositoryErrorException {
        InstanceProperties instanceProperties = new InstanceProperties();
        if (instanceTableRow != null) {
            instanceProperties.setEffectiveFromTime(super.getDatePropertyFromColumn(RepositoryColumn.EFFECTIVE_FROM_TIME.getColumnName(), instanceTableRow, false));
            instanceProperties.setEffectiveToTime(super.getDatePropertyFromColumn(RepositoryColumn.EFFECTIVE_TO_TIME.getColumnName(), instanceTableRow, false));
        }
        HashMap<String, ArrayList<Map<String, Object>>> attributeRows = new HashMap<String, ArrayList<Map<String, Object>>>();
        if (instancePropertiesTableRows != null) {
            for (Map<String, Object> map : instancePropertiesTableRows) {
                boolean rowIsUnique;
                if (map == null || !(rowIsUnique = super.getBooleanPropertyFromColumn(RepositoryColumn.IS_UNIQUE_ATTRIBUTE.getColumnName(), map, true)) && uniqueOnly) continue;
                String attributeName = super.getStringPropertyFromColumn(RepositoryColumn.ATTRIBUTE_NAME.getColumnName(), map, true);
                ArrayList<Map<String, Object>> attributeRow = (ArrayList<Map<String, Object>>)attributeRows.get(attributeName);
                if (attributeRow == null) {
                    attributeRow = new ArrayList<Map<String, Object>>();
                }
                attributeRow.add(map);
                attributeRows.put(attributeName, attributeRow);
            }
        }
        for (String string : attributeRows.keySet()) {
            instanceProperties.setProperty(string, this.getInstancePropertyValue(string, (List)attributeRows.get(string)));
        }
        if (instanceProperties.getPropertyCount() > 0 || instanceProperties.getEffectiveFromTime() != null || instanceProperties.getEffectiveToTime() != null) {
            return instanceProperties;
        }
        return null;
    }

    private InstancePropertyValue getInstancePropertyValue(String attributeName, List<Map<String, JDBCDataValue>> attributeRows) throws RepositoryErrorException {
        String methodName = "getInstancePropertyValue";
        if (attributeRows != null && !attributeRows.isEmpty()) {
            if (attributeRows.size() == 1) {
                return this.getInstancePropertyValue(attributeName, attributeRows.get(0), new ArrayList<Map<String, JDBCDataValue>>());
            }
            Map<String, JDBCDataValue> principleRow = null;
            ArrayList<Map<String, JDBCDataValue>> additionalRows = new ArrayList<Map<String, JDBCDataValue>>();
            for (Map<String, JDBCDataValue> attributeRow : attributeRows) {
                String propertyName = this.getStringPropertyFromColumn(RepositoryColumn.PROPERTY_NAME.getColumnName(), attributeRow, true);
                if (attributeName.equals(propertyName)) {
                    if (principleRow == null) {
                        principleRow = attributeRow;
                        continue;
                    }
                    throw new RepositoryErrorException(PostgresErrorCode.INVALID_REPOSITORY_VALUE.getMessageDefinition(this.repositoryName, RepositoryColumn.PROPERTY_NAME.getColumnName(), "getInstancePropertyValue", ((Object)((Object)this)).getClass().getName(), attributeRows.toString()), ((Object)((Object)this)).getClass().getName(), "getInstancePropertyValue");
                }
                if (propertyName.startsWith(attributeName)) {
                    additionalRows.add(attributeRow);
                    continue;
                }
                throw new RepositoryErrorException(PostgresErrorCode.INVALID_REPOSITORY_VALUE.getMessageDefinition(this.repositoryName, RepositoryColumn.PROPERTY_NAME.getColumnName(), "getInstancePropertyValue", ((Object)((Object)this)).getClass().getName(), attributeRows.toString()), ((Object)((Object)this)).getClass().getName(), "getInstancePropertyValue");
            }
            return this.getInstancePropertyValue(attributeName, principleRow, additionalRows);
        }
        return null;
    }

    private InstancePropertyValue getInstancePropertyValue(String attributeName, Map<String, JDBCDataValue> principleRow, List<Map<String, JDBCDataValue>> additionalRows) throws RepositoryErrorException {
        String methodName = "getInstancePropertyValue";
        String propertyCategory = super.getStringPropertyFromColumn(RepositoryColumn.PROPERTY_CATEGORY.getColumnName(), principleRow, true);
        String attributeTypeName = super.getStringPropertyFromColumn(RepositoryColumn.ATTRIBUTE_TYPE_NAME.getColumnName(), principleRow, true);
        AttributeTypeDef attributeTypeDef = this.repositoryHelper.getAttributeTypeDefByName(this.repositoryName, attributeTypeName);
        for (InstancePropertyCategory instancePropertyCategory : InstancePropertyCategory.values()) {
            if (!instancePropertyCategory.getName().equals(propertyCategory)) continue;
            switch (instancePropertyCategory) {
                case ENUM: {
                    return this.getEnumPropertyValue(attributeTypeDef, super.getStringPropertyFromColumn(RepositoryColumn.PROPERTY_VALUE.getColumnName(), principleRow, true));
                }
                case STRUCT: {
                    return this.getStructPropertyValue(attributeName, attributeTypeDef, additionalRows);
                }
                case MAP: {
                    return this.getMapPropertyValue(attributeName, attributeTypeDef, additionalRows);
                }
                case ARRAY: {
                    return this.getArrayPropertyValue(attributeName, attributeTypeDef, additionalRows);
                }
            }
        }
        for (InstancePropertyCategory instancePropertyCategory : PrimitiveDefCategory.values()) {
            if (!instancePropertyCategory.getName().equals(propertyCategory)) continue;
            String propertyValue = super.getStringPropertyFromColumn(RepositoryColumn.PROPERTY_VALUE.getColumnName(), principleRow, true);
            switch (1.$SwitchMap$org$odpi$openmetadata$repositoryservices$connectors$stores$metadatacollectionstore$properties$typedefs$PrimitiveDefCategory[instancePropertyCategory.ordinal()]) {
                case 1: 
                case 2: {
                    return this.getPrimitivePropertyValue(attributeTypeDef, (PrimitiveDefCategory)instancePropertyCategory, propertyValue);
                }
                case 3: {
                    return this.getPrimitivePropertyValue(attributeTypeDef, (PrimitiveDefCategory)instancePropertyCategory, Boolean.parseBoolean(propertyValue));
                }
                case 4: {
                    return this.getPrimitivePropertyValue(attributeTypeDef, (PrimitiveDefCategory)instancePropertyCategory, Byte.parseByte(propertyValue));
                }
                case 5: {
                    return this.getPrimitivePropertyValue(attributeTypeDef, (PrimitiveDefCategory)instancePropertyCategory, Character.valueOf(propertyValue.charAt(0)));
                }
                case 6: {
                    return this.getPrimitivePropertyValue(attributeTypeDef, (PrimitiveDefCategory)instancePropertyCategory, Short.parseShort(propertyValue));
                }
                case 7: {
                    return this.getPrimitivePropertyValue(attributeTypeDef, (PrimitiveDefCategory)instancePropertyCategory, Integer.parseInt(propertyValue));
                }
                case 8: {
                    return this.getPrimitivePropertyValue(attributeTypeDef, (PrimitiveDefCategory)instancePropertyCategory, Long.parseLong(propertyValue));
                }
                case 9: {
                    return this.getPrimitivePropertyValue(attributeTypeDef, (PrimitiveDefCategory)instancePropertyCategory, Float.valueOf(Float.parseFloat(propertyValue)));
                }
                case 10: 
                case 11: 
                case 12: {
                    return this.getPrimitivePropertyValue(attributeTypeDef, (PrimitiveDefCategory)instancePropertyCategory, Double.parseDouble(propertyValue));
                }
                case 13: {
                    return this.getPrimitivePropertyValue(attributeTypeDef, (PrimitiveDefCategory)instancePropertyCategory, new Date(Long.parseLong(propertyValue)));
                }
            }
        }
        throw new RepositoryErrorException(PostgresErrorCode.INVALID_REPOSITORY_VALUE.getMessageDefinition(this.repositoryName, RepositoryColumn.PROPERTY_VALUE.getColumnName(), "getInstancePropertyValue", ((Object)((Object)this)).getClass().getName(), principleRow.toString()), ((Object)((Object)this)).getClass().getName(), "getInstancePropertyValue");
    }

    private ArrayPropertyValue getArrayPropertyValue(String attributeName, AttributeTypeDef typeDef, List<Map<String, JDBCDataValue>> additionalRows) throws RepositoryErrorException {
        ArrayPropertyValue arrayPropertyValue = new ArrayPropertyValue();
        arrayPropertyValue.setHeaderVersion(1L);
        arrayPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.ARRAY);
        arrayPropertyValue.setTypeGUID(typeDef.getGUID());
        arrayPropertyValue.setTypeName(typeDef.getName());
        arrayPropertyValue.setArrayCount(additionalRows.size());
        arrayPropertyValue.setArrayValues(this.getNestedProperties(attributeName, additionalRows));
        return arrayPropertyValue;
    }

    private MapPropertyValue getMapPropertyValue(String attributeName, AttributeTypeDef attributeTypeDef, List<Map<String, JDBCDataValue>> additionalRows) throws RepositoryErrorException {
        MapPropertyValue mapPropertyValue = new MapPropertyValue();
        mapPropertyValue.setHeaderVersion(1L);
        mapPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.MAP);
        mapPropertyValue.setTypeGUID(attributeTypeDef.getGUID());
        mapPropertyValue.setTypeName(attributeTypeDef.getName());
        mapPropertyValue.setMapValues(this.getNestedProperties(attributeName, additionalRows));
        return mapPropertyValue;
    }

    private StructPropertyValue getStructPropertyValue(String attributeName, AttributeTypeDef attributeTypeDef, List<Map<String, JDBCDataValue>> additionalRows) throws RepositoryErrorException {
        StructPropertyValue structPropertyValue = new StructPropertyValue();
        structPropertyValue.setHeaderVersion(1L);
        structPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.STRUCT);
        structPropertyValue.setTypeGUID(attributeTypeDef.getGUID());
        structPropertyValue.setTypeName(attributeTypeDef.getName());
        structPropertyValue.setAttributes(this.getNestedProperties(attributeName, additionalRows));
        return structPropertyValue;
    }

    private InstanceProperties getNestedProperties(String attributeName, List<Map<String, JDBCDataValue>> additionalRows) throws RepositoryErrorException {
        ArrayList<Map<String, JDBCDataValue>> nestedRows = new ArrayList<Map<String, JDBCDataValue>>();
        for (Map<String, JDBCDataValue> row : additionalRows) {
            HashMap<String, JDBCDataValue> nestedRow = new HashMap<String, JDBCDataValue>(row);
            PropertyNameStruct propertyNameStruct = new PropertyNameStruct(attributeName, super.getStringPropertyFromColumn(RepositoryColumn.PROPERTY_NAME.getColumnName(), row, true));
            nestedRow.put(RepositoryColumn.ATTRIBUTE_NAME.getColumnName(), new JDBCDataValue((Object)propertyNameStruct.getNextParentAttributeName(), ColumnType.STRING.getJdbcType()));
            nestedRow.put(RepositoryColumn.PROPERTY_NAME.getColumnName(), new JDBCDataValue((Object)propertyNameStruct.getNestedPropertyName(), ColumnType.STRING.getJdbcType()));
            nestedRows.add(nestedRow);
        }
        return this.getInstanceProperties(null, nestedRows, false);
    }

    private PrimitivePropertyValue getPrimitivePropertyValue(AttributeTypeDef attributeTypeDef, PrimitiveDefCategory primitiveTypeCategory, Object primitiveValue) {
        PrimitivePropertyValue omrsPropertyValue = new PrimitivePropertyValue();
        omrsPropertyValue.setHeaderVersion(1L);
        omrsPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.PRIMITIVE);
        omrsPropertyValue.setTypeGUID(attributeTypeDef.getGUID());
        omrsPropertyValue.setTypeName(attributeTypeDef.getName());
        omrsPropertyValue.setPrimitiveDefCategory(primitiveTypeCategory);
        omrsPropertyValue.setPrimitiveValue(primitiveValue);
        return omrsPropertyValue;
    }

    private EnumPropertyValue getEnumPropertyValue(AttributeTypeDef attributeTypeDef, String symbolicName) throws RepositoryErrorException {
        EnumDef enumDef;
        List enumElementDefs;
        String methodName = "getEnumPropertyValue";
        if (attributeTypeDef instanceof EnumDef && (enumElementDefs = (enumDef = (EnumDef)attributeTypeDef).getElementDefs()) != null && !enumElementDefs.isEmpty()) {
            for (EnumElementDef enumElementDef : enumElementDefs) {
                if (enumElementDef == null || enumElementDef.getValue() == null || !symbolicName.equalsIgnoreCase(enumElementDef.getValue())) continue;
                EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
                enumPropertyValue.setHeaderVersion(1L);
                enumPropertyValue.setInstancePropertyCategory(InstancePropertyCategory.ENUM);
                enumPropertyValue.setTypeGUID(attributeTypeDef.getGUID());
                enumPropertyValue.setTypeName(attributeTypeDef.getName());
                enumPropertyValue.setSymbolicName(enumElementDef.getValue());
                enumPropertyValue.setOrdinal(enumElementDef.getOrdinal());
                enumPropertyValue.setDescription(enumElementDef.getDescription());
                return enumPropertyValue;
            }
        }
        throw new RepositoryErrorException(PostgresErrorCode.INVALID_REPOSITORY_VALUE.getMessageDefinition(this.repositoryName, RepositoryColumn.PROPERTY_VALUE.getColumnName(), "getEnumPropertyValue", ((Object)((Object)this)).getClass().getName(), symbolicName), ((Object)((Object)this)).getClass().getName(), "getEnumPropertyValue");
    }

    protected InstanceProperties getInstanceProperties(Map<String, JDBCDataValue> instanceTableRow, List<Map<String, JDBCDataValue>> instancePropertiesTableRows) throws RepositoryErrorException {
        return this.getInstanceProperties(instanceTableRow, instancePropertiesTableRows, false);
    }

    protected InstanceProperties getUniqueProperties(Map<String, JDBCDataValue> instanceTableRow, List<Map<String, JDBCDataValue>> instancePropertiesTableRows) throws RepositoryErrorException {
        return this.getInstanceProperties(instanceTableRow, instancePropertiesTableRows, true);
    }

    protected void extractValuesFromInstanceAuditHeader(Map<String, JDBCDataValue> instanceTableRow, String instanceGUID, String classificationName, Date effectiveFromTime, Date effectiveToTime, Date versionEndTime, InstanceAuditHeader instanceAuditHeader) throws RepositoryErrorException {
        super.setUpStringValueInRow(instanceTableRow, instanceGUID, RepositoryColumn.INSTANCE_GUID.getColumnName(), true);
        if (classificationName != null) {
            super.setUpStringValueInRow(instanceTableRow, classificationName, RepositoryColumn.CLASSIFICATION_NAME.getColumnName(), true);
        }
        super.setUpLongValueInRow(instanceTableRow, instanceAuditHeader.getVersion(), RepositoryColumn.VERSION.getColumnName());
        super.setUpStringValueInRow(instanceTableRow, instanceAuditHeader.getType().getTypeDefGUID(), RepositoryColumn.TYPE_GUID.getColumnName(), true);
        this.setUpTypeNameInRow(instanceTableRow, instanceAuditHeader.getType().getTypeDefName());
        super.setUpStringValueInRow(instanceTableRow, instanceAuditHeader.getStatus().getName(), RepositoryColumn.CURRENT_STATUS.getColumnName(), true);
        super.setUpStringValueInRow(instanceTableRow, instanceAuditHeader.getInstanceProvenanceType().getName(), RepositoryColumn.INSTANCE_PROVENANCE_TYPE.getColumnName(), true);
        super.setUpStringValueInRow(instanceTableRow, instanceAuditHeader.getMetadataCollectionId(), RepositoryColumn.METADATA_COLLECTION_GUID.getColumnName(), true);
        super.setUpStringValueInRow(instanceTableRow, instanceAuditHeader.getMetadataCollectionName(), RepositoryColumn.METADATA_COLLECTION_NAME.getColumnName(), false);
        super.setUpSerializableMapValueInRow(instanceTableRow, instanceAuditHeader.getMappingProperties(), RepositoryColumn.MAPPING_PROPERTIES.getColumnName(), false);
        super.setUpDateValueInRow(instanceTableRow, effectiveFromTime, RepositoryColumn.EFFECTIVE_FROM_TIME.getColumnName(), false);
        super.setUpDateValueInRow(instanceTableRow, effectiveToTime, RepositoryColumn.EFFECTIVE_TO_TIME.getColumnName(), false);
        super.setUpStringValueInRow(instanceTableRow, instanceAuditHeader.getReplicatedBy(), RepositoryColumn.REPLICATED_BY.getColumnName(), false);
        super.setUpStringValueInRow(instanceTableRow, instanceAuditHeader.getCreatedBy(), RepositoryColumn.CREATED_BY.getColumnName(), true);
        super.setUpStringValueInRow(instanceTableRow, instanceAuditHeader.getUpdatedBy(), RepositoryColumn.UPDATED_BY.getColumnName(), false);
        super.setUpStringArrayValueInRow(instanceTableRow, instanceAuditHeader.getMaintainedBy(), RepositoryColumn.MAINTAINED_BY.getColumnName(), false);
        super.setUpDateValueInRow(instanceTableRow, instanceAuditHeader.getCreateTime(), RepositoryColumn.CREATE_TIME.getColumnName(), true);
        super.setUpDateValueInRow(instanceTableRow, instanceAuditHeader.getUpdateTime(), RepositoryColumn.UPDATE_TIME.getColumnName(), false);
        if (instanceAuditHeader.getUpdateTime() == null) {
            super.setUpDateValueInRow(instanceTableRow, instanceAuditHeader.getCreateTime(), RepositoryColumn.VERSION_START_TIME.getColumnName(), true);
        } else {
            super.setUpDateValueInRow(instanceTableRow, instanceAuditHeader.getUpdateTime(), RepositoryColumn.VERSION_START_TIME.getColumnName(), true);
        }
        super.setUpDateValueInRow(instanceTableRow, versionEndTime, RepositoryColumn.VERSION_END_TIME.getColumnName(), false);
        if (instanceAuditHeader.getStatusOnDelete() != null) {
            super.setUpStringValueInRow(instanceTableRow, instanceAuditHeader.getStatusOnDelete().getName(), RepositoryColumn.STATUS_ON_DELETE.getColumnName(), false);
        } else {
            super.setUpStringValueInRow(instanceTableRow, null, RepositoryColumn.STATUS_ON_DELETE.getColumnName(), false);
        }
    }

    private void setUpTypeNameInRow(Map<String, JDBCDataValue> instanceTableRow, String typeName) throws RepositoryErrorException {
        List superTypes = this.repositoryHelper.getSuperTypes(this.repositoryName, typeName);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(":");
        stringBuilder.append(typeName);
        if (superTypes != null) {
            for (TypeDefLink typeDefLink : superTypes) {
                stringBuilder.append(":");
                stringBuilder.append(typeDefLink.getName());
            }
        }
        stringBuilder.append(":");
        super.setUpStringValueInRow(instanceTableRow, stringBuilder.toString(), RepositoryColumn.TYPE_NAME.getColumnName(), true);
    }

    protected void extractValuesFromInstanceHeader(Map<String, JDBCDataValue> instanceTableRow, String classificationName, Date effectiveFromTime, Date effectiveToTime, Date versionEndTime, InstanceHeader instanceHeader) throws RepositoryErrorException {
        String methodName = "extractValuesFromInstanceHeader";
        String parameterName = "instanceTableRow";
        if (instanceTableRow == null) {
            throw new RepositoryErrorException(PostgresErrorCode.MISSING_MAPPING_VALUE.getMessageDefinition("instanceTableRow", "extractValuesFromInstanceHeader", ((Object)((Object)this)).getClass().getName()), ((Object)((Object)this)).getClass().getName(), "extractValuesFromInstanceHeader");
        }
        this.extractValuesFromInstanceAuditHeader(instanceTableRow, instanceHeader.getGUID(), classificationName, effectiveFromTime, effectiveToTime, versionEndTime, (InstanceAuditHeader)instanceHeader);
        super.setUpStringValueInRow(instanceTableRow, instanceHeader.getInstanceURL(), RepositoryColumn.INSTANCE_URL.getColumnName(), false);
        super.setUpStringValueInRow(instanceTableRow, instanceHeader.getInstanceLicense(), RepositoryColumn.INSTANCE_LICENCE.getColumnName(), false);
        super.setUpStringValueInRow(instanceTableRow, instanceHeader.getReIdentifiedFromGUID(), RepositoryColumn.REIDENTIFIED_FROM_GUID.getColumnName(), false);
    }

    List<Map<String, JDBCDataValue>> extractValuesFromInstanceProperties(String instanceGUID, String classificationName, long version, String typeName, InstanceProperties instanceProperties, String parentPropertyName, String parentAttributeName) throws RepositoryErrorException {
        if (instanceProperties != null && instanceProperties.getPropertyCount() > 0) {
            ArrayList<Map<String, JDBCDataValue>> attributeRows = new ArrayList<Map<String, JDBCDataValue>>();
            List uniqueAttributeNames = this.repositoryHelper.getUniqueAttributesList(this.repositoryName, typeName);
            for (String propertyName : instanceProperties.getInstanceProperties().keySet()) {
                StructPropertyValue structPropertyValue;
                List<Map<String, JDBCDataValue>> structRows;
                InstancePropertyValue instancePropertyValue = instanceProperties.getPropertyValue(propertyName);
                Object qualifiedPropertyName = parentPropertyName == null ? propertyName : parentPropertyName + ":" + propertyName;
                String attributeName = parentAttributeName == null ? propertyName : parentAttributeName;
                HashMap attributeRow = new HashMap();
                super.setUpStringValueInRow(attributeRow, instanceGUID, RepositoryColumn.INSTANCE_GUID.getColumnName(), true);
                if (classificationName != null) {
                    super.setUpStringValueInRow(attributeRow, classificationName, RepositoryColumn.CLASSIFICATION_NAME.getColumnName(), true);
                }
                super.setUpLongValueInRow(attributeRow, version, RepositoryColumn.VERSION.getColumnName());
                super.setUpStringValueInRow(attributeRow, (String)qualifiedPropertyName, RepositoryColumn.PROPERTY_NAME.getColumnName(), true);
                super.setUpStringValueInRow(attributeRow, attributeName, RepositoryColumn.ATTRIBUTE_NAME.getColumnName(), true);
                if (instancePropertyValue instanceof PrimitivePropertyValue) {
                    PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue;
                    if (primitivePropertyValue.getPrimitiveValue() != null) {
                        super.setUpStringValueInRow(attributeRow, primitivePropertyValue.getPrimitiveValue().toString(), RepositoryColumn.PROPERTY_VALUE.getColumnName(), true);
                    } else {
                        super.setUpStringValueInRow(attributeRow, null, RepositoryColumn.PROPERTY_VALUE.getColumnName(), false);
                    }
                    super.setUpStringValueInRow(attributeRow, primitivePropertyValue.getPrimitiveDefCategory().getName(), RepositoryColumn.PROPERTY_CATEGORY.getColumnName(), true);
                } else if (instancePropertyValue instanceof EnumPropertyValue) {
                    EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
                    super.setUpStringValueInRow(attributeRow, enumPropertyValue.getSymbolicName(), RepositoryColumn.PROPERTY_VALUE.getColumnName(), true);
                    super.setUpStringValueInRow(attributeRow, instancePropertyValue.getInstancePropertyCategory().getName(), RepositoryColumn.PROPERTY_CATEGORY.getColumnName(), true);
                } else {
                    super.setUpStringValueInRow(attributeRow, null, RepositoryColumn.PROPERTY_VALUE.getColumnName(), false);
                    super.setUpStringValueInRow(attributeRow, instancePropertyValue.getInstancePropertyCategory().getName(), RepositoryColumn.PROPERTY_CATEGORY.getColumnName(), true);
                }
                if (uniqueAttributeNames.contains(propertyName)) {
                    super.setUpBooleanValueInRow(attributeRow, true, RepositoryColumn.IS_UNIQUE_ATTRIBUTE.getColumnName());
                } else {
                    super.setUpBooleanValueInRow(attributeRow, false, RepositoryColumn.IS_UNIQUE_ATTRIBUTE.getColumnName());
                }
                super.setUpStringValueInRow(attributeRow, instancePropertyValue.getTypeGUID(), RepositoryColumn.ATTRIBUTE_TYPE_GUID.getColumnName(), false);
                super.setUpStringValueInRow(attributeRow, instancePropertyValue.getTypeName(), RepositoryColumn.ATTRIBUTE_TYPE_NAME.getColumnName(), false);
                if (instancePropertyValue instanceof ArrayPropertyValue) {
                    ArrayPropertyValue arrayPropertyValue = (ArrayPropertyValue)instancePropertyValue;
                    List<Map<String, JDBCDataValue>> arrayRows = this.extractValuesFromInstanceProperties(instanceGUID, classificationName, version, typeName, arrayPropertyValue.getArrayValues(), (String)qualifiedPropertyName, attributeName);
                    if (arrayRows != null) {
                        attributeRows.addAll(arrayRows);
                    }
                } else if (instancePropertyValue instanceof MapPropertyValue) {
                    MapPropertyValue mapPropertyValue = (MapPropertyValue)instancePropertyValue;
                    List<Map<String, JDBCDataValue>> mapRows = this.extractValuesFromInstanceProperties(instanceGUID, classificationName, version, typeName, mapPropertyValue.getMapValues(), (String)qualifiedPropertyName, attributeName);
                    if (mapRows != null) {
                        attributeRows.addAll(mapRows);
                    }
                } else if (instancePropertyValue instanceof StructPropertyValue && (structRows = this.extractValuesFromInstanceProperties(instanceGUID, classificationName, version, typeName, (structPropertyValue = (StructPropertyValue)instancePropertyValue).getAttributes(), (String)qualifiedPropertyName, attributeName)) != null) {
                    attributeRows.addAll(structRows);
                }
                attributeRows.add(attributeRow);
            }
            if (!attributeRows.isEmpty()) {
                return attributeRows;
            }
        }
        return null;
    }

    class PropertyNameStruct {
        String nestedPropertyName;
        String nextParentAttributeName;

        public PropertyNameStruct(String parentAttributeName, String fullPropertyName) throws RepositoryErrorException {
            String methodName = "PropertyNameStruct";
            String[] propertyNameParts = fullPropertyName.split(":");
            if (propertyNameParts.length < 2) {
                throw new RepositoryErrorException(PostgresErrorCode.INVALID_REPOSITORY_VALUE.getMessageDefinition(RepositoryMapper.this.repositoryName, RepositoryColumn.PROPERTY_NAME.getColumnName(), "PropertyNameStruct", this.getClass().getName(), fullPropertyName), this.getClass().getName(), "PropertyNameStruct");
            }
            if (!parentAttributeName.equals(propertyNameParts[0])) {
                throw new RepositoryErrorException(PostgresErrorCode.INVALID_REPOSITORY_VALUE.getMessageDefinition(RepositoryMapper.this.repositoryName, RepositoryColumn.PROPERTY_NAME.getColumnName(), "PropertyNameStruct", this.getClass().getName(), fullPropertyName), this.getClass().getName(), "PropertyNameStruct");
            }
            boolean firstPartOfName = true;
            StringBuilder stringBuilder = new StringBuilder();
            this.nextParentAttributeName = propertyNameParts[1];
            for (int i = 1; i < propertyNameParts.length; ++i) {
                if (firstPartOfName) {
                    firstPartOfName = false;
                } else {
                    stringBuilder.append(":");
                }
                stringBuilder.append(propertyNameParts[i]);
            }
            this.nestedPropertyName = stringBuilder.toString();
        }

        public String getNestedPropertyName() {
            return this.nestedPropertyName;
        }

        public String getNextParentAttributeName() {
            return this.nextParentAttributeName;
        }
    }
}

