/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.ddl.postgres.PostgreSQLColumn;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.ddl.postgres.PostgreSQLForeignKey;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.ddl.postgres.PostgreSQLTable;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.schema.RepositoryColumn;

public enum RepositoryTable implements PostgreSQLTable
{
    CONTROL("control", "Control table to identify the server, metadata collection and version that this repository serves.", null, new RepositoryColumn[]{RepositoryColumn.SERVER_NAME, RepositoryColumn.LOCAL_METADATA_COLLECTION_GUID, RepositoryColumn.SCHEMA_VERSION}),
    ENTITY("entity", "Common information about an entity instance.", new RepositoryColumn[]{RepositoryColumn.INSTANCE_GUID, RepositoryColumn.VERSION}, new RepositoryColumn[]{RepositoryColumn.VERSION_START_TIME, RepositoryColumn.VERSION_END_TIME, RepositoryColumn.IS_PROXY, RepositoryColumn.TYPE_GUID, RepositoryColumn.TYPE_NAME, RepositoryColumn.CURRENT_STATUS, RepositoryColumn.INSTANCE_PROVENANCE_TYPE, RepositoryColumn.METADATA_COLLECTION_GUID, RepositoryColumn.METADATA_COLLECTION_NAME, RepositoryColumn.MAPPING_PROPERTIES, RepositoryColumn.EFFECTIVE_FROM_TIME, RepositoryColumn.EFFECTIVE_TO_TIME, RepositoryColumn.REPLICATED_BY, RepositoryColumn.CREATED_BY, RepositoryColumn.UPDATED_BY, RepositoryColumn.MAINTAINED_BY, RepositoryColumn.CREATE_TIME, RepositoryColumn.UPDATE_TIME, RepositoryColumn.STATUS_ON_DELETE, RepositoryColumn.INSTANCE_URL, RepositoryColumn.INSTANCE_LICENCE, RepositoryColumn.REIDENTIFIED_FROM_GUID}),
    RELATIONSHIP("relationship", "Common information about a relationship instance.", new RepositoryColumn[]{RepositoryColumn.INSTANCE_GUID, RepositoryColumn.VERSION}, new RepositoryColumn[]{RepositoryColumn.VERSION_START_TIME, RepositoryColumn.VERSION_END_TIME, RepositoryColumn.TYPE_GUID, RepositoryColumn.TYPE_NAME, RepositoryColumn.END_1_GUID, RepositoryColumn.END_2_GUID, RepositoryColumn.CURRENT_STATUS, RepositoryColumn.INSTANCE_PROVENANCE_TYPE, RepositoryColumn.METADATA_COLLECTION_GUID, RepositoryColumn.METADATA_COLLECTION_NAME, RepositoryColumn.MAPPING_PROPERTIES, RepositoryColumn.EFFECTIVE_FROM_TIME, RepositoryColumn.EFFECTIVE_TO_TIME, RepositoryColumn.REPLICATED_BY, RepositoryColumn.CREATED_BY, RepositoryColumn.UPDATED_BY, RepositoryColumn.MAINTAINED_BY, RepositoryColumn.CREATE_TIME, RepositoryColumn.UPDATE_TIME, RepositoryColumn.STATUS_ON_DELETE, RepositoryColumn.INSTANCE_URL, RepositoryColumn.INSTANCE_LICENCE, RepositoryColumn.REIDENTIFIED_FROM_GUID}),
    CLASSIFICATION("classification", "Common information about a classification attached to an entity instance.", new RepositoryColumn[]{RepositoryColumn.INSTANCE_GUID, RepositoryColumn.CLASSIFICATION_NAME, RepositoryColumn.VERSION}, new RepositoryColumn[]{RepositoryColumn.VERSION_START_TIME, RepositoryColumn.VERSION_END_TIME, RepositoryColumn.TYPE_GUID, RepositoryColumn.TYPE_NAME, RepositoryColumn.CURRENT_STATUS, RepositoryColumn.INSTANCE_PROVENANCE_TYPE, RepositoryColumn.METADATA_COLLECTION_GUID, RepositoryColumn.METADATA_COLLECTION_NAME, RepositoryColumn.MAPPING_PROPERTIES, RepositoryColumn.EFFECTIVE_FROM_TIME, RepositoryColumn.EFFECTIVE_TO_TIME, RepositoryColumn.REPLICATED_BY, RepositoryColumn.CREATED_BY, RepositoryColumn.UPDATED_BY, RepositoryColumn.MAINTAINED_BY, RepositoryColumn.CREATE_TIME, RepositoryColumn.UPDATE_TIME, RepositoryColumn.STATUS_ON_DELETE}),
    ENTITY_ATTRIBUTE_VALUE("entity_attribute_value", "Attributes for an entity, or for entity properties that are collections.", new RepositoryColumn[]{RepositoryColumn.INSTANCE_GUID, RepositoryColumn.VERSION, RepositoryColumn.PROPERTY_NAME}, new RepositoryColumn[]{RepositoryColumn.ATTRIBUTE_NAME, RepositoryColumn.PROPERTY_VALUE, RepositoryColumn.PROPERTY_CATEGORY, RepositoryColumn.IS_UNIQUE_ATTRIBUTE, RepositoryColumn.ATTRIBUTE_TYPE_GUID, RepositoryColumn.ATTRIBUTE_TYPE_NAME}),
    CLASSIFICATION_ATTRIBUTE_VALUE("classification_attribute_value", "Attributes for a classification, or for classification properties that are collections.", new RepositoryColumn[]{RepositoryColumn.INSTANCE_GUID, RepositoryColumn.CLASSIFICATION_NAME, RepositoryColumn.VERSION, RepositoryColumn.PROPERTY_NAME}, new RepositoryColumn[]{RepositoryColumn.ATTRIBUTE_NAME, RepositoryColumn.PROPERTY_VALUE, RepositoryColumn.PROPERTY_CATEGORY, RepositoryColumn.IS_UNIQUE_ATTRIBUTE, RepositoryColumn.ATTRIBUTE_TYPE_GUID, RepositoryColumn.ATTRIBUTE_TYPE_NAME}),
    RELATIONSHIP_ATTRIBUTE_VALUE("relationship_attribute_value", "Attributes for a relationship, or for relationship properties that are collections.", new RepositoryColumn[]{RepositoryColumn.INSTANCE_GUID, RepositoryColumn.VERSION, RepositoryColumn.PROPERTY_NAME}, new RepositoryColumn[]{RepositoryColumn.ATTRIBUTE_NAME, RepositoryColumn.PROPERTY_VALUE, RepositoryColumn.PROPERTY_CATEGORY, RepositoryColumn.IS_UNIQUE_ATTRIBUTE, RepositoryColumn.ATTRIBUTE_TYPE_GUID, RepositoryColumn.ATTRIBUTE_TYPE_NAME});

    private final String tableName;
    private final String tableDescription;
    private final RepositoryColumn[] primaryKeys;
    private final RepositoryColumn[] dataColumns;

    private RepositoryTable(String tableName, String tableDescription, RepositoryColumn[] primaryKeys, RepositoryColumn[] dataColumns) {
        this.tableName = tableName;
        this.tableDescription = tableDescription;
        this.primaryKeys = primaryKeys;
        this.dataColumns = dataColumns;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableName(String schemaName) {
        return schemaName + "." + this.tableName;
    }

    public String getTableDescription() {
        return this.tableDescription;
    }

    public List<PostgreSQLColumn> getPrimaryKeys() {
        if (this.primaryKeys != null) {
            return Arrays.asList(this.primaryKeys);
        }
        return null;
    }

    public List<PostgreSQLColumn> getDataColumns() {
        if (this.dataColumns != null) {
            return Arrays.asList(this.dataColumns);
        }
        return null;
    }

    public Map<String, Integer> getColumnNameTypeMap() {
        HashMap<String, Integer> columnNameTypeMap = new HashMap<String, Integer>();
        if (this.primaryKeys != null) {
            for (RepositoryColumn column : this.primaryKeys) {
                columnNameTypeMap.put(column.getColumnName(), column.getColumnType().getJdbcType());
            }
        }
        if (this.dataColumns != null) {
            for (RepositoryColumn column : this.dataColumns) {
                columnNameTypeMap.put(column.getColumnName(), column.getColumnType().getJdbcType());
            }
        }
        return columnNameTypeMap;
    }

    public List<String> getQualifiedColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>();
        if (this.primaryKeys != null) {
            for (RepositoryColumn column : this.primaryKeys) {
                columnNames.add(column.getColumnName(this.tableName));
            }
        }
        if (this.dataColumns != null) {
            for (RepositoryColumn column : this.dataColumns) {
                columnNames.add(column.getColumnName(this.tableName));
            }
        }
        return columnNames;
    }

    public List<PostgreSQLForeignKey> getForeignKeys() {
        return null;
    }

    public static List<PostgreSQLTable> getTables() {
        return new ArrayList<PostgreSQLTable>(Arrays.asList(RepositoryTable.values()));
    }

    public String toString() {
        return "RepositoryTable{" + this.tableName + "}";
    }
}

