/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnector;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.database.DatabaseStore;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.database.QueryBuilder;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.ffdc.PostgresErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers.ClassificationMapper;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers.EntityMapper;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers.RelationshipMapper;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.schema.RepositoryTable;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

class PostgresOMRSMetadataStore {
    private final String repositoryName;
    private final OMRSRepositoryHelper repositoryHelper;
    private final String localMetadataCollectionId;
    private final boolean isReadOnly;
    private final Date defaultAsOfTime;
    private final JDBCResourceConnector jdbcResourceConnector;

    PostgresOMRSMetadataStore(String repositoryName, OMRSRepositoryHelper repositoryHelper, String localMetadataCollectionId, boolean isReadOnly, Date defaultAsOfTime, JDBCResourceConnector jdbcResourceConnector) {
        this.repositoryName = repositoryName;
        this.repositoryHelper = repositoryHelper;
        this.localMetadataCollectionId = localMetadataCollectionId;
        this.isReadOnly = isReadOnly;
        this.defaultAsOfTime = defaultAsOfTime;
        this.jdbcResourceConnector = jdbcResourceConnector;
    }

    EntityDetail getEntity(String guid) throws RepositoryErrorException, EntityProxyOnlyException {
        return this.getEntity(guid, null);
    }

    EntityDetail getEntity(String guid, Date asOfTime) throws RepositoryErrorException, EntityProxyOnlyException {
        String methodName = "getEntity";
        String guidParameterName = "guid";
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        EntityMapper storedEntity = databaseStore.getEntityFromStore(guid, this.getAsOfTime(asOfTime));
        if (storedEntity != null) {
            if (storedEntity.isProxy()) {
                throw new EntityProxyOnlyException(OMRSErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(new String[]{guid, this.repositoryName, "guid", "getEntity"}), this.getClass().getName(), "getEntity");
            }
            return storedEntity.getEntityDetail();
        }
        return null;
    }

    private Date getAsOfTime(Date suppliedAsOfTime) {
        if (suppliedAsOfTime == null) {
            return this.defaultAsOfTime;
        }
        return suppliedAsOfTime;
    }

    EntitySummary getEntitySummary(String guid) throws RepositoryErrorException {
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        EntityMapper storedEntity = databaseStore.getEntityFromStore(guid, this.getAsOfTime(null));
        if (storedEntity != null) {
            if (storedEntity.getEntityDetail() != null) {
                return storedEntity.getEntityDetail();
            }
            return storedEntity.getEntityProxy();
        }
        return null;
    }

    EntityProxy getEntityProxy(String guid, Date asOfTime) throws RepositoryErrorException {
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        EntityMapper storedEntity = databaseStore.getEntityFromStore(guid, this.getAsOfTime(asOfTime));
        if (storedEntity != null) {
            return storedEntity.getEntityProxy();
        }
        return null;
    }

    List<EntityDetail> findEntitiesByPropertyValue(String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws RepositoryErrorException {
        String entityTypeGUIDParameterName = "entityTypeGUID";
        QueryBuilder entityQueryBuilder = new QueryBuilder(RepositoryTable.ENTITY.getTableName(), RepositoryTable.ENTITY_ATTRIBUTE_VALUE.getTableName(), this.repositoryHelper, this.repositoryName);
        entityQueryBuilder.setTypeGUID(entityTypeGUID, "entityTypeGUID");
        entityQueryBuilder.setSearchString(searchCriteria);
        entityQueryBuilder.setLimitResultsByStatus(limitResultsByStatus);
        entityQueryBuilder.setAsOfTime(asOfTime);
        entityQueryBuilder.setSequencingOrder(sequencingOrder, sequencingProperty);
        entityQueryBuilder.setPaging(fromEntityElement, pageSize);
        QueryBuilder classificationQueryBuilder = null;
        if (limitResultsByClassification != null && !limitResultsByClassification.isEmpty()) {
            classificationQueryBuilder = new QueryBuilder(RepositoryTable.CLASSIFICATION.getTableName(), RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getTableName(), this.repositoryHelper, this.repositoryName);
            classificationQueryBuilder.setLimitResultsByClassification(limitResultsByClassification);
            classificationQueryBuilder.setAsOfTime(asOfTime);
        }
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        List<EntityMapper> entityMappers = databaseStore.retrieveEntitiesByProperties(entityQueryBuilder, classificationQueryBuilder, asOfTime);
        return this.getEntitiesFromMappers(entityMappers);
    }

    List<EntityDetail> findEntitiesByProperty(String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws RepositoryErrorException {
        String entityTypeGUIDParameterName = "entityTypeGUID";
        QueryBuilder entityQueryBuilder = new QueryBuilder(RepositoryTable.ENTITY.getTableName(), RepositoryTable.ENTITY_ATTRIBUTE_VALUE.getTableName(), this.repositoryHelper, this.repositoryName);
        entityQueryBuilder.setTypeGUID(entityTypeGUID, "entityTypeGUID");
        entityQueryBuilder.setMatchProperties(matchProperties, matchCriteria);
        entityQueryBuilder.setLimitResultsByStatus(limitResultsByStatus);
        entityQueryBuilder.setAsOfTime(asOfTime);
        entityQueryBuilder.setSequencingOrder(sequencingOrder, sequencingProperty);
        entityQueryBuilder.setPaging(fromEntityElement, pageSize);
        QueryBuilder classificationQueryBuilder = null;
        if (limitResultsByClassification != null && !limitResultsByClassification.isEmpty()) {
            classificationQueryBuilder = new QueryBuilder(RepositoryTable.CLASSIFICATION.getTableName(), RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getTableName(), this.repositoryHelper, this.repositoryName);
            classificationQueryBuilder.setLimitResultsByClassification(limitResultsByClassification);
            classificationQueryBuilder.setAsOfTime(asOfTime);
        }
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        List<EntityMapper> entityMappers = databaseStore.retrieveEntitiesByProperties(entityQueryBuilder, classificationQueryBuilder, asOfTime);
        return this.getEntitiesFromMappers(entityMappers);
    }

    List<EntityDetail> findEntities(String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties matchProperties, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws RepositoryErrorException {
        String entityTypeGUIDParameterName = "entityTypeGUID";
        String entitySubtypeGUIDsParameterName = "entitySubtypeGUIDs";
        QueryBuilder entityQueryBuilder = new QueryBuilder(RepositoryTable.ENTITY.getTableName(), RepositoryTable.ENTITY_ATTRIBUTE_VALUE.getTableName(), this.repositoryHelper, this.repositoryName);
        QueryBuilder classificationQueryBuilder = null;
        entityQueryBuilder.setTypeGUID(entityTypeGUID, "entityTypeGUID", entitySubtypeGUIDs, "entitySubtypeGUIDs");
        entityQueryBuilder.setSearchProperties(matchProperties);
        entityQueryBuilder.setLimitResultsByStatus(limitResultsByStatus);
        entityQueryBuilder.setAsOfTime(asOfTime);
        entityQueryBuilder.setSequencingOrder(sequencingOrder, sequencingProperty);
        entityQueryBuilder.setPaging(fromEntityElement, pageSize);
        if (matchClassifications != null) {
            classificationQueryBuilder = new QueryBuilder(RepositoryTable.CLASSIFICATION.getTableName(), RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getTableName(), this.repositoryHelper, this.repositoryName);
            classificationQueryBuilder.setSearchClassifications(matchClassifications);
            classificationQueryBuilder.setAsOfTime(asOfTime);
        }
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        List<EntityMapper> entityMappers = databaseStore.retrieveEntitiesByProperties(entityQueryBuilder, classificationQueryBuilder, asOfTime);
        return this.getEntitiesFromMappers(entityMappers);
    }

    List<EntityDetail> findEntitiesByClassification(String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws RepositoryErrorException {
        String entityTypeGUIDParameterName = "entityTypeGUID";
        QueryBuilder entityQueryBuilder = new QueryBuilder(RepositoryTable.ENTITY.getTableName(), RepositoryTable.ENTITY_ATTRIBUTE_VALUE.getTableName(), this.repositoryHelper, this.repositoryName);
        QueryBuilder classificationQueryBuilder = new QueryBuilder(RepositoryTable.CLASSIFICATION.getTableName(), RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getTableName(), this.repositoryHelper, this.repositoryName);
        entityQueryBuilder.setTypeGUID(entityTypeGUID, "entityTypeGUID");
        entityQueryBuilder.setLimitResultsByStatus(limitResultsByStatus);
        entityQueryBuilder.setAsOfTime(asOfTime);
        entityQueryBuilder.setSequencingOrder(sequencingOrder, sequencingProperty);
        entityQueryBuilder.setPaging(fromEntityElement, pageSize);
        classificationQueryBuilder.setLimitResultsByClassification(Collections.singletonList(classificationName));
        classificationQueryBuilder.setMatchProperties(matchClassificationProperties, matchCriteria);
        classificationQueryBuilder.setAsOfTime(asOfTime);
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        List<EntityMapper> entityMappers = databaseStore.retrieveEntitiesByProperties(entityQueryBuilder, classificationQueryBuilder, asOfTime);
        return this.getEntitiesFromMappers(entityMappers);
    }

    private List<EntityDetail> getEntitiesFromMappers(List<EntityMapper> entityMappers) throws RepositoryErrorException {
        if (entityMappers != null) {
            ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>();
            for (EntityMapper entityMapper : entityMappers) {
                EntityDetail entityDetail;
                if (entityMapper == null || (entityDetail = entityMapper.getEntityDetail()) == null) continue;
                entityDetails.add(entityDetail);
            }
            if (!entityDetails.isEmpty()) {
                return entityDetails;
            }
        }
        return null;
    }

    Relationship getRelationship(String guid) throws RepositoryErrorException {
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        RelationshipMapper storedRelationship = databaseStore.getRelationshipFromStore(guid, this.getAsOfTime(null));
        if (storedRelationship != null) {
            return storedRelationship.getRelationship();
        }
        return null;
    }

    Relationship getRelationship(String guid, Date asOfTime) throws RepositoryErrorException {
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        RelationshipMapper storedRelationship = databaseStore.getRelationshipFromStore(guid, asOfTime);
        if (storedRelationship != null) {
            return storedRelationship.getRelationship();
        }
        return null;
    }

    List<Relationship> getRelationshipsForEntity(String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws RepositoryErrorException {
        String relationshipTypeGUIDParameterName = "relationshipTypeGUID";
        QueryBuilder queryBuilder = new QueryBuilder(RepositoryTable.RELATIONSHIP.getTableName(), RepositoryTable.RELATIONSHIP_ATTRIBUTE_VALUE.getTableName(), this.repositoryHelper, this.repositoryName);
        queryBuilder.setTypeGUID(relationshipTypeGUID, "relationshipTypeGUID");
        queryBuilder.setLimitResultsByStatus(limitResultsByStatus);
        queryBuilder.setAsOfTime(asOfTime);
        queryBuilder.setSequencingOrder(sequencingOrder, sequencingProperty);
        queryBuilder.setPaging(fromRelationshipElement, pageSize);
        queryBuilder.setRelationshipEndGUID(entityGUID);
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        List<RelationshipMapper> storedRelationships = databaseStore.retrieveRelationships(queryBuilder, this.getAsOfTime(asOfTime));
        return this.getRelationshipsFromMappers(storedRelationships);
    }

    private List<Relationship> getRelationshipsFromMappers(List<RelationshipMapper> relationshipMappers) throws RepositoryErrorException {
        if (relationshipMappers != null) {
            ArrayList<Relationship> relationships = new ArrayList<Relationship>();
            for (RelationshipMapper relationshipMapper : relationshipMappers) {
                if (relationshipMapper == null) continue;
                relationships.add(relationshipMapper.getRelationship());
            }
            if (!relationships.isEmpty()) {
                return relationships;
            }
        }
        return null;
    }

    List<Relationship> findRelationships(String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties matchProperties, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws RepositoryErrorException {
        String relationshipTypeGUIDParameterName = "relationshipTypeGUID";
        String relationshipSubtypeGUIDsParameterName = "relationshipSubtypeGUIDs";
        QueryBuilder queryBuilder = new QueryBuilder(RepositoryTable.RELATIONSHIP.getTableName(), RepositoryTable.RELATIONSHIP_ATTRIBUTE_VALUE.getTableName(), this.repositoryHelper, this.repositoryName);
        queryBuilder.setTypeGUID(relationshipTypeGUID, "relationshipTypeGUID", relationshipSubtypeGUIDs, "relationshipSubtypeGUIDs");
        queryBuilder.setSearchProperties(matchProperties);
        queryBuilder.setLimitResultsByStatus(limitResultsByStatus);
        queryBuilder.setAsOfTime(asOfTime);
        queryBuilder.setSequencingOrder(sequencingOrder, sequencingProperty);
        queryBuilder.setPaging(fromRelationshipElement, pageSize);
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        List<RelationshipMapper> storedRelationships = databaseStore.retrieveRelationshipsByProperties(queryBuilder, asOfTime);
        return this.getRelationshipsFromMappers(storedRelationships);
    }

    List<Relationship> findRelationshipsByProperty(String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws RepositoryErrorException {
        String relationshipTypeGUIDParameterName = "relationshipTypeGUID";
        QueryBuilder queryBuilder = new QueryBuilder(RepositoryTable.RELATIONSHIP.getTableName(), RepositoryTable.RELATIONSHIP_ATTRIBUTE_VALUE.getTableName(), this.repositoryHelper, this.repositoryName);
        queryBuilder.setTypeGUID(relationshipTypeGUID, "relationshipTypeGUID");
        queryBuilder.setMatchProperties(matchProperties, matchCriteria);
        queryBuilder.setLimitResultsByStatus(limitResultsByStatus);
        queryBuilder.setAsOfTime(asOfTime);
        queryBuilder.setSequencingOrder(sequencingOrder, sequencingProperty);
        queryBuilder.setPaging(fromRelationshipElement, pageSize);
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        List<RelationshipMapper> storedRelationships = databaseStore.retrieveRelationshipsByProperties(queryBuilder, asOfTime);
        return this.getRelationshipsFromMappers(storedRelationships);
    }

    List<Relationship> findRelationshipsByPropertyValue(String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws RepositoryErrorException {
        String relationshipTypeGUIDParameterName = "relationshipTypeGUID";
        QueryBuilder queryBuilder = new QueryBuilder(RepositoryTable.RELATIONSHIP.getTableName(), RepositoryTable.RELATIONSHIP_ATTRIBUTE_VALUE.getTableName(), this.repositoryHelper, this.repositoryName);
        queryBuilder.setTypeGUID(relationshipTypeGUID, "relationshipTypeGUID");
        queryBuilder.setSearchString(searchCriteria);
        queryBuilder.setLimitResultsByStatus(limitResultsByStatus);
        queryBuilder.setAsOfTime(asOfTime);
        queryBuilder.setSequencingOrder(sequencingOrder, sequencingProperty);
        queryBuilder.setPaging(fromRelationshipElement, pageSize);
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        List<RelationshipMapper> storedRelationships = databaseStore.retrieveRelationshipsByProperties(queryBuilder, asOfTime);
        return this.getRelationshipsFromMappers(storedRelationships);
    }

    EntityDetail addEntityToStore(EntityDetail entityDetail) throws RepositoryErrorException {
        String methodName = "addEntityToStore";
        if (this.isReadOnly) {
            throw new RepositoryErrorException(PostgresErrorCode.READ_ONLY_MODE.getMessageDefinition(this.repositoryName), this.getClass().getName(), "addEntityToStore");
        }
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        EntityMapper storedEntity = databaseStore.getEntityForUpdate(entityDetail.getGUID());
        if (storedEntity == null) {
            databaseStore.addEntityToStore(new EntityMapper(entityDetail, this.repositoryHelper, this.repositoryName));
            return entityDetail;
        }
        if (entityDetail.getVersion() > storedEntity.getEntityDetail().getVersion()) {
            databaseStore.updatePreviousEntityVersionEndTime(storedEntity, databaseStore.getVersionEndDate(entityDetail.getUpdateTime()));
            databaseStore.addEntityToStore(new EntityMapper(entityDetail, this.repositoryHelper, this.repositoryName));
            return entityDetail;
        }
        return storedEntity.getEntityDetail();
    }

    void addEntityProxyToStore(EntityProxy entityProxy) throws RepositoryErrorException {
        String methodName = "addEntityProxyToStore";
        if (this.isReadOnly) {
            throw new RepositoryErrorException(PostgresErrorCode.READ_ONLY_MODE.getMessageDefinition(this.repositoryName), this.getClass().getName(), "addEntityProxyToStore");
        }
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        databaseStore.addEntityProxyToStore(new EntityMapper(entityProxy, this.repositoryHelper, this.repositoryName));
    }

    Relationship addRelationshipToStore(Relationship relationship) throws RepositoryErrorException {
        String methodName = "addRelationshipToStore";
        if (this.isReadOnly) {
            throw new RepositoryErrorException(PostgresErrorCode.READ_ONLY_MODE.getMessageDefinition(this.repositoryName), this.getClass().getName(), "addRelationshipToStore");
        }
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        RelationshipMapper storedRelationship = databaseStore.getRelationshipForUpdate(relationship.getGUID());
        if (storedRelationship == null) {
            databaseStore.addRelationshipToStore(new RelationshipMapper(relationship, this.repositoryHelper, this.repositoryName));
            return relationship;
        }
        if (relationship.getVersion() > storedRelationship.getRelationship().getVersion()) {
            databaseStore.updatePreviousRelationshipVersionEndTime(storedRelationship, databaseStore.getVersionEndDate(relationship.getUpdateTime()));
            databaseStore.addRelationshipToStore(new RelationshipMapper(relationship, this.repositoryHelper, this.repositoryName));
            return relationship;
        }
        return storedRelationship.getRelationship();
    }

    void saveClassification(String entityGUID, Classification classification) throws RepositoryErrorException {
        String methodName = "saveClassification";
        if (this.isReadOnly) {
            throw new RepositoryErrorException(PostgresErrorCode.READ_ONLY_MODE.getMessageDefinition(this.repositoryName), this.getClass().getName(), "saveClassification");
        }
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        ClassificationMapper storedClassification = databaseStore.getClassificationForUpdate(entityGUID, classification.getName());
        if (storedClassification == null) {
            databaseStore.saveClassification(new ClassificationMapper(entityGUID, classification, this.repositoryHelper, this.repositoryName));
        } else if (classification.getVersion() > storedClassification.getClassification().getVersion()) {
            databaseStore.updatePreviousClassificationVersionEndTime(storedClassification, databaseStore.getVersionEndDate(classification.getUpdateTime()));
            databaseStore.saveClassification(new ClassificationMapper(entityGUID, classification, this.repositoryHelper, this.repositoryName));
        }
    }

    Relationship retrievePreviousVersionOfRelationship(Relationship currentRelationship) throws RepositoryErrorException {
        RelationshipMapper relationshipMapper;
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        List<RelationshipMapper> storedRelationships = databaseStore.getRelationshipHistoryFromStore(currentRelationship.getGUID(), null, null, true);
        if (storedRelationships != null && storedRelationships.size() > 1 && (relationshipMapper = storedRelationships.get(storedRelationships.size() - 2)) != null) {
            return relationshipMapper.getRelationship();
        }
        return null;
    }

    EntityDetail retrievePreviousVersionOfEntity(EntityDetail currentEntity) throws RepositoryErrorException {
        EntityMapper entityMapper;
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        List<EntityMapper> storedEntities = databaseStore.getEntityHistoryFromStore(currentEntity.getGUID(), null, null, true);
        if (storedEntities != null && storedEntities.size() > 1 && (entityMapper = storedEntities.get(storedEntities.size() - 2)) != null) {
            try {
                return entityMapper.getEntityDetail();
            }
            catch (RepositoryErrorException onlyAProxy) {
                return null;
            }
        }
        return null;
    }

    List<Classification> getHomeClassifications(String guid) throws RepositoryErrorException {
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        List<ClassificationMapper> classificationMappers = databaseStore.getHomeClassifications(guid, this.localMetadataCollectionId, this.getAsOfTime(null));
        if (classificationMappers != null) {
            ArrayList<Classification> classifications = new ArrayList<Classification>();
            for (ClassificationMapper classificationMapper : classificationMappers) {
                if (classificationMapper == null) continue;
                classifications.add(classificationMapper.getClassification());
            }
            return classifications;
        }
        return null;
    }

    List<EntityDetail> getEntityHistory(String guid, Date fromTime, Date toTime, boolean oldestFirst) throws RepositoryErrorException {
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        List<EntityMapper> entityMappers = databaseStore.getEntityHistoryFromStore(guid, fromTime, toTime, oldestFirst);
        if (entityMappers != null) {
            ArrayList<EntityDetail> historyResults = new ArrayList<EntityDetail>();
            for (EntityMapper entityMapper : entityMappers) {
                if (entityMapper == null || entityMapper.isProxy()) continue;
                historyResults.add(entityMapper.getEntityDetail());
            }
            return historyResults;
        }
        return null;
    }

    List<Relationship> getRelationshipHistory(String guid, Date fromTime, Date toTime, boolean oldestFirst) throws RepositoryErrorException {
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        List<RelationshipMapper> relationshipMappers = databaseStore.getRelationshipHistoryFromStore(guid, fromTime, toTime, oldestFirst);
        if (relationshipMappers != null) {
            ArrayList<Relationship> historyResults = new ArrayList<Relationship>();
            for (RelationshipMapper relationshipMapper : relationshipMappers) {
                if (relationshipMapper == null) continue;
                historyResults.add(relationshipMapper.getRelationship());
            }
            return historyResults;
        }
        return null;
    }

    void removeClassificationFromEntity(String entityGUID, String classificationName) throws RepositoryErrorException {
        String methodName = "removeClassificationFromEntity";
        if (this.isReadOnly) {
            throw new RepositoryErrorException(PostgresErrorCode.READ_ONLY_MODE.getMessageDefinition(this.repositoryName), this.getClass().getName(), "removeClassificationFromEntity");
        }
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        databaseStore.purgeClassification(entityGUID, classificationName);
    }

    void purgeEntityFromStore(String guid) throws RepositoryErrorException {
        String methodName = "purgeEntityFromStore";
        if (this.isReadOnly) {
            throw new RepositoryErrorException(PostgresErrorCode.READ_ONLY_MODE.getMessageDefinition(this.repositoryName), this.getClass().getName(), "purgeEntityFromStore");
        }
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        databaseStore.purgeEntity(guid);
    }

    void purgeRelationshipFromStore(String guid) throws RepositoryErrorException {
        String methodName = "purgeRelationshipFromStore";
        if (this.isReadOnly) {
            throw new RepositoryErrorException(PostgresErrorCode.READ_ONLY_MODE.getMessageDefinition(this.repositoryName), this.getClass().getName(), "purgeRelationshipFromStore");
        }
        DatabaseStore databaseStore = new DatabaseStore(this.jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
        databaseStore.purgeRelationship(guid);
    }
}

