/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.properties.JDBCDataValue;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.ffdc.PostgresErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers.EntityMapper;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers.RepositoryMapper;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.schema.RepositoryColumn;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class RelationshipMapper
extends RepositoryMapper {
    private Relationship relationship = null;
    private Map<String, JDBCDataValue> relationshipTableRow = null;
    private List<Map<String, JDBCDataValue>> relationshipPropertiesTableRows = null;
    private EntityMapper end1Mapper = null;
    private EntityMapper end2Mapper = null;

    public RelationshipMapper(Relationship relationship, OMRSRepositoryHelper repositoryHelper, String repositoryName) {
        super(repositoryHelper, repositoryName);
        this.relationship = relationship;
    }

    public RelationshipMapper(Map<String, JDBCDataValue> relationshipTableRow, List<Map<String, JDBCDataValue>> relationshipPropertiesTableRows, EntityMapper end1Mapper, EntityMapper end2Mapper, OMRSRepositoryHelper repositoryHelper, String repositoryName) {
        super(repositoryHelper, repositoryName);
        this.relationshipTableRow = relationshipTableRow;
        this.relationshipPropertiesTableRows = relationshipPropertiesTableRows;
        this.end1Mapper = end1Mapper;
        this.end2Mapper = end2Mapper;
    }

    public Relationship getRelationship() throws RepositoryErrorException {
        String methodName = "getRelationship";
        if (this.relationship == null) {
            if (this.relationshipTableRow != null) {
                Relationship newRelationship = new Relationship();
                super.fillInstanceHeader((InstanceHeader)newRelationship, this.relationshipTableRow);
                newRelationship.setProperties(super.getInstanceProperties(this.relationshipTableRow, this.relationshipPropertiesTableRows));
                newRelationship.setEntityOneProxy(this.end1Mapper.getEntityProxy());
                newRelationship.setEntityTwoProxy(this.end2Mapper.getEntityProxy());
                this.relationship = newRelationship;
            } else {
                throw new RepositoryErrorException(PostgresErrorCode.MISSING_MAPPING_VALUE.getMessageDefinition("relationshipTableRow", "getRelationship", ((Object)((Object)this)).getClass().getName()), ((Object)((Object)this)).getClass().getName(), "getRelationship");
            }
        }
        return this.relationship;
    }

    public Map<String, JDBCDataValue> getRelationshipTableRow() throws RepositoryErrorException {
        if (this.relationshipTableRow == null) {
            HashMap<String, JDBCDataValue> newRelationshipTableRow = new HashMap<String, JDBCDataValue>();
            if (this.relationship != null) {
                if (this.relationship.getProperties() != null) {
                    super.extractValuesFromInstanceHeader(newRelationshipTableRow, null, this.relationship.getProperties().getEffectiveFromTime(), this.relationship.getProperties().getEffectiveToTime(), null, (InstanceHeader)this.relationship);
                } else {
                    super.extractValuesFromInstanceHeader(newRelationshipTableRow, null, null, null, null, (InstanceHeader)this.relationship);
                }
                super.setUpStringValueInRow(newRelationshipTableRow, this.relationship.getEntityOneProxy().getGUID(), RepositoryColumn.END_1_GUID.getColumnName(), true);
                super.setUpStringValueInRow(newRelationshipTableRow, this.relationship.getEntityTwoProxy().getGUID(), RepositoryColumn.END_2_GUID.getColumnName(), true);
            }
            if (!newRelationshipTableRow.isEmpty()) {
                this.relationshipTableRow = newRelationshipTableRow;
            }
        }
        return this.relationshipTableRow;
    }

    public List<Map<String, JDBCDataValue>> getRelationshipPropertiesTableRows() throws RepositoryErrorException {
        String methodName = "getRelationshipPropertiesTableRows";
        if (this.relationshipPropertiesTableRows == null) {
            if (this.relationship != null) {
                this.relationshipPropertiesTableRows = this.extractValuesFromInstanceProperties(this.relationship.getGUID(), null, this.relationship.getVersion(), this.relationship.getType().getTypeDefName(), this.relationship.getProperties(), null, null);
            } else {
                throw new RepositoryErrorException(PostgresErrorCode.MISSING_MAPPING_VALUE.getMessageDefinition("relationship", "getRelationshipPropertiesTableRows", ((Object)((Object)this)).getClass().getName()), ((Object)((Object)this)).getClass().getName(), "getRelationshipPropertiesTableRows");
            }
        }
        return this.relationshipPropertiesTableRows;
    }

    public EntityMapper getEnd1Mapper() throws RepositoryErrorException {
        String methodName = "getEnd1Mapper";
        if (this.end1Mapper == null) {
            if (this.relationship != null) {
                this.end1Mapper = new EntityMapper(this.relationship.getEntityOneProxy(), this.repositoryHelper, this.repositoryName);
            } else {
                throw new RepositoryErrorException(PostgresErrorCode.MISSING_MAPPING_VALUE.getMessageDefinition("relationship", "getEnd1Mapper", ((Object)((Object)this)).getClass().getName()), ((Object)((Object)this)).getClass().getName(), "getEnd1Mapper");
            }
        }
        return this.end1Mapper;
    }

    public EntityMapper getEnd2Mapper() throws RepositoryErrorException {
        String methodName = "getEnd2Mapper";
        if (this.end2Mapper == null) {
            if (this.relationship != null) {
                this.end2Mapper = new EntityMapper(this.relationship.getEntityTwoProxy(), this.repositoryHelper, this.repositoryName);
            } else {
                throw new RepositoryErrorException(PostgresErrorCode.MISSING_MAPPING_VALUE.getMessageDefinition("relationship", "getEnd2Mapper", ((Object)((Object)this)).getClass().getName()), ((Object)((Object)this)).getClass().getName(), "getEnd2Mapper");
            }
        }
        return this.end2Mapper;
    }

    public String toString() {
        return "RelationshipMapper{relationship=" + this.relationship + ", relationshipTableRow=" + this.relationshipTableRow + ", relationshipPropertiesTableRows=" + this.relationshipPropertiesTableRows + ", end1Mapper=" + this.end1Mapper + ", end2Mapper=" + this.end2Mapper + "} " + super.toString();
    }
}

