/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnector;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.PostgresOMRSMetadataStore;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.PostgresOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSDynamicTypeMetadataCollectionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class PostgresOMRSMetadataCollection
extends OMRSDynamicTypeMetadataCollectionBase {
    private final PostgresOMRSMetadataStore repositoryStore;

    protected PostgresOMRSMetadataCollection(PostgresOMRSRepositoryConnector parentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, boolean isReadOnly, Date defaultAsOfTime, JDBCResourceConnector jdbcResourceConnector, String metadataCollectionId) {
        super((OMRSRepositoryConnector)parentConnector, repositoryName, repositoryHelper, repositoryValidator, metadataCollectionId);
        this.repositoryStore = new PostgresOMRSMetadataStore(repositoryName, repositoryHelper, metadataCollectionId, isReadOnly, defaultAsOfTime, jdbcResourceConnector);
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isEntityKnown";
        super.getInstanceParameterValidation(userId, guid, "isEntityKnown");
        try {
            return this.repositoryStore.getEntity(guid);
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            return null;
        }
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "getEntitySummary";
        super.getInstanceParameterValidation(userId, guid, "getEntitySummary");
        EntitySummary entity = this.repositoryStore.getEntitySummary(guid);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, entity, "getEntitySummary");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "getEntitySummary");
        return entity;
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        EntityProxy entityProxy;
        String methodName = "getEntityDetail";
        String guidParameterName = "guid";
        super.getInstanceParameterValidation(userId, guid, "getEntityDetail");
        EntityDetail entity = this.isEntityKnown(userId, guid);
        if (entity == null && (entityProxy = this.repositoryStore.getEntityProxy(guid, null)) != null) {
            this.reportEntityProxyOnly(guid, "guid", "getEntityDetail");
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, entity, "getEntityDetail");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "getEntityDetail");
        return entity;
    }

    public EntityDetail getEntityDetail(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        EntityProxy entityProxy;
        String methodName = "getEntityDetail";
        String guidParameterName = "guid";
        super.getInstanceParameterValidation(userId, guid, asOfTime, "getEntityDetail");
        EntityDetail entity = this.repositoryStore.getEntity(guid, asOfTime);
        if (entity == null && (entityProxy = this.repositoryStore.getEntityProxy(guid, asOfTime)) != null) {
            this.reportEntityProxyOnly(guid, "guid", "getEntityDetail");
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, entity, "getEntityDetail");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "getEntityDetail");
        return entity;
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        String methodName = "getRelationshipsForEntity";
        super.getRelationshipsForEntityParameterValidation(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        EntitySummary entity = this.getEntitySummary(userId, entityGUID);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "getRelationshipsForEntity");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "getRelationshipsForEntity");
        return this.repositoryStore.getRelationshipsForEntity(entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        super.findEntitiesByPropertyParameterValidation(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.repositoryStore.findEntitiesByProperty(entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntities(String userId, String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties matchProperties, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        super.findEntitiesParameterValidation(userId, entityTypeGUID, entitySubtypeGUIDs, matchProperties, fromEntityElement, limitResultsByStatus, matchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.repositoryStore.findEntities(entityTypeGUID, entitySubtypeGUIDs, matchProperties, fromEntityElement, limitResultsByStatus, matchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        super.findEntitiesByClassificationParameterValidation(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.repositoryStore.findEntitiesByClassification(entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        super.findEntitiesByPropertyValueParameterValidation(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.repositoryStore.findEntitiesByPropertyValue(entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isRelationshipKnown";
        super.getInstanceParameterValidation(userId, guid, "isRelationshipKnown");
        return this.repositoryStore.getRelationship(guid);
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        super.getInstanceParameterValidation(userId, guid, "getRelationship");
        Relationship relationship = this.repositoryStore.getRelationship(guid);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, guid, relationship, "getRelationship");
        this.repositoryValidator.validateRelationshipIsNotDeleted(this.repositoryName, (InstanceHeader)relationship, "getRelationship");
        return relationship;
    }

    public Relationship getRelationship(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        super.getInstanceParameterValidation(userId, guid, asOfTime, "getRelationship");
        Relationship relationship = this.repositoryStore.getRelationship(guid, asOfTime);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, guid, relationship, "getRelationship");
        this.repositoryValidator.validateRelationshipIsNotDeleted(this.repositoryName, (InstanceHeader)relationship, "getRelationship");
        return relationship;
    }

    public List<Relationship> getRelationshipHistory(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationshipHistory";
        this.getInstanceHistoryParameterValidation(userId, guid, fromTime, toTime, "getRelationshipHistory");
        boolean oldestFirst = sequencingOrder == HistorySequencingOrder.FORWARDS;
        List<Relationship> relationshipHistory = this.repositoryStore.getRelationshipHistory(guid, fromTime, toTime, oldestFirst);
        if (relationshipHistory != null) {
            if (relationshipHistory.isEmpty()) {
                return null;
            }
            if (startFromElement > relationshipHistory.size()) {
                return null;
            }
            if (pageSize == 0 || pageSize >= relationshipHistory.size()) {
                return new ArrayList<Relationship>(relationshipHistory.subList(startFromElement, relationshipHistory.size()));
            }
            return new ArrayList<Relationship>(relationshipHistory.subList(startFromElement, pageSize));
        }
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, guid, null, "getRelationshipHistory");
        return null;
    }

    public List<Relationship> findRelationships(String userId, String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties matchProperties, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.findRelationshipsParameterValidation(userId, relationshipTypeGUID, relationshipSubtypeGUIDs, matchProperties, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.repositoryStore.findRelationships(relationshipTypeGUID, relationshipSubtypeGUIDs, matchProperties, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<Relationship> findRelationshipsByProperty(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.findRelationshipsByPropertyParameterValidation(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.repositoryStore.findRelationshipsByProperty(relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<Relationship> findRelationshipsByPropertyValue(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, UserNotAuthorizedException {
        super.findRelationshipsByPropertyValueParameterValidation(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.repositoryStore.findRelationshipsByPropertyValue(relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public EntityDetail addEntity(String userId, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "addEntity";
        TypeDef typeDef = super.addEntityParameterValidation(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus, "addEntity");
        EntityDetail newEntity = this.repositoryHelper.getNewEntity(this.repositoryName, this.metadataCollectionId, this.metadataCollectionName, InstanceProvenanceType.LOCAL_COHORT, null, userId, typeDef.getName(), initialProperties, initialClassifications);
        if (initialStatus != null) {
            newEntity.setStatus(initialStatus);
        }
        return this.repositoryStore.addEntityToStore(newEntity);
    }

    public EntityDetail addExternalEntity(String userId, String entityTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "addExternalEntity";
        TypeDef typeDef = super.addExternalEntityParameterValidation(userId, entityTypeGUID, externalSourceGUID, initialProperties, initialClassifications, initialStatus, "addExternalEntity");
        EntityDetail newEntity = this.repositoryHelper.getNewEntity(this.repositoryName, externalSourceGUID, externalSourceName, InstanceProvenanceType.EXTERNAL_SOURCE, this.metadataCollectionId, userId, typeDef.getName(), initialProperties, initialClassifications);
        if (initialStatus != null) {
            newEntity.setStatus(initialStatus);
        }
        return this.repositoryStore.addEntityToStore(newEntity);
    }

    public void addEntityProxy(String userId, EntityProxy entityProxy) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        super.addEntityProxyParameterValidation(userId, entityProxy);
        this.repositoryStore.addEntityProxyToStore(entityProxy);
    }

    public EntityDetail updateEntityStatus(String userId, String entityGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "updateEntityStatus";
        String statusParameterName = "newStatus";
        this.updateInstanceStatusParameterValidation(userId, entityGUID, newStatus, "updateEntityStatus");
        try {
            EntityDetail entity = this.repositoryStore.getEntity(entityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "updateEntityStatus");
            this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "updateEntityStatus");
            this.repositoryValidator.validateEntityCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)entity, "updateEntityStatus");
            this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
            TypeDef typeDef = super.getTypeDefForInstance((InstanceHeader)entity, "updateEntityStatus");
            this.repositoryValidator.validateNewStatus(this.repositoryName, "newStatus", newStatus, typeDef, "updateEntityStatus");
            EntityDetail updatedEntity = new EntityDetail(entity);
            updatedEntity.setStatus(newStatus);
            updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
            return this.repositoryStore.addEntityToStore(updatedEntity);
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            super.reportEntityNotKnown(entityGUID, "updateEntityStatus", (Exception)((Object)proxyOnlyException));
            return null;
        }
    }

    public EntityDetail updateEntityProperties(String userId, String entityGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "updateEntityProperties";
        String propertiesParameterName = "properties";
        this.updateInstancePropertiesPropertyValidation(userId, entityGUID, properties, "updateEntityProperties");
        try {
            EntityDetail entity = this.repositoryStore.getEntity(entityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "updateEntityProperties");
            this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "updateEntityProperties");
            this.repositoryValidator.validateEntityCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)entity, "updateEntityProperties");
            this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
            TypeDef typeDef = super.getTypeDefForInstance((InstanceHeader)entity, "updateEntityProperties");
            this.repositoryValidator.validateNewPropertiesForType(this.repositoryName, "properties", typeDef, properties, "updateEntityProperties");
            EntityDetail updatedEntity = new EntityDetail(entity);
            updatedEntity.setProperties(properties);
            updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
            return this.repositoryStore.addEntityToStore(updatedEntity);
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            super.reportEntityNotKnown(entityGUID, "updateEntityProperties", (Exception)((Object)proxyOnlyException));
            return null;
        }
    }

    public EntityDetail undoEntityUpdate(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "undoEntityUpdate";
        String parameterName = "entityGUID";
        super.manageInstanceParameterValidation(userId, entityGUID, "entityGUID", "undoEntityUpdate");
        try {
            EntityDetail currentEntity = this.repositoryStore.getEntity(entityGUID);
            EntityDetail restoredEntity = this.repositoryStore.retrievePreviousVersionOfEntity(currentEntity);
            if (restoredEntity != null) {
                restoredEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)currentEntity, restoredEntity);
                this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, restoredEntity, "undoEntityUpdate");
                this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)restoredEntity, "undoEntityUpdate");
                return this.repositoryStore.addEntityToStore(restoredEntity);
            }
            return null;
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            super.reportEntityNotKnown(entityGUID, "undoEntityUpdate", (Exception)((Object)proxyOnlyException));
            return null;
        }
    }

    public EntityDetail deleteEntity(String userId, String typeDefGUID, String typeDefName, String obsoleteEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "deleteEntity";
        String parameterName = "obsoleteEntityGUID";
        super.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteEntityGUID, "obsoleteEntityGUID", "deleteEntity");
        try {
            EntityDetail entity = this.repositoryStore.getEntity(obsoleteEntityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, obsoleteEntityGUID, entity, "deleteEntity");
            this.repositoryValidator.validateTypeForInstanceDelete(this.repositoryName, typeDefGUID, typeDefName, (InstanceHeader)entity, "deleteEntity");
            this.repositoryValidator.validateInstanceStatusForDelete(this.repositoryName, (InstanceHeader)entity, "deleteEntity");
            try {
                List<Relationship> relationships = this.getRelationshipsForEntity(userId, obsoleteEntityGUID, null, 0, null, null, null, null, 10000);
                if (relationships != null) {
                    for (Relationship relationship : relationships) {
                        InstanceType type;
                        if (relationship == null || (type = relationship.getType()) == null) continue;
                        if (this.metadataCollectionId.equals(relationship.getMetadataCollectionId()) || this.metadataCollectionId.equals(relationship.getReplicatedBy())) {
                            this.deleteRelationship(userId, type.getTypeDefGUID(), type.getTypeDefName(), relationship.getGUID());
                            continue;
                        }
                        this.repositoryStore.purgeRelationshipFromStore(relationship.getGUID());
                    }
                }
            }
            catch (Exception relationships) {
                // empty catch block
            }
            EntityDetail updatedEntity = new EntityDetail(entity);
            updatedEntity.setStatusOnDelete(entity.getStatus());
            updatedEntity.setStatus(InstanceStatus.DELETED);
            updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
            return this.repositoryStore.addEntityToStore(updatedEntity);
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            super.reportEntityNotKnown(obsoleteEntityGUID, "deleteEntity", (Exception)((Object)proxyOnlyException));
            return null;
        }
    }

    public void purgeEntity(String userId, String typeDefGUID, String typeDefName, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "purgeEntity";
        String parameterName = "deletedEntityGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedEntityGUID, "deletedEntityGUID", "purgeEntity");
        try {
            EntityDetail entity = this.repositoryStore.getEntity(deletedEntityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, deletedEntityGUID, entity, "purgeEntity");
            this.repositoryValidator.validateTypeForInstanceDelete(this.repositoryName, typeDefGUID, typeDefName, (InstanceHeader)entity, "purgeEntity");
            this.repositoryValidator.validateEntityIsDeleted(this.repositoryName, (InstanceHeader)entity, "purgeEntity");
            this.repositoryStore.purgeEntityFromStore(deletedEntityGUID);
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            super.reportEntityNotKnown(deletedEntityGUID, "purgeEntity", (Exception)((Object)proxyOnlyException));
        }
    }

    public EntityDetail restoreEntity(String userId, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "restoreEntity";
        String parameterName = "deletedEntityGUID";
        super.manageInstanceParameterValidation(userId, deletedEntityGUID, "deletedEntityGUID", "restoreEntity");
        try {
            EntityDetail entity = this.repositoryStore.getEntity(deletedEntityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, deletedEntityGUID, entity, "restoreEntity");
            this.repositoryValidator.validateEntityIsDeleted(this.repositoryName, (InstanceHeader)entity, "restoreEntity");
            EntityDetail restoredEntity = new EntityDetail(entity);
            restoredEntity.setStatus(entity.getStatusOnDelete());
            restoredEntity.setStatusOnDelete(null);
            restoredEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, restoredEntity);
            return this.repositoryStore.addEntityToStore(restoredEntity);
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            super.reportEntityNotKnown(deletedEntityGUID, "restoreEntity", (Exception)((Object)proxyOnlyException));
            return null;
        }
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "classifyEntity";
        String entityGUIDParameterName = "entityGUID";
        String classificationParameterName = "classificationName";
        String propertiesParameterName = "classificationProperties";
        this.validateRepositoryConnector("classifyEntity");
        this.parentConnector.validateRepositoryIsActive("classifyEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "classifyEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "classifyEntity");
        try {
            Classification newClassification;
            EntityDetail entity = this.repositoryStore.getEntity(entityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "classifyEntity");
            this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "classifyEntity");
            this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
            InstanceType entityType = entity.getType();
            this.repositoryValidator.validateClassification(this.repositoryName, "classificationName", classificationName, entityType.getTypeDefName(), "classifyEntity");
            try {
                this.repositoryValidator.validateClassificationProperties(this.repositoryName, classificationName, "classificationProperties", classificationProperties, "classifyEntity");
                newClassification = this.repositoryHelper.getNewClassification(this.repositoryName, this.metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userId, classificationName, entityType.getTypeDefName(), ClassificationOrigin.ASSIGNED, null, classificationProperties);
            }
            catch (PropertyErrorException error) {
                throw error;
            }
            catch (Exception error) {
                throw new ClassificationErrorException(OMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition(new String[]{this.repositoryName, classificationName, entityType.getTypeDefName()}), ((Object)((Object)this)).getClass().getName(), "classifyEntity");
            }
            this.repositoryStore.saveClassification(entityGUID, newClassification);
            return this.repositoryHelper.addClassificationToEntity(this.repositoryName, entity, newClassification, "classifyEntity");
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            super.reportEntityNotKnown(entityGUID, "classifyEntity", (Exception)((Object)proxyOnlyException));
            return null;
        }
    }

    public Classification classifyEntity(String userId, EntityProxy entityProxy, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "classifyEntity (EntityProxy)";
        String entityGUIDParameterName = "entityGUID";
        String classificationParameterName = "classificationName";
        String propertiesParameterName = "classificationProperties";
        String entityGUID = entityProxy.getGUID();
        this.validateRepositoryConnector("classifyEntity (EntityProxy)");
        this.parentConnector.validateRepositoryIsActive("classifyEntity (EntityProxy)");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "classifyEntity (EntityProxy)");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "classifyEntity (EntityProxy)");
        try {
            Classification newClassification;
            EntityDetail entity = this.repositoryStore.getEntity(entityGUID, null);
            if (entity == null) {
                this.repositoryStore.addEntityProxyToStore(entityProxy);
                entity = this.repositoryStore.getEntityProxy(entityGUID, null);
            }
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, (EntitySummary)entity, "classifyEntity (EntityProxy)");
            this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "classifyEntity (EntityProxy)");
            this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
            InstanceType entityType = entity.getType();
            this.repositoryValidator.validateClassification(this.repositoryName, "classificationName", classificationName, entityType.getTypeDefName(), "classifyEntity (EntityProxy)");
            try {
                this.repositoryValidator.validateClassificationProperties(this.repositoryName, classificationName, "classificationProperties", classificationProperties, "classifyEntity (EntityProxy)");
                newClassification = this.repositoryHelper.getNewClassification(this.repositoryName, this.metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userId, classificationName, entityType.getTypeDefName(), ClassificationOrigin.ASSIGNED, null, classificationProperties);
            }
            catch (PropertyErrorException error) {
                throw error;
            }
            catch (Exception error) {
                throw new ClassificationErrorException(OMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition(new String[]{this.repositoryName, classificationName, entityType.getTypeDefName()}), ((Object)((Object)this)).getClass().getName(), "classifyEntity (EntityProxy)");
            }
            this.repositoryStore.saveClassification(entityGUID, newClassification);
            return newClassification;
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            super.reportEntityNotKnown(entityGUID, "classifyEntity (EntityProxy)", (Exception)((Object)proxyOnlyException));
            return null;
        }
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "classifyEntity (detailed)";
        String entityGUIDParameterName = "entityGUID";
        String classificationParameterName = "classificationName";
        String propertiesParameterName = "classificationProperties";
        this.validateRepositoryConnector("classifyEntity (detailed)");
        this.parentConnector.validateRepositoryIsActive("classifyEntity (detailed)");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "classifyEntity (detailed)");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "classifyEntity (detailed)");
        try {
            Classification newClassification;
            EntityDetail entity = this.repositoryStore.getEntity(entityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "classifyEntity (detailed)");
            this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "classifyEntity (detailed)");
            this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
            InstanceType entityType = entity.getType();
            this.repositoryValidator.validateClassification(this.repositoryName, "classificationName", classificationName, entityType.getTypeDefName(), "classifyEntity (detailed)");
            try {
                this.repositoryValidator.validateClassificationProperties(this.repositoryName, classificationName, "classificationProperties", classificationProperties, "classifyEntity (detailed)");
                if (externalSourceGUID == null) {
                    newClassification = this.repositoryHelper.getNewClassification(this.repositoryName, this.metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userId, classificationName, entityType.getTypeDefName(), classificationOrigin, classificationOriginGUID, classificationProperties);
                } else {
                    newClassification = this.repositoryHelper.getNewClassification(this.repositoryName, externalSourceGUID, externalSourceName, InstanceProvenanceType.EXTERNAL_SOURCE, userId, classificationName, entityType.getTypeDefName(), classificationOrigin, classificationOriginGUID, classificationProperties);
                    newClassification.setMetadataCollectionName(externalSourceName);
                    newClassification.setReplicatedBy(this.metadataCollectionId);
                }
            }
            catch (PropertyErrorException error) {
                throw error;
            }
            catch (Exception error) {
                throw new ClassificationErrorException(OMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition(new String[]{this.repositoryName, classificationName, entityType.getTypeDefName()}), ((Object)((Object)this)).getClass().getName(), "classifyEntity (detailed)");
            }
            this.repositoryStore.saveClassification(entityGUID, newClassification);
            return this.repositoryHelper.addClassificationToEntity(this.repositoryName, entity, newClassification, "classifyEntity (detailed)");
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            super.reportEntityNotKnown(entityGUID, "classifyEntity (detailed)", (Exception)((Object)proxyOnlyException));
            return null;
        }
    }

    public Classification classifyEntity(String userId, EntityProxy entityProxy, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "classifyEntity (detailed - EntityProxy)";
        String entityGUIDParameterName = "entityGUID";
        String classificationParameterName = "classificationName";
        String propertiesParameterName = "classificationProperties";
        String entityGUID = entityProxy.getGUID();
        this.validateRepositoryConnector("classifyEntity (detailed - EntityProxy)");
        this.parentConnector.validateRepositoryIsActive("classifyEntity (detailed - EntityProxy)");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "classifyEntity (detailed - EntityProxy)");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "classifyEntity (detailed - EntityProxy)");
        try {
            Classification newClassification;
            EntityDetail entity = this.repositoryStore.getEntity(entityGUID, null);
            if (entity == null) {
                this.repositoryStore.addEntityProxyToStore(entityProxy);
                entity = this.repositoryStore.getEntityProxy(entityGUID, null);
            }
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, (EntitySummary)entity, "classifyEntity (detailed - EntityProxy)");
            this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "classifyEntity (detailed - EntityProxy)");
            this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
            InstanceType entityType = entity.getType();
            this.repositoryValidator.validateClassification(this.repositoryName, "classificationName", classificationName, entityType.getTypeDefName(), "classifyEntity (detailed - EntityProxy)");
            try {
                this.repositoryValidator.validateClassificationProperties(this.repositoryName, classificationName, "classificationProperties", classificationProperties, "classifyEntity (detailed - EntityProxy)");
                if (externalSourceGUID == null) {
                    newClassification = this.repositoryHelper.getNewClassification(this.repositoryName, this.metadataCollectionId, InstanceProvenanceType.LOCAL_COHORT, userId, classificationName, entityType.getTypeDefName(), classificationOrigin, classificationOriginGUID, classificationProperties);
                } else {
                    newClassification = this.repositoryHelper.getNewClassification(this.repositoryName, externalSourceGUID, externalSourceName, InstanceProvenanceType.EXTERNAL_SOURCE, userId, classificationName, entityType.getTypeDefName(), classificationOrigin, classificationOriginGUID, classificationProperties);
                    newClassification.setMetadataCollectionName(externalSourceName);
                    newClassification.setReplicatedBy(this.metadataCollectionId);
                }
            }
            catch (PropertyErrorException error) {
                throw error;
            }
            catch (Exception error) {
                throw new ClassificationErrorException(OMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition(new String[]{this.repositoryName, classificationName, entityType.getTypeDefName()}), ((Object)((Object)this)).getClass().getName(), "classifyEntity (detailed - EntityProxy)");
            }
            this.repositoryStore.saveClassification(entityGUID, newClassification);
            return newClassification;
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            super.reportEntityNotKnown(entityGUID, "classifyEntity (detailed - EntityProxy)", (Exception)((Object)proxyOnlyException));
            return null;
        }
    }

    public EntityDetail declassifyEntity(String userId, String entityGUID, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "declassifyEntity";
        super.declassifyEntityParameterValidation(userId, entityGUID, classificationName, "declassifyEntity");
        try {
            EntityDetail entity = this.repositoryStore.getEntity(entityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "declassifyEntity");
            this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "declassifyEntity");
            Classification classification = this.repositoryHelper.getClassificationFromEntity(this.repositoryName, (EntitySummary)entity, classificationName, "declassifyEntity");
            Classification newClassification = new Classification(classification);
            newClassification.setStatusOnDelete(classification.getStatus());
            newClassification.setStatus(InstanceStatus.DELETED);
            this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)classification, newClassification);
            this.repositoryStore.saveClassification(entityGUID, newClassification);
            return this.repositoryHelper.deleteClassificationFromEntity(this.repositoryName, entity, classificationName, "declassifyEntity");
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            super.reportEntityNotKnown(entityGUID, "declassifyEntity", (Exception)((Object)proxyOnlyException));
            return null;
        }
    }

    public Classification declassifyEntity(String userId, EntityProxy entityProxy, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "declassifyEntity (EntityProxy)";
        super.declassifyEntityParameterValidation(userId, entityProxy, classificationName, "declassifyEntity (EntityProxy)");
        this.repositoryStore.addEntityProxyToStore(entityProxy);
        Classification classification = this.repositoryHelper.getClassificationFromEntity(this.repositoryName, (EntitySummary)entityProxy, classificationName, "declassifyEntity (EntityProxy)");
        Classification newClassification = new Classification(classification);
        newClassification.setStatusOnDelete(classification.getStatus());
        newClassification.setStatus(InstanceStatus.DELETED);
        this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)classification, newClassification);
        this.repositoryStore.saveClassification(entityProxy.getGUID(), newClassification);
        return newClassification;
    }

    public EntityDetail updateEntityClassification(String userId, String entityGUID, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "updateEntityClassification";
        super.classifyEntityParameterValidation(userId, entityGUID, classificationName, properties, "updateEntityClassification");
        try {
            EntityDetail entity = this.repositoryStore.getEntity(entityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "updateEntityClassification");
            this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "updateEntityClassification");
            Classification classification = this.repositoryHelper.getClassificationFromEntity(this.repositoryName, (EntitySummary)entity, classificationName, "updateEntityClassification");
            Classification newClassification = new Classification(classification);
            newClassification.setProperties(properties);
            this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)classification, newClassification);
            this.repositoryStore.saveClassification(entityGUID, newClassification);
            return this.repositoryHelper.updateClassificationInEntity(this.repositoryName, userId, entity, newClassification, "updateEntityClassification");
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            super.reportEntityNotKnown(entityGUID, "updateEntityClassification", (Exception)((Object)proxyOnlyException));
            return null;
        }
    }

    public Classification updateEntityClassification(String userId, EntityProxy entityProxy, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "updateEntityClassification (EntityProxy)";
        super.classifyEntityParameterValidation(userId, entityProxy, classificationName, properties, "updateEntityClassification (EntityProxy)");
        String entityGUID = entityProxy.getGUID();
        EntityProxy entity = this.repositoryStore.getEntityProxy(entityGUID, null);
        if (entity == null) {
            this.repositoryStore.addEntityProxyToStore(entityProxy);
            entity = this.repositoryStore.getEntityProxy(entityGUID, null);
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, (EntitySummary)entity, "updateEntityClassification (EntityProxy)");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entity, "updateEntityClassification (EntityProxy)");
        Classification classification = this.repositoryHelper.getClassificationFromEntity(this.repositoryName, (EntitySummary)entityProxy, classificationName, "updateEntityClassification (EntityProxy)");
        try {
            classification = this.repositoryHelper.getClassificationFromEntity(this.repositoryName, (EntitySummary)entityProxy, classificationName, "updateEntityClassification (EntityProxy)");
        }
        catch (ClassificationErrorException missingClassification) {
            System.out.println("callerClassification: " + String.valueOf(classification));
            System.out.println("callerEntityProxy: " + String.valueOf(entityProxy));
            System.out.println("storedEntity: " + String.valueOf(entity));
            this.repositoryHelper.getClassificationFromEntity(this.repositoryName, (EntitySummary)entityProxy, classificationName, "updateEntityClassification (EntityProxy)");
        }
        Classification storedClassification = null;
        try {
            storedClassification = this.repositoryHelper.getClassificationFromEntity(this.repositoryName, (EntitySummary)entity, classificationName, "updateEntityClassification (EntityProxy)");
        }
        catch (ClassificationErrorException missingClassification) {
            System.out.println("callerClassification: " + String.valueOf(classification));
            System.out.println("storedEntity: " + String.valueOf(entity));
        }
        assert (classification.equals((Object)storedClassification));
        Classification newClassification = new Classification(classification);
        newClassification.setProperties(properties);
        this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)classification, newClassification);
        this.repositoryStore.saveClassification(entityGUID, newClassification);
        return newClassification;
    }

    public List<EntityDetail> getEntityDetailHistory(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityDetailHistory";
        this.getInstanceHistoryParameterValidation(userId, guid, fromTime, toTime, "getEntityDetailHistory");
        boolean oldestFirst = sequencingOrder == HistorySequencingOrder.FORWARDS;
        List<EntityDetail> entityHistory = this.repositoryStore.getEntityHistory(guid, fromTime, toTime, oldestFirst);
        if (entityHistory != null) {
            if (entityHistory.isEmpty()) {
                return null;
            }
            if (startFromElement > entityHistory.size()) {
                return null;
            }
            if (pageSize == 0 || pageSize >= entityHistory.size()) {
                return new ArrayList<EntityDetail>(entityHistory.subList(startFromElement, entityHistory.size()));
            }
            return new ArrayList<EntityDetail>(entityHistory.subList(startFromElement, pageSize));
        }
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, null, "getEntityDetailHistory");
        return null;
    }

    public Relationship addRelationship(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "addRelationship";
        TypeDef typeDef = super.addRelationshipParameterValidation(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addRelationship");
        Relationship relationship = this.repositoryHelper.getNewRelationship(this.repositoryName, this.metadataCollectionId, this.metadataCollectionName, InstanceProvenanceType.LOCAL_COHORT, userId, typeDef.getName(), initialProperties);
        EntityProxy entityOneProxy = this.repositoryStore.getEntityProxy(entityOneGUID, null);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityOneGUID, (EntitySummary)entityOneProxy, "addRelationship");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entityOneProxy, "addRelationship");
        EntityProxy entityTwoProxy = this.repositoryStore.getEntityProxy(entityTwoGUID, null);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityTwoGUID, (EntitySummary)entityTwoProxy, "addRelationship");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entityTwoProxy, "addRelationship");
        this.repositoryValidator.validateRelationshipEnds(this.repositoryName, entityOneProxy, entityTwoProxy, typeDef, "addRelationship");
        relationship.setEntityOneProxy(entityOneProxy);
        relationship.setEntityTwoProxy(entityTwoProxy);
        if (initialStatus != null) {
            relationship.setStatus(initialStatus);
        }
        return this.repositoryStore.addRelationshipToStore(relationship);
    }

    public Relationship addExternalRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "addExternalRelationship";
        TypeDef typeDef = super.addRelationshipParameterValidation(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addExternalRelationship");
        Relationship relationship = this.repositoryHelper.getNewRelationship(this.repositoryName, externalSourceGUID, InstanceProvenanceType.EXTERNAL_SOURCE, userId, typeDef.getName(), initialProperties);
        relationship.setMetadataCollectionName(externalSourceName);
        relationship.setReplicatedBy(this.metadataCollectionId);
        EntityProxy entityOneProxy = this.repositoryStore.getEntityProxy(entityOneGUID, null);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityOneGUID, (EntitySummary)entityOneProxy, "addExternalRelationship");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entityOneProxy, "addExternalRelationship");
        EntityProxy entityTwoProxy = this.repositoryStore.getEntityProxy(entityTwoGUID, null);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityTwoGUID, (EntitySummary)entityTwoProxy, "addExternalRelationship");
        this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)entityTwoProxy, "addExternalRelationship");
        this.repositoryValidator.validateRelationshipEnds(this.repositoryName, entityOneProxy, entityTwoProxy, typeDef, "addExternalRelationship");
        relationship.setEntityOneProxy(entityOneProxy);
        relationship.setEntityTwoProxy(entityTwoProxy);
        if (initialStatus != null) {
            relationship.setStatus(initialStatus);
        }
        return this.repositoryStore.addRelationshipToStore(relationship);
    }

    public Relationship updateRelationshipStatus(String userId, String relationshipGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "updateRelationshipStatus";
        String statusParameterName = "newStatus";
        this.updateInstanceStatusParameterValidation(userId, relationshipGUID, newStatus, "updateRelationshipStatus");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateRelationshipCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)relationship, "updateRelationshipStatus");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)relationship);
        TypeDef typeDef = super.getTypeDefForInstance((InstanceHeader)relationship, "updateRelationshipStatus");
        this.repositoryValidator.validateNewStatus(this.repositoryName, "newStatus", newStatus, typeDef, "updateRelationshipStatus");
        Relationship updatedRelationship = new Relationship(relationship);
        updatedRelationship.setStatus(newStatus);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        return this.repositoryStore.addRelationshipToStore(updatedRelationship);
    }

    public Relationship updateRelationshipProperties(String userId, String relationshipGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "updateRelationshipProperties";
        String propertiesParameterName = "properties";
        this.updateInstancePropertiesPropertyValidation(userId, relationshipGUID, properties, "updateRelationshipProperties");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, relationshipGUID, relationship, "updateRelationshipProperties");
        this.repositoryValidator.validateRelationshipIsNotDeleted(this.repositoryName, (InstanceHeader)relationship, "updateRelationshipProperties");
        this.repositoryValidator.validateRelationshipCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)relationship, "updateRelationshipProperties");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)relationship);
        TypeDef typeDef = super.getTypeDefForInstance((InstanceHeader)relationship, "updateRelationshipProperties");
        this.repositoryValidator.validateNewPropertiesForType(this.repositoryName, "properties", typeDef, properties, "updateRelationshipProperties");
        Relationship updatedRelationship = new Relationship(relationship);
        updatedRelationship.setProperties(properties);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        return this.repositoryStore.addRelationshipToStore(updatedRelationship);
    }

    public Relationship undoRelationshipUpdate(String userId, String relationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "undoRelationshipUpdate";
        String parameterName = "relationshipGUID";
        this.manageInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", "undoRelationshipUpdate");
        Relationship currentRelationship = this.repositoryStore.getRelationship(relationshipGUID);
        Relationship restoredRelationship = this.repositoryStore.retrievePreviousVersionOfRelationship(currentRelationship);
        restoredRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)currentRelationship, restoredRelationship);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, relationshipGUID, restoredRelationship, "undoRelationshipUpdate");
        this.repositoryValidator.validateRelationshipIsNotDeleted(this.repositoryName, (InstanceHeader)restoredRelationship, "undoRelationshipUpdate");
        return this.repositoryStore.addRelationshipToStore(restoredRelationship);
    }

    public Relationship deleteRelationship(String userId, String typeDefGUID, String typeDefName, String obsoleteRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "deleteRelationship";
        String parameterName = "obsoleteRelationshipGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID, "obsoleteRelationshipGUID", "deleteRelationship");
        Relationship relationship = this.getRelationship(userId, obsoleteRelationshipGUID);
        this.repositoryValidator.validateTypeForInstanceDelete(this.repositoryName, typeDefGUID, typeDefName, (InstanceHeader)relationship, "deleteRelationship");
        Relationship updatedRelationship = new Relationship(relationship);
        updatedRelationship.setStatusOnDelete(relationship.getStatus());
        updatedRelationship.setStatus(InstanceStatus.DELETED);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        return this.repositoryStore.addRelationshipToStore(updatedRelationship);
    }

    public void purgeRelationship(String userId, String typeDefGUID, String typeDefName, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "purgeRelationship";
        String parameterName = "deletedRelationshipGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedRelationshipGUID, "deletedRelationshipGUID", "purgeRelationship");
        Relationship relationship = this.repositoryStore.getRelationship(deletedRelationshipGUID);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, deletedRelationshipGUID, relationship, "purgeRelationship");
        this.repositoryValidator.validateTypeForInstanceDelete(this.repositoryName, typeDefGUID, typeDefName, (InstanceHeader)relationship, "purgeRelationship");
        this.repositoryValidator.validateRelationshipIsDeleted(this.repositoryName, (InstanceHeader)relationship, "purgeRelationship");
        this.repositoryStore.purgeRelationshipFromStore(deletedRelationshipGUID);
    }

    public Relationship restoreRelationship(String userId, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "restoreRelationship";
        String parameterName = "deletedRelationshipGUID";
        this.manageInstanceParameterValidation(userId, deletedRelationshipGUID, "deletedRelationshipGUID", "restoreRelationship");
        Relationship relationship = this.repositoryStore.getRelationship(deletedRelationshipGUID);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, deletedRelationshipGUID, relationship, "restoreRelationship");
        this.repositoryValidator.validateRelationshipIsDeleted(this.repositoryName, (InstanceHeader)relationship, "restoreRelationship");
        Relationship restoredRelationship = new Relationship(relationship);
        restoredRelationship.setStatus(relationship.getStatusOnDelete());
        restoredRelationship.setStatusOnDelete(null);
        restoredRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, restoredRelationship);
        this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, deletedRelationshipGUID, relationship, "restoreRelationship");
        this.repositoryValidator.validateRelationshipIsNotDeleted(this.repositoryName, (InstanceHeader)restoredRelationship, "restoreRelationship");
        return this.repositoryStore.addRelationshipToStore(restoredRelationship);
    }

    public EntityDetail reIdentifyEntity(String userId, String typeDefGUID, String typeDefName, String entityGUID, String newEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "reIdentifyEntity";
        String instanceParameterName = "entityGUID";
        String newInstanceParameterName = "newEntityGUID";
        this.reIdentifyInstanceParameterValidation(userId, typeDefGUID, typeDefName, entityGUID, "entityGUID", newEntityGUID, "newEntityGUID", "reIdentifyEntity");
        try {
            EntityDetail entity = this.repositoryStore.getEntity(entityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "reIdentifyEntity");
            this.repositoryValidator.validateEntityCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)entity, "reIdentifyEntity");
            EntityDetail deletedEntity = new EntityDetail(entity);
            deletedEntity.setStatusOnDelete(entity.getStatus());
            deletedEntity.setStatus(InstanceStatus.DELETED);
            deletedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, deletedEntity);
            EntityDetail updatedEntity = new EntityDetail(entity);
            updatedEntity.setGUID(newEntityGUID);
            updatedEntity.setReIdentifiedFromGUID(entityGUID);
            updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
            EntityProxy deletedEntityProxy = this.repositoryHelper.getNewEntityProxy(this.repositoryName, deletedEntity);
            EntityProxy newEntityProxy = this.repositoryHelper.getNewEntityProxy(this.repositoryName, updatedEntity);
            try {
                List<Relationship> relationships = this.getRelationshipsForEntity(userId, entityGUID, null, 0, null, null, null, null, 10000);
                if (relationships != null) {
                    for (Relationship relationship : relationships) {
                        if (relationship == null) continue;
                        if (relationship.getEntityOneProxy().getGUID().equals(entityGUID)) {
                            relationship.setEntityOneProxy(newEntityProxy);
                        } else if (relationship.getEntityTwoProxy().getGUID().equals(entityGUID)) {
                            relationship.setEntityTwoProxy(newEntityProxy);
                        }
                        this.repositoryStore.addRelationshipToStore(relationship);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.repositoryStore.addEntityToStore(deletedEntity);
            this.repositoryStore.addEntityToStore(updatedEntity);
            this.repositoryStore.addEntityProxyToStore(deletedEntityProxy);
            this.repositoryStore.addEntityProxyToStore(newEntityProxy);
            return updatedEntity;
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            super.reportEntityNotKnown(entityGUID, "reIdentifyEntity", (Exception)((Object)proxyOnlyException));
            return null;
        }
    }

    public EntityDetail reTypeEntity(String userId, String entityGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, EntityNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "reTypeEntity";
        String entityParameterName = "entityGUID";
        String currentTypeDefParameterName = "currentTypeDefSummary";
        String newTypeDefParameterName = "newTypeDefSummary";
        super.reTypeInstanceParameterValidation(userId, entityGUID, "entityGUID", TypeDefCategory.ENTITY_DEF, currentTypeDefSummary, newTypeDefSummary, "reTypeEntity");
        try {
            EntityDetail entity = this.repositoryStore.getEntity(entityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "reTypeEntity");
            this.repositoryValidator.validateEntityCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)entity, "reTypeEntity");
            this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity, "currentTypeDefSummary", "currentTypeDefSummary", currentTypeDefSummary.getGUID(), currentTypeDefSummary.getName());
            this.repositoryValidator.validatePropertiesForType(this.repositoryName, "newTypeDefSummary", newTypeDefSummary, entity.getProperties(), "reTypeEntity");
            this.repositoryValidator.validateClassificationList(this.repositoryName, "entityGUID", entity.getClassifications(), newTypeDefSummary.getName(), "reTypeEntity");
            EntityDetail updatedEntity = new EntityDetail(entity);
            InstanceType newInstanceType = this.repositoryHelper.getNewInstanceType(this.repositoryName, newTypeDefSummary);
            updatedEntity.setType(newInstanceType);
            updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
            this.repositoryStore.addEntityToStore(updatedEntity);
            EntityProxy entityProxy = this.repositoryHelper.getNewEntityProxy(this.repositoryName, updatedEntity);
            this.repositoryStore.addEntityProxyToStore(entityProxy);
            return updatedEntity;
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            super.reportEntityNotKnown(entityGUID, "reTypeEntity", (Exception)((Object)proxyOnlyException));
            return null;
        }
    }

    public EntityDetail reHomeEntity(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "reHomeEntity";
        String entityParameterName = "entityGUID";
        super.reHomeInstanceParameterValidation(userId, entityGUID, "entityGUID", typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, "reHomeEntity");
        try {
            EntityDetail entity = this.repositoryStore.getEntity(entityGUID);
            this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "reHomeEntity");
            this.repositoryValidator.validateEntityCanBeRehomed(this.repositoryName, this.metadataCollectionId, (InstanceHeader)entity, "reHomeEntity");
            EntityDetail updatedEntity = new EntityDetail(entity);
            updatedEntity.setMetadataCollectionId(newHomeMetadataCollectionId);
            updatedEntity.setMetadataCollectionName(newHomeMetadataCollectionName);
            updatedEntity.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
            updatedEntity = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)entity, updatedEntity);
            this.repositoryStore.addEntityToStore(updatedEntity);
            EntityProxy entityProxy = this.repositoryHelper.getNewEntityProxy(this.repositoryName, updatedEntity);
            this.repositoryStore.addEntityProxyToStore(entityProxy);
            return updatedEntity;
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            super.reportEntityNotKnown(entityGUID, "reHomeEntity", (Exception)((Object)proxyOnlyException));
            return null;
        }
    }

    public Relationship reIdentifyRelationship(String userId, String typeDefGUID, String typeDefName, String relationshipGUID, String newRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "reIdentifyRelationship";
        String instanceParameterName = "relationshipGUID";
        String newInstanceParameterName = "newRelationshipGUID";
        this.reIdentifyInstanceParameterValidation(userId, typeDefGUID, typeDefName, relationshipGUID, "relationshipGUID", newRelationshipGUID, "newRelationshipGUID", "reIdentifyRelationship");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateRelationshipCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)relationship, "reIdentifyRelationship");
        Relationship deletedRelationship = new Relationship(relationship);
        deletedRelationship.setStatusOnDelete(relationship.getStatus());
        deletedRelationship.setStatus(InstanceStatus.DELETED);
        deletedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, deletedRelationship);
        Relationship updatedRelationship = new Relationship(relationship);
        updatedRelationship.setGUID(newRelationshipGUID);
        updatedRelationship.setReIdentifiedFromGUID(relationshipGUID);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        this.repositoryStore.addRelationshipToStore(deletedRelationship);
        this.repositoryStore.addRelationshipToStore(updatedRelationship);
        return updatedRelationship;
    }

    public Relationship reTypeRelationship(String userId, String relationshipGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, RelationshipNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "reTypeRelationship";
        String relationshipParameterName = "relationshipGUID";
        String currentTypeDefParameterName = "currentTypeDefSummary";
        String newTypeDefParameterName = "newTypeDefSummary";
        super.reTypeInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", TypeDefCategory.RELATIONSHIP_DEF, currentTypeDefSummary, newTypeDefSummary, "reTypeRelationship");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateRelationshipCanBeUpdated(this.repositoryName, this.metadataCollectionId, (InstanceHeader)relationship, "reTypeRelationship");
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)relationship, "currentTypeDefSummary", "currentTypeDefSummary", currentTypeDefSummary.getGUID(), currentTypeDefSummary.getName());
        this.repositoryValidator.validatePropertiesForType(this.repositoryName, "newTypeDefSummary", newTypeDefSummary, relationship.getProperties(), "reTypeRelationship");
        Relationship updatedRelationship = new Relationship(relationship);
        InstanceType newInstanceType = this.repositoryHelper.getNewInstanceType(this.repositoryName, newTypeDefSummary);
        updatedRelationship.setType(newInstanceType);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        return this.repositoryStore.addRelationshipToStore(updatedRelationship);
    }

    public Relationship reHomeRelationship(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "reHomeRelationship";
        String guidParameterName = "typeDefGUID";
        String nameParameterName = "typeDefName";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        String newHomeParameterName = "newHomeMetadataCollectionId";
        this.validateRepositoryConnector("reHomeRelationship");
        this.parentConnector.validateRepositoryIsActive("reHomeRelationship");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "reHomeRelationship");
        this.repositoryValidator.validateGUID(this.repositoryName, "relationshipGUID", relationshipGUID, "reHomeRelationship");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "reHomeRelationship");
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "homeMetadataCollectionId", homeMetadataCollectionId, "reHomeRelationship");
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "newHomeMetadataCollectionId", newHomeMetadataCollectionId, "reHomeRelationship");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateRelationshipCanBeRehomed(this.repositoryName, this.metadataCollectionId, (InstanceHeader)relationship, "reHomeRelationship");
        Relationship updatedRelationship = new Relationship(relationship);
        updatedRelationship.setMetadataCollectionId(newHomeMetadataCollectionId);
        updatedRelationship.setMetadataCollectionName(newHomeMetadataCollectionName);
        updatedRelationship.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
        updatedRelationship = this.repositoryHelper.incrementVersion(userId, (InstanceAuditHeader)relationship, updatedRelationship);
        return this.repositoryStore.addRelationshipToStore(updatedRelationship);
    }

    public void saveEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, UserNotAuthorizedException {
        String methodName = "saveEntityReferenceCopy";
        String instanceParameterName = "entity";
        this.validateRepositoryConnector("saveEntityReferenceCopy");
        this.parentConnector.validateRepositoryIsActive("saveEntityReferenceCopy");
        this.repositoryValidator.validateReferenceInstanceHeader(this.repositoryName, this.metadataCollectionId, "entity", (InstanceHeader)entity, this.auditLog, "saveEntityReferenceCopy");
        TypeDef typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "entity", entity.getType().getTypeDefGUID(), "saveEntityReferenceCopy");
        this.repositoryValidator.validatePropertiesForType(this.repositoryName, "entity", typeDef, entity.getProperties(), "saveEntityReferenceCopy");
        this.repositoryStore.addEntityToStore(entity);
    }

    public List<Classification> getHomeClassifications(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "getHomeClassifications";
        String guidParameterName = "entityGUID";
        this.validateRepositoryConnector("getHomeClassifications");
        this.parentConnector.validateRepositoryIsActive("getHomeClassifications");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getHomeClassifications");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "getHomeClassifications");
        return this.repositoryStore.getHomeClassifications(entityGUID);
    }

    public void purgeEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, HomeEntityException, UserNotAuthorizedException {
        String methodName = "purgeEntityReferenceCopy";
        String entityParameterName = "entityGUID";
        String homeParameterName = "homeMetadataCollectionId";
        this.manageReferenceInstanceParameterValidation(userId, entityGUID, typeDefGUID, typeDefName, "entityGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "purgeEntityReferenceCopy");
        try {
            EntityDetail entity = this.repositoryStore.getEntity(entityGUID);
            if (entity != null) {
                this.repositoryStore.purgeEntityFromStore(entityGUID);
            } else {
                super.reportEntityNotKnown(entityGUID, "purgeEntityReferenceCopy");
            }
        }
        catch (EntityProxyOnlyException proxyOnlyException) {
            super.reportEntityNotKnown(entityGUID, "purgeEntityReferenceCopy", (Exception)((Object)proxyOnlyException));
        }
    }

    public void saveClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException {
        String methodName = "saveClassificationReferenceCopy";
        String classificationParameterName = "classification";
        String propertiesParameterName = "classification.getProperties()";
        this.validateRepositoryConnector("saveClassificationReferenceCopy");
        this.parentConnector.validateRepositoryIsActive("saveClassificationReferenceCopy");
        this.repositoryStore.addEntityToStore(entity);
        EntityProxy retrievedEntity = this.repositoryStore.getEntityProxy(entity.getGUID(), null);
        if (retrievedEntity != null) {
            try {
                this.repositoryValidator.validateEntityIsNotDeleted(this.repositoryName, (InstanceHeader)retrievedEntity, "saveClassificationReferenceCopy");
                this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)entity);
                InstanceType entityType = entity.getType();
                this.repositoryValidator.validateClassification(this.repositoryName, "classification", classification.getName(), entityType.getTypeDefName(), "saveClassificationReferenceCopy");
                this.repositoryValidator.validateClassificationProperties(this.repositoryName, classification.getName(), "classification.getProperties()", classification.getProperties(), "saveClassificationReferenceCopy");
                this.repositoryStore.saveClassification(entity.getGUID(), classification);
            }
            catch (EntityNotKnownException entityType) {
            }
            catch (ClassificationErrorException error) {
                throw new TypeErrorException((OMRSCheckedExceptionBase)error);
            }
        }
    }

    public void saveClassificationReferenceCopy(String userId, EntityProxy entityProxy, Classification classification) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException {
        String methodName = "saveClassificationReferenceCopy(proxy)";
        this.validateRepositoryConnector("saveClassificationReferenceCopy(proxy)");
        this.parentConnector.validateRepositoryIsActive("saveClassificationReferenceCopy(proxy)");
        this.repositoryStore.addEntityProxyToStore(entityProxy);
        this.repositoryStore.saveClassification(entityProxy.getGUID(), classification);
    }

    public void purgeClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws TypeErrorException, RepositoryErrorException {
        String methodName = "purgeClassificationReferenceCopy";
        this.validateRepositoryConnector("purgeClassificationReferenceCopy");
        this.parentConnector.validateRepositoryIsActive("purgeClassificationReferenceCopy");
        this.repositoryStore.removeClassificationFromEntity(entity.getGUID(), classification.getName());
    }

    public void purgeClassificationReferenceCopy(String userId, EntityProxy entityProxy, Classification classification) throws InvalidParameterException, TypeErrorException, PropertyErrorException, EntityConflictException, InvalidEntityException, RepositoryErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "purgeClassificationReferenceCopy (proxy)";
        this.validateRepositoryConnector("purgeClassificationReferenceCopy (proxy)");
        this.parentConnector.validateRepositoryIsActive("purgeClassificationReferenceCopy (proxy)");
        this.repositoryStore.removeClassificationFromEntity(entityProxy.getGUID(), classification.getName());
    }

    public void saveRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, UserNotAuthorizedException {
        String methodName = "saveRelationshipReferenceCopy";
        String instanceParameterName = "relationship";
        super.referenceInstanceParameterValidation(userId, (InstanceHeader)relationship, "relationship", "saveRelationshipReferenceCopy");
        this.parentConnector.validateRepositoryIsActive("saveRelationshipReferenceCopy");
        this.repositoryValidator.validateReferenceInstanceHeader(this.repositoryName, this.metadataCollectionId, "relationship", (InstanceHeader)relationship, this.auditLog, "saveRelationshipReferenceCopy");
        TypeDef typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "relationship", relationship.getType().getTypeDefGUID(), "saveRelationshipReferenceCopy");
        this.repositoryValidator.validatePropertiesForType(this.repositoryName, "relationship", typeDef, relationship.getProperties(), "saveRelationshipReferenceCopy");
        this.repositoryStore.addEntityProxyToStore(relationship.getEntityOneProxy());
        this.repositoryStore.addEntityProxyToStore(relationship.getEntityTwoProxy());
        this.repositoryStore.addRelationshipToStore(relationship);
    }

    public void purgeRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, HomeRelationshipException, UserNotAuthorizedException {
        String methodName = "purgeRelationshipReferenceCopy";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        this.manageReferenceInstanceParameterValidation(userId, relationshipGUID, typeDefGUID, typeDefName, "relationshipGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "purgeRelationshipReferenceCopy");
        this.repositoryStore.purgeRelationshipFromStore(relationshipGUID);
    }
}

