/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector;

import java.sql.Connection;
import java.util.Date;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnector;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.ddl.postgres.PostgreSQLSchemaDDL;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.PostgresOMRSMetadataCollection;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.controls.PostgresConfigurationProperty;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.database.DatabaseStore;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.ffdc.PostgresAuditCode;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.ffdc.PostgresErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers.ControlMapper;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.schema.RepositoryTable;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSRuntimeException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class PostgresOMRSRepositoryConnector
extends OMRSRepositoryConnector {
    private static final String supportedSchemaVersion = "V1.0";
    private JDBCResourceConnector jdbcResourceConnector = null;

    public void setMetadataCollectionId(String metadataCollectionId) {
        String methodName = "setMetadataCollectionId";
        this.metadataCollectionId = metadataCollectionId;
        this.repositoryName = super.getStringConfigurationProperty(PostgresConfigurationProperty.DATABASE_SCHEMA.getName(), this.connectionDetails.getConfigurationProperties());
        if (metadataCollectionId != null && this.embeddedConnectors != null && !this.embeddedConnectors.isEmpty()) {
            for (Connector embeddedConnector : this.embeddedConnectors) {
                JDBCResourceConnector embeddedJDBCResourceConnector;
                if (!(embeddedConnector instanceof JDBCResourceConnector)) continue;
                this.jdbcResourceConnector = embeddedJDBCResourceConnector = (JDBCResourceConnector)embeddedConnector;
                try {
                    if (!this.jdbcResourceConnector.isActive()) {
                        this.jdbcResourceConnector.start();
                    }
                    this.validateRepositoryControlTable(this.jdbcResourceConnector);
                    boolean isReadOnly = this.getRepositoryMode();
                    Date defaultAsOfTime = this.getDefaultAsOfTime();
                    this.metadataCollection = new PostgresOMRSMetadataCollection(this, this.serverName, this.repositoryHelper, this.repositoryValidator, isReadOnly, defaultAsOfTime, this.jdbcResourceConnector, metadataCollectionId);
                    break;
                }
                catch (Exception exception) {
                    this.auditLog.logException("setMetadataCollectionId", PostgresAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, exception.getClass().getName(), "setMetadataCollectionId", exception.getMessage()), (Throwable)exception);
                    throw new OMRSRuntimeException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, exception.getClass().getName(), "setMetadataCollectionId", exception.getMessage()), ((Object)((Object)this)).getClass().getName(), "setMetadataCollectionId", exception);
                }
            }
        }
    }

    private void validateRepositoryControlTable(JDBCResourceConnector jdbcResourceConnector) throws RepositoryErrorException {
        String methodName = "validateRepositoryControlTable";
        this.auditLog.logMessage("validateRepositoryControlTable", PostgresAuditCode.STARTING_REPOSITORY.getMessageDefinition(this.repositoryName, jdbcResourceConnector.getDatabaseName()));
        Object schemaName = super.getStringConfigurationProperty(PostgresConfigurationProperty.DATABASE_SCHEMA.getName(), this.connectionDetails.getConfigurationProperties());
        if (schemaName == null) {
            schemaName = "repository_" + this.serverName;
        }
        try {
            this.loadDDL(jdbcResourceConnector, (String)schemaName);
            DatabaseStore databaseStore = new DatabaseStore(jdbcResourceConnector, this.repositoryName, this.repositoryHelper);
            ControlMapper controlMapper = databaseStore.getControlTable();
            if (controlMapper == null) {
                controlMapper = new ControlMapper(this.repositoryName, this.serverName, this.metadataCollectionId, supportedSchemaVersion);
                databaseStore.saveControlTable(controlMapper);
            } else {
                if (!this.serverName.equals(controlMapper.getServerName())) {
                    throw new RepositoryErrorException(PostgresErrorCode.CONTROL_SERVER_MISMATCH.getMessageDefinition(new String[]{this.repositoryName, schemaName, controlMapper.getServerName()}), ((Object)((Object)this)).getClass().getName(), "validateRepositoryControlTable");
                }
                if (!this.metadataCollectionId.equals(controlMapper.getLocalMetadataCollectionGUID())) {
                    throw new RepositoryErrorException(PostgresErrorCode.CONTROL_MC_ID_MISMATCH.getMessageDefinition(new String[]{this.repositoryName, schemaName, controlMapper.getLocalMetadataCollectionGUID(), this.metadataCollectionId}), ((Object)((Object)this)).getClass().getName(), "validateRepositoryControlTable");
                }
                if (!supportedSchemaVersion.equals(controlMapper.getSchemaVersion())) {
                    throw new RepositoryErrorException(PostgresErrorCode.CONTROL_SCHEMA_VERSION_MISMATCH.getMessageDefinition(new String[]{this.repositoryName, schemaName, controlMapper.getSchemaVersion()}), ((Object)((Object)this)).getClass().getName(), "validateRepositoryControlTable");
                }
            }
        }
        catch (RepositoryErrorException error) {
            throw error;
        }
        catch (Exception error) {
            this.auditLog.logException("validateRepositoryControlTable", PostgresAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, error.getClass().getName(), "validateRepositoryControlTable", error.getMessage()), (Throwable)error);
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, error.getClass().getName(), "validateRepositoryControlTable", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "validateRepositoryControlTable", error);
        }
    }

    private void loadDDL(JDBCResourceConnector jdbcResourceConnector, String schemaName) throws RepositoryErrorException {
        String methodName = "loadDDL";
        this.auditLog.logMessage("loadDDL", PostgresAuditCode.CONFIRMING_REPOSITORY_SCHEMA.getMessageDefinition(this.repositoryName, schemaName));
        try {
            Connection jdbcConnection = jdbcResourceConnector.getDataSource().getConnection();
            PostgreSQLSchemaDDL postgreSQLSchemaDDL = new PostgreSQLSchemaDDL(schemaName, this.repositoryName, RepositoryTable.getTables());
            jdbcResourceConnector.addDatabaseDefinitions(jdbcConnection, postgreSQLSchemaDDL.getDDLStatements());
            jdbcConnection.commit();
        }
        catch (Exception error) {
            this.auditLog.logException("loadDDL", PostgresAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, error.getClass().getName(), "loadDDL", error.getMessage()), (Throwable)error);
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, error.getClass().getName(), "loadDDL", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "loadDDL", error);
        }
    }

    private boolean getRepositoryMode() {
        String methodName = "getRepositoryMode";
        String repositoryMode = super.getStringConfigurationProperty(PostgresConfigurationProperty.REPOSITORY_MODE.getName(), this.connectionDetails.getConfigurationProperties());
        repositoryMode = "readOnly".equals(repositoryMode) ? "read-only" : "read-write";
        this.auditLog.logMessage("getRepositoryMode", PostgresAuditCode.REPOSITORY_MODE.getMessageDefinition(this.repositoryName, repositoryMode));
        return "read-only".equals(repositoryMode);
    }

    private Date getDefaultAsOfTime() throws InvalidParameterException {
        String methodName = "getDefaultAsOfTime";
        Date defaultAsOfTime = super.getDateConfigurationProperty(PostgresConfigurationProperty.REPOSITORY_MODE.getName(), this.connectionDetails.getConfigurationProperties());
        if (defaultAsOfTime == null) {
            this.auditLog.logMessage("getDefaultAsOfTime", PostgresAuditCode.DEFAULT_AS_OF_TIME.getMessageDefinition(this.repositoryName, "'null'"));
        } else {
            this.auditLog.logMessage("getDefaultAsOfTime", PostgresAuditCode.DEFAULT_AS_OF_TIME.getMessageDefinition(this.repositoryName, defaultAsOfTime.toString()));
        }
        return defaultAsOfTime;
    }

    public void disconnect() throws ConnectorCheckedException {
        if (this.jdbcResourceConnector != null) {
            this.jdbcResourceConnector.disconnect();
        }
    }
}

