/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.controls;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.controls.ConfigurationPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.types.DataType;

public enum PostgresConfigurationProperty {
    DATABASE_URL("databaseURL", "Connection string for the database where the schema is located. This should set the current schema to your chosen schema.", DataType.STRING.getName(), "~{postgreSQLDatabaseURL}~"),
    DATABASE_SCHEMA("databaseSchema", "The name of the database schema used to store the repository contents.", DataType.STRING.getName(), "repository_{{serverName}}"),
    SECRETS_STORE("secretsStore", "The file name of the secrets store containing the log on credentials to access the database schema.", DataType.STRING.getName(), "~{secretsStore}~"),
    SECRETS_COLLECTION_NAME("secretsCollectionName", "The name of the secrets collection.", DataType.STRING.getName(), "~{postgreSQLServerCollectionName}~"),
    DEFAULT_AS_OF_TIME("defaultAsOfTime", "Optional value that changes the default value for 'asOfTime'. The 'asOfTime' parameter is used on queries to control which point in time to take the open metadata from.  The standard default is 'null' which means use the current time. If the 'defaultAsOfTime' option is specified then, by default, queries will use the supplied asOfTime value.  This can be overridden on individual requests.  Creates, updates, deletes continue to be appended to the database.  The mode recent data can be retrieved by setting the asOfTime to the current time on queries.", DataType.DATE.getName(), null),
    REPOSITORY_MODE("repositoryMode", "Optional value that controls which functions are active in the repository. If it is set to 'readOnly' the repository is switched into read-only mode.  Any other value (or if it is not specified) results in a read-write repository.", DataType.DATE.getName(), "yyyy/MM/dd HH:mm:ss");

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;

    private PostgresConfigurationProperty(String name, String description, String dataType, String example) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public static List<ConfigurationPropertyType> getConfigurationPropertyTypes() {
        ArrayList<ConfigurationPropertyType> configurationPropertyTypes = new ArrayList<ConfigurationPropertyType>();
        for (PostgresConfigurationProperty configurationProperty : PostgresConfigurationProperty.values()) {
            configurationPropertyTypes.add(configurationProperty.getConfigurationPropertyType());
        }
        return configurationPropertyTypes;
    }

    public ConfigurationPropertyType getConfigurationPropertyType() {
        ConfigurationPropertyType requestParameterType = new ConfigurationPropertyType();
        requestParameterType.setName(this.name);
        requestParameterType.setDescription(this.description);
        requestParameterType.setDataType(this.dataType);
        requestParameterType.setExample(this.example);
        return requestParameterType;
    }

    public String toString() {
        return "MoveCopyFileRequestParameter{ name=" + this.name + "}";
    }
}

