/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.database;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.ffdc.PostgresErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.schema.RepositoryColumn;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.schema.RepositoryTable;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.StructPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyComparisonOperator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.PropertyCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBuilder {
    private final OMRSRepositoryHelper repositoryHelper;
    private final String repositoryName;
    private String relationshipEndGUID = null;
    private String searchString = null;
    private SearchProperties searchProperties = null;
    private String principleTableName = null;
    private String propertyTableName = null;
    private SearchClassifications matchClassifications = null;
    private List<String> limitResultsByClassification = null;
    private String typeGUID = null;
    private String typeGUIDParameterName = "typeGUID";
    private List<String> subtypeGUIDs = null;
    private String subTypeGUIDsParameterName = "subTypeGUIDs";
    private List<InstanceStatus> limitResultsByStatus = null;
    private List<String> guidList = null;
    private Date asOfTime = null;
    private String sequencingProperty = null;
    private SequencingOrder sequencingOrder = null;
    private int fromElement = 0;
    private int pageSize = 0;
    private static final Logger log = LoggerFactory.getLogger(QueryBuilder.class);

    public QueryBuilder(String principleTableName, String propertyTableName, OMRSRepositoryHelper repositoryHelper, String repositoryName) {
        this.principleTableName = principleTableName;
        this.propertyTableName = propertyTableName;
        this.repositoryHelper = repositoryHelper;
        this.repositoryName = repositoryName;
    }

    public void setRelationshipEndGUID(String relationshipEndGUID) {
        this.relationshipEndGUID = relationshipEndGUID;
    }

    private String getRelationshipEndGUIDClause() {
        if (this.relationshipEndGUID != null) {
            return " and (" + RepositoryColumn.END_1_GUID.getColumnName() + " = '" + this.relationshipEndGUID + "' or " + RepositoryColumn.END_2_GUID.getColumnName() + " = '" + this.relationshipEndGUID + "')";
        }
        return " ";
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    private String getSearchStringClause() throws RepositoryErrorException {
        if (this.searchString != null) {
            if (this.repositoryHelper.isCaseInsensitiveRegex(this.searchString)) {
                return " and " + this.getPropertySubSelect(null, null, " ~* ", this.getSafeRegex(this.searchString));
            }
            return " and " + this.getPropertySubSelect(null, null, " ~ ", this.getSafeRegex(this.searchString));
        }
        return " ";
    }

    private String getPropertySubSelect(String propertyName, String propertyColumn, String operator, String propertyValue) {
        String subSelect = " (" + RepositoryColumn.INSTANCE_GUID.getColumnName(this.principleTableName) + " in (select " + RepositoryColumn.INSTANCE_GUID.getColumnName(this.propertyTableName) + " from " + this.propertyTableName + " where (";
        if (propertyName != null) {
            subSelect = subSelect + propertyColumn + "='" + propertyName + "'";
            if (propertyValue != null) {
                subSelect = subSelect + " and ";
            }
        }
        if (propertyValue != null) {
            subSelect = subSelect + RepositoryColumn.PROPERTY_VALUE.getColumnName() + " " + operator + "  '" + propertyValue + "'";
        }
        return subSelect + "))) ";
    }

    private String escapePropertyValue(Object propertyValue) {
        if (propertyValue != null) {
            return propertyValue.toString().replaceAll("'", "''");
        }
        return null;
    }

    private String getSafeRegex(Object suppliedSearchString) throws RepositoryErrorException {
        String methodName = "getSafeRegex";
        String tester = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        if (suppliedSearchString != null) {
            String strippedSearchString = this.repositoryHelper.getUnqualifiedLiteralString(suppliedSearchString.toString());
            Date currentTime = new Date();
            Date maxExecutionTime = new Date(currentTime.getTime() + 500L);
            try {
                boolean bl = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".matches(strippedSearchString);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Date completionTime = new Date();
            if (completionTime.after(maxExecutionTime)) {
                throw new RepositoryErrorException(PostgresErrorCode.BAD_REGEX.getMessageDefinition(this.searchString), this.getClass().getName(), "getSafeRegex");
            }
            return strippedSearchString;
        }
        return null;
    }

    public void setMatchProperties(InstanceProperties matchProperties, MatchCriteria matchCriteria) {
        if (matchProperties != null && (matchProperties.getPropertyCount() > 0 || matchProperties.getEffectiveFromTime() != null || matchProperties.getEffectiveToTime() != null)) {
            PropertyCondition propertyCondition;
            SearchProperties searchProperties = new SearchProperties();
            ArrayList<PropertyCondition> propertyConditions = new ArrayList<PropertyCondition>();
            if (matchProperties.getEffectiveFromTime() != null) {
                propertyCondition = this.getEffectiveTimePropertyCondition(matchCriteria, OpenMetadataProperty.EFFECTIVE_FROM_TIME.name, matchProperties.getEffectiveFromTime());
                propertyConditions.add(propertyCondition);
            }
            if (matchProperties.getEffectiveToTime() != null) {
                propertyCondition = this.getEffectiveTimePropertyCondition(matchCriteria, OpenMetadataProperty.EFFECTIVE_TO_TIME.name, matchProperties.getEffectiveToTime());
                propertyConditions.add(propertyCondition);
            }
            if (matchProperties.getPropertyCount() > 0) {
                Map properties = matchProperties.getInstanceProperties();
                for (String propertyName : properties.keySet()) {
                    InstancePropertyValue instancePropertyValue = (InstancePropertyValue)properties.get(propertyName);
                    PropertyCondition propertyCondition2 = new PropertyCondition();
                    propertyCondition2.setProperty(propertyName);
                    propertyCondition2.setValue(instancePropertyValue);
                    if (matchCriteria == MatchCriteria.NONE) {
                        propertyCondition2.setOperator(PropertyComparisonOperator.NEQ);
                    } else {
                        propertyCondition2.setOperator(PropertyComparisonOperator.EQ);
                    }
                    propertyConditions.add(propertyCondition2);
                }
            }
            searchProperties.setConditions(propertyConditions);
            searchProperties.setMatchCriteria(matchCriteria);
            this.setSearchProperties(searchProperties);
        }
    }

    private PropertyCondition getEffectiveTimePropertyCondition(MatchCriteria matchCriteria, String propertyName, Date dateValue) {
        PropertyCondition propertyCondition = new PropertyCondition();
        propertyCondition.setProperty(propertyName);
        if (matchCriteria == MatchCriteria.NONE) {
            propertyCondition.setOperator(PropertyComparisonOperator.NEQ);
        } else {
            propertyCondition.setOperator(PropertyComparisonOperator.EQ);
        }
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setHeaderVersion(1L);
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getName());
        primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getGUID());
        primitivePropertyValue.setPrimitiveValue((Object)dateValue);
        return propertyCondition;
    }

    private String getPropertyComparisonFromInstanceProperties(InstanceProperties instanceProperties, String topLevelPropertyName, PropertyComparisonOperator stringPropertyOperator, PropertyComparisonOperator numericPropertyOperator, String matchOperand) throws RepositoryErrorException {
        if (instanceProperties != null && instanceProperties.getPropertyCount() > 0) {
            StringBuilder stringBuilder = new StringBuilder(" (");
            Iterator propertyNames = instanceProperties.getPropertyNames();
            boolean firstProperty = true;
            while (propertyNames.hasNext()) {
                String leafPropertyName = (String)propertyNames.next();
                InstancePropertyValue instancePropertyValue = instanceProperties.getPropertyValue(leafPropertyName);
                if (instancePropertyValue != null) {
                    if (firstProperty) {
                        firstProperty = false;
                    } else {
                        stringBuilder.append(matchOperand);
                    }
                }
                if (instancePropertyValue instanceof PrimitivePropertyValue) {
                    PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue;
                    if (primitivePropertyValue.getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING) {
                        stringBuilder.append(this.getNestedPropertyComparisonClause(topLevelPropertyName, leafPropertyName, stringPropertyOperator, this.escapePropertyValue(primitivePropertyValue.getPrimitiveValue())));
                        continue;
                    }
                    stringBuilder.append(this.getNestedPropertyComparisonClause(topLevelPropertyName, leafPropertyName, numericPropertyOperator, primitivePropertyValue.getPrimitiveValue()));
                    continue;
                }
                if (instancePropertyValue instanceof EnumPropertyValue) {
                    EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
                    stringBuilder.append(this.getNestedPropertyComparisonClause(topLevelPropertyName, leafPropertyName, stringPropertyOperator, this.escapePropertyValue(enumPropertyValue.getSymbolicName())));
                    continue;
                }
                if (instancePropertyValue instanceof MapPropertyValue) {
                    MapPropertyValue mapPropertyValue = (MapPropertyValue)instancePropertyValue;
                    stringBuilder.append(this.getPropertyComparisonFromInstanceProperties(mapPropertyValue.getMapValues(), leafPropertyName, stringPropertyOperator, numericPropertyOperator, matchOperand));
                    continue;
                }
                if (instancePropertyValue instanceof ArrayPropertyValue) {
                    ArrayPropertyValue arrayPropertyValue = (ArrayPropertyValue)instancePropertyValue;
                    stringBuilder.append(this.getPropertyComparisonFromInstanceProperties(arrayPropertyValue.getArrayValues(), leafPropertyName, stringPropertyOperator, numericPropertyOperator, matchOperand));
                    continue;
                }
                if (!(instancePropertyValue instanceof StructPropertyValue)) continue;
                StructPropertyValue structPropertyValue = (StructPropertyValue)instancePropertyValue;
                stringBuilder.append(this.getPropertyComparisonFromInstanceProperties(structPropertyValue.getAttributes(), leafPropertyName, stringPropertyOperator, numericPropertyOperator, matchOperand));
            }
            stringBuilder.append(") ");
            return stringBuilder.toString();
        }
        return " ";
    }

    private String getNestedPropertyComparisonClause(String topLevelPropertyName, String leafPropertyName, PropertyComparisonOperator operator, Object propertyValue) throws RepositoryErrorException {
        String methodName = "getNestedPropertyComparisonClause";
        String propertyColumn = this.mapPropertyNameToColumn(leafPropertyName, RepositoryColumn.ATTRIBUTE_NAME.getColumnName());
        if (propertyColumn.equals(RepositoryColumn.ATTRIBUTE_NAME.getColumnName()) || propertyColumn.equals(RepositoryColumn.PROPERTY_NAME.getColumnName())) {
            if (operator == PropertyComparisonOperator.IS_NULL) {
                if (this.propertyTableName != null) {
                    String subSelect = " (" + RepositoryColumn.INSTANCE_GUID.getColumnName(this.principleTableName) + " not in (select " + RepositoryColumn.INSTANCE_GUID.getColumnName(this.propertyTableName) + " from " + this.propertyTableName + " where (";
                    if (topLevelPropertyName == null) {
                        return subSelect + RepositoryColumn.ATTRIBUTE_NAME.getColumnName() + " = '" + leafPropertyName + "'))) ";
                    }
                    return subSelect + RepositoryColumn.ATTRIBUTE_NAME.getColumnName() + " = '" + topLevelPropertyName + "' and " + RepositoryColumn.PROPERTY_NAME.getColumnName() + " like '%:" + leafPropertyName + "'))) ";
                }
            } else {
                String sqlClause = " (" + RepositoryColumn.INSTANCE_GUID.getColumnName(this.principleTableName) + " in (select " + RepositoryColumn.INSTANCE_GUID.getColumnName(this.propertyTableName) + " from " + this.propertyTableName + " where (";
                if (topLevelPropertyName == null) {
                    sqlClause = sqlClause + RepositoryColumn.ATTRIBUTE_NAME.getColumnName() + " = '" + leafPropertyName + "'";
                } else {
                    sqlClause = sqlClause + RepositoryColumn.ATTRIBUTE_NAME.getColumnName() + " = '" + topLevelPropertyName + "' and ";
                    sqlClause = sqlClause + RepositoryColumn.PROPERTY_NAME.getColumnName() + " like '%:" + leafPropertyName + "'";
                }
                switch (operator) {
                    case EQ: {
                        return sqlClause + " and " + RepositoryColumn.PROPERTY_VALUE.getColumnName() + " = '" + this.getSafeRegex(propertyValue) + "'))) ";
                    }
                    case NEQ: {
                        return sqlClause + " and " + RepositoryColumn.PROPERTY_VALUE.getColumnName() + " != '" + this.getSafeRegex(propertyValue) + "'))) ";
                    }
                    case LT: {
                        return sqlClause + " and " + RepositoryColumn.PROPERTY_VALUE.getColumnName() + " < '" + String.valueOf(propertyValue) + "'))) ";
                    }
                    case LTE: {
                        return sqlClause + " and " + RepositoryColumn.PROPERTY_VALUE.getColumnName() + " <= '" + String.valueOf(propertyValue) + "'))) ";
                    }
                    case GT: {
                        return sqlClause + " and " + RepositoryColumn.PROPERTY_VALUE.getColumnName() + " > '" + String.valueOf(propertyValue) + "'))) ";
                    }
                    case GTE: {
                        return sqlClause + " and " + RepositoryColumn.PROPERTY_VALUE.getColumnName() + " >= '" + String.valueOf(propertyValue) + "'))) ";
                    }
                    case LIKE: {
                        if (this.repositoryHelper.isCaseInsensitiveRegex(propertyValue.toString())) {
                            return sqlClause + " and " + RepositoryColumn.PROPERTY_VALUE.getColumnName() + " ~* '" + this.getSafeRegex(propertyValue) + "'))) ";
                        }
                        return sqlClause + " and " + RepositoryColumn.PROPERTY_VALUE.getColumnName() + " ~ '" + this.getSafeRegex(propertyValue) + "'))) ";
                    }
                    case NOT_LIKE: {
                        if (this.repositoryHelper.isCaseInsensitiveRegex(propertyValue.toString())) {
                            return sqlClause + " and " + RepositoryColumn.PROPERTY_VALUE.getColumnName() + " !~* '" + this.getSafeRegex(propertyValue) + "'))) ";
                        }
                        return sqlClause + " and " + RepositoryColumn.PROPERTY_VALUE.getColumnName() + " !~ '" + this.getSafeRegex(propertyValue) + "'))) ";
                    }
                    case NOT_NULL: {
                        return sqlClause + ")))";
                    }
                }
            }
        } else {
            switch (operator) {
                case EQ: {
                    return " (" + this.principleTableName + "." + propertyColumn + " = '" + this.getSafeRegex(propertyValue) + "') ";
                }
                case NEQ: {
                    return " (" + this.principleTableName + "." + propertyColumn + " != '" + this.getSafeRegex(propertyValue) + "') ";
                }
                case LT: {
                    return " (" + this.principleTableName + "." + propertyColumn + " < '" + String.valueOf(propertyValue) + "') ";
                }
                case LTE: {
                    return " (" + this.principleTableName + "." + propertyColumn + " <= '" + String.valueOf(propertyValue) + "') ";
                }
                case GT: {
                    return " (" + this.principleTableName + "." + propertyColumn + " > '" + String.valueOf(propertyValue) + "') ";
                }
                case GTE: {
                    return " (" + this.principleTableName + "." + propertyColumn + " >= '" + String.valueOf(propertyValue) + "') ";
                }
                case IS_NULL: {
                    return " (" + this.principleTableName + "." + propertyColumn + " is null)";
                }
                case NOT_NULL: {
                    return " (" + this.principleTableName + "." + propertyColumn + " is not null)";
                }
                case LIKE: {
                    if (this.repositoryHelper.isCaseInsensitiveRegex(propertyValue.toString())) {
                        return " (" + this.principleTableName + "." + propertyColumn + " ~* '" + this.getSafeRegex(propertyValue) + "') ";
                    }
                    return " (" + this.principleTableName + "." + propertyColumn + " ~ '" + this.getSafeRegex(propertyValue) + "') ";
                }
                case NOT_LIKE: {
                    if (this.repositoryHelper.isCaseInsensitiveRegex(propertyValue.toString())) {
                        return " (" + this.principleTableName + "." + propertyColumn + " !~* '" + this.getSafeRegex(propertyValue) + "') ";
                    }
                    return " (" + this.principleTableName + "." + propertyColumn + " !~ '" + this.getSafeRegex(propertyValue) + "') ";
                }
            }
        }
        throw new RepositoryErrorException(PostgresErrorCode.BAD_SEARCH_PROPERTY.getMessageDefinition(this.repositoryName, operator.getName(), propertyValue.toString()), this.getClass().getName(), "getNestedPropertyComparisonClause");
    }

    public void setSearchProperties(SearchProperties searchProperties) {
        this.searchProperties = searchProperties;
    }

    private String getSearchPropertiesClause() throws RepositoryErrorException {
        if (this.searchProperties != null) {
            return " and " + this.getPropertyComparisonFromPropertyConditions(this.searchProperties, this.propertyTableName, null);
        }
        return " ";
    }

    private String getPropertyComparisonFromPropertyConditions(SearchProperties searchProperties, String propertyTableName, String topLevelPropertyName) throws RepositoryErrorException {
        if (searchProperties != null && searchProperties.getConditions() != null && !searchProperties.getConditions().isEmpty()) {
            String matchOperand = " and ";
            if (searchProperties.getMatchCriteria() == MatchCriteria.ANY) {
                matchOperand = " or ";
            }
            StringBuilder stringBuilder = new StringBuilder("(");
            boolean firstProperty = true;
            for (PropertyCondition propertyCondition : searchProperties.getConditions()) {
                if (propertyCondition.getNestedConditions() != null) {
                    if (firstProperty) {
                        firstProperty = false;
                    } else {
                        stringBuilder.append(matchOperand);
                    }
                    stringBuilder.append(this.getPropertyComparisonFromPropertyConditions(propertyCondition.getNestedConditions(), propertyTableName, topLevelPropertyName));
                    continue;
                }
                String leafPropertyName = propertyCondition.getProperty();
                InstancePropertyValue instancePropertyValue = propertyCondition.getValue();
                if (firstProperty) {
                    firstProperty = false;
                } else {
                    stringBuilder.append(matchOperand);
                }
                if (instancePropertyValue instanceof PrimitivePropertyValue) {
                    PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue;
                    if (primitivePropertyValue.getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING) {
                        stringBuilder.append(this.getNestedPropertyComparisonClause(topLevelPropertyName, leafPropertyName, propertyCondition.getOperator(), this.escapePropertyValue(primitivePropertyValue.getPrimitiveValue())));
                        continue;
                    }
                    stringBuilder.append(this.getNestedPropertyComparisonClause(topLevelPropertyName, leafPropertyName, propertyCondition.getOperator(), primitivePropertyValue.getPrimitiveValue()));
                    continue;
                }
                if (instancePropertyValue instanceof EnumPropertyValue) {
                    EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
                    stringBuilder.append(this.getNestedPropertyComparisonClause(topLevelPropertyName, leafPropertyName, propertyCondition.getOperator(), this.escapePropertyValue(enumPropertyValue.getSymbolicName())));
                    continue;
                }
                if (instancePropertyValue instanceof MapPropertyValue) {
                    MapPropertyValue mapPropertyValue = (MapPropertyValue)instancePropertyValue;
                    stringBuilder.append(this.getPropertyComparisonFromInstanceProperties(mapPropertyValue.getMapValues(), leafPropertyName, propertyCondition.getOperator(), propertyCondition.getOperator(), matchOperand));
                    continue;
                }
                if (instancePropertyValue instanceof ArrayPropertyValue) {
                    ArrayPropertyValue arrayPropertyValue = (ArrayPropertyValue)instancePropertyValue;
                    stringBuilder.append(this.getPropertyComparisonFromInstanceProperties(arrayPropertyValue.getArrayValues(), leafPropertyName, propertyCondition.getOperator(), propertyCondition.getOperator(), matchOperand));
                    continue;
                }
                if (instancePropertyValue instanceof StructPropertyValue) {
                    StructPropertyValue structPropertyValue = (StructPropertyValue)instancePropertyValue;
                    stringBuilder.append(this.getPropertyComparisonFromInstanceProperties(structPropertyValue.getAttributes(), leafPropertyName, propertyCondition.getOperator(), propertyCondition.getOperator(), matchOperand));
                    continue;
                }
                stringBuilder.append(this.getNestedPropertyComparisonClause(topLevelPropertyName, leafPropertyName, propertyCondition.getOperator(), null));
            }
            stringBuilder.append(") ");
            return stringBuilder.toString();
        }
        return " ";
    }

    public void setSearchClassifications(SearchClassifications matchClassifications) {
        this.matchClassifications = matchClassifications;
    }

    private String getSearchClassificationsClause() throws RepositoryErrorException {
        if (this.matchClassifications != null && this.matchClassifications.getConditions() != null) {
            String matchOperand = " and ";
            PropertyComparisonOperator operator = PropertyComparisonOperator.EQ;
            if (this.matchClassifications.getMatchCriteria() == MatchCriteria.ANY) {
                matchOperand = " or ";
            } else if (this.matchClassifications.getMatchCriteria() == MatchCriteria.NONE) {
                operator = PropertyComparisonOperator.NEQ;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (ClassificationCondition classificationCondition : this.matchClassifications.getConditions()) {
                if (classificationCondition == null) continue;
                stringBuilder.append(matchOperand);
                stringBuilder.append(" (");
                stringBuilder.append(RepositoryColumn.CLASSIFICATION_NAME.getColumnName(RepositoryTable.CLASSIFICATION.getTableName()));
                if (operator == PropertyComparisonOperator.EQ) {
                    stringBuilder.append(" = '");
                } else {
                    stringBuilder.append(" != '");
                }
                stringBuilder.append(classificationCondition.getName());
                stringBuilder.append("' ");
                if (classificationCondition.getMatchProperties() != null) {
                    stringBuilder.append(" and ");
                    stringBuilder.append(this.getPropertyComparisonFromPropertyConditions(classificationCondition.getMatchProperties(), RepositoryTable.CLASSIFICATION_ATTRIBUTE_VALUE.getTableName(), null));
                }
                stringBuilder.append(") ");
            }
            return stringBuilder.toString();
        }
        return " ";
    }

    public void setLimitResultsByClassification(List<String> limitResultsByClassification) {
        this.limitResultsByClassification = limitResultsByClassification;
    }

    private String getLimitResultsByClassificationClaus() {
        if (this.limitResultsByClassification != null && !this.limitResultsByClassification.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(" and (");
            boolean firstClassification = true;
            for (String classificationName : this.limitResultsByClassification) {
                if (firstClassification) {
                    firstClassification = false;
                } else {
                    stringBuilder.append(" or ");
                }
                stringBuilder.append(RepositoryColumn.CLASSIFICATION_NAME.getColumnName(RepositoryTable.CLASSIFICATION.getTableName()));
                stringBuilder.append(" = '");
                stringBuilder.append(classificationName);
                stringBuilder.append("'");
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
        return " ";
    }

    public void setTypeGUID(String typeGUID, String typeGUIDParameterName) {
        this.typeGUID = typeGUID;
        this.typeGUIDParameterName = typeGUIDParameterName;
    }

    public void setTypeGUID(String typeGUID, String typeGUIDParameterName, List<String> subTypeGUIDs, String subTypeGUIDsParameterName) {
        this.typeGUID = typeGUID;
        this.typeGUIDParameterName = typeGUIDParameterName;
        this.subtypeGUIDs = subTypeGUIDs;
        this.subTypeGUIDsParameterName = subTypeGUIDsParameterName;
    }

    private String getTypeClause() throws RepositoryErrorException {
        if (this.subtypeGUIDs != null && !this.subtypeGUIDs.isEmpty()) {
            StringBuilder stringBuffer = new StringBuilder(" and (");
            boolean firstType = true;
            for (String subTypeGUID : this.subtypeGUIDs) {
                if (firstType) {
                    firstType = false;
                } else {
                    stringBuffer.append(" or ");
                }
                stringBuffer.append(RepositoryColumn.TYPE_NAME.getColumnName());
                stringBuffer.append(" like '%:");
                stringBuffer.append(this.lookUpTypeName(subTypeGUID, this.subTypeGUIDsParameterName));
                stringBuffer.append(":%')");
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        if (this.typeGUID != null) {
            return " and (" + RepositoryColumn.TYPE_NAME.getColumnName() + " like '%:" + this.lookUpTypeName(this.typeGUID, this.typeGUIDParameterName) + ":%')";
        }
        return " ";
    }

    private String lookUpTypeName(String typeGUID, String parameterName) throws RepositoryErrorException {
        String methodName = "lookUpTypeName";
        try {
            TypeDef typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, parameterName, typeGUID, "lookUpTypeName");
            if (typeDef != null) {
                return typeDef.getName();
            }
        }
        catch (TypeErrorException error) {
            throw new RepositoryErrorException(PostgresErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.repositoryName, ((Object)((Object)error)).getClass().getName(), "lookUpTypeName", error.getMessage()), this.getClass().getName(), "lookUpTypeName", (Exception)((Object)error));
        }
        return OpenMetadataType.OPEN_METADATA_ROOT.typeName;
    }

    public void setLimitResultsByStatus(List<InstanceStatus> limitResultsByStatus) {
        this.limitResultsByStatus = limitResultsByStatus;
    }

    private String getLimitResultsByStatusClause() {
        if (this.limitResultsByStatus == null) {
            return " and (" + RepositoryColumn.CURRENT_STATUS.getColumnName() + " != '" + InstanceStatus.DELETED.getName() + "') ";
        }
        if (this.limitResultsByStatus.isEmpty()) {
            return " ";
        }
        StringBuilder sqlClause = new StringBuilder(" and (");
        boolean firstStatus = true;
        for (InstanceStatus instanceStatus : this.limitResultsByStatus) {
            if (instanceStatus == null) continue;
            if (firstStatus) {
                firstStatus = false;
            } else {
                sqlClause.append(" or ");
            }
            sqlClause.append(RepositoryColumn.CURRENT_STATUS.getColumnName());
            sqlClause.append(" = '");
            sqlClause.append(instanceStatus.getName());
            sqlClause.append("'");
        }
        sqlClause.append(")");
        return sqlClause.toString();
    }

    public void setAsOfTime(Date asOfTime) {
        this.asOfTime = asOfTime;
    }

    private String getAsOfTimeClause() {
        if (this.asOfTime == null) {
            return " (" + RepositoryColumn.VERSION_END_TIME.getColumnName() + " is null) ";
        }
        return " (" + RepositoryColumn.VERSION_START_TIME.getColumnName() + " < '" + String.valueOf(this.asOfTime) + "' and (" + RepositoryColumn.VERSION_END_TIME.getColumnName() + " is null or " + RepositoryColumn.VERSION_END_TIME.getColumnName() + " > '" + String.valueOf(this.asOfTime) + "')) ";
    }

    public void setSequencingOrder(SequencingOrder sequencingOrder, String sequencingProperty) {
        this.sequencingOrder = sequencingOrder;
        this.sequencingProperty = sequencingProperty;
    }

    private String getSequencingOrder(String principleTableName) {
        if (this.sequencingOrder != null) {
            switch (this.sequencingOrder) {
                case ANY: 
                case CREATION_DATE_RECENT: {
                    return " order by " + RepositoryColumn.CREATE_TIME.getColumnName(principleTableName) + " desc ";
                }
                case CREATION_DATE_OLDEST: {
                    return " order by " + RepositoryColumn.CREATE_TIME.getColumnName(principleTableName) + " asc ";
                }
                case LAST_UPDATE_RECENT: {
                    return " order by " + RepositoryColumn.UPDATE_TIME.getColumnName(principleTableName) + " desc ";
                }
                case LAST_UPDATE_OLDEST: {
                    return " order by " + RepositoryColumn.UPDATE_TIME.getColumnName(principleTableName) + " asc ";
                }
                case GUID: {
                    return " order by " + RepositoryColumn.INSTANCE_GUID.getColumnName(principleTableName) + " asc ";
                }
                case PROPERTY_DESCENDING: {
                    return " order by " + RepositoryColumn.CREATE_TIME.getColumnName(principleTableName) + " desc ";
                }
                case PROPERTY_ASCENDING: {
                    return " order by " + RepositoryColumn.CREATE_TIME.getColumnName(principleTableName) + " asc ";
                }
            }
        }
        return " ";
    }

    private String mapPropertyNameToColumn(String propertyName, String defaultColumnName) {
        if (OpenMetadataProperty.GUID.name.equals(propertyName)) {
            return RepositoryColumn.INSTANCE_GUID.getColumnName();
        }
        if (OpenMetadataProperty.METADATA_COLLECTION_ID.name.equals(propertyName)) {
            return RepositoryColumn.METADATA_COLLECTION_GUID.getColumnName();
        }
        if (OpenMetadataProperty.METADATA_COLLECTION_NAME.name.equals(propertyName)) {
            return RepositoryColumn.METADATA_COLLECTION_NAME.getColumnName();
        }
        if (OpenMetadataProperty.INSTANCE_PROVENANCE_TYPE.name.equals(propertyName)) {
            return RepositoryColumn.INSTANCE_PROVENANCE_TYPE.getColumnName();
        }
        if (OpenMetadataProperty.CREATED_BY.name.equals(propertyName)) {
            return RepositoryColumn.CREATED_BY.getColumnName();
        }
        if (OpenMetadataProperty.UPDATED_BY.name.equals(propertyName)) {
            return RepositoryColumn.UPDATED_BY.getColumnName();
        }
        if (OpenMetadataProperty.CURRENT_STATUS.name.equals(propertyName)) {
            return RepositoryColumn.CURRENT_STATUS.getColumnName();
        }
        if (OpenMetadataProperty.OPEN_METADATA_TYPE_NAME.name.equals(propertyName)) {
            return RepositoryColumn.TYPE_NAME.getColumnName();
        }
        if (OpenMetadataProperty.VERSION.name.equals(propertyName)) {
            return RepositoryColumn.VERSION.getColumnName();
        }
        if (OpenMetadataProperty.EFFECTIVE_FROM_TIME.name.equals(propertyName)) {
            return RepositoryColumn.EFFECTIVE_FROM_TIME.getColumnName();
        }
        if (OpenMetadataProperty.EFFECTIVE_TO_TIME.name.equals(propertyName)) {
            return RepositoryColumn.EFFECTIVE_TO_TIME.getColumnName();
        }
        if (defaultColumnName != null) {
            return defaultColumnName;
        }
        return RepositoryColumn.ATTRIBUTE_NAME.getColumnName();
    }

    public void setPaging(int fromElement, int pageSize) {
        this.fromElement = fromElement;
        this.pageSize = pageSize;
    }

    private String getPaging(String principleTableName) {
        if (this.pageSize == 0) {
            return " ";
        }
        String sqlClause = "";
        if (this.sequencingOrder == null) {
            this.sequencingOrder = SequencingOrder.CREATION_DATE_RECENT;
            sqlClause = this.getSequencingOrder(principleTableName);
        }
        return sqlClause + " limit " + this.pageSize + " offset " + this.fromElement;
    }

    public void setGUIDList(List<String> guidList) {
        this.guidList = guidList;
    }

    private String getGUIDListClause() {
        if (this.guidList != null && !this.guidList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(" and (");
            boolean firstGUID = true;
            for (String guid : this.guidList) {
                if (firstGUID) {
                    firstGUID = false;
                } else {
                    stringBuilder.append(" or ");
                }
                stringBuilder.append(RepositoryColumn.INSTANCE_GUID.getColumnName());
                stringBuilder.append(" = '");
                stringBuilder.append(guid);
                stringBuilder.append("' ");
            }
            stringBuilder.append(") ");
            return stringBuilder.toString();
        }
        return " ";
    }

    public String getPrimaryKeysClause(String instanceGUID, long version, String classificationName) {
        if (instanceGUID != null && version != 0L) {
            String sqlFragment = "(" + RepositoryColumn.INSTANCE_GUID.getColumnName() + " = '" + instanceGUID + "' and " + RepositoryColumn.VERSION.getColumnName() + " = " + version;
            if (classificationName != null) {
                sqlFragment = sqlFragment + " and " + RepositoryColumn.CLASSIFICATION_NAME.getColumnName() + " = '" + classificationName + "' ";
            }
            return sqlFragment + ")";
        }
        return " ";
    }

    public String getPropertyJoinQuery(String principleTableName, String propertiesTableName, String columnSelection) {
        return "select " + columnSelection + " from " + principleTableName + " left outer join " + propertiesTableName + " on " + RepositoryColumn.INSTANCE_GUID.getColumnName(principleTableName) + " = " + RepositoryColumn.INSTANCE_GUID.getColumnName(propertiesTableName) + " and " + RepositoryColumn.VERSION.getColumnName(principleTableName) + " = " + RepositoryColumn.VERSION.getColumnName(propertiesTableName);
    }

    public String getDistinctPropertyJoinQuery(RepositoryTable principleTable, String propertiesTableName) {
        StringBuilder clause = new StringBuilder("select distinct ");
        boolean firstColumn = true;
        for (String columnName : principleTable.getQualifiedColumnNames()) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                clause.append(", ");
            }
            clause.append(columnName);
        }
        clause.append(" from ");
        clause.append(principleTable.getTableName());
        clause.append(" left outer join ");
        clause.append(propertiesTableName);
        clause.append(" on ");
        clause.append(RepositoryColumn.INSTANCE_GUID.getColumnName(principleTable.getTableName()));
        clause.append(" = ");
        clause.append(RepositoryColumn.INSTANCE_GUID.getColumnName(propertiesTableName));
        clause.append(" and ");
        clause.append(RepositoryColumn.VERSION.getColumnName(principleTable.getTableName()));
        clause.append(" = ");
        clause.append(RepositoryColumn.VERSION.getColumnName(propertiesTableName));
        if (log.isDebugEnabled()) {
            log.debug(this.toString());
            log.debug(clause.toString());
        }
        return clause.toString();
    }

    public String getAsOfTimeWhereClause() throws RepositoryErrorException {
        String whereClause = this.getAsOfTimeClause() + this.getRelationshipEndGUIDClause() + this.getGUIDListClause() + this.getSearchStringClause() + this.getSearchPropertiesClause() + this.getSearchClassificationsClause() + this.getTypeClause() + this.getLimitResultsByClassificationClaus() + this.getLimitResultsByStatusClause();
        if (log.isDebugEnabled()) {
            log.debug(this.toString());
            log.debug(whereClause);
        }
        return whereClause;
    }

    public String getSequenceAndPaging(String principleTableName) {
        String clause = this.getSequencingOrder(principleTableName) + this.getPaging(principleTableName);
        if (log.isDebugEnabled()) {
            log.debug(this.toString());
            log.debug(clause);
        }
        return clause + ";";
    }

    public String toString() {
        return "QueryBuilder{relationshipEndGUID='" + this.relationshipEndGUID + "', searchString='" + this.searchString + "', searchProperties=" + String.valueOf(this.searchProperties) + ", matchClassifications=" + String.valueOf(this.matchClassifications) + ", limitResultsByClassification=" + String.valueOf(this.limitResultsByClassification) + ", typeGUID='" + this.typeGUID + "', typeGUIDParameterName='" + this.typeGUIDParameterName + "', subtypeGUIDs=" + String.valueOf(this.subtypeGUIDs) + ", subTypeGUIDsParameterName='" + this.subTypeGUIDsParameterName + "', limitResultsByStatus=" + String.valueOf(this.limitResultsByStatus) + ", asOfTime=" + String.valueOf(this.asOfTime) + ", sequencingProperty='" + this.sequencingProperty + "', sequencingOrder=" + String.valueOf(this.sequencingOrder) + ", fromElement=" + this.fromElement + ", pageSize=" + this.pageSize + "}";
    }
}

