/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum PostgresAuditCode implements AuditLogMessageSet
{
    UNEXPECTED_EXCEPTION("POSTGRES-REPOSITORY-CONNECTOR-0001", AuditLogRecordSeverityLevel.EXCEPTION, "The PostgreSQL repository connector {0} received an unexpected {1} exception during method {2}; the error message was: {3}", "The connector is unable to process the current request.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved."),
    STARTING_REPOSITORY("POSTGRES-REPOSITORY-CONNECTOR-0002", AuditLogRecordSeverityLevel.STARTUP, "The PostgreSQL repository connector {0} is connecting to database {1}", "The connector is testing its connection to the database.", "Check for errors following this message."),
    CONFIRMING_REPOSITORY_SCHEMA("POSTGRES-REPOSITORY-CONNECTOR-0003", AuditLogRecordSeverityLevel.STARTUP, "The PostgreSQL repository connector {0} is validating the schema definitions for schema {1}", "The connector is testing the table and column definitions for the database schema.  If they are missing, they are created automatically.", "Check for errors in configuring the schema."),
    INVALID_REPOSITORY_CONTROL_TABLE("POSTGRES-REPOSITORY-CONNECTOR-0004", AuditLogRecordSeverityLevel.ERROR, "The PostgreSQL repository connector {0} has opened database schema {1} which is the repository for server {2} (metadata collection id {3})", "The connector has been configured to use the wrong repository.", "Update the configuration for this server to connect it either to an empty database schema, or the database schema it was using last time."),
    CONFIRMING_CONTROL_TABLE("POSTGRES-REPOSITORY-CONNECTOR-0005", AuditLogRecordSeverityLevel.STARTUP, "The PostgreSQL repository connector {0} has opened database schema {1} for server {2} (metadata collection id {3})", "The connector has validated that it is connected to the correct database schema.", "No action is required."),
    NEW_CONTROL_TABLE("POSTGRES-REPOSITORY-CONNECTOR-0006", AuditLogRecordSeverityLevel.STARTUP, "The PostgreSQL repository connector {0} has initialized database schema {1} for server {2} (metadata collection id {3})", "The connector has created the repository control table for a new repository.", "No action is required, the new repository has been successfully initialized."),
    DEFAULT_AS_OF_TIME("POSTGRES-REPOSITORY-CONNECTOR-0007", AuditLogRecordSeverityLevel.STARTUP, "The PostgreSQL repository connector {0} has is using a default 'asOfTime' for queries of: {1}", "All queries that do not explicitly specify an asOfTime will use this value.  A value of null means it will use the current time.  This value is changed using the 'defaultAsOfTime' configuration property.", "Check that this is the intended value.  Typically it is only changed from its default value of null for audits that are focused on a particular moment in time."),
    REPOSITORY_MODE("POSTGRES-REPOSITORY-CONNECTOR-0008", AuditLogRecordSeverityLevel.STARTUP, "The PostgreSQL repository connector {0} is using a repository mode of: {1}", "The repository mode is used to switch the repository into a read-only mode.  The default mode is read-write.  This value is changed using the 'repositoryMode' configuration property.  If it is set to 'readOnly' then repositoryMode=read-only; if it is set to anything else (or not set) then repositoryMode=read-write.", "Check that this is the intended value.  Typically it is only changed from its default value of read-write for situations where you do not want any changes to be made to the metadata in the repository.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private PostgresAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "AuditCode{logMessageId='" + this.logMessageId + "', severity=" + String.valueOf(this.severity) + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

