/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.properties.JDBCDataValue;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.ffdc.PostgresErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers.ClassificationMapper;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.mappers.RepositoryMapper;
import org.odpi.openmetadata.adapters.repositoryservices.postgres.repositoryconnector.schema.RepositoryColumn;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public class EntityMapper
extends RepositoryMapper {
    private EntityDetail entityDetail = null;
    private EntityProxy entityProxy = null;
    private Map<String, JDBCDataValue> entityTableRow = null;
    private List<Map<String, JDBCDataValue>> entityPropertiesTableRows = null;
    private List<ClassificationMapper> classificationMappers = null;

    public EntityMapper(EntityDetail entityDetail, OMRSRepositoryHelper repositoryHelper, String repositoryName) {
        super(repositoryHelper, repositoryName);
        this.entityDetail = entityDetail;
    }

    public EntityMapper(EntityProxy entityProxy, OMRSRepositoryHelper repositoryHelper, String repositoryName) {
        super(repositoryHelper, repositoryName);
        this.entityProxy = entityProxy;
    }

    public EntityMapper(Map<String, JDBCDataValue> entityTableRow, List<Map<String, JDBCDataValue>> entityPropertiesTableRows, List<ClassificationMapper> classificationMappers, OMRSRepositoryHelper repositoryHelper, String repositoryName) {
        super(repositoryHelper, repositoryName);
        this.entityTableRow = entityTableRow;
        this.entityPropertiesTableRows = entityPropertiesTableRows;
        this.classificationMappers = classificationMappers;
    }

    public boolean isProxy() throws RepositoryErrorException {
        String methodName = "isProxy";
        if (this.entityDetail == null && this.entityProxy != null) {
            return true;
        }
        if (this.entityTableRow != null) {
            return super.getBooleanPropertyFromColumn(RepositoryColumn.IS_PROXY.getColumnName(), this.entityTableRow, true);
        }
        throw new RepositoryErrorException(PostgresErrorCode.MISSING_MAPPING_VALUE.getMessageDefinition("entityTableRow", "isProxy", ((Object)((Object)this)).getClass().getName()), ((Object)((Object)this)).getClass().getName(), "isProxy");
    }

    public EntityDetail getEntityDetail() throws RepositoryErrorException {
        String methodName = "getEntityDetail";
        if (this.entityDetail == null) {
            if (this.entityTableRow != null) {
                EntityDetail entity = new EntityDetail();
                super.fillInstanceHeader((InstanceHeader)entity, this.entityTableRow);
                entity.setProperties(super.getInstanceProperties(this.entityTableRow, this.entityPropertiesTableRows));
                entity.setClassifications(this.getClassifications());
                this.entityDetail = entity;
            } else {
                throw new RepositoryErrorException(PostgresErrorCode.MISSING_MAPPING_VALUE.getMessageDefinition("entityTableRow", "getEntityDetail", ((Object)((Object)this)).getClass().getName()), ((Object)((Object)this)).getClass().getName(), "getEntityDetail");
            }
        }
        return this.entityDetail;
    }

    public EntityProxy getEntityProxy() throws RepositoryErrorException {
        String methodName = "getEntityProxy";
        if (this.entityProxy == null) {
            if (this.entityTableRow != null) {
                EntityProxy entity = new EntityProxy();
                super.fillInstanceHeader((InstanceHeader)entity, this.entityTableRow);
                entity.setUniqueProperties(super.getUniqueProperties(this.entityTableRow, this.entityPropertiesTableRows));
                entity.setClassifications(this.getClassifications());
                this.entityProxy = entity;
            } else {
                throw new RepositoryErrorException(PostgresErrorCode.MISSING_MAPPING_VALUE.getMessageDefinition("entityTableRow", "getEntityProxy", ((Object)((Object)this)).getClass().getName()), ((Object)((Object)this)).getClass().getName(), "getEntityProxy");
            }
        }
        return this.entityProxy;
    }

    private List<Classification> getClassifications() throws RepositoryErrorException {
        if (this.classificationMappers != null) {
            ArrayList<Classification> classifications = new ArrayList<Classification>();
            for (ClassificationMapper classificationMapper : this.classificationMappers) {
                if (classificationMapper == null) continue;
                classifications.add(classificationMapper.getClassification());
            }
            if (!classifications.isEmpty()) {
                return classifications;
            }
        }
        return null;
    }

    public Map<String, JDBCDataValue> getEntityTableRow() throws RepositoryErrorException {
        if (this.entityTableRow == null) {
            HashMap<String, JDBCDataValue> newEntityTableRow = new HashMap<String, JDBCDataValue>();
            if (this.entityDetail != null) {
                if (this.entityDetail.getProperties() != null) {
                    super.extractValuesFromInstanceHeader(newEntityTableRow, null, this.entityDetail.getProperties().getEffectiveFromTime(), this.entityDetail.getProperties().getEffectiveToTime(), null, (InstanceHeader)this.entityDetail);
                } else {
                    super.extractValuesFromInstanceHeader(newEntityTableRow, null, null, null, null, (InstanceHeader)this.entityDetail);
                }
                super.setUpBooleanValueInRow(newEntityTableRow, false, RepositoryColumn.IS_PROXY.getColumnName());
            } else if (this.entityProxy != null) {
                if (this.entityProxy.getUniqueProperties() != null) {
                    super.extractValuesFromInstanceHeader(newEntityTableRow, null, this.entityProxy.getUniqueProperties().getEffectiveFromTime(), this.entityProxy.getUniqueProperties().getEffectiveToTime(), null, (InstanceHeader)this.entityProxy);
                } else {
                    super.extractValuesFromInstanceHeader(newEntityTableRow, null, null, null, null, (InstanceHeader)this.entityProxy);
                }
                super.setUpBooleanValueInRow(newEntityTableRow, true, RepositoryColumn.IS_PROXY.getColumnName());
            }
            if (!newEntityTableRow.isEmpty()) {
                this.entityTableRow = newEntityTableRow;
            }
        }
        return this.entityTableRow;
    }

    public List<Map<String, JDBCDataValue>> getEntityPropertiesTableRows() throws RepositoryErrorException {
        String methodName = "getEntityPropertiesTableRows";
        if (this.entityPropertiesTableRows == null) {
            if (this.entityDetail != null) {
                this.entityPropertiesTableRows = this.extractValuesFromInstanceProperties(this.entityDetail.getGUID(), null, this.entityDetail.getVersion(), this.entityDetail.getType().getTypeDefName(), this.entityDetail.getProperties(), null, null);
            } else {
                throw new RepositoryErrorException(PostgresErrorCode.MISSING_MAPPING_VALUE.getMessageDefinition("entityDetail", "getEntityPropertiesTableRows", ((Object)((Object)this)).getClass().getName()), ((Object)((Object)this)).getClass().getName(), "getEntityPropertiesTableRows");
            }
        }
        return this.entityPropertiesTableRows;
    }

    public List<Map<String, JDBCDataValue>> getUniquePropertiesTableRows() throws RepositoryErrorException {
        List<Map<String, JDBCDataValue>> uniquePropertiesTableRows;
        String methodName = "getUniquePropertiesTableRows";
        if (this.entityDetail != null) {
            this.entityPropertiesTableRows = this.extractValuesFromInstanceProperties(this.entityDetail.getGUID(), null, this.entityDetail.getVersion(), this.entityDetail.getType().getTypeDefName(), this.entityDetail.getProperties(), null, null);
            uniquePropertiesTableRows = this.entityPropertiesTableRows;
        } else if (this.entityProxy != null) {
            this.entityPropertiesTableRows = this.extractValuesFromInstanceProperties(this.entityProxy.getGUID(), null, this.entityProxy.getVersion(), this.entityProxy.getType().getTypeDefName(), this.entityProxy.getUniqueProperties(), null, null);
            uniquePropertiesTableRows = this.entityPropertiesTableRows;
        } else {
            throw new RepositoryErrorException(PostgresErrorCode.MISSING_MAPPING_VALUE.getMessageDefinition("entityProxy", "getUniquePropertiesTableRows", ((Object)((Object)this)).getClass().getName()), ((Object)((Object)this)).getClass().getName(), "getUniquePropertiesTableRows");
        }
        if (uniquePropertiesTableRows != null && !uniquePropertiesTableRows.isEmpty()) {
            return uniquePropertiesTableRows;
        }
        return null;
    }

    public List<ClassificationMapper> getClassificationMappers() {
        if (this.classificationMappers == null) {
            List classificationList = null;
            String entityGUID = null;
            if (this.entityDetail != null) {
                classificationList = this.entityDetail.getClassifications();
                entityGUID = this.entityDetail.getGUID();
            } else if (this.entityProxy != null) {
                classificationList = this.entityProxy.getClassifications();
                entityGUID = this.entityProxy.getGUID();
            }
            if (classificationList != null) {
                ArrayList<ClassificationMapper> classificationMapperList = new ArrayList<ClassificationMapper>();
                for (Classification classification : classificationList) {
                    classificationMapperList.add(new ClassificationMapper(entityGUID, classification, this.repositoryHelper, this.repositoryName));
                }
                if (!classificationMapperList.isEmpty()) {
                    this.classificationMappers = classificationMapperList;
                }
            }
        }
        return this.classificationMappers;
    }

    public String toString() {
        return "EntityMapper{entityDetail=" + String.valueOf(this.entityDetail) + ", entityProxy=" + String.valueOf(this.entityProxy) + ", entityTableRow=" + String.valueOf(this.entityTableRow) + ", entityPropertiesTableRows=" + String.valueOf(this.entityPropertiesTableRows) + ", classificationMappers=" + String.valueOf(this.classificationMappers) + "}";
    }
}

