/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.postgres.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresConfigurationProperty;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.postgres.ffdc.PostgresAuditCode;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnector;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.integration.connectors.CatalogTargetIntegrator;
import org.odpi.openmetadata.frameworks.integration.context.OpenMetadataAccess;
import org.odpi.openmetadata.frameworks.integration.properties.RequestedCatalogTarget;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OperationalStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ServerAssetUseType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.infrastructure.connector.InfrastructureIntegratorConnector;

public class PostgresServerIntegrationConnector
extends InfrastructureIntegratorConnector
implements CatalogTargetIntegrator {
    final PropertyHelper propertyHelper = new PropertyHelper();
    List<String> defaultExcludeDatabases = null;
    List<String> defaultIncludeDatabases = null;

    public void start() throws ConnectorCheckedException {
        super.start();
        this.defaultExcludeDatabases = super.getArrayConfigurationProperty(PostgresConfigurationProperty.EXCLUDE_DATABASE_LIST.getName(), this.connectionProperties.getConfigurationProperties(), null);
        this.defaultIncludeDatabases = super.getArrayConfigurationProperty(PostgresConfigurationProperty.INCLUDE_DATABASE_LIST.getName(), this.connectionProperties.getConfigurationProperties(), null);
    }

    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        if (this.embeddedConnectors != null && !this.embeddedConnectors.isEmpty()) {
            for (Connector embeddedConnector : this.embeddedConnectors) {
                if (!(embeddedConnector instanceof JDBCResourceConnector)) continue;
                JDBCResourceConnector jdbcResourceConnector = (JDBCResourceConnector)embeddedConnector;
                try {
                    if (!jdbcResourceConnector.isActive()) {
                        jdbcResourceConnector.start();
                    }
                    this.catalogDatabases(null, null, this.connectionProperties.getConfigurationProperties(), jdbcResourceConnector);
                }
                catch (ConnectorCheckedException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    this.auditLog.logException("refresh", PostgresAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, exception.getClass().getName(), "refresh", exception.getMessage()), (Throwable)exception);
                }
            }
        }
        this.refreshCatalogTargets(this);
    }

    public void integrateCatalogTarget(RequestedCatalogTarget requestedCatalogTarget) throws ConnectorCheckedException {
        String methodName = "integrateCatalogTarget";
        if (PostgresDeployedImplementationType.POSTGRESQL_SERVER.getAssociatedTypeName().equals(requestedCatalogTarget.getCatalogTargetElement().getType().getTypeName())) {
            String databaseServerGUID = requestedCatalogTarget.getCatalogTargetElement().getGUID();
            String databaseManagerGUID = this.getDatabaseManagerGUID(databaseServerGUID, requestedCatalogTarget.getCatalogTargetElement().getUniqueName());
            try {
                Connector connector = this.getContext().getConnectedAssetContext().getConnectorToAsset(databaseServerGUID, this.auditLog);
                JDBCResourceConnector assetConnector = (JDBCResourceConnector)connector;
                assetConnector.start();
                this.catalogDatabases(databaseServerGUID, databaseManagerGUID, requestedCatalogTarget.getConfigurationProperties(), assetConnector);
                assetConnector.disconnect();
            }
            catch (Exception exception) {
                this.auditLog.logException("integrateCatalogTarget", PostgresAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, exception.getClass().getName(), "integrateCatalogTarget", exception.getMessage()), (Throwable)exception);
            }
        } else {
            super.throwWrongTypeOfAsset(requestedCatalogTarget.getCatalogTargetElement().getGUID(), requestedCatalogTarget.getCatalogTargetElement().getType().getTypeName(), PostgresDeployedImplementationType.POSTGRESQL_SERVER.getAssociatedTypeName(), this.connectorName, "integrateCatalogTarget");
        }
    }

    private String getDatabaseManagerGUID(String databaseServerGUID, String databaseServerQualifiedName) throws ConnectorCheckedException {
        String methodName = "getDatabaseManagerGUID";
        String databaseManagerGUID = null;
        try {
            OpenMetadataAccess openMetadataAccess = this.getContext().getIntegrationGovernanceContext().getOpenMetadataAccess();
            int startFrom = 0;
            List relatedCapabilities = openMetadataAccess.getRelatedMetadataElements(databaseServerGUID, 1, OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.typeName, startFrom, this.getContext().getMaxPageSize());
            while (relatedCapabilities != null) {
                for (RelatedMetadataElement relatedCapability : relatedCapabilities) {
                    if (!OpenMetadataType.DATABASE_MANAGER.typeName.equals(relatedCapability.getElement().getType().getTypeName())) continue;
                    databaseManagerGUID = relatedCapability.getElement().getElementGUID();
                    break;
                }
                relatedCapabilities = openMetadataAccess.getRelatedMetadataElements(databaseServerGUID, 1, OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.typeName, startFrom += this.getContext().getMaxPageSize(), this.getContext().getMaxPageSize());
            }
            if (databaseManagerGUID == null) {
                databaseManagerGUID = openMetadataAccess.createMetadataElementInStore(OpenMetadataType.DATABASE_MANAGER.typeName, ElementStatus.ACTIVE, null, databaseServerGUID, false, null, null, this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, databaseServerQualifiedName + ":DBMS"), databaseServerGUID, OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.typeName, this.propertyHelper.addEnumProperty(null, OpenMetadataProperty.OPERATIONAL_STATUS.name, OperationalStatus.getOpenTypeName(), OperationalStatus.ENABLED.getName()), true);
            }
        }
        catch (ConnectorCheckedException exception) {
            throw exception;
        }
        catch (Exception exception) {
            this.auditLog.logException("getDatabaseManagerGUID", PostgresAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, exception.getClass().getName(), "getDatabaseManagerGUID", exception.getMessage()), (Throwable)exception);
        }
        return databaseManagerGUID;
    }

    private void catalogDatabases(String databaseServerGUID, String databaseManagerGUID, Map<String, Object> configurationProperties, JDBCResourceConnector assetConnector) throws ConnectorCheckedException {
        String methodName = "catalogDatabases";
        List excludedDatabases = super.getArrayConfigurationProperty(PostgresConfigurationProperty.EXCLUDE_DATABASE_LIST.getName(), configurationProperties, this.defaultExcludeDatabases);
        List includedDatabases = super.getArrayConfigurationProperty(PostgresConfigurationProperty.INCLUDE_DATABASE_LIST.getName(), configurationProperties, this.defaultIncludeDatabases);
        String catalogTemplateName = super.getStringConfigurationProperty(PostgresConfigurationProperty.DATABASE_CATALOG_TEMPLATE_QUALIFIED_NAME.getName(), configurationProperties);
        try {
            DataSource jdbcDataSource = assetConnector.getDataSource();
            Connection jdbcConnection = jdbcDataSource.getConnection();
            String sqlCommand1 = "SELECT datname, datistemplate, datallowconn from pg_database;";
            PreparedStatement preparedStatement = jdbcConnection.prepareStatement("SELECT datname, datistemplate, datallowconn from pg_database;");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                if (resultSet.getBoolean("datistemplate") || !resultSet.getBoolean("datallowconn")) continue;
                String databaseName = resultSet.getString("datname");
                if (!this.getContext().elementShouldBeCatalogued(databaseName, excludedDatabases, includedDatabases)) continue;
                this.catalogDatabase(databaseName, databaseServerGUID, databaseManagerGUID, catalogTemplateName, configurationProperties);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (ConnectorCheckedException exception) {
            throw exception;
        }
        catch (Exception exception) {
            this.auditLog.logException("catalogDatabases", PostgresAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, exception.getClass().getName(), "catalogDatabases", exception.getMessage()), (Throwable)exception);
        }
    }

    private void catalogDatabase(String databaseName, String databaseServerGUID, String databaseManagerGUID, String catalogTemplateName, Map<String, Object> configurationProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectorCheckedException {
        String methodName = "catalogDatabase";
        OpenMetadataAccess openMetadataAccess = this.getContext().getIntegrationGovernanceContext().getOpenMetadataAccess();
        ElementProperties serverAssetUseProperties = this.propertyHelper.addEnumProperty(null, OpenMetadataProperty.USE_TYPE.name, ServerAssetUseType.getOpenTypeName(), ServerAssetUseType.OWNS.getName());
        if (catalogTemplateName != null) {
            HashMap<String, String> placeholderProperties = super.getSuppliedPlaceholderProperties(configurationProperties);
            if (placeholderProperties == null) {
                placeholderProperties = new HashMap<String, String>();
            }
            placeholderProperties.put(PostgresConfigurationProperty.DATABASE_NAME.getName(), databaseName);
            OpenMetadataElement templateElement = openMetadataAccess.getMetadataElementByUniqueName(catalogTemplateName, OpenMetadataProperty.QUALIFIED_NAME.name);
            String qualifiedName = this.propertyHelper.getResolvedStringPropertyFromTemplate(this.connectorName, templateElement, OpenMetadataProperty.QUALIFIED_NAME.name, placeholderProperties);
            OpenMetadataElement databaseElement = openMetadataAccess.getMetadataElementByUniqueName(qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name);
            if (databaseElement != null) {
                this.auditLog.logMessage("catalogDatabase", PostgresAuditCode.SKIPPING_DATABASE.getMessageDefinition(this.connectorName, databaseElement.getElementGUID(), qualifiedName));
            } else {
                String databaseGUID = openMetadataAccess.createMetadataElementFromTemplate(OpenMetadataType.RELATIONAL_DATABASE.typeName, databaseServerGUID, false, null, null, catalogTemplateName, null, placeholderProperties, databaseManagerGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, serverAssetUseProperties, true);
                this.auditLog.logMessage("catalogDatabase", PostgresAuditCode.CATALOGED_DATABASE.getMessageDefinition(this.connectorName, qualifiedName, databaseGUID));
            }
        } else {
            String hostIdentifier = super.getStringConfigurationProperty(PostgresConfigurationProperty.HOST_IDENTIFIER.getName(), configurationProperties);
            String portNumber = super.getStringConfigurationProperty(PostgresConfigurationProperty.PORT_NUMBER.getName(), configurationProperties);
            String serverName = super.getStringConfigurationProperty(PostgresConfigurationProperty.SERVER_NAME.getName(), configurationProperties);
            String databaseUserId = super.getStringConfigurationProperty(PostgresConfigurationProperty.DATABASE_USER_ID.getName(), configurationProperties);
            String databasePassword = super.getStringConfigurationProperty(PostgresConfigurationProperty.DATABASE_PASSWORD.getName(), configurationProperties);
            String qualifiedName = "PostgreSQLDatabase:" + serverName + ":" + databaseName;
            if (openMetadataAccess.getMetadataElementByUniqueName(qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name) == null) {
                ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName);
                elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NAME.name, databaseName);
                elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getDeployedImplementationType());
                String databaseGUID = openMetadataAccess.createMetadataElementInStore(PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getAssociatedTypeName(), ElementStatus.ACTIVE, null, databaseServerGUID, false, null, null, elementProperties, databaseManagerGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, serverAssetUseProperties, true);
                elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, "PostgreSQLDatabase:" + serverName + ":" + databaseName + ":Connection");
                elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DISPLAY_NAME.name, databaseName + " connection");
                elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.USER_ID.name, databaseUserId);
                elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.CLEAR_PASSWORD.name, databasePassword);
                String connectionGUID = openMetadataAccess.createMetadataElementInStore(OpenMetadataType.CONNECTION.typeName, ElementStatus.ACTIVE, null, databaseGUID, false, null, null, elementProperties, databaseGUID, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeName, null, false);
                JDBCResourceConnectorProvider jdbcResourceConnectorProvider = new JDBCResourceConnectorProvider();
                ConnectorType connectorType = jdbcResourceConnectorProvider.getConnectorType();
                this.getContext().setupConnectorType(connectionGUID, connectorType.getGUID());
                elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, "PostgreSQLDatabase:" + serverName + ":" + databaseName + ":Endpoint");
                elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NAME.name, databaseName + " endpoint");
                elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NETWORK_ADDRESS.name, "jdbc:postgresql://" + hostIdentifier + ":" + portNumber + "/" + databaseName);
                openMetadataAccess.createMetadataElementInStore(OpenMetadataType.ENDPOINT.typeName, ElementStatus.ACTIVE, null, databaseGUID, false, null, null, elementProperties, connectionGUID, OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeName, null, false);
            }
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
    }
}

