/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.postgres.controls;

import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationTypeDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public enum PostgresDeployedImplementationType implements DeployedImplementationTypeDefinition
{
    POSTGRESQL_DATABASE("PostgreSQL Relational Database", (DeployedImplementationTypeDefinition)DeployedImplementationType.JDBC_RELATIONAL_DATABASE, OpenMetadataType.RELATIONAL_DATABASE.typeName, null, "A database hosted on a PostgreSQL server.", "https://www.postgresql.org/"),
    POSTGRESQL_DATABASE_SCHEMA("PostgreSQL Relational Database Schema", (DeployedImplementationTypeDefinition)DeployedImplementationType.JDBC_RELATIONAL_DATABASE_SCHEMA, OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeName, null, "A database schema hosted on a PostgreSQL relational database server capable of being called through a JDBC Driver.", "https://www.postgresql.org/"),
    POSTGRESQL_DATABASE_TABLE("PostgreSQL Relational Database Table", (DeployedImplementationTypeDefinition)DeployedImplementationType.DATA_ASSET, OpenMetadataType.TABLE_DATA_SET.typeName, null, "A database table hosted on a PostgreSQL relational database server capable of being called through a JDBC Driver.", "https://www.postgresql.org/"),
    POSTGRESQL_SERVER("PostgreSQL Server", (DeployedImplementationTypeDefinition)DeployedImplementationType.SOFTWARE_SERVER, OpenMetadataType.SOFTWARE_SERVER.typeName, OpenMetadataType.DATABASE_SERVER_CLASSIFICATION.typeName, "A database server running the PostgreSQL software.", "https://www.postgresql.org/"),
    POSTGRESQL_DATABASE_MANAGER("PostgreSQL database manager (RDBMS)", (DeployedImplementationTypeDefinition)DeployedImplementationType.RELATIONAL_DATABASE_MANAGER, OpenMetadataType.DATABASE_MANAGER.typeName, null, "The PostgreSQL capability that manages collections of data called relational databases which in turn are organized into a tabular format and accessed via the Structured Query Language (SQL).", "https://egeria-project.org/types/0/0050-Applications-and-Processes/");

    private final String deployedImplementationType;
    private final DeployedImplementationTypeDefinition isATypeOf;
    private final String associatedTypeName;
    private final String associatedClassification;
    private final String description;
    private final String wikiLink;

    public static DeployedImplementationTypeDefinition getDefinitionFromDeployedImplementationType(String deployedImplementationType) {
        if (deployedImplementationType != null) {
            for (PostgresDeployedImplementationType definition : PostgresDeployedImplementationType.values()) {
                if (!definition.getDeployedImplementationType().equals(deployedImplementationType)) continue;
                return definition;
            }
        }
        return null;
    }

    private PostgresDeployedImplementationType(String deployedImplementationType, DeployedImplementationTypeDefinition isATypeOf, String associatedTypeName, String associatedClassification, String description, String wikiLink) {
        this.deployedImplementationType = deployedImplementationType;
        this.isATypeOf = isATypeOf;
        this.associatedTypeName = associatedTypeName;
        this.associatedClassification = associatedClassification;
        this.description = description;
        this.wikiLink = wikiLink;
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public DeployedImplementationTypeDefinition getIsATypeOf() {
        return this.isATypeOf;
    }

    public String getAssociatedTypeName() {
        return this.associatedTypeName;
    }

    public String getAssociatedClassification() {
        return this.associatedClassification;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName((String)this.associatedTypeName, (String)OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null, (String)this.deployedImplementationType);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory((String)this.associatedTypeName, (String)OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null);
    }

    public String getDescription() {
        return this.description;
    }

    public String getWikiLink() {
        return this.wikiLink;
    }

    public String toString() {
        return "DeployedImplementationType{" + this.deployedImplementationType + "}";
    }
}

