/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.postgres.survey;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresAnnotationType;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceConnector;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalDatabaseMeasurement;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceMeasureAnnotation;

public class PostgresDatabaseStatsExtractor {
    private final List<String> validDatabases;
    private final Connection jdbcConnection;
    private final SurveyActionServiceConnector surveyActionServiceConnector;

    public PostgresDatabaseStatsExtractor(List<String> validDatabases, Connection jdbcConnection, SurveyActionServiceConnector surveyActionServiceConnector) {
        this.validDatabases = validDatabases;
        this.jdbcConnection = jdbcConnection;
        this.surveyActionServiceConnector = surveyActionServiceConnector;
    }

    List<Annotation> getStatistics() throws SQLException, PropertyServerException {
        HashMap<Object, RelationalDatabaseMeasurement> databaseMeasurements = new HashMap<Object, RelationalDatabaseMeasurement>();
        String pg_stat_user_tablesSQLCommand = "SELECT datname, tup_fetched, tup_inserted, tup_updated, tup_deleted, session_time, active_time, stats_reset FROM pg_catalog.pg_stat_database;";
        PreparedStatement preparedStatement = this.jdbcConnection.prepareStatement(pg_stat_user_tablesSQLCommand);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            String databaseName = resultSet.getString("datname");
            if (!this.validDatabases.contains(databaseName)) continue;
            RelationalDatabaseMeasurement databaseMeasurement = new RelationalDatabaseMeasurement();
            databaseMeasurement.setDatabaseName(databaseName);
            databaseMeasurement.setRowsFetched(resultSet.getLong("tup_fetched"));
            databaseMeasurement.setRowsInserted(resultSet.getLong("tup_inserted"));
            databaseMeasurement.setRowsUpdated(resultSet.getLong("tup_updated"));
            databaseMeasurement.setRowsDeleted(resultSet.getLong("tup_deleted"));
            databaseMeasurement.setSessionTime(resultSet.getDouble("session_time"));
            databaseMeasurement.setActiveTime(resultSet.getDouble("active_time"));
            databaseMeasurement.setStatsReset((Date)resultSet.getDate("stats_reset"));
            databaseMeasurements.put(databaseName, databaseMeasurement);
        }
        resultSet.close();
        preparedStatement.close();
        for (String databaseName : this.validDatabases) {
            RelationalDatabaseMeasurement currentDatabase = (RelationalDatabaseMeasurement)databaseMeasurements.get(databaseName);
            if (currentDatabase == null) continue;
            String sqlCommand2 = "SELECT pg_database_size(" + databaseName + ");";
            preparedStatement = this.jdbcConnection.prepareStatement(sqlCommand2);
            try {
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    currentDatabase.setSize(resultSet.getLong("pg_database_size"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            databaseMeasurements.put(databaseName, currentDatabase);
            resultSet.close();
            preparedStatement.close();
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (String databaseName : databaseMeasurements.keySet()) {
            RelationalDatabaseMeasurement currentDatabase = (RelationalDatabaseMeasurement)databaseMeasurements.get(databaseName);
            if (currentDatabase == null) continue;
            ResourceMeasureAnnotation annotation = new ResourceMeasureAnnotation();
            annotation.setAnnotationType(PostgresAnnotationType.DATABASE_METRICS.getName());
            annotation.setSummary(PostgresAnnotationType.DATABASE_METRICS.getSummary());
            annotation.setExplanation(PostgresAnnotationType.DATABASE_METRICS.getExplanation());
            annotation.setAnalysisStep(PostgresAnnotationType.DATABASE_METRICS.getAnalysisStep());
            annotation.setJsonProperties(this.surveyActionServiceConnector.getJSONProperties((Object)currentDatabase));
        }
        if (!annotations.isEmpty()) {
            return annotations;
        }
        return null;
    }
}

