/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.postgres.controls;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresPlaceholderProperty;
import org.odpi.openmetadata.frameworks.connectors.controls.ConfigurationPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;

public enum PostgresConfigurationProperty {
    HOST_IDENTIFIER(PlaceholderProperty.HOST_IDENTIFIER.getName(), PlaceholderProperty.HOST_IDENTIFIER.getDescription(), PlaceholderProperty.HOST_IDENTIFIER.getDataType(), PlaceholderProperty.HOST_IDENTIFIER.getExample(), true),
    PORT_NUMBER(PlaceholderProperty.PORT_NUMBER.getName(), PlaceholderProperty.PORT_NUMBER.getDescription(), PlaceholderProperty.PORT_NUMBER.getDataType(), PlaceholderProperty.PORT_NUMBER.getExample(), true),
    SERVER_NAME(PlaceholderProperty.SERVER_NAME.getName(), PlaceholderProperty.SERVER_NAME.getDescription(), PlaceholderProperty.SERVER_NAME.getDataType(), PlaceholderProperty.SERVER_NAME.getExample(), true),
    DATABASE_NAME(PostgresPlaceholderProperty.DATABASE_NAME.getName(), PostgresPlaceholderProperty.DATABASE_NAME.getDescription(), PostgresPlaceholderProperty.DATABASE_NAME.getDataType(), PostgresPlaceholderProperty.DATABASE_NAME.getExample(), true),
    DATABASE_USER_ID(PostgresPlaceholderProperty.DATABASE_USER_ID.getName(), PostgresPlaceholderProperty.DATABASE_USER_ID.getDescription(), PostgresPlaceholderProperty.DATABASE_USER_ID.getDataType(), PostgresPlaceholderProperty.DATABASE_USER_ID.getExample(), true),
    DATABASE_PASSWORD(PostgresPlaceholderProperty.DATABASE_PASSWORD.getName(), PostgresPlaceholderProperty.DATABASE_PASSWORD.getDescription(), PostgresPlaceholderProperty.DATABASE_PASSWORD.getDataType(), PostgresPlaceholderProperty.DATABASE_PASSWORD.getExample(), true),
    SCHEMA_NAME(PostgresPlaceholderProperty.SCHEMA_NAME.getName(), PostgresPlaceholderProperty.SCHEMA_NAME.getDescription(), PostgresPlaceholderProperty.SCHEMA_NAME.getDataType(), PostgresPlaceholderProperty.SCHEMA_NAME.getExample(), true),
    TABLE_NAME(PostgresPlaceholderProperty.TABLE_NAME.getName(), PostgresPlaceholderProperty.TABLE_NAME.getDescription(), PostgresPlaceholderProperty.TABLE_NAME.getDataType(), PostgresPlaceholderProperty.TABLE_NAME.getExample(), true),
    DATABASE_CATALOG_TEMPLATE_QUALIFIED_NAME("databaseCatalogTemplate", "A configuration property that describes the qualified name of the catalog template to use for each database. The connector will pass the supplied configuration properties to the template as placeholder property values. If this property is not specified/null then a standard asset, server capability and connection is set up for the database.", "string", "SoftwareServer:PostgreSQLDatabaseServer:Template", false),
    EXCLUDE_DATABASE_LIST("excludeDatabaseList", "Provides a list of database names that should not be catalogued.", "array<string>", "dbBoring,dbNotUsed", false),
    INCLUDE_DATABASE_LIST("includeDatabaseList", "Provides a list of databases that should be catalogued.  If not set, or null, or *, all databases except the excluded databases are catalogued.", "array<string>", "*", false);

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;
    public final boolean isPlaceholder;

    private PostgresConfigurationProperty(String name, String description, String dataType, String example, boolean isPlaceholder) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
        this.isPlaceholder = isPlaceholder;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public boolean isPlaceholder() {
        return this.isPlaceholder;
    }

    public static List<String> getPostgresServerIntegrationConnectorNames() {
        ArrayList<String> recognizedConfigurationProperties = new ArrayList<String>();
        recognizedConfigurationProperties.add(DATABASE_CATALOG_TEMPLATE_QUALIFIED_NAME.getName());
        recognizedConfigurationProperties.add(EXCLUDE_DATABASE_LIST.getName());
        recognizedConfigurationProperties.add(INCLUDE_DATABASE_LIST.getName());
        recognizedConfigurationProperties.add(HOST_IDENTIFIER.getName());
        recognizedConfigurationProperties.add(PORT_NUMBER.getName());
        recognizedConfigurationProperties.add(SERVER_NAME.getName());
        recognizedConfigurationProperties.add(DATABASE_USER_ID.getName());
        recognizedConfigurationProperties.add(DATABASE_PASSWORD.getName());
        return recognizedConfigurationProperties;
    }

    public static List<ConfigurationPropertyType> getPostgresServerConfigurationPropertyTypes() {
        ArrayList<ConfigurationPropertyType> configurationPropertyTypes = new ArrayList<ConfigurationPropertyType>();
        configurationPropertyTypes.add(DATABASE_CATALOG_TEMPLATE_QUALIFIED_NAME.getConfigurationPropertyType());
        configurationPropertyTypes.add(EXCLUDE_DATABASE_LIST.getConfigurationPropertyType());
        configurationPropertyTypes.add(INCLUDE_DATABASE_LIST.getConfigurationPropertyType());
        configurationPropertyTypes.add(HOST_IDENTIFIER.getConfigurationPropertyType());
        configurationPropertyTypes.add(PORT_NUMBER.getConfigurationPropertyType());
        configurationPropertyTypes.add(SERVER_NAME.getConfigurationPropertyType());
        configurationPropertyTypes.add(DATABASE_USER_ID.getConfigurationPropertyType());
        configurationPropertyTypes.add(DATABASE_PASSWORD.getConfigurationPropertyType());
        return configurationPropertyTypes;
    }

    public static List<ConfigurationPropertyType> getConfigurationPropertyTypes() {
        ArrayList<ConfigurationPropertyType> configurationPropertyTypes = new ArrayList<ConfigurationPropertyType>();
        for (PostgresConfigurationProperty configurationProperty : PostgresConfigurationProperty.values()) {
            configurationPropertyTypes.add(configurationProperty.getConfigurationPropertyType());
        }
        return configurationPropertyTypes;
    }

    public ConfigurationPropertyType getConfigurationPropertyType() {
        ConfigurationPropertyType configurationPropertyType = new ConfigurationPropertyType();
        configurationPropertyType.setName(this.name);
        configurationPropertyType.setDescription(this.description);
        configurationPropertyType.setDataType(this.dataType);
        configurationPropertyType.setExample(this.example);
        configurationPropertyType.setRequired(this.isPlaceholder);
        return configurationPropertyType;
    }

    public String toString() {
        return "ConfigurationProperty{ name=" + this.name + "}";
    }
}

