/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.postgres.controls;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderPropertyType;

public enum PostgresPlaceholderProperty {
    DATABASE_NAME("databaseName", "The name of the database being catalogued.", "string", "myDatabase"),
    DATABASE_DESCRIPTION("databaseDescription", "The description of the database being catalogued.", "string", null),
    DATABASE_USER_ID("databaseUserId", "The userId to store in the userId attribute of the connection. This is a user that is defined to the database and it is used when connecting to the database.", "string", "myDatabase"),
    DATABASE_PASSWORD("databasePassword", "The password to store in the clearPassword attribute of the connection.  This is the password for the databaseUserId and it is used when connecting to the database.", "string", "myDatabase"),
    SCHEMA_NAME("schemaName", "The name of the database schema being catalogued.", "string", "MyServer.schema"),
    SCHEMA_DESCRIPTION("schemaDescription", "The description of the database schema being catalogued.", "string", null),
    TABLE_NAME("tableName", "The name of the database table being catalogued.", "string", "myTable");

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;

    private PostgresPlaceholderProperty(String name, String description, String dataType, String example) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getPlaceholder() {
        return "{{" + this.name + "}}";
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public static List<PlaceholderPropertyType> getPostgresServerPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(PlaceholderProperty.HOST_IDENTIFIER.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.PORT_NUMBER.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.SERVER_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.DESCRIPTION.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.SECRETS_STORE.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getJDBCEndpointPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(PlaceholderProperty.HOST_IDENTIFIER.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.PORT_NUMBER.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.SERVER_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.DESCRIPTION.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getPostgresDatabasePlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(PlaceholderProperty.HOST_IDENTIFIER.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.PORT_NUMBER.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.SERVER_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(DATABASE_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(DATABASE_DESCRIPTION.getPlaceholderType());
        placeholderPropertyTypes.add(DATABASE_USER_ID.getPlaceholderType());
        placeholderPropertyTypes.add(DATABASE_PASSWORD.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public static List<PlaceholderPropertyType> getPostgresSchemaPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        placeholderPropertyTypes.add(PlaceholderProperty.HOST_IDENTIFIER.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.PORT_NUMBER.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.SERVER_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(DATABASE_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(SCHEMA_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(SCHEMA_DESCRIPTION.getPlaceholderType());
        placeholderPropertyTypes.add(DATABASE_USER_ID.getPlaceholderType());
        placeholderPropertyTypes.add(DATABASE_PASSWORD.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public PlaceholderPropertyType getPlaceholderType() {
        PlaceholderPropertyType placeholderPropertyType = new PlaceholderPropertyType();
        placeholderPropertyType.setName(this.name);
        placeholderPropertyType.setDescription(this.description);
        placeholderPropertyType.setDataType(this.dataType);
        placeholderPropertyType.setExample(this.example);
        placeholderPropertyType.setRequired(true);
        return placeholderPropertyType;
    }

    public String toString() {
        return "PlaceholderProperty{ name=" + this.name + "}";
    }
}

