/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.postgres.survey;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.odpi.openmetadata.adapters.connectors.postgres.survey.PostgresDatabaseStatsExtractor;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceConnector;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;

public class PostgresDatabaseSurveyActionService
extends SurveyActionServiceConnector {
    private Map<String, SchemaDetails> schemaDetailsMap = new HashMap<String, SchemaDetails>();

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            AnnotationStore annotationStore = this.surveyContext.getAnnotationStore();
            this.connector = super.performCheckAssetAnalysisStep(JDBCResourceConnector.class, OpenMetadataType.RELATIONAL_DATABASE.typeName);
            JDBCResourceConnector assetConnector = (JDBCResourceConnector)this.connector;
            DataSource jdbcDataSource = assetConnector.getDataSource();
            Connection jdbcConnection = jdbcDataSource.getConnection();
            String databaseName = assetConnector.getDatabaseName();
            ArrayList<String> validDatabases = new ArrayList<String>();
            validDatabases.add(databaseName);
            annotationStore.setAnalysisStep(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName());
            PostgresDatabaseStatsExtractor databaseStatsExtractor = new PostgresDatabaseStatsExtractor(validDatabases, jdbcConnection, this);
            List<Annotation> annotations = databaseStatsExtractor.getStatistics();
            String pg_statsSQLCommand = "SELECT schemaname, tablename, attname, avg_width, most_common_vals, most_common_elems from pg_stats;";
            PreparedStatement preparedStatement = jdbcConnection.prepareStatement("SELECT schemaname, tablename, attname, avg_width, most_common_vals, most_common_elems from pg_stats;");
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.close();
            String pg_stat_user_tablesSQLCommand = "SELECT schemaname, relname, seq_tup_read, n_tup_ins, n_tup_upd, n_tup_del from pg_catalog.pg_stat_user_tables;";
            preparedStatement = jdbcConnection.prepareStatement("SELECT schemaname, relname, seq_tup_read, n_tup_ins, n_tup_upd, n_tup_del from pg_catalog.pg_stat_user_tables;");
            resultSet = preparedStatement.executeQuery();
            resultSet.close();
            String pg_tablesSQLCommand = "SELECT schemaname, tablename, tableowner, tablespace, hasindexes, hasrules, hastriggers from pg_tables;";
            preparedStatement = jdbcConnection.prepareStatement("SELECT schemaname, tablename, tableowner, tablespace, hasindexes, hasrules, hastriggers from pg_tables;");
            resultSet = preparedStatement.executeQuery();
            resultSet.close();
            annotationStore.setAnalysisStep(AnalysisStep.MEASURE_RESOURCE.getName());
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            super.handleUnexpectedException("start", error);
        }
    }

    static class ColumnDetails {
        ColumnDetails() {
        }
    }

    static class TableDetails {
        String tableOwner = null;
        boolean hasIndexes = false;
        boolean hasRules = false;
        boolean hasTriggers = false;
        Map<String, ColumnDetails> columns = new HashMap<String, ColumnDetails>();

        TableDetails() {
        }
    }

    static class SchemaDetails {
        Map<String, TableDetails> tables = new HashMap<String, TableDetails>();

        SchemaDetails() {
        }
    }
}

