/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.postgres.survey;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.odpi.openmetadata.adapters.connectors.postgres.ffdc.PostgresAuditCode;
import org.odpi.openmetadata.adapters.connectors.postgres.survey.PostgresDatabaseStatsExtractor;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceConnector;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyAssetStore;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;

public class PostgresServerSurveyActionService
extends SurveyActionServiceConnector {
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            AnnotationStore annotationStore = this.surveyContext.getAnnotationStore();
            SurveyAssetStore assetStore = this.surveyContext.getAssetStore();
            this.connector = super.performCheckAssetAnalysisStep(JDBCResourceConnector.class, OpenMetadataType.SOFTWARE_SERVER.typeName);
            JDBCResourceConnector assetConnector = (JDBCResourceConnector)this.connector;
            assetConnector.start();
            annotationStore.setAnalysisStep(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName());
            DataSource jdbcDataSource = assetConnector.getDataSource();
            Connection jdbcConnection = jdbcDataSource.getConnection();
            String sqlCommand1 = "SELECT oid, datname, datistemplate, datallowconn from pg_database;";
            PreparedStatement preparedStatement = jdbcConnection.prepareStatement("SELECT oid, datname, datistemplate, datallowconn from pg_database;");
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<String> validDatabases = new ArrayList<String>();
            while (resultSet.next()) {
                if (resultSet.getBoolean("datistemplate") || !resultSet.getBoolean("datallowconn")) continue;
                String databaseName = resultSet.getString("datname");
                validDatabases.add(databaseName);
            }
            resultSet.close();
            preparedStatement.close();
            if (validDatabases.isEmpty()) {
                this.auditLog.logMessage("start", PostgresAuditCode.NO_DATABASES.getMessageDefinition(this.surveyActionServiceName, assetStore.getAssetProperties().getQualifiedName(), assetStore.getAssetGUID()));
            } else {
                PostgresDatabaseStatsExtractor statsExtractor = new PostgresDatabaseStatsExtractor(validDatabases, jdbcConnection, this);
                List<Annotation> databaseStatistics = statsExtractor.getStatistics();
                if (databaseStatistics != null) {
                    for (Annotation annotation : databaseStatistics) {
                        if (!super.isActive()) continue;
                        annotationStore.addAnnotation(annotation, this.surveyContext.getAssetGUID());
                    }
                }
            }
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            super.handleUnexpectedException("start", error);
        }
    }
}

