/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.postgres.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresDeployedImplementationType;
import org.odpi.openmetadata.frameworks.connectors.controls.TemplateType;

public enum PostgreSQLTemplateType {
    POSTGRES_SERVER_TEMPLATE(PostgresDeployedImplementationType.POSTGRESQL_SERVER.getDeployedImplementationType(), "Create a " + PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getAssociatedTypeName() + " asset.", PostgresDeployedImplementationType.POSTGRESQL_SERVER.getAssociatedTypeName(), false, "542134e6-b9ce-4dce-8aef-22e8daf34fdb", null),
    POSTGRES_DATABASE_TEMPLATE(PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getDeployedImplementationType(), "Create a " + PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getAssociatedTypeName() + " asset.", PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getAssociatedTypeName(), false, "3d398b3f-7ae6-4713-952a-409f3dea8520", null),
    POSTGRES_SCHEMA_TEMPLATE(PostgresDeployedImplementationType.POSTGRESQL_DATABASE_SCHEMA.getDeployedImplementationType(), "Create a " + PostgresDeployedImplementationType.POSTGRESQL_DATABASE_SCHEMA.getAssociatedTypeName() + " asset.", PostgresDeployedImplementationType.POSTGRESQL_DATABASE_SCHEMA.getAssociatedTypeName(), false, "82a5417c-d882-4271-8444-4c6a996a8bfc", null);

    private final String templateName;
    private final String templateDescription;
    private final String typeName;
    private final boolean required;
    private final String defaultTemplateGUID;
    private final Map<String, String> otherPropertyValues;

    private PostgreSQLTemplateType(String templateName, String templateDescription, String typeName, boolean required, String defaultTemplateGUID, Map<String, String> otherPropertyValues) {
        this.templateName = templateName;
        this.templateDescription = templateDescription;
        this.typeName = typeName;
        this.required = required;
        this.defaultTemplateGUID = defaultTemplateGUID;
        this.otherPropertyValues = otherPropertyValues;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getTemplateDescription() {
        return this.templateDescription;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean getRequired() {
        return this.required;
    }

    public String getDefaultTemplateGUID() {
        return this.defaultTemplateGUID;
    }

    public Map<String, String> getOtherPropertyValues() {
        return this.otherPropertyValues;
    }

    public static List<TemplateType> getTemplateTypes() {
        ArrayList<TemplateType> templateTypes = new ArrayList<TemplateType>();
        for (PostgreSQLTemplateType templateTypeEnum : PostgreSQLTemplateType.values()) {
            templateTypes.add(templateTypeEnum.getTemplateType());
        }
        return templateTypes;
    }

    public TemplateType getTemplateType() {
        TemplateType templateType = new TemplateType();
        templateType.setTemplateName(this.templateName);
        templateType.setTypeName(this.typeName);
        templateType.setTemplateDescription(this.templateDescription);
        templateType.setRequired(this.required);
        templateType.setDefaultTemplateGUID(this.defaultTemplateGUID);
        templateType.setOtherPropertyValues(this.otherPropertyValues);
        return templateType;
    }

    public String toString() {
        return "TemplateType{templateName='" + this.templateName + "'}";
    }
}

