/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.postgres.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresDeployedImplementationType;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTargetType;
import org.odpi.openmetadata.frameworks.integration.controls.CatalogTargetType;

public enum PostgresTarget {
    SERVER("postgreSQLServer", PostgresDeployedImplementationType.POSTGRESQL_SERVER.getDescription(), PostgresDeployedImplementationType.POSTGRESQL_SERVER.getAssociatedTypeName(), PostgresDeployedImplementationType.POSTGRESQL_SERVER.getDeployedImplementationType(), null),
    DATABASE("postgresDatabase", PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getDescription(), PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getAssociatedTypeName(), PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getDeployedImplementationType(), null);

    private final String name;
    public final String description;
    private final String typeName;
    private final String deployedImplementationType;
    private final Map<String, String> otherPropertyValues;

    private PostgresTarget(String name, String description, String typeName, String deployedImplementationType, Map<String, String> otherPropertyValues) {
        this.name = name;
        this.description = description;
        this.typeName = typeName;
        this.deployedImplementationType = deployedImplementationType;
        this.otherPropertyValues = otherPropertyValues;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public Map<String, String> getOtherPropertyValues() {
        return this.otherPropertyValues;
    }

    public static List<CatalogTargetType> getPostgresServerCatalogTargetTypes() {
        ArrayList<CatalogTargetType> catalogTargetTypes = new ArrayList<CatalogTargetType>();
        catalogTargetTypes.add(SERVER.getCatalogTargetType());
        return catalogTargetTypes;
    }

    public CatalogTargetType getCatalogTargetType() {
        CatalogTargetType catalogTargetType = new CatalogTargetType();
        catalogTargetType.setName(this.name);
        catalogTargetType.setTypeName(this.typeName);
        catalogTargetType.setDeployedImplementationType(this.deployedImplementationType);
        catalogTargetType.setOtherPropertyValues(this.otherPropertyValues);
        return catalogTargetType;
    }

    public static List<ActionTargetType> getPostgresServerActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        actionTargetTypes.add(SERVER.getActionTargetType());
        return actionTargetTypes;
    }

    public static List<ActionTargetType> getPostgresDatabaseActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        actionTargetTypes.add(DATABASE.getActionTargetType());
        return actionTargetTypes;
    }

    public ActionTargetType getActionTargetType() {
        ActionTargetType actionTargetType = new ActionTargetType();
        actionTargetType.setName(this.name);
        actionTargetType.setDescription(this.description);
        actionTargetType.setTypeName(this.typeName);
        actionTargetType.setDeployedImplementationType(this.deployedImplementationType);
        return actionTargetType;
    }

    public String toString() {
        return "CatalogTargetEnum{catalogTargetName='" + this.name + "'}";
    }
}

