/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.postgres.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgreSQLTemplateType;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresConfigurationProperty;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.postgres.ffdc.PostgresAuditCode;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnector;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.integration.connectors.CatalogTargetIntegrator;
import org.odpi.openmetadata.frameworks.integration.context.OpenMetadataAccess;
import org.odpi.openmetadata.frameworks.integration.properties.RequestedCatalogTarget;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OperationalStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ServerAssetUseType;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.infrastructure.connector.InfrastructureIntegratorConnector;

public class PostgresServerIntegrationConnector
extends InfrastructureIntegratorConnector
implements CatalogTargetIntegrator {
    final PropertyHelper propertyHelper = new PropertyHelper();
    List<String> defaultExcludeDatabases = null;
    List<String> defaultIncludeDatabases = null;
    String defaultFriendshipGUID = null;
    Map<String, String> defaultTemplates = new HashMap<String, String>();

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        this.defaultExcludeDatabases = super.getArrayConfigurationProperty(PostgresConfigurationProperty.EXCLUDE_DATABASE_LIST.getName(), this.connectionDetails.getConfigurationProperties(), Collections.singletonList("postgres"));
        this.defaultIncludeDatabases = super.getArrayConfigurationProperty(PostgresConfigurationProperty.INCLUDE_DATABASE_LIST.getName(), this.connectionDetails.getConfigurationProperties());
        this.defaultFriendshipGUID = this.getFriendshipGUID(this.connectionDetails.getConfigurationProperties());
        if (this.defaultFriendshipGUID != null) {
            this.auditLog.logMessage("start", PostgresAuditCode.FRIENDSHIP_GUID.getMessageDefinition(this.connectorName, this.defaultFriendshipGUID));
        }
        for (PostgreSQLTemplateType templateType : PostgreSQLTemplateType.values()) {
            this.defaultTemplates.put(templateType.getTemplateName(), templateType.getTemplateGUID());
        }
    }

    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        if (this.embeddedConnectors != null && !this.embeddedConnectors.isEmpty()) {
            for (Connector embeddedConnector : this.embeddedConnectors) {
                if (!(embeddedConnector instanceof JDBCResourceConnector)) continue;
                JDBCResourceConnector jdbcResourceConnector = (JDBCResourceConnector)embeddedConnector;
                try {
                    if (!jdbcResourceConnector.isActive()) {
                        jdbcResourceConnector.start();
                    }
                    this.catalogDatabases(null, null, this.defaultTemplates, this.connectionDetails.getConfigurationProperties(), jdbcResourceConnector);
                }
                catch (ConnectorCheckedException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    this.auditLog.logException("refresh", PostgresAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, exception.getClass().getName(), "refresh", exception.getMessage()), (Throwable)exception);
                }
            }
        }
        this.refreshCatalogTargets(this);
    }

    public void integrateCatalogTarget(RequestedCatalogTarget requestedCatalogTarget) throws ConnectorCheckedException {
        String methodName = "integrateCatalogTarget";
        if (PostgresDeployedImplementationType.POSTGRESQL_SERVER.getAssociatedTypeName().equals(requestedCatalogTarget.getCatalogTargetElement().getType().getTypeName())) {
            String databaseServerGUID = requestedCatalogTarget.getCatalogTargetElement().getGUID();
            String databaseManagerGUID = this.getDatabaseManagerGUID(databaseServerGUID, requestedCatalogTarget.getCatalogTargetElement().getUniqueName());
            try {
                Connector connector = this.getContext().getConnectedAssetContext().getConnectorToAsset(databaseServerGUID, this.auditLog);
                JDBCResourceConnector assetConnector = (JDBCResourceConnector)connector;
                assetConnector.start();
                this.catalogDatabases(databaseServerGUID, databaseManagerGUID, requestedCatalogTarget.getTemplateProperties(), requestedCatalogTarget.getConfigurationProperties(), assetConnector);
                assetConnector.disconnect();
            }
            catch (Exception exception) {
                this.auditLog.logException("integrateCatalogTarget", PostgresAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, exception.getClass().getName(), "integrateCatalogTarget", exception.getMessage()), (Throwable)exception);
            }
        } else {
            super.throwWrongTypeOfAsset(requestedCatalogTarget.getCatalogTargetElement().getGUID(), requestedCatalogTarget.getCatalogTargetElement().getType().getTypeName(), PostgresDeployedImplementationType.POSTGRESQL_SERVER.getAssociatedTypeName(), this.connectorName, "integrateCatalogTarget");
        }
    }

    private String getDatabaseManagerGUID(String databaseServerGUID, String databaseServerQualifiedName) throws ConnectorCheckedException {
        String methodName = "getDatabaseManagerGUID";
        String databaseManagerGUID = null;
        try {
            OpenMetadataAccess openMetadataAccess = this.getContext().getIntegrationGovernanceContext().getOpenMetadataAccess();
            int startFrom = 0;
            RelatedMetadataElementList relatedCapabilities = openMetadataAccess.getRelatedMetadataElements(databaseServerGUID, 1, OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.typeName, startFrom, this.getContext().getMaxPageSize());
            while (relatedCapabilities != null && relatedCapabilities.getElementList() != null) {
                for (RelatedMetadataElement relatedCapability : relatedCapabilities.getElementList()) {
                    if (!OpenMetadataType.DATABASE_MANAGER.typeName.equals(relatedCapability.getElement().getType().getTypeName())) continue;
                    databaseManagerGUID = relatedCapability.getElement().getElementGUID();
                    break;
                }
                relatedCapabilities = openMetadataAccess.getRelatedMetadataElements(databaseServerGUID, 1, OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.typeName, startFrom += this.getContext().getMaxPageSize(), this.getContext().getMaxPageSize());
            }
            if (databaseManagerGUID == null) {
                databaseManagerGUID = openMetadataAccess.createMetadataElementInStore(OpenMetadataType.DATABASE_MANAGER.typeName, ElementStatus.ACTIVE, null, databaseServerGUID, false, null, null, null, this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, databaseServerQualifiedName + ":DBMS"), databaseServerGUID, OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.typeName, this.propertyHelper.addEnumProperty(null, OpenMetadataProperty.OPERATIONAL_STATUS.name, OperationalStatus.getOpenTypeName(), OperationalStatus.ENABLED.getName()), true);
            }
        }
        catch (ConnectorCheckedException exception) {
            throw exception;
        }
        catch (Exception exception) {
            this.auditLog.logException("getDatabaseManagerGUID", PostgresAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, exception.getClass().getName(), "getDatabaseManagerGUID", exception.getMessage()), (Throwable)exception);
        }
        return databaseManagerGUID;
    }

    private void catalogDatabases(String databaseServerGUID, String databaseManagerGUID, Map<String, String> configuredTemplates, Map<String, Object> configurationProperties, JDBCResourceConnector assetConnector) throws ConnectorCheckedException {
        String methodName = "catalogDatabases";
        List excludedDatabases = super.getArrayConfigurationProperty(PostgresConfigurationProperty.EXCLUDE_DATABASE_LIST.getName(), configurationProperties, this.defaultExcludeDatabases);
        List includedDatabases = super.getArrayConfigurationProperty(PostgresConfigurationProperty.INCLUDE_DATABASE_LIST.getName(), configurationProperties, this.defaultIncludeDatabases);
        Map<String, String> templates = this.defaultTemplates;
        if (configuredTemplates != null) {
            templates = configuredTemplates;
        }
        try {
            DataSource jdbcDataSource = assetConnector.getDataSource();
            Connection jdbcConnection = jdbcDataSource.getConnection();
            String sqlCommand1 = "SELECT datname, datistemplate, datallowconn from pg_database;";
            PreparedStatement preparedStatement = jdbcConnection.prepareStatement("SELECT datname, datistemplate, datallowconn from pg_database;");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                if (resultSet.getBoolean("datistemplate") || !resultSet.getBoolean("datallowconn")) continue;
                String databaseName = resultSet.getString("datname");
                if (!this.getContext().elementShouldBeCatalogued(databaseName, excludedDatabases, includedDatabases)) continue;
                this.catalogDatabase(databaseName, databaseServerGUID, databaseManagerGUID, templates, configurationProperties);
            }
            resultSet.close();
            preparedStatement.close();
            jdbcConnection.commit();
        }
        catch (ConnectorCheckedException exception) {
            throw exception;
        }
        catch (Exception exception) {
            this.auditLog.logException("catalogDatabases", PostgresAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, exception.getClass().getName(), "catalogDatabases", exception.getMessage()), (Throwable)exception);
        }
    }

    private void catalogDatabase(String databaseName, String databaseServerGUID, String databaseManagerGUID, Map<String, String> templates, Map<String, Object> configurationProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectorCheckedException {
        HashMap<String, String> placeholderProperties;
        String methodName = "catalogDatabase";
        String friendshipConnectorGUID = this.getFriendshipGUID(configurationProperties);
        OpenMetadataAccess openMetadataAccess = this.getContext().getIntegrationGovernanceContext().getOpenMetadataAccess();
        ElementProperties serverAssetUseProperties = this.propertyHelper.addEnumProperty(null, OpenMetadataProperty.USE_TYPE.name, ServerAssetUseType.getOpenTypeName(), ServerAssetUseType.OWNS.getName());
        String databaseTemplateGUID = templates.get(PostgreSQLTemplateType.POSTGRES_DATABASE_TEMPLATE.getTemplateGUID());
        if (databaseTemplateGUID == null) {
            databaseTemplateGUID = PostgreSQLTemplateType.POSTGRES_DATABASE_TEMPLATE.getTemplateGUID();
        }
        if ((placeholderProperties = super.getSuppliedPlaceholderProperties(configurationProperties)) == null) {
            placeholderProperties = new HashMap<String, String>();
        }
        placeholderProperties.put(PostgresConfigurationProperty.DATABASE_NAME.getName(), databaseName);
        OpenMetadataElement templateElement = openMetadataAccess.getMetadataElementByGUID(databaseTemplateGUID);
        String qualifiedName = this.propertyHelper.getResolvedStringPropertyFromTemplate(this.connectorName, templateElement, OpenMetadataProperty.QUALIFIED_NAME.name, placeholderProperties);
        OpenMetadataElement databaseElement = openMetadataAccess.getMetadataElementByUniqueName(qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name);
        if (databaseElement != null) {
            this.auditLog.logMessage("catalogDatabase", PostgresAuditCode.SKIPPING_DATABASE.getMessageDefinition(this.connectorName, databaseElement.getElementGUID(), qualifiedName));
        } else {
            String databaseGUID = openMetadataAccess.getMetadataElementFromTemplate(OpenMetadataType.RELATIONAL_DATABASE.typeName, databaseServerGUID, false, null, null, null, databaseTemplateGUID, null, placeholderProperties, databaseManagerGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, serverAssetUseProperties, true);
            this.auditLog.logMessage("catalogDatabase", PostgresAuditCode.CATALOGED_DATABASE.getMessageDefinition(this.connectorName, qualifiedName, databaseGUID));
            this.addCatalogTarget(friendshipConnectorGUID, databaseGUID, databaseManagerGUID, databaseName, templates, configurationProperties);
        }
    }

    private String getFriendshipGUID(Map<String, Object> configurationProperties) {
        String friendshipGUID = this.defaultFriendshipGUID;
        if (configurationProperties != null && configurationProperties.get(PostgresConfigurationProperty.FRIENDSHIP_GUID.getName()) != null) {
            friendshipGUID = this.connectionDetails.getConfigurationProperties().get(PostgresConfigurationProperty.FRIENDSHIP_GUID.getName()).toString();
        }
        return friendshipGUID;
    }

    private void addCatalogTarget(String friendshipConnectorGUID, String databaseGUID, String dbmsQualifiedName, String databaseName, Map<String, String> templates, Map<String, Object> configurationProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addCatalogTarget";
        if (databaseGUID != null && friendshipConnectorGUID != null) {
            CatalogTargetProperties catalogTargetProperties = new CatalogTargetProperties();
            catalogTargetProperties.setCatalogTargetName(databaseName);
            catalogTargetProperties.setMetadataSourceQualifiedName(dbmsQualifiedName);
            catalogTargetProperties.setTemplateProperties(templates);
            HashMap<String, Object> targetConfigurationProperties = new HashMap<String, Object>();
            if (configurationProperties != null) {
                targetConfigurationProperties.putAll(configurationProperties);
            }
            targetConfigurationProperties.put(PostgresConfigurationProperty.DATABASE_NAME.getName(), databaseName);
            targetConfigurationProperties.put(OpenMetadataProperty.GUID.name, databaseGUID);
            catalogTargetProperties.setConfigurationProperties(targetConfigurationProperties);
            String relationshipGUID = this.integrationContext.addCatalogTarget(friendshipConnectorGUID, databaseGUID, catalogTargetProperties);
            this.auditLog.logMessage("addCatalogTarget", PostgresAuditCode.NEW_CATALOG_TARGET.getMessageDefinition(this.connectorName, relationshipGUID, friendshipConnectorGUID, databaseGUID, databaseName));
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
    }
}

