/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.postgres.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresPlaceholderProperty;
import org.odpi.openmetadata.frameworks.connectors.controls.TemplateType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.ReplacementAttributeType;
import org.odpi.openmetadata.frameworks.openmetadata.controls.TemplateDefinition;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationTypeDefinition;

public enum PostgreSQLTemplateType implements TemplateDefinition
{
    POSTGRES_SERVER_TEMPLATE(PostgresDeployedImplementationType.POSTGRESQL_SERVER.getDeployedImplementationType(), "Create a " + PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getAssociatedTypeName() + " asset.", PostgresDeployedImplementationType.POSTGRESQL_SERVER.getAssociatedTypeName(), false, "542134e6-b9ce-4dce-8aef-22e8daf34fdb", PostgresDeployedImplementationType.POSTGRESQL_SERVER, PostgresPlaceholderProperty.getPostgresServerPlaceholderPropertyTypes(), null),
    POSTGRES_DATABASE_TEMPLATE(PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getDeployedImplementationType(), "Create a " + PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getAssociatedTypeName() + " asset.", PostgresDeployedImplementationType.POSTGRESQL_DATABASE.getAssociatedTypeName(), false, "3d398b3f-7ae6-4713-952a-409f3dea8520", PostgresDeployedImplementationType.POSTGRESQL_DATABASE, PostgresPlaceholderProperty.getPostgresDatabasePlaceholderPropertyTypes(), null),
    POSTGRES_SCHEMA_TEMPLATE(PostgresDeployedImplementationType.POSTGRESQL_DATABASE_SCHEMA.getDeployedImplementationType(), "Create a " + PostgresDeployedImplementationType.POSTGRESQL_DATABASE_SCHEMA.getAssociatedTypeName() + " asset.", PostgresDeployedImplementationType.POSTGRESQL_DATABASE_SCHEMA.getAssociatedTypeName(), false, "82a5417c-d882-4271-8444-4c6a996a8bfc", PostgresDeployedImplementationType.POSTGRESQL_DATABASE_SCHEMA, PostgresPlaceholderProperty.getPostgresSchemaPlaceholderPropertyTypes(), null);

    private final String templateName;
    private final String templateDescription;
    private final String typeName;
    private final boolean required;
    private final String defaultTemplateGUID;
    private final Map<String, String> otherPropertyValues;
    private final PostgresDeployedImplementationType deployedImplementationType;
    private final List<PlaceholderPropertyType> placeholderPropertyTypes;

    private PostgreSQLTemplateType(String templateName, String templateDescription, String typeName, boolean required, String defaultTemplateGUID, PostgresDeployedImplementationType deployedImplementationType, List<PlaceholderPropertyType> placeholderPropertyTypes, Map<String, String> otherPropertyValues) {
        this.templateName = templateName;
        this.templateDescription = templateDescription;
        this.typeName = typeName;
        this.required = required;
        this.defaultTemplateGUID = defaultTemplateGUID;
        this.deployedImplementationType = deployedImplementationType;
        this.placeholderPropertyTypes = placeholderPropertyTypes;
        this.otherPropertyValues = otherPropertyValues;
    }

    public String getTemplateGUID() {
        return this.defaultTemplateGUID;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getTemplateDescription() {
        return this.templateDescription;
    }

    public String getTemplateVersionIdentifier() {
        return "V1.0";
    }

    public DeployedImplementationTypeDefinition getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public String getElementVersionIdentifier() {
        return PlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder();
    }

    public List<PlaceholderPropertyType> getPlaceholders() {
        return this.placeholderPropertyTypes;
    }

    public List<ReplacementAttributeType> getReplacementAttributes() {
        return null;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean getRequired() {
        return this.required;
    }

    public Map<String, String> getOtherPropertyValues() {
        return this.otherPropertyValues;
    }

    public static List<TemplateType> getTemplateTypes() {
        ArrayList<TemplateType> templateTypes = new ArrayList<TemplateType>();
        for (PostgreSQLTemplateType templateTypeEnum : PostgreSQLTemplateType.values()) {
            templateTypes.add(templateTypeEnum.getTemplateType());
        }
        return templateTypes;
    }

    public TemplateType getTemplateType() {
        TemplateType templateType = new TemplateType();
        templateType.setTemplateName(this.templateName);
        templateType.setTypeName(this.typeName);
        templateType.setTemplateDescription(this.templateDescription);
        templateType.setRequired(this.required);
        templateType.setDefaultTemplateGUID(this.defaultTemplateGUID);
        templateType.setOtherPropertyValues(this.otherPropertyValues);
        return templateType;
    }

    public String toString() {
        return "TemplateType{templateName='" + this.templateName + "'}";
    }
}

