/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.postgres.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum PostgresAuditCode implements AuditLogMessageSet
{
    UNEXPECTED_EXCEPTION("POSTGRES-CONNECTOR-0001", AuditLogRecordSeverityLevel.EXCEPTION, "The PostgreSQL connector {0} received an unexpected {1} exception during method {2}; the error message was: {3}", "The connector is unable to process the current request.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved."),
    NO_DATABASES("POSTGRES-CONNECTOR-0002", AuditLogRecordSeverityLevel.INFO, "The {0} survey action service is unable to retrieve details of any databases for PostgreSQL Database Server {1} ({2})", "The survey terminates.", "This may not be an error if there are no user database on the database server.  If there are, check the permissions associated with the database userId."),
    CATALOGED_DATABASE("POSTGRES-CONNECTOR-0003", AuditLogRecordSeverityLevel.INFO, "The {0} integration connector has catalogued PostgreSQL Database {1} ({2})", "The integration connector looks for another database.", "This is an information message showing that the integration connector has found a new database."),
    SKIPPING_DATABASE("POSTGRES-CONNECTOR-0004", AuditLogRecordSeverityLevel.INFO, "The {0} integration connector is skipping PostgreSQL Database {1} ({2}) because it is already catalogued", "The integration connector continues, looking for another database.", "This is an information message showing that the integration connector is working, but does not need to do any processing on this database."),
    FRIENDSHIP_GUID("POSTGRES-CONNECTOR-0007", AuditLogRecordSeverityLevel.INFO, "The {0} PostgreSQL Server Connector has been supplied with a friendship connector with GUID {1}", "The friendship connector is an integration connector that is able to catalog a JDBC database.  Therefore, they will cooperate to synchronize the contents of the PostgreSQL Server with the open metadata ecosystem.", "No action is required, this message is just to acknowledge that that the two integration connectors are going to collaborate to catalog the entire contents of the PostgreSQL Server."),
    NEW_CATALOG_TARGET("POSTGRES-CONNECTOR-0009", AuditLogRecordSeverityLevel.INFO, "The {0} Connector has added a catalog target relationship {1} from friendship connector {2} to PostgreSQL Database Asset {3} for Database {4}", "The connector has requested that its friendship connector starts to catalog a new PostgreSQL Database.", "Verify that the cataloguing starts the next time that the friendship connector refreshes.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private PostgresAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "PostgresAuditCode{logMessageId='" + this.logMessageId + "', severity=" + String.valueOf(this.severity) + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

