/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.postgres.survey;

import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceConnector;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyDatabaseAnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalColumnMeasurement;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalColumnMetric;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalDataManagerMeasurement;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalDatabaseMetric;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalSchemaMeasurement;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalSchemaMetric;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalTableMeasurement;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalTableMetric;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceMeasureAnnotation;

public class PostgresDatabaseStatsExtractor {
    private final List<String> validDatabases;
    private final SurveyActionServiceConnector surveyActionServiceConnector;
    private final Map<String, DatabaseDetails> databaseResults = new HashMap<String, DatabaseDetails>();

    public PostgresDatabaseStatsExtractor(List<String> validDatabases, SurveyActionServiceConnector surveyActionServiceConnector) {
        this.validDatabases = validDatabases;
        this.surveyActionServiceConnector = surveyActionServiceConnector;
    }

    void getDatabaseStatistics(Connection serverJDBCConnection) throws SQLException, PropertyServerException {
        String pg_stat_databaseSQLCommand = "SELECT datname, tup_fetched, tup_inserted, tup_updated, tup_deleted, session_time, active_time, stats_reset FROM pg_catalog.pg_stat_database;";
        try {
            PreparedStatement preparedStatement = serverJDBCConnection.prepareStatement("SELECT datname, tup_fetched, tup_inserted, tup_updated, tup_deleted, session_time, active_time, stats_reset FROM pg_catalog.pg_stat_database;");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String databaseName = resultSet.getString("datname");
                if (!this.validDatabases.contains(databaseName)) continue;
                RelationalDataManagerMeasurement databaseMeasurement = new RelationalDataManagerMeasurement();
                databaseMeasurement.setResourceName(databaseName);
                databaseMeasurement.setRowsFetched(resultSet.getLong("tup_fetched"));
                databaseMeasurement.setRowsInserted(resultSet.getLong("tup_inserted"));
                databaseMeasurement.setRowsUpdated(resultSet.getLong("tup_updated"));
                databaseMeasurement.setRowsDeleted(resultSet.getLong("tup_deleted"));
                databaseMeasurement.setSessionTime(resultSet.getDouble("session_time"));
                databaseMeasurement.setActiveTime(resultSet.getDouble("active_time"));
                databaseMeasurement.setStatsReset((Date)resultSet.getDate("stats_reset"));
                this.databaseResults.put(databaseName, new DatabaseDetails(databaseMeasurement));
            }
            resultSet.close();
            preparedStatement.close();
            for (String databaseName : this.validDatabases) {
                DatabaseDetails currentDatabase = this.databaseResults.get(databaseName);
                if (currentDatabase == null) continue;
                String databaseSizeSQLCommand = "SELECT pg_database_size('" + databaseName + "');";
                preparedStatement = serverJDBCConnection.prepareStatement(databaseSizeSQLCommand);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    currentDatabase.setSize(resultSet.getLong("pg_database_size"));
                }
                resultSet.close();
                preparedStatement.close();
                this.databaseResults.put(databaseName, currentDatabase);
            }
        }
        catch (SQLException sqlException) {
            try {
                serverJDBCConnection.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw sqlException;
        }
    }

    void getSchemaStatistics(String databaseName, Connection databaseSQLConnection) throws SQLException {
        String pg_tablesSQLCommand = "select pg_stat_user_tables.relid,pg_stat_user_tables.schemaname,pg_tables.tablename, pg_tables.tableowner, pg_tables.hasindexes, pg_tables.hasrules, pg_tables.hastriggers, pg_tables.rowsecurity, pg_stat_user_tables.n_tup_ins, pg_stat_user_tables.n_tup_upd, pg_stat_user_tables.n_tup_del from pg_catalog.pg_statio_user_tables left outer join pg_catalog.pg_stat_user_tables on pg_stat_user_tables.schemaname = pg_statio_user_tables.schemaname and pg_stat_user_tables.relname = pg_statio_user_tables.relname left outer join pg_catalog.pg_tables on pg_stat_user_tables.schemaname = pg_tables.schemaname and pg_stat_user_tables.relname = pg_tables.tablename where (pg_catalog.pg_statio_user_tables.schemaname != 'pg_catalog') and (pg_catalog.pg_statio_user_tables.schemaname != 'information_schema') ;";
        String pg_columnStatsSQLCommand = "select pg_stats.schemaname, pg_stats.tablename, pg_statio_user_tables.relid, pg_stats.attname, pg_stats.avg_width, pg_stats.n_distinct, pg_stats.most_common_vals, pg_stats.most_common_freqs, pg_attribute.atttypid, pg_type.typname, pg_attribute.attnotnull from pg_catalog.pg_stats left outer join pg_catalog.pg_statio_user_tables on pg_stats.schemaname = pg_statio_user_tables.schemaname and pg_stats.tablename = pg_statio_user_tables.relname left outer join pg_catalog.pg_attribute on pg_statio_user_tables.relid = pg_attribute.attrelid and pg_stats.attname = pg_attribute.attname left outer join pg_type on pg_attribute.atttypid = pg_type.oid where (pg_stats.schemaname != 'pg_catalog') and (pg_stats.schemaname != 'information_schema') ;";
        String pg_viewsSQLCommand = "SELECT schemaname, viewname, viewowner, definition FROM pg_catalog.pg_views;";
        String pg_matViewsSQLCommand = "SELECT schemaname, matviewname, matviewowner, hasindexes, ispopulated, definition FROM pg_catalog.pg_matviews;";
        try {
            DatabaseDetails databaseDetails = this.databaseResults.get(databaseName);
            if (databaseDetails != null) {
                String viewOwner;
                String viewName;
                String tableName;
                String schemaName;
                PreparedStatement preparedStatement = databaseSQLConnection.prepareStatement("select pg_stats.schemaname, pg_stats.tablename, pg_statio_user_tables.relid, pg_stats.attname, pg_stats.avg_width, pg_stats.n_distinct, pg_stats.most_common_vals, pg_stats.most_common_freqs, pg_attribute.atttypid, pg_type.typname, pg_attribute.attnotnull from pg_catalog.pg_stats left outer join pg_catalog.pg_statio_user_tables on pg_stats.schemaname = pg_statio_user_tables.schemaname and pg_stats.tablename = pg_statio_user_tables.relname left outer join pg_catalog.pg_attribute on pg_statio_user_tables.relid = pg_attribute.attrelid and pg_stats.attname = pg_attribute.attname left outer join pg_type on pg_attribute.atttypid = pg_type.oid where (pg_stats.schemaname != 'pg_catalog') and (pg_stats.schemaname != 'information_schema') ;");
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    schemaName = resultSet.getString("schemaname");
                    if (schemaName == null || schemaName.equals("pg_catalog") || schemaName.equals("information_schema")) continue;
                    tableName = resultSet.getString("tablename");
                    String columnName = resultSet.getString("attname");
                    int averageColumnWidth = resultSet.getInt("avg_width");
                    long numberOfDistinctValues = resultSet.getLong("n_distinct");
                    Array mostCommonValues = resultSet.getArray("most_common_vals");
                    Array mostCommonFrequencies = resultSet.getArray("most_common_freqs");
                    String columnTypeName = resultSet.getString("typname");
                    boolean columnNotNull = resultSet.getBoolean("attnotnull");
                    SchemaDetails schemaDetails = databaseDetails.getSchemaDetails(schemaName);
                    TableDetails tableDetails = schemaDetails.getTableDetails(tableName);
                    ColumnDetails columnDetails = tableDetails.getColumnDetails(columnName);
                    columnDetails.setColumnMeasurement(averageColumnWidth, numberOfDistinctValues, mostCommonValues, mostCommonFrequencies, columnTypeName, columnNotNull);
                }
                resultSet.close();
                preparedStatement.close();
                preparedStatement = databaseSQLConnection.prepareStatement("select pg_stat_user_tables.relid,pg_stat_user_tables.schemaname,pg_tables.tablename, pg_tables.tableowner, pg_tables.hasindexes, pg_tables.hasrules, pg_tables.hastriggers, pg_tables.rowsecurity, pg_stat_user_tables.n_tup_ins, pg_stat_user_tables.n_tup_upd, pg_stat_user_tables.n_tup_del from pg_catalog.pg_statio_user_tables left outer join pg_catalog.pg_stat_user_tables on pg_stat_user_tables.schemaname = pg_statio_user_tables.schemaname and pg_stat_user_tables.relname = pg_statio_user_tables.relname left outer join pg_catalog.pg_tables on pg_stat_user_tables.schemaname = pg_tables.schemaname and pg_stat_user_tables.relname = pg_tables.tablename where (pg_catalog.pg_statio_user_tables.schemaname != 'pg_catalog') and (pg_catalog.pg_statio_user_tables.schemaname != 'information_schema') ;");
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    schemaName = resultSet.getString("schemaname");
                    if (schemaName == null || schemaName.equals("pg_catalog") || schemaName.equals("information_schema")) continue;
                    tableName = resultSet.getString("tablename");
                    String tableOwner = resultSet.getString("tableowner");
                    boolean hasIndexes = resultSet.getBoolean("hasindexes");
                    boolean hasRules = resultSet.getBoolean("hasrules");
                    boolean hasTriggers = resultSet.getBoolean("hastriggers");
                    boolean hasRowSecurity = resultSet.getBoolean("rowsecurity");
                    long numberOfRowsInserted = resultSet.getLong("n_tup_ins");
                    long numberOfRowsUpdated = resultSet.getLong("n_tup_upd");
                    long numberOfRowsDeleted = resultSet.getLong("n_tup_del");
                    SchemaDetails schemaDetails = databaseDetails.getSchemaDetails(schemaName);
                    TableDetails tableDetails = schemaDetails.getTableDetails(tableName);
                    tableDetails.setTableMeasurements(tableOwner, hasIndexes, hasRules, hasTriggers, hasRowSecurity, numberOfRowsInserted, numberOfRowsUpdated, numberOfRowsDeleted);
                }
                resultSet.close();
                preparedStatement.close();
                preparedStatement = databaseSQLConnection.prepareStatement("SELECT schemaname, viewname, viewowner, definition FROM pg_catalog.pg_views;");
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    schemaName = resultSet.getString("schemaname");
                    if (schemaName == null || schemaName.equals("pg_catalog") || schemaName.equals("information_schema")) continue;
                    viewName = resultSet.getString("viewname");
                    viewOwner = resultSet.getString("viewowner");
                    String definition = resultSet.getString("definition");
                    SchemaDetails schemaDetails = databaseDetails.getSchemaDetails(schemaName);
                    TableDetails tableDetails = schemaDetails.getTableDetails(viewName);
                    tableDetails.setViewDetails(viewOwner, definition);
                }
                resultSet.close();
                preparedStatement.close();
                preparedStatement = databaseSQLConnection.prepareStatement("SELECT schemaname, matviewname, matviewowner, hasindexes, ispopulated, definition FROM pg_catalog.pg_matviews;");
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    schemaName = resultSet.getString("schemaname");
                    if (schemaName == null || schemaName.equals("pg_catalog") || schemaName.equals("information_schema")) continue;
                    viewName = resultSet.getString("matviewname");
                    viewOwner = resultSet.getString("matviewowner");
                    boolean hasIndexes = resultSet.getBoolean("hasindexes");
                    boolean isPopulated = resultSet.getBoolean("ispopulated");
                    String definition = resultSet.getString("definition");
                    SchemaDetails schemaDetails = databaseDetails.getSchemaDetails(schemaName);
                    TableDetails tableDetails = schemaDetails.getTableDetails(viewName);
                    tableDetails.setMaterializedViewDetails(viewOwner, hasIndexes, isPopulated, definition);
                }
                resultSet.close();
                preparedStatement.close();
                List<String> schemaNames = databaseDetails.getSchemaNames();
                if (schemaNames != null) {
                    for (String schemaName2 : schemaNames) {
                        List<String> tableNames;
                        SchemaDetails currentSchema = databaseDetails.getSchemaDetails(schemaName2);
                        if (currentSchema == null || (tableNames = currentSchema.getTableNames()) == null) continue;
                        long schemaSize = 0L;
                        for (String tableName2 : tableNames) {
                            TableDetails currentTable = currentSchema.getTableDetails(tableName2);
                            if (currentTable == null) continue;
                            this.getTableSize(databaseSQLConnection, currentTable);
                            schemaSize += currentTable.getTableMeasurements().getTableSize();
                            List<String> columnNames = currentTable.getColumnNames();
                            if (columnNames == null) continue;
                            for (String columnName : columnNames) {
                                ColumnDetails currentColumn = currentTable.getColumnDetails(columnName);
                                this.getColumnSize(databaseSQLConnection, currentColumn);
                            }
                        }
                        currentSchema.schemaMeasurement.setTotalTableSize(schemaSize);
                    }
                    databaseDetails.setUpCounts();
                }
            }
        }
        catch (SQLException sqlException) {
            try {
                databaseSQLConnection.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw sqlException;
        }
    }

    List<Annotation> getAnnotations() throws PropertyServerException {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (String databaseName : this.databaseResults.keySet()) {
            DatabaseDetails databaseDetails = this.databaseResults.get(databaseName);
            if (databaseDetails == null) continue;
            List<String> schemaNames = databaseDetails.getSchemaNames();
            ResourceMeasureAnnotation databaseAnnotation = new ResourceMeasureAnnotation();
            databaseAnnotation.setAnnotationType(SurveyDatabaseAnnotationType.DATABASE_MEASUREMENTS.getName());
            databaseAnnotation.setSummary(SurveyDatabaseAnnotationType.DATABASE_MEASUREMENTS.getSummary());
            databaseAnnotation.setExplanation(SurveyDatabaseAnnotationType.DATABASE_MEASUREMENTS.getExplanation());
            databaseAnnotation.setAnalysisStep(SurveyDatabaseAnnotationType.DATABASE_MEASUREMENTS.getAnalysisStep());
            databaseAnnotation.setJsonProperties(this.surveyActionServiceConnector.getJSONProperties((Object)databaseDetails.getDatabaseMeasurements()));
            databaseAnnotation.setResourceProperties(databaseDetails.getDatabaseResourceProperties());
            annotations.add((Annotation)databaseAnnotation);
            for (String schemaName : schemaNames) {
                SchemaDetails currentSchema = databaseDetails.getSchemaDetails(schemaName);
                if (currentSchema == null) continue;
                ResourceMeasureAnnotation schemaAnnotation = new ResourceMeasureAnnotation();
                schemaAnnotation.setAnnotationType(SurveyDatabaseAnnotationType.SCHEMA_MEASUREMENTS.getName());
                schemaAnnotation.setSummary(SurveyDatabaseAnnotationType.SCHEMA_MEASUREMENTS.getSummary());
                schemaAnnotation.setExplanation(SurveyDatabaseAnnotationType.SCHEMA_MEASUREMENTS.getExplanation());
                schemaAnnotation.setAnalysisStep(SurveyDatabaseAnnotationType.SCHEMA_MEASUREMENTS.getAnalysisStep());
                schemaAnnotation.setJsonProperties(this.surveyActionServiceConnector.getJSONProperties((Object)currentSchema.getSchemaMeasurement()));
                schemaAnnotation.setResourceProperties(currentSchema.getSchemaResourceProperties());
                annotations.add((Annotation)schemaAnnotation);
                List<String> tableNames = currentSchema.getTableNames();
                if (tableNames == null) continue;
                for (String tableName : tableNames) {
                    TableDetails currentTable = currentSchema.getTableDetails(tableName);
                    if (currentTable == null) continue;
                    ResourceMeasureAnnotation tableAnnotation = new ResourceMeasureAnnotation();
                    tableAnnotation.setAnnotationType(SurveyDatabaseAnnotationType.TABLE_MEASUREMENTS.getName());
                    tableAnnotation.setSummary(SurveyDatabaseAnnotationType.TABLE_MEASUREMENTS.getSummary());
                    tableAnnotation.setExplanation(SurveyDatabaseAnnotationType.TABLE_MEASUREMENTS.getExplanation());
                    tableAnnotation.setAnalysisStep(SurveyDatabaseAnnotationType.TABLE_MEASUREMENTS.getAnalysisStep());
                    tableAnnotation.setJsonProperties(this.surveyActionServiceConnector.getJSONProperties((Object)currentTable.getTableMeasurements()));
                    tableAnnotation.setResourceProperties(currentTable.getTableResourceProperties());
                    annotations.add((Annotation)tableAnnotation);
                    List<String> columnNames = currentTable.getColumnNames();
                    if (columnNames == null) continue;
                    for (String columnName : columnNames) {
                        ColumnDetails currentColumn = currentTable.getColumnDetails(columnName);
                        ResourceMeasureAnnotation columnAnnotation = new ResourceMeasureAnnotation();
                        columnAnnotation.setAnnotationType(SurveyDatabaseAnnotationType.COLUMN_MEASUREMENTS.getName());
                        columnAnnotation.setSummary(SurveyDatabaseAnnotationType.COLUMN_MEASUREMENTS.getSummary());
                        columnAnnotation.setExplanation(SurveyDatabaseAnnotationType.COLUMN_MEASUREMENTS.getExplanation());
                        columnAnnotation.setAnalysisStep(SurveyDatabaseAnnotationType.COLUMN_MEASUREMENTS.getAnalysisStep());
                        columnAnnotation.setJsonProperties(this.surveyActionServiceConnector.getJSONProperties((Object)currentColumn.getColumnMeasurements()));
                        columnAnnotation.setResourceProperties(currentColumn.getColumnResourceProperties());
                        annotations.add((Annotation)columnAnnotation);
                    }
                }
            }
        }
        if (!annotations.isEmpty()) {
            return annotations;
        }
        return null;
    }

    void getTableSize(Connection databaseSQLConnection, TableDetails tableDetails) throws SQLException {
        String databaseSizeSQLCommand = "SELECT pg_table_size('" + tableDetails.getQualifiedTableName() + "');";
        if (!tableDetails.columns.isEmpty()) {
            try {
                PreparedStatement preparedStatement = databaseSQLConnection.prepareStatement(databaseSizeSQLCommand);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    tableDetails.setTableSize(resultSet.getLong("pg_table_size"));
                }
                resultSet.close();
                preparedStatement.close();
            }
            catch (SQLException sqlException) {
                try {
                    databaseSQLConnection.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw sqlException;
            }
        }
    }

    void getColumnSize(Connection databaseSQLConnection, ColumnDetails columnDetails) throws SQLException {
        String databaseSizeSQLCommand = "SELECT pg_column_size('" + columnDetails.getQualifiedColumnName() + "');";
        try {
            PreparedStatement preparedStatement = databaseSQLConnection.prepareStatement(databaseSizeSQLCommand);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                columnDetails.setColumnSize(resultSet.getLong("pg_column_size"));
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sqlException) {
            try {
                databaseSQLConnection.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw sqlException;
        }
    }

    static class DatabaseDetails {
        private final RelationalDataManagerMeasurement databaseMeasurements;
        private final Map<String, SchemaDetails> schemas = new HashMap<String, SchemaDetails>();

        public DatabaseDetails(RelationalDataManagerMeasurement databaseMeasurements) {
            this.databaseMeasurements = databaseMeasurements;
        }

        void setSize(long size) {
            this.databaseMeasurements.setSize(size);
        }

        void setUpCounts() {
            if (!this.schemas.isEmpty()) {
                this.databaseMeasurements.setSchemaCount((long)this.schemas.size());
                long tableCount = 0L;
                long viewCount = 0L;
                long materializedViewCount = 0L;
                long columnCount = 0L;
                for (String schemaName : this.schemas.keySet()) {
                    SchemaDetails schemaDetails = this.schemas.get(schemaName);
                    if (schemaDetails == null) continue;
                    tableCount += schemaDetails.getTableCount();
                    viewCount += schemaDetails.getViewCount();
                    materializedViewCount += schemaDetails.getMaterializedViewCount();
                    columnCount += schemaDetails.getColumnCount();
                }
                this.databaseMeasurements.setTableCount(tableCount);
                this.databaseMeasurements.setViewCount(tableCount);
                this.databaseMeasurements.setMaterializedViewCount(tableCount);
                this.databaseMeasurements.setColumnCount(columnCount);
            }
        }

        Map<String, String> getDatabaseResourceProperties() {
            HashMap<String, String> resourceProperties = new HashMap<String, String>();
            resourceProperties.put(RelationalDatabaseMetric.DATABASE_NAME.getDisplayName(), this.databaseMeasurements.getResourceName());
            resourceProperties.put(RelationalDatabaseMetric.DATA_SIZE.getDisplayName(), Long.toString(this.databaseMeasurements.getSize()));
            resourceProperties.put(RelationalDatabaseMetric.SCHEMA_COUNT.getDisplayName(), Long.toString(this.databaseMeasurements.getSchemaCount()));
            resourceProperties.put(RelationalDatabaseMetric.TABLE_COUNT.getDisplayName(), Long.toString(this.databaseMeasurements.getTableCount()));
            resourceProperties.put(RelationalDatabaseMetric.COLUMN_COUNT.getDisplayName(), Long.toString(this.databaseMeasurements.getColumnCount()));
            resourceProperties.put(RelationalDatabaseMetric.ROWS_FETCHED.getDisplayName(), Long.toString(this.databaseMeasurements.getRowsFetched()));
            resourceProperties.put(RelationalDatabaseMetric.ROWS_INSERTED.getDisplayName(), Long.toString(this.databaseMeasurements.getRowsInserted()));
            resourceProperties.put(RelationalDatabaseMetric.ROWS_UPDATED.getDisplayName(), Long.toString(this.databaseMeasurements.getRowsUpdated()));
            resourceProperties.put(RelationalDatabaseMetric.ROWS_DELETED.getDisplayName(), Long.toString(this.databaseMeasurements.getRowsDeleted()));
            resourceProperties.put(RelationalDatabaseMetric.SESSION_TIME.getDisplayName(), Double.toString(this.databaseMeasurements.getSessionTime()));
            resourceProperties.put(RelationalDatabaseMetric.ACTIVE_TIME.getDisplayName(), Double.toString(this.databaseMeasurements.getActiveTime()));
            if (this.databaseMeasurements.getStatsReset() != null) {
                resourceProperties.put(RelationalDatabaseMetric.LAST_STATISTICS_RESET.getDisplayName(), this.databaseMeasurements.getStatsReset().toString());
            }
            return resourceProperties;
        }

        public RelationalDataManagerMeasurement getDatabaseMeasurements() {
            return this.databaseMeasurements;
        }

        SchemaDetails getSchemaDetails(String schemaName) {
            SchemaDetails schemaDetails = this.schemas.get(schemaName);
            if (schemaDetails == null) {
                schemaDetails = new SchemaDetails(this.databaseMeasurements.getResourceName(), schemaName);
                this.schemas.put(schemaName, schemaDetails);
            }
            return schemaDetails;
        }

        List<String> getSchemaNames() {
            return new ArrayList<String>(this.schemas.keySet());
        }
    }

    static class SchemaDetails {
        private final RelationalSchemaMeasurement schemaMeasurement = new RelationalSchemaMeasurement();
        private final Map<String, TableDetails> tables = new HashMap<String, TableDetails>();

        SchemaDetails(String databaseName, String schemaName) {
            this.schemaMeasurement.setQualifiedSchemaName(databaseName + "." + schemaName);
            this.schemaMeasurement.setSchemaName(schemaName);
        }

        void setSize(long size) {
            this.schemaMeasurement.setTotalTableSize(size);
        }

        long getTableCount() {
            long tableCount = 0L;
            if (!this.tables.isEmpty()) {
                for (TableDetails tableDetails : this.tables.values()) {
                    if (tableDetails == null || !"Table".equals(tableDetails.getTableMeasurements().getTableType())) continue;
                    ++tableCount;
                }
            }
            this.schemaMeasurement.setTableCount(tableCount);
            return this.schemaMeasurement.getTableCount();
        }

        long getViewCount() {
            long viewCount = 0L;
            if (!this.tables.isEmpty()) {
                for (TableDetails tableDetails : this.tables.values()) {
                    if (tableDetails == null || !"View".equals(tableDetails.getTableMeasurements().getTableType())) continue;
                    ++viewCount;
                }
            }
            this.schemaMeasurement.setViewCount(viewCount);
            return this.schemaMeasurement.getViewCount();
        }

        long getMaterializedViewCount() {
            long viewCount = 0L;
            if (!this.tables.isEmpty()) {
                for (TableDetails tableDetails : this.tables.values()) {
                    if (tableDetails == null || !"MaterializedView".equals(tableDetails.getTableMeasurements().getTableType())) continue;
                    ++viewCount;
                }
            }
            this.schemaMeasurement.setMaterializedViewCount(viewCount);
            return this.schemaMeasurement.getMaterializedViewCount();
        }

        long getColumnCount() {
            long columnCount = 0L;
            if (!this.tables.isEmpty()) {
                for (String tableName : this.tables.keySet()) {
                    TableDetails tableDetails = this.tables.get(tableName);
                    if (tableDetails == null) continue;
                    columnCount = tableDetails.getColumnCount();
                }
            }
            this.schemaMeasurement.setColumnCount(columnCount);
            return this.schemaMeasurement.getColumnCount();
        }

        public String getQualifiedSchemaName() {
            return this.schemaMeasurement.getQualifiedSchemaName();
        }

        TableDetails getTableDetails(String tableName) {
            TableDetails tableDetails = this.tables.get(tableName);
            if (tableDetails == null) {
                tableDetails = new TableDetails(this.getQualifiedSchemaName(), tableName);
                this.tables.put(tableName, tableDetails);
            }
            return tableDetails;
        }

        List<String> getTableNames() {
            return new ArrayList<String>(this.tables.keySet());
        }

        Map<String, String> getSchemaResourceProperties() {
            HashMap<String, String> resourceProperties = new HashMap<String, String>();
            resourceProperties.put(RelationalSchemaMetric.QUALIFIED_SCHEMA_NAME.getDisplayName(), this.schemaMeasurement.getQualifiedSchemaName());
            resourceProperties.put(RelationalSchemaMetric.SCHEMA_NAME.getDisplayName(), this.schemaMeasurement.getSchemaName());
            resourceProperties.put(RelationalSchemaMetric.TOTAL_TABLE_SIZE.getDisplayName(), Long.toString(this.schemaMeasurement.getTotalTableSize()));
            resourceProperties.put(RelationalSchemaMetric.TABLE_COUNT.getDisplayName(), Long.toString(this.schemaMeasurement.getTableCount()));
            resourceProperties.put(RelationalSchemaMetric.VIEW_COUNT.getDisplayName(), Long.toString(this.schemaMeasurement.getViewCount()));
            resourceProperties.put(RelationalSchemaMetric.MAT_VIEW_COUNT.getDisplayName(), Long.toString(this.schemaMeasurement.getMaterializedViewCount()));
            resourceProperties.put(RelationalSchemaMetric.COLUMN_COUNT.getDisplayName(), Long.toString(this.schemaMeasurement.getColumnCount()));
            return resourceProperties;
        }

        public RelationalSchemaMeasurement getSchemaMeasurement() {
            return this.schemaMeasurement;
        }
    }

    static class TableDetails {
        private final RelationalTableMeasurement tableMeasurement = new RelationalTableMeasurement();
        private final Map<String, ColumnDetails> columns = new HashMap<String, ColumnDetails>();

        TableDetails(String qualifiedSchemaName, String tableName) {
            this.tableMeasurement.setQualifiedTableName(qualifiedSchemaName + "." + tableName);
            this.tableMeasurement.setTableName(tableName);
        }

        void setTableMeasurements(String tableOwner, boolean hasIndexes, boolean hasRules, boolean hasTriggers, boolean hasRowSecurity, long numberOfRowsInserted, long numberOfRowsUpdated, long numberOfRowsDeleted) {
            this.tableMeasurement.setTableOwner(tableOwner);
            this.tableMeasurement.setHasIndexes(hasIndexes);
            this.tableMeasurement.setHasRules(hasRules);
            this.tableMeasurement.setHasTriggers(hasTriggers);
            this.tableMeasurement.setHasRowSecurity(hasRowSecurity);
            this.tableMeasurement.setNumberOfRowsInserted(numberOfRowsInserted);
            this.tableMeasurement.setNumberOfRowsUpdated(numberOfRowsUpdated);
            this.tableMeasurement.setNumberOfRowsDeleted(numberOfRowsDeleted);
        }

        void setTableSize(long tableSize) {
            this.tableMeasurement.setTableSize(tableSize);
        }

        long getColumnCount() {
            this.tableMeasurement.setColumnCount((long)this.columns.size());
            return this.tableMeasurement.getColumnCount();
        }

        void setViewDetails(String viewOwner, String definition) {
            this.tableMeasurement.setTableOwner(viewOwner);
            this.tableMeasurement.setQueryDefinition(definition);
            this.tableMeasurement.setTableType("View");
        }

        void setMaterializedViewDetails(String viewOwner, boolean hasIndexes, boolean isPopulated, String definition) {
            this.tableMeasurement.setTableOwner(viewOwner);
            this.tableMeasurement.setQueryDefinition(definition);
            this.tableMeasurement.setHasIndexes(hasIndexes);
            this.tableMeasurement.setIsPopulated(isPopulated);
            this.tableMeasurement.setTableType("MaterializedView");
        }

        public String getQualifiedTableName() {
            return this.tableMeasurement.getQualifiedTableName();
        }

        List<String> getColumnNames() {
            return new ArrayList<String>(this.columns.keySet());
        }

        ColumnDetails getColumnDetails(String columnName) {
            ColumnDetails columnDetails = this.columns.get(columnName);
            if (columnDetails == null) {
                columnDetails = new ColumnDetails(this.getQualifiedTableName(), columnName);
                this.columns.put(columnName, columnDetails);
            }
            return columnDetails;
        }

        Map<String, String> getTableResourceProperties() {
            HashMap<String, String> resourceProperties = new HashMap<String, String>();
            resourceProperties.put(RelationalTableMetric.TABLE_QNAME.getDisplayName(), this.tableMeasurement.getQualifiedTableName());
            resourceProperties.put(RelationalTableMetric.TABLE_NAME.getDisplayName(), this.tableMeasurement.getTableName());
            resourceProperties.put(RelationalTableMetric.TABLE_OWNER.getDisplayName(), this.tableMeasurement.getTableOwner());
            resourceProperties.put(RelationalTableMetric.TABLE_TYPE.getDisplayName(), this.tableMeasurement.getTableType());
            resourceProperties.put(RelationalTableMetric.TABLE_SIZE.getDisplayName(), Long.toString(this.tableMeasurement.getTableSize()));
            resourceProperties.put(RelationalTableMetric.COLUMN_COUNT.getDisplayName(), Long.toString(this.tableMeasurement.getColumnCount()));
            resourceProperties.put(RelationalTableMetric.NUMBER_OF_ROWS_INSERTED.getDisplayName(), Long.toString(this.tableMeasurement.getNumberOfRowsInserted()));
            resourceProperties.put(RelationalTableMetric.NUMBER_OF_ROWS_UPDATED.getDisplayName(), Long.toString(this.tableMeasurement.getNumberOfRowsUpdated()));
            resourceProperties.put(RelationalTableMetric.NUMBER_OF_ROWS_DELETED.getDisplayName(), Long.toString(this.tableMeasurement.getNumberOfRowsDeleted()));
            resourceProperties.put(RelationalTableMetric.IS_POPULATED.getDisplayName(), Boolean.toString(this.tableMeasurement.getIsPopulated()));
            resourceProperties.put(RelationalTableMetric.HAS_INDEXES.getDisplayName(), Boolean.toString(this.tableMeasurement.getHasIndexes()));
            resourceProperties.put(RelationalTableMetric.HAS_RULES.getDisplayName(), Boolean.toString(this.tableMeasurement.getHasRules()));
            resourceProperties.put(RelationalTableMetric.HAS_TRIGGERS.getDisplayName(), Boolean.toString(this.tableMeasurement.getHasTriggers()));
            resourceProperties.put(RelationalTableMetric.HAS_ROW_SECURITY.getDisplayName(), Boolean.toString(this.tableMeasurement.getHasRowSecurity()));
            resourceProperties.put(RelationalTableMetric.QUERY_DEFINITION.getDisplayName(), this.tableMeasurement.getQueryDefinition());
            return resourceProperties;
        }

        public RelationalTableMeasurement getTableMeasurements() {
            return this.tableMeasurement;
        }
    }

    static class ColumnDetails {
        private final RelationalColumnMeasurement columnMeasurement = new RelationalColumnMeasurement();

        ColumnDetails(String qualifiedTableName, String columnName) {
            this.columnMeasurement.setQualifiedColumnName(qualifiedTableName + "." + columnName);
            this.columnMeasurement.setColumnName(columnName);
        }

        public String getQualifiedColumnName() {
            return this.columnMeasurement.getQualifiedColumnName();
        }

        public void setColumnSize(long columnSize) {
            this.columnMeasurement.setColumnSize(columnSize);
        }

        void setColumnMeasurement(int averageColumnWidth, long numberOfDistinctValues, Array mostCommonValues, Array mostCommonFrequencies, String columnTypeName, boolean columnNotNull) {
            this.columnMeasurement.setAverageColumnWidth(averageColumnWidth);
            this.columnMeasurement.setNumberOfDistinctValues(numberOfDistinctValues);
            if (mostCommonValues != null) {
                this.columnMeasurement.setMostCommonValues(mostCommonValues.toString());
            }
            if (mostCommonFrequencies != null) {
                this.columnMeasurement.setMostCommonValuesFrequency(mostCommonFrequencies.toString());
            }
            this.columnMeasurement.setColumnDataType(columnTypeName);
            this.columnMeasurement.setColumnNotNull(columnNotNull);
        }

        Map<String, String> getColumnResourceProperties() {
            HashMap<String, String> resourceProperties = new HashMap<String, String>();
            resourceProperties.put(RelationalColumnMetric.COLUMN_QNAME.getDisplayName(), this.columnMeasurement.getQualifiedColumnName());
            resourceProperties.put(RelationalColumnMetric.COLUMN_NAME.getDisplayName(), this.columnMeasurement.getColumnName());
            resourceProperties.put(RelationalColumnMetric.COLUMN_SIZE.getDisplayName(), Long.toString(this.columnMeasurement.getColumnSize()));
            resourceProperties.put(RelationalColumnMetric.COLUMN_TYPE.getDisplayName(), this.columnMeasurement.getColumnDataType());
            resourceProperties.put(RelationalColumnMetric.COLUMN_NOT_NULL.getDisplayName(), Boolean.toString(this.columnMeasurement.getColumnNotNull()));
            resourceProperties.put(RelationalColumnMetric.AVERAGE_WIDTH.getDisplayName(), Integer.toString(this.columnMeasurement.getAverageColumnWidth()));
            resourceProperties.put(RelationalColumnMetric.NUMBER_OF_DISTINCT_VALUES.getDisplayName(), Long.toString(this.columnMeasurement.getNumberOfDistinctValues()));
            resourceProperties.put(RelationalColumnMetric.MOST_COMMON_VALUES.getDisplayName(), this.columnMeasurement.getMostCommonValues());
            resourceProperties.put(RelationalColumnMetric.MOST_COMMON_VALUES_FREQUENCY.getDisplayName(), this.columnMeasurement.getMostCommonValuesFrequency());
            return resourceProperties;
        }

        public RelationalColumnMeasurement getColumnMeasurements() {
            return this.columnMeasurement;
        }
    }
}

