/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.postgres.survey;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.odpi.openmetadata.adapters.connectors.postgres.ffdc.PostgresAuditCode;
import org.odpi.openmetadata.adapters.connectors.postgres.survey.PostgresDatabaseStatsExtractor;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceConnector;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyAssetStore;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;

public class PostgresDatabaseSurveyActionService
extends SurveyActionServiceConnector {
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            AnnotationStore annotationStore = this.surveyContext.getAnnotationStore();
            SurveyAssetStore assetStore = this.surveyContext.getAssetStore();
            this.connector = super.performCheckAssetAnalysisStep(JDBCResourceConnector.class, OpenMetadataType.SOFTWARE_SERVER.typeName);
            JDBCResourceConnector assetConnector = (JDBCResourceConnector)this.connector;
            assetConnector.start();
            DataSource jdbcDataSource = assetConnector.getDataSource();
            Connection jdbcConnection = jdbcDataSource.getConnection();
            String databaseName = assetConnector.getDatabaseName();
            if (databaseName == null) {
                this.auditLog.logMessage("start", PostgresAuditCode.NO_DATABASES.getMessageDefinition(this.surveyActionServiceName, assetStore.getAssetProperties().getQualifiedName(), assetStore.getAssetGUID()));
            } else {
                annotationStore.setAnalysisStep(AnalysisStep.MEASURE_RESOURCE.getName());
                List<String> validDatabases = Collections.singletonList(databaseName);
                PostgresDatabaseStatsExtractor statsExtractor = new PostgresDatabaseStatsExtractor(validDatabases, this);
                statsExtractor.getDatabaseStatistics(jdbcConnection);
                annotationStore.setAnalysisStep(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName());
                statsExtractor.getSchemaStatistics(databaseName, jdbcConnection);
                List<Annotation> annotations = statsExtractor.getAnnotations();
                if (annotations != null) {
                    for (Annotation annotation : annotations) {
                        if (!super.isActive()) continue;
                        annotationStore.addAnnotation(annotation, this.surveyContext.getAssetGUID());
                    }
                }
            }
            jdbcConnection.commit();
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            super.handleUnexpectedException("start", error);
        }
    }
}

