/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.postgres.survey;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresConfigurationProperty;
import org.odpi.openmetadata.adapters.connectors.postgres.ffdc.PostgresAuditCode;
import org.odpi.openmetadata.adapters.connectors.postgres.survey.PostgresDatabaseStatsExtractor;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionDetails;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceConnector;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyAssetStore;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;

public class PostgresServerSurveyActionService
extends SurveyActionServiceConnector {
    private final List<JDBCResourceConnector> jdbcResourceConnectors = new ArrayList<JDBCResourceConnector>();

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            AnnotationStore annotationStore = this.surveyContext.getAnnotationStore();
            SurveyAssetStore assetStore = this.surveyContext.getAssetStore();
            this.connector = super.performCheckAssetAnalysisStep(JDBCResourceConnector.class, OpenMetadataType.SOFTWARE_SERVER.typeName);
            JDBCResourceConnector assetConnector = (JDBCResourceConnector)this.connector;
            assetConnector.start();
            annotationStore.setAnalysisStep(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName());
            DataSource jdbcDataSource = assetConnector.getDataSource();
            Connection jdbcConnection = jdbcDataSource.getConnection();
            String sqlCommand1 = "SELECT oid, datname, datistemplate, datallowconn from pg_database;";
            PreparedStatement preparedStatement = jdbcConnection.prepareStatement("SELECT oid, datname, datistemplate, datallowconn from pg_database;");
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<String> validDatabases = new ArrayList<String>();
            while (resultSet.next()) {
                if (resultSet.getBoolean("datistemplate") || !resultSet.getBoolean("datallowconn")) continue;
                String databaseName = resultSet.getString("datname");
                validDatabases.add(databaseName);
            }
            resultSet.close();
            preparedStatement.close();
            if (validDatabases.isEmpty()) {
                this.auditLog.logMessage("start", PostgresAuditCode.NO_DATABASES.getMessageDefinition(this.surveyActionServiceName, assetStore.getAssetProperties().getQualifiedName(), assetStore.getAssetGUID()));
            } else {
                List excludedDatabases = super.getArrayConfigurationProperty(PostgresConfigurationProperty.EXCLUDE_DATABASE_LIST.getName(), this.connectionDetails.getConfigurationProperties(), Collections.singletonList("postgres"));
                List includedDatabases = super.getArrayConfigurationProperty(PostgresConfigurationProperty.INCLUDE_DATABASE_LIST.getName(), this.connectionDetails.getConfigurationProperties());
                ArrayList<String> surveyDatabases = new ArrayList<String>();
                for (String string : validDatabases) {
                    if (!this.surveyContext.elementShouldBeSurveyed(string, excludedDatabases, includedDatabases)) continue;
                    surveyDatabases.add(string);
                }
                PostgresDatabaseStatsExtractor statsExtractor = new PostgresDatabaseStatsExtractor(surveyDatabases, this);
                statsExtractor.getDatabaseStatistics(jdbcConnection);
                jdbcConnection.commit();
                annotationStore.setAnalysisStep(AnalysisStep.PRODUCE_INVENTORY.getName());
                for (String databaseName : surveyDatabases) {
                    Connection databaseSpecificConnection = this.getDatabaseConnection(assetConnector, databaseName);
                    if (databaseSpecificConnection == null) continue;
                    statsExtractor.getSchemaStatistics(databaseName, databaseSpecificConnection);
                }
                List<Annotation> list = statsExtractor.getAnnotations();
                if (list != null) {
                    for (Annotation annotation : list) {
                        if (!super.isActive()) continue;
                        annotationStore.addAnnotation(annotation, this.surveyContext.getAssetGUID());
                    }
                }
            }
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            super.handleUnexpectedException("start", error);
        }
    }

    private Connection getDatabaseConnection(JDBCResourceConnector serverConnector, String databaseName) {
        String methodName = "getDatabaseConnection";
        try {
            String serverNetworkAddress = serverConnector.getConnection().getEndpoint().getAddress();
            String databaseSpecificURL = serverNetworkAddress.replace("/postgres", "/" + databaseName);
            ConnectionDetails databaseConnectionDetails = new ConnectionDetails(serverConnector.getConnection(), databaseSpecificURL);
            ConnectorBroker connectorBroker = new ConnectorBroker(this.auditLog);
            JDBCResourceConnector newConnector = (JDBCResourceConnector)connectorBroker.getConnector(databaseConnectionDetails);
            newConnector.start();
            this.jdbcResourceConnectors.add(newConnector);
            return newConnector.getDataSource().getConnection();
        }
        catch (Exception error) {
            this.logExceptionRecord("getDatabaseConnection", PostgresAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.surveyActionServiceName, error.getClass().getName(), "getDatabaseConnection", error.getMessage()), error);
            return null;
        }
    }

    public synchronized void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        for (JDBCResourceConnector resourceConnector : this.jdbcResourceConnectors) {
            if (resourceConnector == null || !resourceConnector.isActive()) continue;
            resourceConnector.disconnect();
        }
    }
}

